/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponent;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartTimerDummy;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

public class SmartTimer {
    @Inject
    @Extension
    private ComponentGenHelpers _componentGenHelpers;
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;
    @Inject
    @Extension
    private SmartComponent _smartComponent;

    public String TimerHeaderFileName(SmartTimerDummy h) {
        String _nameClass = this._componentGenHelpers.nameClass(h);
        return String.valueOf(_nameClass) + "Core.hh";
    }

    public String TimerSourceFileName(SmartTimerDummy h) {
        String _nameClass = this._componentGenHelpers.nameClass(h);
        return String.valueOf(_nameClass) + "Core.cc";
    }

    public String TimerUserHeaderFileName(SmartTimerDummy h) {
        String _nameClass = this._componentGenHelpers.nameClass(h);
        return String.valueOf(_nameClass) + ".hh";
    }

    public String TimerUserSourceFileName(SmartTimerDummy h) {
        String _nameClass = this._componentGenHelpers.nameClass(h);
        return String.valueOf(_nameClass) + ".cc";
    }

    protected void _CreateSmartTimer(SmartTimerDummy t, IFileSystemAccess fsa) {
        fsa.generateFile(this.TimerHeaderFileName(t), this.TimerHeaderFile(t));
        fsa.generateFile(this.TimerSourceFileName(t), this.TimerSourceFile(t));
        fsa.generateFile(this.TimerUserHeaderFileName(t), "SRC_OUTPUT", this.TimerUserHeaderFile(t));
        fsa.generateFile(this.TimerUserSourceFileName(t), "SRC_OUTPUT", this.TimerUserSourceFile(t));
    }

    protected void _CreateSmartTimer(Object s, IFileSystemAccess fsa) {
    }

    public CharSequence TimerHeaderFile(SmartTimerDummy timer) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _");
        String _upperCase = this._componentGenHelpers.nameClass(timer).toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_CORE_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = this._componentGenHelpers.nameClass(timer).toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_CORE_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("#include \"smartSoft.hh\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        String _nameClass = this._componentGenHelpers.nameClass(timer);
        _builder.append(_nameClass);
        _builder.append("Core : public Smart::TimerHandler");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("private:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("long timerId;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// create mutex");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("CHS::SmartMutex mutex;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// create condition mutex");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("CHS::SmartConditionMutex cond;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void timerExpired(const ACE_Time_Value & absolute_time,");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("const void * arg);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        String _nameClass_1 = this._componentGenHelpers.nameClass(timer);
        _builder.append(_nameClass_1, "\t");
        _builder.append("Core()");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(": timerId(0)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(", mutex()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(", cond(mutex)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{  }");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void timerExpired(const ACE_Time_Value & absolute_time) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// overload this method in derived classes");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void waitTimer();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void start();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void stop();");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public double getCycleInSeconds(SmartTimerDummy timer) {
        double seconds;
        block18: {
            block16: {
                seconds = 0.0;
                String _timeUnit = timer.getTimeUnit();
                if (_timeUnit == null) break block16;
                switch (_timeUnit) {
                    case "s": {
                        seconds = timer.getCycle();
                        break;
                    }
                    case "ms": {
                        double _divide;
                        int _cycle = timer.getCycle();
                        seconds = _divide = (double)_cycle / 1000.0;
                        break;
                    }
                    case "us": {
                        double _divide_1;
                        int _cycle_1 = timer.getCycle();
                        seconds = _divide_1 = (double)_cycle_1 / 1000000.0;
                        break;
                    }
                    case "ns": {
                        double _divide_2;
                        int _cycle_2 = timer.getCycle();
                        seconds = _divide_2 = (double)_cycle_2 / 1.0E9;
                        break;
                    }
                    default: {
                        seconds = -1.0;
                        break;
                    }
                }
                break block18;
            }
            seconds = -1.0;
        }
        return seconds;
    }

    public CharSequence TimerSourceFile(SmartTimerDummy timer) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _TimerHeaderFileName = this.TimerHeaderFileName(timer);
        _builder.append(_TimerHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _compHeaderFilename = this._smartComponent.getCompHeaderFilename(timer.getComponentDefinition());
        _builder.append(_compHeaderFilename);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("void ");
        String _nameClass = this._componentGenHelpers.nameClass(timer);
        _builder.append(_nameClass);
        _builder.append("Core::timerExpired(const ACE_Time_Value & absolute_time,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("const void * arg)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mutex.acquire();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cond.signal();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mutex.release();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this->timerExpired(absolute_time);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _nameClass_1 = this._componentGenHelpers.nameClass(timer);
        _builder.append(_nameClass_1);
        _builder.append("Core::waitTimer()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mutex.acquire();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cond.wait();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mutex.release();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _nameClass_2 = this._componentGenHelpers.nameClass(timer);
        _builder.append(_nameClass_2);
        _builder.append("Core::start()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// create timer");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("double fractpart, intpart;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// setup ");
        String _nameClass_3 = this._componentGenHelpers.nameClass(timer);
        _builder.append(_nameClass_3, "\t");
        _builder.append("Core");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("fractpart = modf(");
        double _cycleInSeconds = this.getCycleInSeconds(timer);
        _builder.append((Object)_cycleInSeconds, "\t");
        _builder.append(", &intpart);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("timerId = COMP->component->getTimerThread().scheduleTimer(*this, (void*) 0, ACE_Time_Value(0,0),");
        _builder.newLine();
        _builder.append("                                  ");
        _builder.append("ACE_Time_Value(intpart, (int)(fractpart*1000*1000)));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _nameClass_4 = this._componentGenHelpers.nameClass(timer);
        _builder.append(_nameClass_4);
        _builder.append("Core::stop()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("COMP->component->getTimerThread().cancelTimer(timerId);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence TimerUserHeaderFile(SmartTimerDummy timer) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#ifndef _");
        String _upperCase = this._componentGenHelpers.nameClass(timer).toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = this._componentGenHelpers.nameClass(timer).toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("#include \"smartSoft.hh\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("#include \"");
        String _TimerHeaderFileName = this.TimerHeaderFileName(timer);
        _builder.append(_TimerHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("class ");
        String _nameClass = this._componentGenHelpers.nameClass(timer);
        _builder.append(_nameClass);
        _builder.append(" : public ");
        String _nameClass_1 = this._componentGenHelpers.nameClass(timer);
        _builder.append(_nameClass_1);
        _builder.append("Core ");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void timerExpired(const ACE_Time_Value & absolute_time);");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence TimerUserSourceFile(SmartTimerDummy timer) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _TimerUserHeaderFileName = this.TimerUserHeaderFileName(timer);
        _builder.append(_TimerUserHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _compHeaderFilename = this._smartComponent.getCompHeaderFilename(timer.getComponentDefinition());
        _builder.append(_compHeaderFilename);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <iostream>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _nameClass = this._componentGenHelpers.nameClass(timer);
        _builder.append(_nameClass);
        _builder.append("::timerExpired(const ACE_Time_Value & absolute_time)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// change this code to your needs !!!");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public void CreateSmartTimer(Object t, IFileSystemAccess fsa) {
        if (t instanceof SmartTimerDummy) {
            this._CreateSmartTimer((SmartTimerDummy)t, fsa);
            return;
        }
        if (t != null) {
            this._CreateSmartTimer(t, fsa);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t, fsa).toString());
    }
}

