/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component.params;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.SingleValue;
import org.eclipse.smartmdsd.ecore.base.documentation.AbstractDocumentationElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentParameter.AbstractComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterBase;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedTrigger;
import org.eclipse.smartmdsd.ecore.component.componentParameter.InternalParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterSetInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.TriggerInstance;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.AbstractParameter;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetRepository;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.TriggerDefinition;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponent;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.params.ComponentParamsGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class SmartComponentParameter {
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;
    @Inject
    @Extension
    private SmartComponent _smartComponent;
    @Inject
    @Extension
    private ComponentParamsGenHelpers _componentParamsGenHelpers;
    @Inject
    @Extension
    private ComponentParameterModelUtility _componentParameterModelUtility;

    public String ParameterUpdateHandlerHeaderFileName(ComponentParameter h) {
        return "ParameterUpdateHandler.hh";
    }

    public String ParameterUpdateHandlerSourceFileName(ComponentParameter h) {
        return "ParameterUpdateHandler.cc";
    }

    public String TriggerHandlerCoreHeaderFileName(ComponentParameter h) {
        return "TriggerHandlerCore.hh";
    }

    public String TriggerHandlerCoreSourceFileName(ComponentParameter h) {
        return "TriggerHandlerCore.cc";
    }

    public String TriggerHandlerHeaderFileName(ComponentParameter h) {
        return "TriggerHandler.hh";
    }

    public String TriggerHandlerSourceFileName(ComponentParameter h) {
        return "TriggerHandler.cc";
    }

    public String ParameterStateStructCoreHeaderFileName(ComponentParameter h) {
        return "ParameterStateStructCore.hh";
    }

    public String ParameterStateStructHeaderFileName(ComponentParameter h) {
        return "ParameterStateStruct.hh";
    }

    public String ParameterStateStructSourceFileName(ComponentParameter h) {
        return "ParameterStateStruct.cc";
    }

    public String ParameterIniFileName(ComponentParameter h) {
        String _name = h.getComponent().getName();
        return String.valueOf(_name) + ".ini.bottom";
    }

    public String ParameterIniFileHeadName(ComponentParameter h) {
        String _name = h.getComponent().getName();
        return String.valueOf(_name) + ".ini.head";
    }

    public String ParameterIniFileTemplateName(ComponentParameter h) {
        String _name = h.getComponent().getName();
        return String.valueOf(_name) + ".ini.template";
    }

    public void CreateSmartComponentParameterSlave(ComponentParameter p, IFileSystemAccess2 fsa) {
        CharSequence iniFileBottomContent = this.compileIniFile(p);
        fsa.generateFile(this.ParameterIniFileName(p), "SRC_GEN_PARAMS", iniFileBottomContent);
        boolean _isFile = fsa.isFile(this.ParameterIniFileHeadName(p));
        if (_isFile) {
            String iniFileHeadContent = fsa.readTextFile(this.ParameterIniFileHeadName(p)).toString();
            fsa.generateFile(this.ParameterIniFileTemplateName(p), (CharSequence)(String.valueOf(iniFileHeadContent) + iniFileBottomContent));
        }
        fsa.generateFile(this.ParameterStateStructCoreHeaderFileName(p), "SRC_GEN_PARAMS", this.compileStructCore(p));
        fsa.generateFile(this.ParameterUpdateHandlerHeaderFileName(p), "SRC_GEN_PARAMS", this.compileUpdateHandlerHH(p));
        fsa.generateFile(this.ParameterUpdateHandlerSourceFileName(p), "SRC_GEN_PARAMS", this.compileUpdateHandlerCC(p));
        if (IterableExtensions.exists((Iterable)Iterables.filter((Iterable)p.getParameters(), ParameterSetInstance.class), pi -> {
            Functions.Function1 _function = pd -> pd instanceof TriggerDefinition;
            return IterableExtensions.exists((Iterable)pi.getParamSet().getParameters(), (Functions.Function1)_function);
        }) || IterableExtensions.exists((Iterable)p.getParameters(), tr -> tr instanceof ExtendedTrigger)) {
            fsa.generateFile(this.TriggerHandlerCoreHeaderFileName(p), "SRC_GEN_PARAMS", this.compileTriggerHandlerCoreHH(p));
            fsa.generateFile(this.TriggerHandlerCoreSourceFileName(p), "SRC_GEN_PARAMS", this.compileTriggerHandlerCoreCC(p));
            fsa.generateFile(this.TriggerHandlerHeaderFileName(p), "SRC_OUTPUT", this.compileTriggerHandlerHH(p));
            fsa.generateFile(this.TriggerHandlerSourceFileName(p), "SRC_OUTPUT", this.compileTriggerHandlerCC(p));
        }
        fsa.generateFile(this.ParameterStateStructHeaderFileName(p), "SRC_OUTPUT", this.compileStructHH(p));
        fsa.generateFile(this.ParameterStateStructSourceFileName(p), "SRC_OUTPUT", this.compileStructCC(p));
    }

    private String _getFullyQualifiedName(ParameterDefinition par) {
        EObject _eContainer = par.eContainer();
        ParameterSetDefinition set = (ParameterSetDefinition)_eContainer;
        String _fullyQualifiedName = this.getFullyQualifiedName((AbstractDocumentationElement)set);
        String _plus = String.valueOf(_fullyQualifiedName) + ".";
        String _name = par.getName();
        String result = String.valueOf(_plus) + _name;
        return result;
    }

    private String _getFullyQualifiedVariableName(ParameterDefinition par) {
        EObject _eContainer = par.eContainer();
        ParameterSetDefinition set = (ParameterSetDefinition)_eContainer;
        String _fullyQualifiedVariableName = this.getFullyQualifiedVariableName((AbstractDocumentationElement)set);
        String _plus = String.valueOf(_fullyQualifiedVariableName) + "_";
        String _name = par.getName();
        String result = String.valueOf(_plus) + _name;
        return result;
    }

    private String _getFullyQualifiedName(TriggerDefinition trig) {
        EObject _eContainer = trig.eContainer();
        ParameterSetDefinition set = (ParameterSetDefinition)_eContainer;
        String _fullyQualifiedName = this.getFullyQualifiedName((AbstractDocumentationElement)set);
        String _plus = String.valueOf(_fullyQualifiedName) + ".";
        String _name = trig.getName();
        String result = String.valueOf(_plus) + _name;
        return result;
    }

    private String _getFullyQualifiedVariableName(TriggerDefinition trig) {
        EObject _eContainer = trig.eContainer();
        ParameterSetDefinition set = (ParameterSetDefinition)_eContainer;
        String _fullyQualifiedVariableName = this.getFullyQualifiedVariableName((AbstractDocumentationElement)set);
        String _plus = String.valueOf(_fullyQualifiedVariableName) + "_";
        String _name = trig.getName();
        String result = String.valueOf(_plus) + _name;
        return result;
    }

    private String _getFullyQualifiedName(ParameterSetDefinition set) {
        EObject _eContainer = set.eContainer();
        ParameterSetRepository repo = (ParameterSetRepository)_eContainer;
        String _name = repo.getName();
        String _plus = String.valueOf(_name) + ".";
        String _name_1 = set.getName();
        String result = String.valueOf(_plus) + _name_1;
        return result;
    }

    private String _getFullyQualifiedVariableName(ParameterSetDefinition set) {
        EObject _eContainer = set.eContainer();
        ParameterSetRepository repo = (ParameterSetRepository)_eContainer;
        String _name = repo.getName();
        String _plus = String.valueOf(_name) + "_";
        String _name_1 = set.getName();
        String result = String.valueOf(_plus) + _name_1;
        return result;
    }

    private String _generateTriggerAttributeDefinitions(TriggerDefinition t) {
        String result = "";
        EList _attributes = t.getAttributes();
        for (AttributeDefinition el : _attributes) {
            String _plus_2;
            boolean _notEquals;
            Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(el);
            if (_isArrayType.booleanValue()) {
                String _plus;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("const std::list<");
                String _compileCppType = this._componentParamsGenHelpers.compileCppType(el);
                _builder.append(_compileCppType);
                _builder.append("> &");
                String _name = el.getName();
                _builder.append(_name);
                result = _plus = String.valueOf(result) + _builder;
            } else {
                String _plus_1;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("const ");
                String _compileCppType_1 = this._componentParamsGenHelpers.compileCppType(el);
                _builder_1.append(_compileCppType_1);
                _builder_1.append(" &");
                String _name_1 = el.getName();
                _builder_1.append(_name_1);
                result = _plus_1 = String.valueOf(result) + _builder_1;
            }
            AttributeDefinition _last = (AttributeDefinition)IterableExtensions.last((Iterable)t.getAttributes());
            boolean bl = _notEquals = !Objects.equal((Object)el, (Object)_last);
            if (!_notEquals) continue;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(", ");
            result = _plus_2 = String.valueOf(result) + _builder_2;
        }
        return result;
    }

    private String _generateTriggerAttributeDefinitions(ExtendedTrigger t) {
        String result = "";
        EList _attributes = t.getAttributes();
        for (AttributeDefinition el : _attributes) {
            String _plus_2;
            boolean _notEquals;
            Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(el);
            if (_isArrayType.booleanValue()) {
                String _plus;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("const std::list<");
                String _compileCppType = this._componentParamsGenHelpers.compileCppType(el);
                _builder.append(_compileCppType);
                _builder.append("> &");
                String _name = el.getName();
                _builder.append(_name);
                result = _plus = String.valueOf(result) + _builder;
            } else {
                String _plus_1;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("const ");
                String _compileCppType_1 = this._componentParamsGenHelpers.compileCppType(el);
                _builder_1.append(_compileCppType_1);
                _builder_1.append(" &");
                String _name_1 = el.getName();
                _builder_1.append(_name_1);
                result = _plus_1 = String.valueOf(result) + _builder_1;
            }
            AttributeDefinition _last = (AttributeDefinition)IterableExtensions.last((Iterable)t.getAttributes());
            boolean bl = _notEquals = !Objects.equal((Object)el, (Object)_last);
            if (!_notEquals) continue;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(", ");
            result = _plus_2 = String.valueOf(result) + _builder_2;
        }
        return result;
    }

    private String _generateTriggerAttributeNames(TriggerDefinition t, String prefix) {
        String result = "";
        EList _attributes = t.getAttributes();
        for (AttributeDefinition el : _attributes) {
            String _plus_1;
            boolean _notEquals;
            String _plus;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(prefix);
            String _name = el.getName();
            _builder.append(_name);
            result = _plus = String.valueOf(result) + _builder;
            AttributeDefinition _last = (AttributeDefinition)IterableExtensions.last((Iterable)t.getAttributes());
            boolean bl = _notEquals = !Objects.equal((Object)el, (Object)_last);
            if (!_notEquals) continue;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(", ");
            result = _plus_1 = String.valueOf(result) + _builder_1;
        }
        return result;
    }

    private String _generateTriggerAttributeNames(ExtendedTrigger t, String prefix) {
        String result = "";
        EList _attributes = t.getAttributes();
        for (AttributeDefinition el : _attributes) {
            String _plus_1;
            boolean _notEquals;
            String _plus;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(prefix);
            String _name = el.getName();
            _builder.append(_name);
            result = _plus = String.valueOf(result) + _builder;
            AttributeDefinition _last = (AttributeDefinition)IterableExtensions.last((Iterable)t.getAttributes());
            boolean bl = _notEquals = !Objects.equal((Object)el, (Object)_last);
            if (!_notEquals) continue;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(", ");
            result = _plus_1 = String.valueOf(result) + _builder_1;
        }
        return result;
    }

    public boolean hasActiveTriggers(ComponentParameter usage) {
        Iterable _filter = Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class);
        for (ParameterSetInstance inst : _filter) {
            Functions.Function1 _function = t -> t.isActive();
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)inst.getParameterInstances(), TriggerInstance.class), (Functions.Function1)_function);
            if (!_exists) continue;
            return true;
        }
        Iterable _filter_1 = Iterables.filter((Iterable)usage.getParameters(), ExtendedTrigger.class);
        for (ExtendedTrigger extTr : _filter_1) {
            boolean _isActive = extTr.isActive();
            if (!_isActive) continue;
            return true;
        }
        return false;
    }

    public CharSequence compileTriggerHandlerCoreHH(ComponentParameter usage) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _TRIGGERHANDLERCORE_HH");
        _builder.newLine();
        _builder.append("#define _TRIGGERHANDLERCORE_HH");
        _builder.newLine();
        _builder.newLine();
        boolean _hasActiveTriggers = this.hasActiveTriggers(usage);
        if (_hasActiveTriggers) {
            _builder.append("#include \"aceSmartSoft.hh\"");
            _builder.newLine();
            _builder.append("#include <queue>");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("#include <string>");
        _builder.newLine();
        _builder.append("#include <iostream>");
        _builder.newLine();
        _builder.append("#include <list>");
        _builder.newLine();
        _builder.newLine();
        boolean _hasActiveTriggers_1 = this.hasActiveTriggers(usage);
        if (_hasActiveTriggers_1) {
            _builder.append("class TriggerHandlerCore : public SmartACE::ManagedTask");
            _builder.newLine();
        } else {
            _builder.append("class TriggerHandlerCore");
            _builder.newLine();
        }
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("friend class ParamUpdateHandler;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("TriggerHandlerCore() ");
        _builder.newLine();
        boolean _hasActiveTriggers_2 = this.hasActiveTriggers(usage);
        if (_hasActiveTriggers_2) {
            _builder.append("\t");
            _builder.append(":\tSmartACE::ManagedTask(NULL) //TODO: a propper component pointer should be probably used here instead of NULL");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(",\tmutex()");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(",\tsema(0) // initialize semaphore in blocking mode");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(",\tcurrent_trigger_enumerator(TriggerEnumerators::UNDEFINED_TRIGGER_ACTION)");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("{  ");
        _builder.newLine();
        boolean _hasActiveTriggers_3 = this.hasActiveTriggers(usage);
        if (_hasActiveTriggers_3) {
            _builder.append("\t\t");
            _builder.append("this->start();");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual ~TriggerHandlerCore() {  }");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function);
        for (ParameterSetInstance paramSetInst : _sortBy) {
            _builder.append("\t");
            _builder.append("// trigger user methods");
            _builder.newLine();
            Functions.Function1 _function_1 = it -> it.getName();
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)paramSetInst.getParamSet().getParameters(), TriggerDefinition.class), (Functions.Function1)_function_1);
            for (TriggerDefinition trigger : _sortBy_1) {
                _builder.append("\t");
                _builder.newLine();
                Functions.Function1 _function_2 = el -> {
                    AbstractAttributeType _type = el.getType();
                    return _type instanceof InlineEnumerationType;
                };
                boolean _exists = IterableExtensions.exists((Iterable)trigger.getAttributes(), (Functions.Function1)_function_2);
                if (_exists) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("class ");
                    String _name = trigger.getName();
                    _builder.append(_name, "\t\t");
                    _builder.append("Type {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("public:");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                }
                Functions.Function1 _function_3 = el -> {
                    AbstractAttributeType _type = el.getType();
                    return _type instanceof InlineEnumerationType;
                };
                Functions.Function1 _function_4 = it -> it.getName();
                List _sortBy_2 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)trigger.getAttributes(), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
                for (AttributeDefinition attr : _sortBy_2) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    CharSequence _generateEnumClass = this.generateEnumClass(attr);
                    _builder.append((Object)_generateEnumClass, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.newLine();
                    Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(attr);
                    if (!_isArrayType.booleanValue()) continue;
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("static std::list<");
                    String _compileCppType = this._componentParamsGenHelpers.compileCppType(attr);
                    _builder.append(_compileCppType, "\t\t\t");
                    _builder.append("> convert");
                    String _firstUpper = StringExtensions.toFirstUpper((String)attr.getName());
                    _builder.append(_firstUpper, "\t\t\t");
                    _builder.append("Type(const std::list<std::string> &");
                    String _name_1 = attr.getName();
                    _builder.append(_name_1, "\t\t\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("static std::list<");
                    String _compileCppType_1 = this._componentParamsGenHelpers.compileCppType(attr);
                    _builder.append(_compileCppType_1, "\t\t\t\t");
                    _builder.append("> result;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("std::list<std::string>::const_iterator it;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("for(it=");
                    String _name_2 = attr.getName();
                    _builder.append(_name_2, "\t\t\t\t");
                    _builder.append(".begin(); it!=");
                    String _name_3 = attr.getName();
                    _builder.append(_name_3, "\t\t\t\t");
                    _builder.append(".end(); it++) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t\t");
                    _builder.append("result.push_back(*it);");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("return result;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.newLine();
                }
                Functions.Function1 _function_5 = el -> {
                    AbstractAttributeType _type = el.getType();
                    return _type instanceof InlineEnumerationType;
                };
                boolean _exists_1 = IterableExtensions.exists((Iterable)trigger.getAttributes(), (Functions.Function1)_function_5);
                if (_exists_1) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}; // end class ");
                    String _name_4 = trigger.getName();
                    _builder.append(_name_4, "\t\t");
                    _builder.append("Type");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("virtual void handle");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)this.getFullyQualifiedVariableName((AbstractDocumentationElement)trigger));
                _builder.append(_firstUpper_1, "\t\t");
                _builder.append("(");
                String _generateTriggerAttributeDefinitions = this.generateTriggerAttributeDefinitions((AbstractDocumentationElement)trigger);
                _builder.append(_generateTriggerAttributeDefinitions, "\t\t");
                _builder.append(") = 0;");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// extended trigger user methods");
        _builder.newLine();
        Functions.Function1 _function_6 = it -> it.getName();
        List _sortBy_3 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedTrigger.class), (Functions.Function1)_function_6);
        for (ExtendedTrigger extendedTrigger : _sortBy_3) {
            Boolean _haveEnums = this._componentParameterModelUtility.haveEnums((Collection)extendedTrigger.getAttributes());
            if (_haveEnums.booleanValue()) {
                _builder.append("\t");
                _builder.append("class ");
                String _name_5 = extendedTrigger.getName();
                _builder.append(_name_5, "\t");
                _builder.append("Type {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("public:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
            }
            Functions.Function1 _function_7 = it -> {
                AbstractAttributeType _type = it.getType();
                return _type instanceof InlineEnumerationType;
            };
            Functions.Function1 _function_8 = it -> it.getName();
            List _sortBy_4 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)extendedTrigger.getAttributes(), (Functions.Function1)_function_7), (Functions.Function1)_function_8);
            for (AttributeDefinition attr_1 : _sortBy_4) {
                _builder.append("\t");
                _builder.append("\t");
                Iterator _generateEnumClass_1 = this.generateEnumClass(attr_1);
                _builder.append((Object)_generateEnumClass_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                Boolean _isArrayType_1 = this._componentParameterModelUtility.isArrayType(attr_1);
                if (!_isArrayType_1.booleanValue()) continue;
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("static std::list<");
                String _compileCppType_2 = this._componentParamsGenHelpers.compileCppType(attr_1);
                _builder.append(_compileCppType_2, "\t\t");
                _builder.append("> convert");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)attr_1.getName());
                _builder.append(_firstUpper_2, "\t\t");
                _builder.append("Type(const std::list<std::string> &");
                String _name_6 = attr_1.getName();
                _builder.append(_name_6, "\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("static std::list<");
                String _compileCppType_3 = this._componentParamsGenHelpers.compileCppType(attr_1);
                _builder.append(_compileCppType_3, "\t\t\t");
                _builder.append("> result;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("std::list<std::string>::const_iterator it;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("for(it=");
                String _name_7 = attr_1.getName();
                _builder.append(_name_7, "\t\t\t");
                _builder.append(".begin(); it!=");
                String _name_8 = attr_1.getName();
                _builder.append(_name_8, "\t\t\t");
                _builder.append(".end(); it++) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("result.push_back(*it);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return result;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
            }
            Boolean _haveEnums_1 = this._componentParameterModelUtility.haveEnums((Collection)extendedTrigger.getAttributes());
            if (_haveEnums_1.booleanValue()) {
                _builder.append("\t");
                _builder.append("}; // end class ");
                String _name_9 = extendedTrigger.getName();
                _builder.append(_name_9, "\t");
                _builder.append("Type");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("virtual void handle");
            Iterator _firstUpper_3 = StringExtensions.toFirstUpper((String)extendedTrigger.getName());
            _builder.append((String)((Object)_firstUpper_3), "\t");
            _builder.append("(");
            String _generateTriggerAttributeDefinitions_1 = this.generateTriggerAttributeDefinitions((AbstractDocumentationElement)extendedTrigger);
            _builder.append(_generateTriggerAttributeDefinitions_1, "\t");
            _builder.append(") = 0;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        boolean _hasActiveTriggers_4 = this.hasActiveTriggers(usage);
        if (_hasActiveTriggers_4) {
            _builder.append("protected:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("SmartACE::SmartMutex mutex;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("SmartACE::SmartSemaphore sema;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("int on_execute();");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("class TriggerEnumerators {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("enum ENUM {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("UNDEFINED_TRIGGER_ACTION");
            _builder.newLine();
            Functions.Function1 _function_9 = it -> it.getName();
            List _sortBy_5 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function_9);
            for (ParameterSetInstance inst : _sortBy_5) {
                Functions.Function1 _function_10 = t -> t.isActive();
                Functions.Function1 _function_11 = it -> it.getTriggerDef().getName();
                List _sortBy_6 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)inst.getParameterInstances(), TriggerInstance.class), (Functions.Function1)_function_10), (Functions.Function1)_function_11);
                for (TriggerInstance t2 : _sortBy_6) {
                    _builder.append("\t\t\t");
                    _builder.append(", ");
                    String _upperCase = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t2.getTriggerDef()).toUpperCase();
                    _builder.append(_upperCase, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                Functions.Function1 _function_12 = t_1 -> t_1.isActive();
                Functions.Function1 _function_13 = it -> it.getName();
                List _sortBy_7 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedTrigger.class), (Functions.Function1)_function_12), (Functions.Function1)_function_13);
                for (ExtendedTrigger extTr : _sortBy_7) {
                    _builder.append("\t\t\t");
                    _builder.append(", ");
                    String _upperCase_1 = extTr.getName().toUpperCase();
                    _builder.append(_upperCase_1, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("\t\t");
            _builder.append("};");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("};");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("TriggerEnumerators::ENUM current_trigger_enumerator;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("std::queue<TriggerEnumerators::ENUM> trigger_queue;");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            Functions.Function1 _function_14 = it -> it.getName();
            List _sortBy_8 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function_14);
            for (ParameterSetInstance inst_1 : _sortBy_8) {
                Functions.Function1 _function_15 = t_1 -> t_1.isActive();
                Functions.Function1 _function_16 = it -> it.getTriggerDef().getName();
                List _sortBy_9 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)inst_1.getParameterInstances(), TriggerInstance.class), (Functions.Function1)_function_15), (Functions.Function1)_function_16);
                for (TriggerInstance t_12 : _sortBy_9) {
                    _builder.append("\t");
                    _builder.append("// active trigger ");
                    String _name_10 = t_12.getTriggerDef().getName();
                    _builder.append(_name_10, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("struct ");
                    String _fullyQualifiedVariableName = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t_12.getTriggerDef());
                    _builder.append(_fullyQualifiedVariableName, "\t");
                    _builder.append("Attributes {");
                    _builder.newLineIfNotEmpty();
                    Functions.Function1 _function_17 = it -> it.getName();
                    List _sortBy_10 = IterableExtensions.sortBy((Iterable)t_12.getTriggerDef().getAttributes(), (Functions.Function1)_function_17);
                    for (AttributeDefinition el2 : _sortBy_10) {
                        Boolean _isArrayType_2 = this._componentParameterModelUtility.isArrayType(el2);
                        if (_isArrayType_2.booleanValue()) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("std::list<");
                            String _compileCppType_4 = this._componentParamsGenHelpers.compileCppType(el2);
                            _builder.append(_compileCppType_4, "\t\t");
                            _builder.append("> ");
                            String _name_11 = el2.getName();
                            _builder.append(_name_11, "\t\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        String _compileCppType_5 = this._componentParamsGenHelpers.compileCppType(el2);
                        _builder.append(_compileCppType_5, "\t\t");
                        _builder.append(" ");
                        String _name_12 = el2.getName();
                        _builder.append(_name_12, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("}current_");
                    String _fullyQualifiedVariableName_1 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t_12.getTriggerDef());
                    _builder.append(_fullyQualifiedVariableName_1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("std::queue<");
                    String _fullyQualifiedVariableName_2 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t_12.getTriggerDef());
                    _builder.append(_fullyQualifiedVariableName_2, "\t");
                    _builder.append("Attributes> ");
                    String _fullyQualifiedVariableName_3 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t_12.getTriggerDef());
                    _builder.append(_fullyQualifiedVariableName_3, "\t");
                    _builder.append("_queue;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.newLine();
                }
            }
            Functions.Function1 _function_18 = t_2 -> t_2.isActive();
            Functions.Function1 _function_19 = it -> it.getName();
            List _sortBy_11 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedTrigger.class), (Functions.Function1)_function_18), (Functions.Function1)_function_19);
            for (ExtendedTrigger extTr_1 : _sortBy_11) {
                _builder.append("\t");
                _builder.append("// active trigger ");
                String _name_13 = extTr_1.getName();
                _builder.append(_name_13, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("struct ");
                String _name_14 = extTr_1.getName();
                _builder.append(_name_14, "\t");
                _builder.append("Attributes {");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_20 = it -> it.getName();
                List _sortBy_12 = IterableExtensions.sortBy((Iterable)extTr_1.getAttributes(), (Functions.Function1)_function_20);
                for (AttributeDefinition el_1 : _sortBy_12) {
                    Boolean _isArrayType_3 = this._componentParameterModelUtility.isArrayType(el_1);
                    if (_isArrayType_3.booleanValue()) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("std::list<");
                        String _compileCppType_6 = this._componentParamsGenHelpers.compileCppType(el_1);
                        _builder.append(_compileCppType_6, "\t\t");
                        _builder.append("> ");
                        String _name_15 = el_1.getName();
                        _builder.append(_name_15, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    String _compileCppType_7 = this._componentParamsGenHelpers.compileCppType(el_1);
                    _builder.append(_compileCppType_7, "\t\t");
                    _builder.append(" ");
                    String _name_16 = el_1.getName();
                    _builder.append(_name_16, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("}current_");
                String _name_17 = extTr_1.getName();
                _builder.append(_name_17, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("std::queue<");
                String _name_18 = extTr_1.getName();
                _builder.append(_name_18, "\t");
                _builder.append("Attributes> ");
                String _name_19 = extTr_1.getName();
                _builder.append(_name_19, "\t");
                _builder.append("_queue;");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("private:");
        _builder.newLine();
        Functions.Function1 _function_21 = it -> it.getName();
        List _sortBy_13 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function_21);
        for (ParameterSetInstance paramSetInst_1 : _sortBy_13) {
            _builder.append("\t");
            _builder.append("// trigger internal methods");
            _builder.newLine();
            Functions.Function1 _function_22 = it -> it.getName();
            List _sortBy_14 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)paramSetInst_1.getParamSet().getParameters(), TriggerDefinition.class), (Functions.Function1)_function_22);
            for (TriggerDefinition trigger_1 : _sortBy_14) {
                _builder.append("\t");
                _builder.append("void handle");
                String _firstUpper_4 = StringExtensions.toFirstUpper((String)this.getFullyQualifiedVariableName((AbstractDocumentationElement)trigger_1));
                _builder.append(_firstUpper_4, "\t");
                _builder.append("Core(");
                String _generateTriggerAttributeDefinitions_2 = this.generateTriggerAttributeDefinitions((AbstractDocumentationElement)trigger_1);
                _builder.append(_generateTriggerAttributeDefinitions_2, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// extended trigger internal methods ");
        _builder.newLine();
        Functions.Function1 _function_23 = it -> it.getName();
        List _sortBy_15 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedTrigger.class), (Functions.Function1)_function_23);
        for (ExtendedTrigger extendedTrigger_1 : _sortBy_15) {
            _builder.append("\t");
            _builder.append("void handle");
            String _firstUpper_5 = StringExtensions.toFirstUpper((String)extendedTrigger_1.getName());
            _builder.append(_firstUpper_5, "\t");
            _builder.append("Core(");
            String _generateTriggerAttributeDefinitions_3 = this.generateTriggerAttributeDefinitions((AbstractDocumentationElement)extendedTrigger_1);
            _builder.append(_generateTriggerAttributeDefinitions_3, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif // _TRIGGERHANDLERCORE_HH");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileTriggerHandlerCoreCC(ComponentParameter usage) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _TriggerHandlerCoreHeaderFileName = this.TriggerHandlerCoreHeaderFileName(usage);
        _builder.append(_TriggerHandlerCoreHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasActiveTriggers = this.hasActiveTriggers(usage);
        if (_hasActiveTriggers) {
            _builder.append("int TriggerHandlerCore::on_execute()");
            _builder.newLine();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// blocking wait until some active trigger request(s) come in");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("sema.acquire();");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("SmartACE::SmartGuard g(mutex);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("// get the top trigger from the queue");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("current_trigger_enumerator = trigger_queue.front();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("trigger_queue.pop();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("// retrieve the corresponding trigger attributes from the trigger specific queue");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("switch(current_trigger_enumerator) {");
            _builder.newLine();
            Functions.Function1 _function = it -> it.getName();
            List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function);
            for (ParameterSetInstance inst : _sortBy) {
                Functions.Function1 _function_1 = t -> t.isActive();
                Functions.Function1 _function_2 = it -> it.getTriggerDef().getName();
                List _sortBy_1 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)inst.getParameterInstances(), TriggerInstance.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
                for (TriggerInstance t2 : _sortBy_1) {
                    _builder.append("\t\t");
                    _builder.append("case TriggerEnumerators::");
                    String _upperCase = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t2.getTriggerDef()).toUpperCase();
                    _builder.append(_upperCase, "\t\t");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("current_");
                    String _fullyQualifiedVariableName = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t2.getTriggerDef());
                    _builder.append(_fullyQualifiedVariableName, "\t\t\t");
                    _builder.append(" = ");
                    String _fullyQualifiedVariableName_1 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t2.getTriggerDef());
                    _builder.append(_fullyQualifiedVariableName_1, "\t\t\t");
                    _builder.append("_queue.front();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    String _fullyQualifiedVariableName_2 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t2.getTriggerDef());
                    _builder.append(_fullyQualifiedVariableName_2, "\t\t\t");
                    _builder.append("_queue.pop();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("break;");
                    _builder.newLine();
                }
            }
            Functions.Function1 _function_3 = t_1 -> t_1.isActive();
            Functions.Function1 _function_4 = it -> it.getName();
            List _sortBy_2 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedTrigger.class), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
            for (Object extTr : _sortBy_2) {
                _builder.append("\t\t");
                _builder.append("case TriggerEnumerators::");
                String _upperCase_1 = extTr.getName().toUpperCase();
                _builder.append(_upperCase_1, "\t\t");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("current_");
                String _name = extTr.getName();
                _builder.append(_name, "\t\t");
                _builder.append(" = ");
                String _name_1 = extTr.getName();
                _builder.append(_name_1, "\t\t");
                _builder.append("_queue.front();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                String _name_2 = extTr.getName();
                _builder.append(_name_2, "\t\t");
                _builder.append("_queue.pop();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} // mutex release");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// now call the corresponding trigger handler");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// (releasing the mutex before, allows to store newly incoming trigger commands on the queue in parallel)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("switch(current_trigger_enumerator) {");
            _builder.newLine();
            Functions.Function1 _function_5 = it -> it.getName();
            List _sortBy_3 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function_5);
            for (ParameterSetInstance inst_1 : _sortBy_3) {
                Functions.Function1 _function_6 = t_1 -> t_1.isActive();
                Functions.Function1 _function_7 = it -> it.getTriggerDef().getName();
                List _sortBy_4 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)inst_1.getParameterInstances(), TriggerInstance.class), (Functions.Function1)_function_6), (Functions.Function1)_function_7);
                for (TriggerInstance t_12 : _sortBy_4) {
                    _builder.append("\t");
                    _builder.append("case TriggerEnumerators::");
                    String _upperCase_2 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t_12.getTriggerDef()).toUpperCase();
                    _builder.append(_upperCase_2, "\t");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("this->handle");
                    String _firstUpper = StringExtensions.toFirstUpper((String)this.getFullyQualifiedVariableName((AbstractDocumentationElement)t_12.getTriggerDef()));
                    _builder.append(_firstUpper, "\t\t");
                    _builder.append("(");
                    TriggerDefinition _triggerDef = t_12.getTriggerDef();
                    String _fullyQualifiedVariableName_3 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)t_12.getTriggerDef());
                    String _plus = "current_" + _fullyQualifiedVariableName_3;
                    String _plus_1 = String.valueOf(_plus) + ".";
                    String _generateTriggerAttributeNames = this.generateTriggerAttributeNames((AbstractDocumentationElement)_triggerDef, _plus_1);
                    _builder.append(_generateTriggerAttributeNames, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("break;");
                    _builder.newLine();
                }
            }
            Functions.Function1 _function_8 = t_2 -> t_2.isActive();
            Functions.Function1 _function_9 = it -> it.getName();
            List _sortBy_5 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedTrigger.class), (Functions.Function1)_function_8), (Functions.Function1)_function_9);
            for (ExtendedTrigger extTr_1 : _sortBy_5) {
                _builder.append("\t");
                _builder.append("case TriggerEnumerators::");
                String _upperCase_3 = extTr_1.getName().toUpperCase();
                _builder.append(_upperCase_3, "\t");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("this->handle");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)extTr_1.getName());
                _builder.append(_firstUpper_1, "\t\t");
                _builder.append("(");
                String _name_3 = extTr_1.getName();
                String _plus_2 = "current_" + _name_3;
                String _plus_3 = String.valueOf(_plus_2) + ".";
                String _generateTriggerAttributeNames_1 = this.generateTriggerAttributeNames((AbstractDocumentationElement)extTr_1, _plus_3);
                _builder.append(_generateTriggerAttributeNames_1, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return 0;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        Functions.Function1 _function_10 = it -> it.getName();
        List _sortBy_6 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function_10);
        for (ParameterSetInstance paramSetInst : _sortBy_6) {
            _builder.append("//");
            _builder.newLine();
            _builder.append("// trigger internal handler methods");
            _builder.newLine();
            _builder.append("//");
            _builder.newLine();
            Functions.Function1 _function_11 = it -> it.getName();
            List _sortBy_7 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)paramSetInst.getParamSet().getParameters(), TriggerDefinition.class), (Functions.Function1)_function_11);
            for (TriggerDefinition trigger : _sortBy_7) {
                _builder.newLine();
                _builder.append("\t");
                _builder.append("// handle ");
                String _name_4 = trigger.getName();
                _builder.append(_name_4, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("void TriggerHandlerCore::handle");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)this.getFullyQualifiedVariableName((AbstractDocumentationElement)trigger));
                _builder.append(_firstUpper_2, "\t");
                _builder.append("Core(");
                String _generateTriggerAttributeDefinitions = this.generateTriggerAttributeDefinitions((AbstractDocumentationElement)trigger);
                _builder.append(_generateTriggerAttributeDefinitions, "\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                Functions.Function1 _function_12 = t_2 -> Objects.equal((Object)t_2.getTriggerDef(), (Object)trigger) && t_2.isActive();
                boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)paramSetInst.getParameterInstances(), TriggerInstance.class), (Functions.Function1)_function_12);
                if (_exists) {
                    _builder.append("\t\t");
                    _builder.append("SmartACE::SmartGuard g(mutex);");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("// store the current set of trigger-attributes in a queue");
                    _builder.newLine();
                    _builder.append("\t\t");
                    String _fullyQualifiedVariableName_4 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)trigger);
                    _builder.append(_fullyQualifiedVariableName_4, "\t\t");
                    _builder.append("Attributes attr;");
                    _builder.newLineIfNotEmpty();
                    Functions.Function1 _function_13 = it -> it.getName();
                    List _sortBy_8 = IterableExtensions.sortBy((Iterable)trigger.getAttributes(), (Functions.Function1)_function_13);
                    for (AttributeDefinition el : _sortBy_8) {
                        _builder.append("\t\t");
                        _builder.append("attr.");
                        String _name_5 = el.getName();
                        _builder.append(_name_5, "\t\t");
                        _builder.append(" = ");
                        String _name_6 = el.getName();
                        _builder.append(_name_6, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t");
                    String _fullyQualifiedVariableName_5 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)trigger);
                    _builder.append(_fullyQualifiedVariableName_5, "\t\t");
                    _builder.append("_queue.push(attr);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("// store the current trigger call in the shared trigger-queue");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("trigger_queue.push(TriggerEnumerators::");
                    String _upperCase_4 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)trigger).toUpperCase();
                    _builder.append(_upperCase_4, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("// signal the task, in case it is waiting");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("sema.release();");
                    _builder.newLine();
                } else {
                    _builder.append("\t\t");
                    _builder.append("this->handle");
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)this.getFullyQualifiedVariableName((AbstractDocumentationElement)trigger));
                    _builder.append(_firstUpper_3, "\t\t");
                    _builder.append("(");
                    String _generateTriggerAttributeNames_2 = this.generateTriggerAttributeNames((AbstractDocumentationElement)trigger, "");
                    _builder.append(_generateTriggerAttributeNames_2, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append("//");
        _builder.newLine();
        _builder.append("// extended trigger internal handler methods");
        _builder.newLine();
        _builder.append("//");
        _builder.newLine();
        Functions.Function1 _function_14 = it -> it.getName();
        List _sortBy_9 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedTrigger.class), (Functions.Function1)_function_14);
        for (ExtendedTrigger extendedTrigger : _sortBy_9) {
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("// handle ");
            String _name_7 = extendedTrigger.getName();
            _builder.append(_name_7, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("void TriggerHandlerCore::handle");
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)extendedTrigger.getName());
            _builder.append(_firstUpper_4, "\t\t");
            _builder.append("Core(");
            String _generateTriggerAttributeDefinitions_1 = this.generateTriggerAttributeDefinitions((AbstractDocumentationElement)extendedTrigger);
            _builder.append(_generateTriggerAttributeDefinitions_1, "\t\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            boolean _isActive = extendedTrigger.isActive();
            if (_isActive) {
                _builder.append("\t\t\t");
                _builder.append("SmartACE::SmartGuard g(mutex);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("// store the current set of trigger-attributes in a queue");
                _builder.newLine();
                _builder.append("\t\t\t");
                String _name_8 = extendedTrigger.getName();
                _builder.append(_name_8, "\t\t\t");
                _builder.append("Attributes attr;");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_15 = it -> it.getName();
                List _sortBy_10 = IterableExtensions.sortBy((Iterable)extendedTrigger.getAttributes(), (Functions.Function1)_function_15);
                for (AttributeDefinition el_1 : _sortBy_10) {
                    _builder.append("\t\t\t");
                    _builder.append("attr.");
                    String _name_9 = el_1.getName();
                    _builder.append(_name_9, "\t\t\t");
                    _builder.append(" = ");
                    String _name_10 = el_1.getName();
                    _builder.append(_name_10, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t\t");
                String _name_11 = extendedTrigger.getName();
                _builder.append(_name_11, "\t\t\t");
                _builder.append("_queue.push(attr);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("// store the current trigger call in the shared trigger-queue");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("trigger_queue.push(TriggerEnumerators::");
                String _upperCase_5 = extendedTrigger.getName().toUpperCase();
                _builder.append(_upperCase_5, "\t\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("// signal the task, in case it is waiting");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("cond.signal();");
                _builder.newLine();
            } else {
                _builder.append("\t\t\t");
                _builder.append("this->handle");
                String _firstUpper_5 = StringExtensions.toFirstUpper((String)extendedTrigger.getName());
                _builder.append(_firstUpper_5, "\t\t\t");
                _builder.append("(");
                String _generateTriggerAttributeNames_3 = this.generateTriggerAttributeNames((AbstractDocumentationElement)extendedTrigger, "");
                _builder.append(_generateTriggerAttributeNames_3, "\t\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileTriggerHandlerHH(ComponentParameter usage) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _TRIGGERHANDLER_HH");
        _builder.newLine();
        _builder.append("#define _TRIGGERHANDLER_HH");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _TriggerHandlerCoreHeaderFileName = this.TriggerHandlerCoreHeaderFileName(usage);
        _builder.append(_TriggerHandlerCoreHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class TriggerHandler: public TriggerHandlerCore ");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("TriggerHandler() {  }");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual ~TriggerHandler() {  }");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// trigger user methods");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function);
        for (ParameterSetInstance paramSetInst : _sortBy) {
            Functions.Function1 _function_1 = it -> it.getName();
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)paramSetInst.getParamSet().getParameters(), TriggerDefinition.class), (Functions.Function1)_function_1);
            for (TriggerDefinition trigger : _sortBy_1) {
                _builder.append("\t");
                _builder.append("virtual void handle");
                String _firstUpper = StringExtensions.toFirstUpper((String)this.getFullyQualifiedVariableName((AbstractDocumentationElement)trigger));
                _builder.append(_firstUpper, "\t");
                _builder.append("(");
                String _generateTriggerAttributeDefinitions = this.generateTriggerAttributeDefinitions((AbstractDocumentationElement)trigger);
                _builder.append(_generateTriggerAttributeDefinitions, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedTrigger.class), (Functions.Function1)_function_2);
        for (ExtendedTrigger extendedTrigger : _sortBy_2) {
            _builder.append("\t");
            _builder.append("virtual void handle");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)extendedTrigger.getName());
            _builder.append(_firstUpper_1, "\t");
            _builder.append("(");
            String _generateTriggerAttributeDefinitions_1 = this.generateTriggerAttributeDefinitions((AbstractDocumentationElement)extendedTrigger);
            _builder.append(_generateTriggerAttributeDefinitions_1, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif // _TRIGGERHANDLER_HH");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileTriggerHandlerCC(ComponentParameter usage) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _TriggerHandlerHeaderFileName = this.TriggerHandlerHeaderFileName(usage);
        _builder.append(_TriggerHandlerHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        ComponentDefinition _component = usage.getComponent();
        String _compHeaderFilename = null;
        if (_component != null) {
            _compHeaderFilename = this._smartComponent.getCompHeaderFilename(_component);
        }
        _builder.append(_compHeaderFilename);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// trigger user methods");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function);
        for (ParameterSetInstance paramSetInst : _sortBy) {
            Functions.Function1 _function_1 = it -> it.getName();
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)paramSetInst.getParamSet().getParameters(), TriggerDefinition.class), (Functions.Function1)_function_1);
            for (TriggerDefinition trigger : _sortBy_1) {
                _builder.append("void TriggerHandler::handle");
                String _firstUpper = StringExtensions.toFirstUpper((String)this.getFullyQualifiedVariableName((AbstractDocumentationElement)trigger));
                _builder.append(_firstUpper);
                _builder.append("(");
                String _generateTriggerAttributeDefinitions = this.generateTriggerAttributeDefinitions((AbstractDocumentationElement)trigger);
                _builder.append(_generateTriggerAttributeDefinitions);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("// implement the trigger behavior here. Be aware, if you must use blocking calls here, please set this");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("// trigger as active in the model. For an active trigger an active queue will be generated internally ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("// (transparent for the usage here). Thus an active trigger will be called within a separate task scope.");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
        }
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedTrigger.class), (Functions.Function1)_function_2);
        for (ExtendedTrigger extendedTrigger : _sortBy_2) {
            _builder.append("void TriggerHandler::handle");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)extendedTrigger.getName());
            _builder.append(_firstUpper_1);
            _builder.append("(");
            String _generateTriggerAttributeDefinitions_1 = this.generateTriggerAttributeDefinitions((AbstractDocumentationElement)extendedTrigger);
            _builder.append(_generateTriggerAttributeDefinitions_1);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// implement the trigger behavior here. Be aware, if you must use blocking calls here, please set this");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// trigger as active in the model. For an active trigger an active queue will be generated internally ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// (transparent for the usage here). Thus an active trigger will be called within a separate task scope.");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileStructHH(ComponentParameter usage) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#ifndef _PARAMETERSTATESTRUCT_HH");
        _builder.newLine();
        _builder.append("#define _PARAMETERSTATESTRUCT_HH");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _ParameterStateStructCoreHeaderFileName = this.ParameterStateStructCoreHeaderFileName(usage);
        _builder.append(_ParameterStateStructCoreHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ParameterStateStruct: public ParameterStateStructCore");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ParameterStateStruct() {  }");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual ~ParameterStateStruct() {  }");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// implement this method to check whether the incoming parameters");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// provided by the commit state are consistent, in case the ParameterResponseType");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// is not OK, the commit parameter is NOT copied into the global state.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// HINT: avoid using blocking calls from within this handler, use Triggers for that instead.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual SmartACE::ParamResponseType handleCOMMIT(const ParameterStateStruct &commitState);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// define your own getter methods here");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// (to provide conversion functions and/or more convenient getter methods)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// these own getter methods will be accessible through \"COMP->getParameters().yourOwnMethod()\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// inside of your methods use the getter methods from the parent class ParameterStateStructCore");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// (they provide parameter values from the global state only, which are available after the last commit)");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("inline std::ostream &operator<<(std::ostream &os, const ParameterStateStruct &pss)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("pss.to_ostream(os);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return os;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileStructCC(ComponentParameter usage) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _ParameterStateStructHeaderFileName = this.ParameterStateStructHeaderFileName(usage);
        _builder.append(_ParameterStateStructHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _compHeaderFilename = this._smartComponent.getCompHeaderFilename(usage.getComponent());
        _builder.append(_compHeaderFilename);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("SmartACE::ParamResponseType ParameterStateStruct::handleCOMMIT(const ParameterStateStruct &commitState) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// implement any consistency checks here which ensure that the incoming parameter meets components");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// internal constraints. If the current parameter violates any consistency checks, return ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// SmartACE::ParamResponseType::INVALID, which will result in this commitState to be rejected (not ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// copied into the globalState) and the corresponding response type is communicated back to the");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// ParameterMaster. Be aware, that you should avoid blocking calls here. If you need blocking");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// calls, use an active trigger in combination with commit.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return SmartACE::ParamResponseType::OK;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// implement your custom getter methods here");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileUpdateHandlerCC(ComponentParameter usage) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _ParameterUpdateHandlerHeaderFileName = this.ParameterUpdateHandlerHeaderFileName(usage);
        _builder.append(_ParameterUpdateHandlerHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _compHeaderFilename = this._smartComponent.getCompHeaderFilename(usage.getComponent());
        _builder.append(_compHeaderFilename);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("SmartACE::CommParameterResponse ParamUpdateHandler::handleParameter(const SmartACE::CommParameterRequest& request)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SmartACE::CommParameterResponse answer;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::string tag = request.getTag();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::cout<<\"PARAMETER: \"<<tag<<std::endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateHandleEntries = this.generateHandleEntries((EList<AbstractComponentParameter>)usage.getParameters());
        _builder.append((Object)_generateHandleEntries, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::cout<<\"[handleQuery] PARAMETER \"<<tag<<\" DONE\\n\\n\";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return answer;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("ParameterStateStruct ParamUpdateHandler::getGlobalState() const{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SmartACE::SmartGuard g(globalStateLock);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return this->globalState;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ParamUpdateHandler::loadParameter(SmartACE::SmartIniParameter &parameter)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("Parameters can be specified via command line -filename=<filename>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("With this parameter present:");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("- The component will look for the file in the current working directory,");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("a path relative to the current directory or any absolute path");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("- The component will use the default values if the file cannot be found");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("With this parameter absent:");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("- <Name of Component>.ini will be read from current working directory, if found there");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("- $SMART_ROOT/etc/<Name of Component>.ini will be read otherwise");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("- Default values will be used if neither found in working directory or /etc");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// load parameters");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// print all known parameters");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("parameter.print();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// load internal parameters (if any)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), InternalParameter.class), (Functions.Function1)_function);
        for (InternalParameter p : _sortBy) {
            _builder.append("\t\t");
            _builder.append("// parameter ");
            String _name = p.getName();
            _builder.append(_name, "\t\t");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_1 = it -> it.getName();
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)p.getAttributes(), (Functions.Function1)_function_1);
            for (AttributeDefinition v : _sortBy_1) {
                AbstractAttributeType _type = v.getType();
                if (_type instanceof InlineEnumerationType) {
                    Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(v);
                    if (_isArrayType.booleanValue()) {
                        _builder.append("\t\t");
                        _builder.append("std::list<std::string> temp_");
                        String _name_1 = p.getName();
                        _builder.append(_name_1, "\t\t");
                        _builder.append("_");
                        String _name_2 = v.getName();
                        _builder.append(_name_2, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("if(parameter.get");
                        String _compileCommObjType = this._componentParamsGenHelpers.compileCommObjType(v);
                        _builder.append(_compileCommObjType, "\t\t");
                        _builder.append("List(\"");
                        String _name_3 = p.getName();
                        _builder.append(_name_3, "\t\t");
                        _builder.append("\", \"");
                        String _name_4 = v.getName();
                        _builder.append(_name_4, "\t\t");
                        _builder.append("\", temp_");
                        String _name_5 = p.getName();
                        _builder.append(_name_5, "\t\t");
                        _builder.append("_");
                        String _name_6 = v.getName();
                        _builder.append(_name_6, "\t\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("{");
                        _builder.newLine();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("commitState.");
                        String _name_7 = p.getName();
                        _builder.append(_name_7, "\t\t\t");
                        _builder.append(".set");
                        String _firstUpper = StringExtensions.toFirstUpper((String)v.getName());
                        _builder.append(_firstUpper, "\t\t\t");
                        _builder.append("Type(temp_");
                        String _name_8 = p.getName();
                        _builder.append(_name_8, "\t\t\t");
                        _builder.append("_");
                        String _name_9 = v.getName();
                        _builder.append(_name_9, "\t\t\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("globalState.");
                        String _name_10 = p.getName();
                        _builder.append(_name_10, "\t\t\t");
                        _builder.append(".");
                        String _name_11 = v.getName();
                        _builder.append(_name_11, "\t\t\t");
                        _builder.append(" = commitState.");
                        String _name_12 = p.getName();
                        _builder.append(_name_12, "\t\t\t");
                        _builder.append(".");
                        String _name_13 = v.getName();
                        _builder.append(_name_13, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("}");
                        _builder.newLine();
                        continue;
                    }
                    _builder.append("\t\t");
                    _builder.append("std::string temp_");
                    String _name_14 = p.getName();
                    _builder.append(_name_14, "\t\t");
                    _builder.append("_");
                    String _name_15 = v.getName();
                    _builder.append(_name_15, "\t\t");
                    _builder.append(" = \"\";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_1 = this._componentParamsGenHelpers.compileCommObjType(v);
                    _builder.append(_compileCommObjType_1, "\t\t");
                    _builder.append("(\"");
                    String _name_16 = p.getName();
                    _builder.append(_name_16, "\t\t");
                    _builder.append("\", \"");
                    String _name_17 = v.getName();
                    _builder.append(_name_17, "\t\t");
                    _builder.append("\", temp_");
                    String _name_18 = p.getName();
                    _builder.append(_name_18, "\t\t");
                    _builder.append("_");
                    String _name_19 = v.getName();
                    _builder.append(_name_19, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("commitState.");
                    String _name_20 = p.getName();
                    _builder.append(_name_20, "\t\t\t");
                    _builder.append(".");
                    String _name_21 = v.getName();
                    _builder.append(_name_21, "\t\t\t");
                    _builder.append(" = temp_");
                    String _name_22 = p.getName();
                    _builder.append(_name_22, "\t\t\t");
                    _builder.append("_");
                    String _name_23 = v.getName();
                    _builder.append(_name_23, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("globalState.");
                    String _name_24 = p.getName();
                    _builder.append(_name_24, "\t\t\t");
                    _builder.append(".");
                    String _name_25 = v.getName();
                    _builder.append(_name_25, "\t\t\t");
                    _builder.append(" = commitState.");
                    String _name_26 = p.getName();
                    _builder.append(_name_26, "\t\t\t");
                    _builder.append(".");
                    String _name_27 = v.getName();
                    _builder.append(_name_27, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    continue;
                }
                Boolean _isArrayType_1 = this._componentParameterModelUtility.isArrayType(v);
                if (_isArrayType_1.booleanValue()) {
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_2 = this._componentParamsGenHelpers.compileCommObjType(v);
                    _builder.append(_compileCommObjType_2, "\t\t");
                    _builder.append("List(\"");
                    String _name_28 = p.getName();
                    _builder.append(_name_28, "\t\t");
                    _builder.append("\", \"");
                    String _name_29 = v.getName();
                    _builder.append(_name_29, "\t\t");
                    _builder.append("\", commitState.");
                    String _name_30 = p.getName();
                    _builder.append(_name_30, "\t\t");
                    _builder.append(".");
                    String _name_31 = v.getName();
                    _builder.append(_name_31, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_3 = this._componentParamsGenHelpers.compileCommObjType(v);
                    _builder.append(_compileCommObjType_3, "\t\t");
                    _builder.append("(\"");
                    String _name_32 = p.getName();
                    _builder.append(_name_32, "\t\t");
                    _builder.append("\", \"");
                    String _name_33 = v.getName();
                    _builder.append(_name_33, "\t\t");
                    _builder.append("\", commitState.");
                    String _name_34 = p.getName();
                    _builder.append(_name_34, "\t\t");
                    _builder.append(".");
                    String _name_35 = v.getName();
                    _builder.append(_name_35, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("globalState.");
                String _name_36 = p.getName();
                _builder.append(_name_36, "\t\t\t");
                _builder.append(".");
                String _name_37 = v.getName();
                _builder.append(_name_37, "\t\t\t");
                _builder.append(" = commitState.");
                String _name_38 = p.getName();
                _builder.append(_name_38, "\t\t\t");
                _builder.append(".");
                String _name_39 = v.getName();
                _builder.append(_name_39, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// load extended parameters (if any)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedParameter.class), (Functions.Function1)_function_2);
        for (ExtendedParameter p_1 : _sortBy_2) {
            _builder.append("\t\t");
            _builder.append("// parameter ");
            String _name_40 = p_1.getName();
            _builder.append(_name_40, "\t\t");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_3 = it -> it.getName();
            List _sortBy_3 = IterableExtensions.sortBy((Iterable)p_1.getAttributes(), (Functions.Function1)_function_3);
            for (AttributeDefinition v_1 : _sortBy_3) {
                AbstractAttributeType _type_1 = v_1.getType();
                if (_type_1 instanceof InlineEnumerationType) {
                    Boolean _isArrayType_2 = this._componentParameterModelUtility.isArrayType(v_1);
                    if (_isArrayType_2.booleanValue()) {
                        _builder.append("\t\t");
                        _builder.append("std::list<std::string> temp_");
                        String _name_41 = p_1.getName();
                        _builder.append(_name_41, "\t\t");
                        _builder.append("_");
                        String _name_42 = v_1.getName();
                        _builder.append(_name_42, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("if(parameter.get");
                        String _compileCommObjType_4 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                        _builder.append(_compileCommObjType_4, "\t\t");
                        _builder.append("List(\"");
                        String _name_43 = p_1.getName();
                        _builder.append(_name_43, "\t\t");
                        _builder.append("\", \"");
                        String _name_44 = v_1.getName();
                        _builder.append(_name_44, "\t\t");
                        _builder.append("\", temp_");
                        String _name_45 = p_1.getName();
                        _builder.append(_name_45, "\t\t");
                        _builder.append("_");
                        String _name_46 = v_1.getName();
                        _builder.append(_name_46, "\t\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("{");
                        _builder.newLine();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("commitState.");
                        String _name_47 = p_1.getName();
                        _builder.append(_name_47, "\t\t\t");
                        _builder.append(".set");
                        String _firstUpper_1 = StringExtensions.toFirstUpper((String)v_1.getName());
                        _builder.append(_firstUpper_1, "\t\t\t");
                        _builder.append("Type(temp_");
                        String _name_48 = p_1.getName();
                        _builder.append(_name_48, "\t\t\t");
                        _builder.append("_");
                        String _name_49 = v_1.getName();
                        _builder.append(_name_49, "\t\t\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("globalState.");
                        String _name_50 = p_1.getName();
                        _builder.append(_name_50, "\t\t\t");
                        _builder.append(".");
                        String _name_51 = v_1.getName();
                        _builder.append(_name_51, "\t\t\t");
                        _builder.append(" = commitState.");
                        String _name_52 = p_1.getName();
                        _builder.append(_name_52, "\t\t\t");
                        _builder.append(".");
                        String _name_53 = v_1.getName();
                        _builder.append(_name_53, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("}");
                        _builder.newLine();
                        continue;
                    }
                    _builder.append("\t\t");
                    _builder.append("std::string temp_");
                    String _name_54 = p_1.getName();
                    _builder.append(_name_54, "\t\t");
                    _builder.append("_");
                    String _name_55 = v_1.getName();
                    _builder.append(_name_55, "\t\t");
                    _builder.append(" = \"\";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_5 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                    _builder.append(_compileCommObjType_5, "\t\t");
                    _builder.append("(\"");
                    String _name_56 = p_1.getName();
                    _builder.append(_name_56, "\t\t");
                    _builder.append("\", \"");
                    String _name_57 = v_1.getName();
                    _builder.append(_name_57, "\t\t");
                    _builder.append("\", temp_");
                    String _name_58 = p_1.getName();
                    _builder.append(_name_58, "\t\t");
                    _builder.append("_");
                    String _name_59 = v_1.getName();
                    _builder.append(_name_59, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("commitState.");
                    String _name_60 = p_1.getName();
                    _builder.append(_name_60, "\t\t\t");
                    _builder.append(".");
                    String _name_61 = v_1.getName();
                    _builder.append(_name_61, "\t\t\t");
                    _builder.append(" = temp_");
                    String _name_62 = p_1.getName();
                    _builder.append(_name_62, "\t\t\t");
                    _builder.append("_");
                    String _name_63 = v_1.getName();
                    _builder.append(_name_63, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("globalState.");
                    String _name_64 = p_1.getName();
                    _builder.append(_name_64, "\t\t\t");
                    _builder.append(".");
                    String _name_65 = v_1.getName();
                    _builder.append(_name_65, "\t\t\t");
                    _builder.append(" = commitState.");
                    String _name_66 = p_1.getName();
                    _builder.append(_name_66, "\t\t\t");
                    _builder.append(".");
                    String _name_67 = v_1.getName();
                    _builder.append(_name_67, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    continue;
                }
                Boolean _isArrayType_3 = this._componentParameterModelUtility.isArrayType(v_1);
                if (_isArrayType_3.booleanValue()) {
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_6 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                    _builder.append(_compileCommObjType_6, "\t\t");
                    _builder.append("List(\"");
                    String _name_68 = p_1.getName();
                    _builder.append(_name_68, "\t\t");
                    _builder.append("\", \"");
                    String _name_69 = v_1.getName();
                    _builder.append(_name_69, "\t\t");
                    _builder.append("\", commitState.");
                    String _name_70 = p_1.getName();
                    _builder.append(_name_70, "\t\t");
                    _builder.append(".");
                    String _name_71 = v_1.getName();
                    _builder.append(_name_71, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_7 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                    _builder.append(_compileCommObjType_7, "\t\t");
                    _builder.append("(\"");
                    String _name_72 = p_1.getName();
                    _builder.append(_name_72, "\t\t");
                    _builder.append("\", \"");
                    String _name_73 = v_1.getName();
                    _builder.append(_name_73, "\t\t");
                    _builder.append("\", commitState.");
                    String _name_74 = p_1.getName();
                    _builder.append(_name_74, "\t\t");
                    _builder.append(".");
                    String _name_75 = v_1.getName();
                    _builder.append(_name_75, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("globalState.");
                String _name_76 = p_1.getName();
                _builder.append(_name_76, "\t\t\t");
                _builder.append(".");
                String _name_77 = v_1.getName();
                _builder.append(_name_77, "\t\t\t");
                _builder.append(" = commitState.");
                String _name_78 = p_1.getName();
                _builder.append(_name_78, "\t\t\t");
                _builder.append(".");
                String _name_79 = v_1.getName();
                _builder.append(_name_79, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// load instance parameters (if a parameter definition was instantiated in the model)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//");
        _builder.newLine();
        Functions.Function1 _function_4 = it -> it.getName();
        List _sortBy_4 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function_4);
        for (ParameterSetInstance inst : _sortBy_4) {
            Functions.Function1 _function_5 = it -> it.getName();
            List _sortBy_5 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)inst.getParamSet().getParameters(), ParameterDefinition.class), (Functions.Function1)_function_5);
            for (ParameterDefinition p_2 : _sortBy_5) {
                _builder.append("\t\t");
                _builder.append("// parameter ");
                String _fullyQualifiedName = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                _builder.append(_fullyQualifiedName, "\t\t");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_6 = it -> it.getName();
                List _sortBy_6 = IterableExtensions.sortBy((Iterable)p_2.getAttributes(), (Functions.Function1)_function_6);
                for (AttributeDefinition v_2 : _sortBy_6) {
                    AbstractAttributeType _type_2 = v_2.getType();
                    if (_type_2 instanceof InlineEnumerationType) {
                        Boolean _isArrayType_4 = this._componentParameterModelUtility.isArrayType(v_2);
                        if (_isArrayType_4.booleanValue()) {
                            _builder.append("\t\t");
                            _builder.append("std::list<std::string> temp_");
                            String _fullyQualifiedVariableName = this.getFullyQualifiedVariableName((AbstractDocumentationElement)p_2);
                            _builder.append(_fullyQualifiedVariableName, "\t\t");
                            _builder.append("_");
                            String _name_80 = v_2.getName();
                            _builder.append(_name_80, "\t\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t");
                            _builder.append("if(parameter.get");
                            String _compileCommObjType_8 = this._componentParamsGenHelpers.compileCommObjType(v_2);
                            _builder.append(_compileCommObjType_8, "\t\t");
                            _builder.append("List(\"");
                            String _fullyQualifiedName_1 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                            _builder.append(_fullyQualifiedName_1, "\t\t");
                            _builder.append("\", \"");
                            String _name_81 = v_2.getName();
                            _builder.append(_name_81, "\t\t");
                            _builder.append("\", temp_");
                            String _fullyQualifiedVariableName_1 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)p_2);
                            _builder.append(_fullyQualifiedVariableName_1, "\t\t");
                            _builder.append("_");
                            String _name_82 = v_2.getName();
                            _builder.append(_name_82, "\t\t");
                            _builder.append("))");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t");
                            _builder.append("{");
                            _builder.newLine();
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("commitState.");
                            String _fullyQualifiedName_2 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                            _builder.append(_fullyQualifiedName_2, "\t\t\t");
                            _builder.append(".set");
                            String _firstUpper_2 = StringExtensions.toFirstUpper((String)v_2.getName());
                            _builder.append(_firstUpper_2, "\t\t\t");
                            _builder.append("Type(temp_");
                            String _fullyQualifiedVariableName_2 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)p_2);
                            _builder.append(_fullyQualifiedVariableName_2, "\t\t\t");
                            _builder.append("_");
                            String _name_83 = v_2.getName();
                            _builder.append(_name_83, "\t\t\t");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("globalState.");
                            String _fullyQualifiedName_3 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                            _builder.append(_fullyQualifiedName_3, "\t\t\t");
                            _builder.append(".");
                            String _name_84 = v_2.getName();
                            _builder.append(_name_84, "\t\t\t");
                            _builder.append(" = commitState.");
                            String _fullyQualifiedName_4 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                            _builder.append(_fullyQualifiedName_4, "\t\t\t");
                            _builder.append(".");
                            String _name_85 = v_2.getName();
                            _builder.append(_name_85, "\t\t\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t");
                            _builder.append("}");
                            _builder.newLine();
                            continue;
                        }
                        _builder.append("\t\t");
                        _builder.append("std::string temp_");
                        String _fullyQualifiedVariableName_3 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedVariableName_3, "\t\t");
                        _builder.append("_");
                        String _name_86 = v_2.getName();
                        _builder.append(_name_86, "\t\t");
                        _builder.append(" = \"\";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("if(parameter.get");
                        String _compileCommObjType_9 = this._componentParamsGenHelpers.compileCommObjType(v_2);
                        _builder.append(_compileCommObjType_9, "\t\t");
                        _builder.append("(\"");
                        String _fullyQualifiedName_5 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedName_5, "\t\t");
                        _builder.append("\", \"");
                        String _name_87 = v_2.getName();
                        _builder.append(_name_87, "\t\t");
                        _builder.append("\", temp_");
                        String _fullyQualifiedVariableName_4 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedVariableName_4, "\t\t");
                        _builder.append("_");
                        String _name_88 = v_2.getName();
                        _builder.append(_name_88, "\t\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("{");
                        _builder.newLine();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("commitState.");
                        String _fullyQualifiedName_6 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedName_6, "\t\t\t");
                        _builder.append(".");
                        String _name_89 = v_2.getName();
                        _builder.append(_name_89, "\t\t\t");
                        _builder.append(" = temp_");
                        String _fullyQualifiedVariableName_5 = this.getFullyQualifiedVariableName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedVariableName_5, "\t\t\t");
                        _builder.append("_");
                        String _name_90 = v_2.getName();
                        _builder.append(_name_90, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("globalState.");
                        String _fullyQualifiedName_7 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedName_7, "\t\t\t");
                        _builder.append(".");
                        String _name_91 = v_2.getName();
                        _builder.append(_name_91, "\t\t\t");
                        _builder.append(" = commitState.");
                        String _fullyQualifiedName_8 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedName_8, "\t\t\t");
                        _builder.append(".");
                        String _name_92 = v_2.getName();
                        _builder.append(_name_92, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("}");
                        _builder.newLine();
                        continue;
                    }
                    Boolean _isArrayType_5 = this._componentParameterModelUtility.isArrayType(v_2);
                    if (_isArrayType_5.booleanValue()) {
                        _builder.append("\t\t");
                        _builder.append("if(parameter.get");
                        String _compileCommObjType_10 = this._componentParamsGenHelpers.compileCommObjType(v_2);
                        _builder.append(_compileCommObjType_10, "\t\t");
                        _builder.append("List(\"");
                        String _fullyQualifiedName_9 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedName_9, "\t\t");
                        _builder.append("\", \"");
                        String _name_93 = v_2.getName();
                        _builder.append(_name_93, "\t\t");
                        _builder.append("\", commitState.");
                        String _fullyQualifiedName_10 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedName_10, "\t\t");
                        _builder.append(".");
                        String _name_94 = v_2.getName();
                        _builder.append(_name_94, "\t\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append("\t\t");
                        _builder.append("if(parameter.get");
                        String _compileCommObjType_11 = this._componentParamsGenHelpers.compileCommObjType(v_2);
                        _builder.append(_compileCommObjType_11, "\t\t");
                        _builder.append("(\"");
                        String _fullyQualifiedName_11 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedName_11, "\t\t");
                        _builder.append("\", \"");
                        String _name_95 = v_2.getName();
                        _builder.append(_name_95, "\t\t");
                        _builder.append("\", commitState.");
                        String _fullyQualifiedName_12 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                        _builder.append(_fullyQualifiedName_12, "\t\t");
                        _builder.append(".");
                        String _name_96 = v_2.getName();
                        _builder.append(_name_96, "\t\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("globalState.");
                    String _fullyQualifiedName_13 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                    _builder.append(_fullyQualifiedName_13, "\t\t\t");
                    _builder.append(".");
                    String _name_97 = v_2.getName();
                    _builder.append(_name_97, "\t\t\t");
                    _builder.append(" = commitState.");
                    String _fullyQualifiedName_14 = this.getFullyQualifiedName((AbstractDocumentationElement)p_2);
                    _builder.append(_fullyQualifiedName_14, "\t\t\t");
                    _builder.append(".");
                    String _name_98 = v_2.getName();
                    _builder.append(_name_98, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                }
            }
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (const SmartACE::IniParameterError & e)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::cerr << \"Exception from parameter handling: \" << e << std::endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (const std::exception &ex)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::cerr << \"Uncaught std:: exception\" << ex.what() << std::endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (...)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::cerr << \"Uncaught exception\" << std::endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateHandleEntries(EList<AbstractComponentParameter> list) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (tag == \"COMMIT\")");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("answer.setResponse(globalState.handleCOMMIT(commitState));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(answer.getResponse() == SmartACE::ParamResponseType::OK) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("globalStateLock.acquire();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// change the content of the globalState, however change only the generated content");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// without affecting potential user member variables (which is more intuitive for the user)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("globalState.setContent(commitState);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("globalStateLock.release();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// the commit validation check returned != OK");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// the commit state is rejected and is not copied into the global state");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter(list, ExtendedParameter.class), (Functions.Function1)_function);
        for (ExtendedParameter ex : _sortBy) {
            _builder.append("else if (tag == \"");
            String _upperCase = ex.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("\")");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("answer.setResponse(SmartACE::ParamResponseType::OK); // TODO: this should be decided according to validation checks defined in the model (not yet implemented)");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            int counter = 0;
            _builder.newLineIfNotEmpty();
            EList _attributes = ex.getAttributes();
            for (AttributeDefinition v : _attributes) {
                Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(v);
                if (_isArrayType.booleanValue()) {
                    _builder.append("\t");
                    _builder.append("std::list<");
                    String _compileParamHandlerCppType = this._componentParamsGenHelpers.compileParamHandlerCppType(v.getType());
                    _builder.append(_compileParamHandlerCppType, "\t");
                    _builder.append("> temp_");
                    String _name = v.getName();
                    _builder.append(_name, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("if(request.get");
                    String _compileCommObjType = this._componentParamsGenHelpers.compileCommObjType(v);
                    _builder.append(_compileCommObjType, "\t");
                    _builder.append("List(\"");
                    _builder.append((Object)(++counter), "\t");
                    _builder.append("\", temp_");
                    String _name_1 = v.getName();
                    _builder.append(_name_1, "\t");
                    _builder.append(") == 0) {");
                    _builder.newLineIfNotEmpty();
                    AbstractAttributeType _type = v.getType();
                    if (_type instanceof InlineEnumerationType) {
                        _builder.append("\t");
                        _builder.append("commitState.");
                        String _name_2 = ex.getName();
                        _builder.append(_name_2, "\t");
                        _builder.append(".set");
                        String _firstUpper = StringExtensions.toFirstUpper((String)v.getName());
                        _builder.append(_firstUpper, "\t");
                        _builder.append("Type(temp_");
                        String _name_3 = v.getName();
                        _builder.append(_name_3, "\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append("\t");
                        _builder.append("commitState.");
                        String _name_4 = ex.getName();
                        _builder.append(_name_4, "\t");
                        _builder.append(".");
                        String _name_5 = v.getName();
                        _builder.append(_name_5, "\t");
                        _builder.append(" = temp_");
                        String _name_6 = v.getName();
                        _builder.append(_name_6, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                } else {
                    _builder.append("\t");
                    String _compileParamHandlerCppType_1 = this._componentParamsGenHelpers.compileParamHandlerCppType(v.getType());
                    _builder.append(_compileParamHandlerCppType_1, "\t");
                    _builder.append(" temp_");
                    String _name_7 = v.getName();
                    _builder.append(_name_7, "\t");
                    _builder.append(" = ");
                    String _standardValue = this._componentParamsGenHelpers.getStandardValue(v);
                    _builder.append(_standardValue, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("if(request.get");
                    String _compileCommObjType_1 = this._componentParamsGenHelpers.compileCommObjType(v);
                    _builder.append(_compileCommObjType_1, "\t");
                    _builder.append("(\"");
                    _builder.append((Object)(++counter), "\t");
                    _builder.append("\", temp_");
                    String _name_8 = v.getName();
                    _builder.append(_name_8, "\t");
                    _builder.append(") == 0) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("commitState.");
                    String _name_9 = ex.getName();
                    _builder.append(_name_9, "\t\t");
                    _builder.append(".");
                    String _name_10 = v.getName();
                    _builder.append(_name_10, "\t\t");
                    _builder.append(" = temp_");
                    String _name_11 = v.getName();
                    _builder.append(_name_11, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("} else {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("answer.setResponse(SmartACE::ParamResponseType::INVALID);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
        }
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)Iterables.filter(list, ExtendedTrigger.class), (Functions.Function1)_function_1);
        for (ExtendedTrigger exTr : _sortBy_1) {
            _builder.append("else if (tag == \"");
            String _upperCase_1 = exTr.getName().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("\")");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            int counter_1 = 0;
            _builder.newLineIfNotEmpty();
            EList _attributes_1 = exTr.getAttributes();
            for (AttributeDefinition v_1 : _attributes_1) {
                Boolean _isArrayType_1 = this._componentParameterModelUtility.isArrayType(v_1);
                if (_isArrayType_1.booleanValue()) {
                    _builder.append("\t");
                    _builder.append("std::list<");
                    String _compileParamHandlerCppType_2 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_1.getType());
                    _builder.append(_compileParamHandlerCppType_2, "\t");
                    _builder.append("> temp_");
                    String _name_12 = v_1.getName();
                    _builder.append(_name_12, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("if(request.get");
                    String _compileCommObjType_2 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                    _builder.append(_compileCommObjType_2, "\t");
                    _builder.append("List(\"");
                    _builder.append((Object)(++counter_1), "\t");
                    _builder.append("\", temp_");
                    String _name_13 = v_1.getName();
                    _builder.append(_name_13, "\t");
                    _builder.append(") != 0) {");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    String _compileParamHandlerCppType_3 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_1.getType());
                    _builder.append(_compileParamHandlerCppType_3, "\t");
                    _builder.append(" temp_");
                    String _name_14 = v_1.getName();
                    _builder.append(_name_14, "\t");
                    _builder.append(" = ");
                    String _standardValue_1 = this._componentParamsGenHelpers.getStandardValue(v_1);
                    _builder.append(_standardValue_1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("if(request.get");
                    String _compileCommObjType_3 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                    _builder.append(_compileCommObjType_3, "\t");
                    _builder.append("(\"");
                    _builder.append((Object)(++counter_1), "\t");
                    _builder.append("\", temp_");
                    String _name_15 = v_1.getName();
                    _builder.append(_name_15, "\t");
                    _builder.append(") != 0) {");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("answer.setResponse(SmartACE::ParamResponseType::INVALID);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if(answer.getResponse() == SmartACE::ParamResponseType::OK) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("triggerHandler.handle");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)exTr.getName());
            _builder.append(_firstUpper_1, "\t\t");
            _builder.append("Core(");
            _builder.newLineIfNotEmpty();
            EList _attributes_2 = exTr.getAttributes();
            for (AttributeDefinition v_2 : _attributes_2) {
                boolean _notEquals_1;
                if (this._componentParameterModelUtility.isArrayType(v_2).booleanValue() && v_2.getType() instanceof InlineEnumerationType) {
                    boolean _notEquals;
                    _builder.append("\t\t");
                    _builder.append("TriggerHandler::");
                    String _name_16 = exTr.getName();
                    _builder.append(_name_16, "\t\t");
                    _builder.append("Type::convert");
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)v_2.getName());
                    _builder.append(_firstUpper_2, "\t\t");
                    _builder.append("Type(temp_");
                    String _name_17 = v_2.getName();
                    _builder.append(_name_17, "\t\t");
                    _builder.append(")");
                    AttributeDefinition _last = (AttributeDefinition)IterableExtensions.last((Iterable)exTr.getAttributes());
                    boolean bl = _notEquals = !Objects.equal((Object)v_2, (Object)_last);
                    if (_notEquals) {
                        _builder.append(", ");
                    }
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t\t");
                _builder.append("temp_");
                String _name_18 = v_2.getName();
                _builder.append(_name_18, "\t\t");
                AttributeDefinition _last_1 = (AttributeDefinition)IterableExtensions.last((Iterable)exTr.getAttributes());
                boolean bl = _notEquals_1 = !Objects.equal((Object)v_2, (Object)_last_1);
                if (_notEquals_1) {
                    _builder.append(", ");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append(");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)Iterables.filter(list, ParameterSetInstance.class), (Functions.Function1)_function_2);
        for (ParameterSetInstance ex_1 : _sortBy_2) {
            Functions.Function1 _function_3 = it -> it.getName();
            List _sortBy_3 = IterableExtensions.sortBy((Iterable)ex_1.getParamSet().getParameters(), (Functions.Function1)_function_3);
            for (AbstractParameter p : _sortBy_3) {
                _builder.append("else if (tag == \"");
                String _upperCase_2 = this.getFullyQualifiedName((AbstractDocumentationElement)p).toUpperCase();
                _builder.append(_upperCase_2);
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
                _builder.append("{");
                _builder.newLine();
                if (p instanceof TriggerDefinition) {
                    _builder.append("\t");
                    _builder.append("answer.setResponse(SmartACE::ParamResponseType::OK);");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    int counter_2 = 0;
                    _builder.newLineIfNotEmpty();
                    EList _attributes_3 = ((TriggerDefinition)p).getAttributes();
                    for (AttributeDefinition v_3 : _attributes_3) {
                        Boolean _isArrayType_2 = this._componentParameterModelUtility.isArrayType(v_3);
                        if (_isArrayType_2.booleanValue()) {
                            _builder.append("\t");
                            _builder.append("std::list<");
                            String _compileParamHandlerCppType_4 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_3.getType());
                            _builder.append(_compileParamHandlerCppType_4, "\t");
                            _builder.append("> temp_");
                            String _name_19 = v_3.getName();
                            _builder.append(_name_19, "\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("if(request.get");
                            String _compileCommObjType_4 = this._componentParamsGenHelpers.compileCommObjType(v_3);
                            _builder.append(_compileCommObjType_4, "\t");
                            _builder.append("List(\"");
                            _builder.append((Object)(++counter_2), "\t");
                            _builder.append("\", temp_");
                            String _name_20 = v_3.getName();
                            _builder.append(_name_20, "\t");
                            _builder.append(") != 0) {");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("\t");
                            String _compileParamHandlerCppType_5 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_3.getType());
                            _builder.append(_compileParamHandlerCppType_5, "\t");
                            _builder.append(" temp_");
                            String _name_21 = v_3.getName();
                            _builder.append(_name_21, "\t");
                            _builder.append(" = ");
                            String _standardValue_2 = this._componentParamsGenHelpers.getStandardValue(v_3);
                            _builder.append(_standardValue_2, "\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("if(request.get");
                            String _compileCommObjType_5 = this._componentParamsGenHelpers.compileCommObjType(v_3);
                            _builder.append(_compileCommObjType_5, "\t");
                            _builder.append("(\"");
                            _builder.append((Object)(++counter_2), "\t");
                            _builder.append("\", temp_");
                            String _name_22 = v_3.getName();
                            _builder.append(_name_22, "\t");
                            _builder.append(") != 0) {");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("answer.setResponse(SmartACE::ParamResponseType::INVALID);");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                    }
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("if(answer.getResponse() == SmartACE::ParamResponseType::OK) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("triggerHandler.handle");
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)this.getFullyQualifiedVariableName((AbstractDocumentationElement)p));
                    _builder.append(_firstUpper_3, "\t\t");
                    _builder.append("Core(");
                    _builder.newLineIfNotEmpty();
                    EList _attributes_4 = ((TriggerDefinition)p).getAttributes();
                    for (AttributeDefinition v_4 : _attributes_4) {
                        boolean _notEquals_3;
                        if (this._componentParameterModelUtility.isArrayType(v_4).booleanValue() && v_4.getType() instanceof InlineEnumerationType) {
                            boolean _notEquals_2;
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("TriggerHandler::");
                            String _name_23 = ((TriggerDefinition)p).getName();
                            _builder.append(_name_23, "\t\t");
                            _builder.append("Type::convert");
                            String _firstUpper_4 = StringExtensions.toFirstUpper((String)v_4.getName());
                            _builder.append(_firstUpper_4, "\t\t");
                            _builder.append("Type(temp_");
                            String _name_24 = v_4.getName();
                            _builder.append(_name_24, "\t\t");
                            _builder.append(")");
                            AttributeDefinition _last_2 = (AttributeDefinition)IterableExtensions.last((Iterable)((TriggerDefinition)p).getAttributes());
                            boolean bl = _notEquals_2 = !Objects.equal((Object)v_4, (Object)_last_2);
                            if (_notEquals_2) {
                                _builder.append(", ");
                            }
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("temp_");
                        String _name_25 = v_4.getName();
                        _builder.append(_name_25, "\t\t");
                        AttributeDefinition _last_3 = (AttributeDefinition)IterableExtensions.last((Iterable)((TriggerDefinition)p).getAttributes());
                        boolean bl = _notEquals_3 = !Objects.equal((Object)v_4, (Object)_last_3);
                        if (_notEquals_3) {
                            _builder.append(", ");
                        }
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append(");");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                } else if (p instanceof ParameterDefinition) {
                    _builder.append("\t");
                    _builder.append("answer.setResponse(SmartACE::ParamResponseType::OK); // TODO: this should be decided according to validation checks defined in the model (not yet implemented)");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    int counter_3 = 0;
                    _builder.newLineIfNotEmpty();
                    EList _attributes_5 = ((ParameterDefinition)p).getAttributes();
                    for (AttributeDefinition v_5 : _attributes_5) {
                        Boolean _isArrayType_3 = this._componentParameterModelUtility.isArrayType(v_5);
                        if (_isArrayType_3.booleanValue()) {
                            _builder.append("\t");
                            _builder.append("std::list<");
                            String _compileParamHandlerCppType_6 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_5.getType());
                            _builder.append(_compileParamHandlerCppType_6, "\t");
                            _builder.append("> temp_");
                            String _name_26 = v_5.getName();
                            _builder.append(_name_26, "\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("if(request.get");
                            String _compileCommObjType_6 = this._componentParamsGenHelpers.compileCommObjType(v_5);
                            _builder.append(_compileCommObjType_6, "\t");
                            _builder.append("List(\"");
                            _builder.append((Object)(++counter_3), "\t");
                            _builder.append("\", temp_");
                            String _name_27 = v_5.getName();
                            _builder.append(_name_27, "\t");
                            _builder.append(") == 0) {");
                            _builder.newLineIfNotEmpty();
                            AbstractAttributeType _type_1 = v_5.getType();
                            if (_type_1 instanceof InlineEnumerationType) {
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("commitState.");
                                String _fullyQualifiedName = this.getFullyQualifiedName((AbstractDocumentationElement)p);
                                _builder.append(_fullyQualifiedName, "\t\t");
                                _builder.append(".set");
                                String _firstUpper_5 = StringExtensions.toFirstUpper((String)v_5.getName());
                                _builder.append(_firstUpper_5, "\t\t");
                                _builder.append("Type(temp_");
                                String _name_28 = v_5.getName();
                                _builder.append(_name_28, "\t\t");
                                _builder.append(");");
                                _builder.newLineIfNotEmpty();
                            } else {
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("commitState.");
                                String _fullyQualifiedName_1 = this.getFullyQualifiedName((AbstractDocumentationElement)p);
                                _builder.append(_fullyQualifiedName_1, "\t\t");
                                _builder.append(".");
                                String _name_29 = v_5.getName();
                                _builder.append(_name_29, "\t\t");
                                _builder.append(" = temp_");
                                String _name_30 = v_5.getName();
                                _builder.append(_name_30, "\t\t");
                                _builder.append(";");
                                _builder.newLineIfNotEmpty();
                            }
                        } else {
                            _builder.append("\t");
                            String _compileParamHandlerCppType_7 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_5.getType());
                            _builder.append(_compileParamHandlerCppType_7, "\t");
                            _builder.append(" temp_");
                            String _name_31 = v_5.getName();
                            _builder.append(_name_31, "\t");
                            _builder.append(" = ");
                            String _standardValue_3 = this._componentParamsGenHelpers.getStandardValue(v_5);
                            _builder.append(_standardValue_3, "\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("if(request.get");
                            String _compileCommObjType_7 = this._componentParamsGenHelpers.compileCommObjType(v_5);
                            _builder.append(_compileCommObjType_7, "\t");
                            _builder.append("(\"");
                            _builder.append((Object)(++counter_3), "\t");
                            _builder.append("\", temp_");
                            String _name_32 = v_5.getName();
                            _builder.append(_name_32, "\t");
                            _builder.append(") == 0) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("commitState.");
                            String _fullyQualifiedName_2 = this.getFullyQualifiedName((AbstractDocumentationElement)p);
                            _builder.append(_fullyQualifiedName_2, "\t\t");
                            _builder.append(".");
                            String _name_33 = v_5.getName();
                            _builder.append(_name_33, "\t\t");
                            _builder.append(" = temp_");
                            String _name_34 = v_5.getName();
                            _builder.append(_name_34, "\t\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("\t");
                        _builder.append("} else {");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("answer.setResponse(SmartACE::ParamResponseType::INVALID);");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                    }
                    _builder.append("\t");
                    _builder.newLine();
                }
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("else");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/////////////////////////////////////////////////////////////////////");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// default new");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::cout<<\"ERROR wrong Parameter!\"<<std::endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("answer.setResponse(SmartACE::ParamResponseType::INVALID);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileUpdateHandlerHH(ComponentParameter usage) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _PARAMUPDATEHANDLER_HH_");
        _builder.newLine();
        _builder.append("#define _PARAMUPDATEHANDLER_HH_");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"aceSmartSoft.hh\"");
        _builder.newLine();
        _builder.append("#include \"");
        String _ParameterStateStructHeaderFileName = this.ParameterStateStructHeaderFileName(usage);
        _builder.append(_ParameterStateStructHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        if (IterableExtensions.exists((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), pi -> {
            Functions.Function1 _function = pd -> pd instanceof TriggerDefinition;
            return IterableExtensions.exists((Iterable)pi.getParamSet().getParameters(), (Functions.Function1)_function);
        }) || IterableExtensions.exists((Iterable)usage.getParameters(), tr -> tr instanceof ExtendedTrigger)) {
            _builder.append("#include \"");
            String _TriggerHandlerHeaderFileName = this.TriggerHandlerHeaderFileName(usage);
            _builder.append(_TriggerHandlerHeaderFileName);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("class ParamUpdateHandler: public SmartACE::ParameterUpdateHandler {");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SmartACE::CommParameterResponse handleParameter(const SmartACE::CommParameterRequest& request);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ParameterStateStruct getGlobalState() const;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void loadParameter(SmartACE::SmartIniParameter &parameter);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//local globale state stuff");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ParameterStateStruct globalState,commitState;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mutable SmartACE::SmartMutex globalStateLock;");
        _builder.newLine();
        if (IterableExtensions.exists((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), pi -> {
            Functions.Function1 _function = pd -> pd instanceof TriggerDefinition;
            return IterableExtensions.exists((Iterable)pi.getParamSet().getParameters(), (Functions.Function1)_function);
        }) || IterableExtensions.exists((Iterable)usage.getParameters(), tr -> tr instanceof ExtendedTrigger)) {
            _builder.append("\t");
            _builder.append("TriggerHandler triggerHandler;");
            _builder.newLine();
        }
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileStructCore(ComponentParameter usage) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _PARAMETERSTATESTRUCTCORE_HH");
        _builder.newLine();
        _builder.append("#define _PARAMETERSTATESTRUCTCORE_HH");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"aceSmartSoft.hh\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <iostream>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// forward declaration (in order to define validateCOMMIT(ParameterStateStruct) which is implemented in derived class)");
        _builder.newLine();
        _builder.append("class ParameterStateStruct;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ParameterStateStructCore");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("friend class ParamUpdateHandler;");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateMemberStructs = this.generateMemberStructs(usage);
        _builder.append((Object)_generateMemberStructs, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("protected:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateMemberVariables = this.generateMemberVariables(usage);
        _builder.append((Object)_generateMemberVariables, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateMembersCopyFunction = this.generateMembersCopyFunction(usage);
        _builder.append((Object)_generateMembersCopyFunction, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// special trigger method (user upcall) called before updating parameter global state");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual SmartACE::ParamResponseType handleCOMMIT(const ParameterStateStruct &commitState) = 0;");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ParameterStateStructCore() {  }");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual ~ParameterStateStructCore() {  }");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateGetterMethods = this.generateGetterMethods(usage);
        _builder.append((Object)_generateGetterMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// helper method to easily implement output stream in derived classes");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void to_ostream(std::ostream &os = std::cout) const");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _generateOSmembers = this.generateOSmembers(usage);
        _builder.append((Object)_generateOSmembers, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateEnumClass(AttributeDefinition attr) {
        StringConcatenation _xifexpression = null;
        AbstractAttributeType _type = attr.getType();
        if (_type instanceof InlineEnumerationType) {
            StringConcatenation _xblockexpression = null;
            AbstractAttributeType _type_1 = attr.getType();
            InlineEnumerationType en = (InlineEnumerationType)_type_1;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Wrapper class for Enum ");
            String _name = attr.getName();
            _builder.append(_name, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("class ");
            String _name_1 = attr.getName();
            _builder.append(_name_1);
            _builder.append("Type {");
            _builder.newLineIfNotEmpty();
            _builder.append("public:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("enum ENUM_");
            String _name_2 = attr.getName();
            _builder.append(_name_2, "\t");
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("ENUM_VALUE_UNDEFINED = 0,");
            _builder.newLine();
            _builder.append("\t\t");
            int counter = 0;
            _builder.newLineIfNotEmpty();
            EList _enums = en.getEnums();
            for (EnumerationElement el : _enums) {
                boolean _notEquals;
                _builder.append("\t\t");
                String _name_3 = el.getName();
                _builder.append(_name_3, "\t\t");
                _builder.append(" = ");
                _builder.append((Object)(++counter), "\t\t");
                EnumerationElement _last = (EnumerationElement)IterableExtensions.last((Iterable)en.getEnums());
                boolean bl = _notEquals = !Objects.equal((Object)el, (Object)_last);
                if (_notEquals) {
                    _builder.append(",");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("};");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// default constructor");
            _builder.newLine();
            _builder.append("\t");
            String _name_4 = attr.getName();
            _builder.append(_name_4, "\t");
            _builder.append("Type() { ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("value = ENUM_VALUE_UNDEFINED;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// copy constructor for enum type");
            _builder.newLine();
            _builder.append("\t");
            String _name_5 = attr.getName();
            _builder.append(_name_5, "\t");
            _builder.append("Type(ENUM_");
            String _name_6 = attr.getName();
            _builder.append(_name_6, "\t");
            _builder.append(" e) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("value = e;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// copy constructor for String type");
            _builder.newLine();
            _builder.append("\t");
            String _name_7 = attr.getName();
            _builder.append(_name_7, "\t");
            _builder.append("Type(const std::string &literal) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("from_string(literal);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// from_string assignment operator");
            _builder.newLine();
            _builder.append("\t");
            String _name_8 = attr.getName();
            _builder.append(_name_8, "\t");
            _builder.append("Type& operator = (const std::string &literal) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("from_string(literal);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return *this;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// ENUM operator");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("operator ENUM_");
            String _name_9 = attr.getName();
            _builder.append(_name_9, "\t");
            _builder.append("() const {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("return value;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// String operator");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("operator std::string() const {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return to_string();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// compare operator");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("bool operator == (const ENUM_");
            String _name_10 = attr.getName();
            _builder.append(_name_10, "\t");
            _builder.append(" t) const {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("return this->value == t;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("std::string to_string() const {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("std::string result = \"\";");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("switch (value) {");
            _builder.newLine();
            Functions.Function1 _function = it -> it.getName();
            List _sortBy = IterableExtensions.sortBy((Iterable)en.getEnums(), (Functions.Function1)_function);
            for (EnumerationElement el_1 : _sortBy) {
                _builder.append("\t\t\t");
                _builder.append("case ");
                String _name_11 = el_1.getName();
                _builder.append(_name_11, "\t\t\t");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("result = \"");
                String _name_12 = el_1.getName();
                _builder.append(_name_12, "\t\t\t\t");
                _builder.append("\";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("\t\t\t");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("result = \"ENUM_VALUE_UNDEFINED\";");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("};");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("void from_string(const std::string &literal) {");
            _builder.newLine();
            EList _enums_1 = en.getEnums();
            for (EnumerationElement el_2 : _enums_1) {
                EnumerationElement _head;
                boolean _equals = Objects.equal((Object)el_2, (Object)(_head = (EnumerationElement)IterableExtensions.head((Iterable)en.getEnums())));
                if (_equals) {
                    _builder.append("\t\t");
                    _builder.append("if(literal == \"");
                    String _name_13 = el_2.getName();
                    _builder.append(_name_13, "\t\t");
                    _builder.append("\") {");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t\t");
                    _builder.append("} else if(literal == \"");
                    String _name_14 = el_2.getName();
                    _builder.append(_name_14, "\t\t");
                    _builder.append("\") {");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("value = ");
                String _name_15 = el_2.getName();
                _builder.append(_name_15, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("value = ENUM_VALUE_UNDEFINED;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// helper method to easily implement output stream");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("void to_ostream(std::ostream &os = std::cout) const {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("os << to_string();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("private:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ENUM_");
            String _name_16 = attr.getName();
            _builder.append(_name_16, "\t");
            _builder.append(" value;");
            _builder.newLineIfNotEmpty();
            _builder.append("};");
            _builder.newLine();
            _xifexpression = _xblockexpression = _builder;
        }
        return _xifexpression;
    }

    public CharSequence generateMemberStructs(ComponentParameter usage) {
        Iterator iterator;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        _builder.append("///////////////////////////////////////////");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Internal params");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("///////////////////////////////////////////");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        Iterable _filter = Iterables.filter((Iterable)usage.getParameters(), InternalParameter.class);
        for (InternalParameter internalParameter : _filter) {
            Object attr22;
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* Definition of Parameter ");
            String _name = internalParameter.getName();
            _builder.append(_name, "\t ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("class ");
            String _name_1 = internalParameter.getName();
            _builder.append(_name_1, "\t");
            _builder.append("Type ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("friend class ParamUpdateHandler;");
            _builder.newLine();
            Functions.Function1 _function = v -> {
                AbstractAttributeType _type = v.getType();
                return _type instanceof InlineEnumerationType;
            };
            Functions.Function1 _function_1 = it -> it.getName();
            List _sortBy = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)internalParameter.getAttributes(), (Functions.Function1)_function), (Functions.Function1)_function_1);
            for (Object attr22 : _sortBy) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _generateEnumClass = this.generateEnumClass((AttributeDefinition)attr22);
                _builder.append((Object)_generateEnumClass, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                Boolean _isArrayType = this._componentParameterModelUtility.isArrayType((AttributeDefinition)attr22);
                if (!_isArrayType.booleanValue()) continue;
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _generateEnumArrayConversionMethod = this.generateEnumArrayConversionMethod((AttributeDefinition)attr22);
                _builder.append((Object)_generateEnumArrayConversionMethod, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("protected:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t ");
            _builder.append("* here are the member definitions");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t ");
            _builder.append("*/");
            _builder.newLine();
            Functions.Function1 _function_2 = it -> it.getName();
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)internalParameter.getAttributes(), (Functions.Function1)_function_2);
            attr22 = _sortBy_1.iterator();
            while (attr22.hasNext()) {
                AttributeDefinition el = (AttributeDefinition)attr22.next();
                Boolean _isArrayType_1 = this._componentParameterModelUtility.isArrayType(el);
                if (_isArrayType_1.booleanValue()) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("std::list<");
                    String _compileCppType = this._componentParamsGenHelpers.compileCppType(el);
                    _builder.append(_compileCppType, "\t\t");
                    _builder.append("> ");
                    String _name_2 = el.getName();
                    _builder.append(_name_2, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                _builder.append("\t");
                String _compileCppType_1 = this._componentParamsGenHelpers.compileCppType(el);
                _builder.append(_compileCppType_1, "\t\t");
                _builder.append(" ");
                String _name_3 = el.getName();
                _builder.append(_name_3, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// default constructor");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _name_4 = internalParameter.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append("Type() {");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_3 = it -> it.getName();
            List _sortBy_2 = IterableExtensions.sortBy((Iterable)internalParameter.getAttributes(), (Functions.Function1)_function_3);
            for (AttributeDefinition el_1 : _sortBy_2) {
                boolean _tripleNotEquals;
                ArrayType _array = el_1.getType().getArray();
                boolean bl = _tripleNotEquals = _array != null;
                if (_tripleNotEquals) {
                    AbstractValue _defaultvalue = el_1.getDefaultvalue();
                    EList _values = ((ArrayValue)_defaultvalue).getValues();
                    for (SingleValue v2 : _values) {
                        _builder.append("\t");
                        _builder.append("\t\t");
                        String _name_5 = el_1.getName();
                        _builder.append(_name_5, "\t\t\t");
                        _builder.append(".push_back(");
                        String _compileContent = this._componentParamsGenHelpers.compileContent((AbstractValue)v2);
                        _builder.append(_compileContent, "\t\t\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                    }
                    continue;
                }
                _builder.append("\t");
                _builder.append("\t\t");
                String _name_6 = el_1.getName();
                _builder.append(_name_6, "\t\t\t");
                _builder.append(" = ");
                String _compileContent_1 = this._componentParamsGenHelpers.compileContent(el_1.getDefaultvalue());
                _builder.append(_compileContent_1, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t ");
            _builder.append("* here are the public getters");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t ");
            _builder.append("*/");
            _builder.newLine();
            Functions.Function1 _function_4 = it -> it.getName();
            List _sortBy_3 = IterableExtensions.sortBy((Iterable)internalParameter.getAttributes(), (Functions.Function1)_function_4);
            for (AttributeDefinition el_2 : _sortBy_3) {
                boolean _tripleNotEquals_1;
                ArrayType _array_1 = el_2.getType().getArray();
                boolean bl = _tripleNotEquals_1 = _array_1 != null;
                if (_tripleNotEquals_1) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("inline std::list<");
                    String _compileCppType_2 = this._componentParamsGenHelpers.compileCppType(el_2);
                    _builder.append(_compileCppType_2, "\t\t");
                    _builder.append("> get");
                    String _firstUpper = StringExtensions.toFirstUpper((String)el_2.getName());
                    _builder.append(_firstUpper, "\t\t");
                    _builder.append("() const { return ");
                    String _name_7 = el_2.getName();
                    _builder.append(_name_7, "\t\t");
                    _builder.append("; }");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("inline ");
                String _compileCppType_3 = this._componentParamsGenHelpers.compileCppType(el_2);
                _builder.append(_compileCppType_3, "\t\t");
                _builder.append(" get");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)el_2.getName());
                _builder.append(_firstUpper_1, "\t\t");
                _builder.append("() const { return ");
                String _name_8 = el_2.getName();
                _builder.append(_name_8, "\t\t");
                _builder.append("; }");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("void to_ostream(std::ostream &os = std::cout) const");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("os << \"");
            String _name_9 = internalParameter.getName();
            _builder.append(_name_9, "\t\t\t");
            _builder.append("(\";");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_5 = it -> it.getName();
            List _sortBy_4 = IterableExtensions.sortBy((Iterable)internalParameter.getAttributes(), (Functions.Function1)_function_5);
            for (AttributeDefinition el_3 : _sortBy_4) {
                AbstractValue _defaultvalue_1 = el_3.getDefaultvalue();
                if (_defaultvalue_1 instanceof ArrayValue) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("std::list<");
                    String _compileCppType_4 = this._componentParamsGenHelpers.compileCppType(el_3);
                    _builder.append(_compileCppType_4, "\t\t\t");
                    _builder.append(">::const_iterator ");
                    String _name_10 = el_3.getName();
                    _builder.append(_name_10, "\t\t\t");
                    _builder.append("It;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("for(");
                    String _name_11 = el_3.getName();
                    _builder.append(_name_11, "\t\t\t");
                    _builder.append("It=");
                    String _name_12 = el_3.getName();
                    _builder.append(_name_12, "\t\t\t");
                    _builder.append(".begin(); ");
                    String _name_13 = el_3.getName();
                    _builder.append(_name_13, "\t\t\t");
                    _builder.append("It!=");
                    String _name_14 = el_3.getName();
                    _builder.append(_name_14, "\t\t\t");
                    _builder.append(".end(); ");
                    String _name_15 = el_3.getName();
                    _builder.append(_name_15, "\t\t\t");
                    _builder.append("It++)");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    AbstractValue _defaultvalue_2 = el_3.getDefaultvalue();
                    EList _values_1 = ((ArrayValue)_defaultvalue_2).getValues();
                    iterator = _values_1.iterator();
                    while (iterator.hasNext()) {
                        SingleValue cfr_ignored_0 = (SingleValue)iterator.next();
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("os << \"");
                        String _name_16 = el_3.getName();
                        _builder.append(_name_16, "\t\t\t");
                        _builder.append(" = \" << *");
                        String _name_17 = el_3.getName();
                        _builder.append(_name_17, "\t\t\t");
                        _builder.append("It << \", \";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    continue;
                }
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("os << \"");
                String _name_18 = el_3.getName();
                _builder.append(_name_18, "\t\t\t");
                _builder.append(" = \" << ");
                String _name_19 = el_3.getName();
                _builder.append(_name_19, "\t\t\t");
                _builder.append(" << \", \";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("os << \")\\n\";");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}; // end class ");
            String _name_20 = internalParameter.getName();
            _builder.append(_name_20, "\t");
            _builder.append("Type");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("///////////////////////////////////////////");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// External params");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("///////////////////////////////////////////");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        Iterable _filter_1 = Iterables.filter((Iterable)usage.getParameters(), ExtendedParameter.class);
        for (ExtendedParameter extendedParameter : _filter_1) {
            Object attr_122;
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* Definition of Parameter ");
            String _name_21 = extendedParameter.getName();
            _builder.append(_name_21, "\t ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("class ");
            String _name_22 = extendedParameter.getName();
            _builder.append(_name_22, "\t");
            _builder.append("Type ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("friend class ParamUpdateHandler;");
            _builder.newLine();
            Functions.Function1 _function_6 = v_2 -> {
                AbstractAttributeType _type = v_2.getType();
                return _type instanceof InlineEnumerationType;
            };
            Functions.Function1 _function_7 = it -> it.getName();
            List _sortBy_5 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)extendedParameter.getAttributes(), (Functions.Function1)_function_6), (Functions.Function1)_function_7);
            for (Object attr_122 : _sortBy_5) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _generateEnumClass_1 = this.generateEnumClass((AttributeDefinition)attr_122);
                _builder.append((Object)_generateEnumClass_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                Boolean _isArrayType_2 = this._componentParameterModelUtility.isArrayType((AttributeDefinition)attr_122);
                if (!_isArrayType_2.booleanValue()) continue;
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _generateEnumArrayConversionMethod_1 = this.generateEnumArrayConversionMethod((AttributeDefinition)attr_122);
                _builder.append((Object)_generateEnumArrayConversionMethod_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("protected:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t ");
            _builder.append("* here are the member definitions");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t ");
            _builder.append("*/");
            _builder.newLine();
            Functions.Function1 _function_8 = it -> it.getName();
            List _sortBy_6 = IterableExtensions.sortBy((Iterable)extendedParameter.getAttributes(), (Functions.Function1)_function_8);
            attr_122 = _sortBy_6.iterator();
            while (attr_122.hasNext()) {
                AttributeDefinition el_4 = (AttributeDefinition)attr_122.next();
                Boolean _isArrayType_3 = this._componentParameterModelUtility.isArrayType(el_4);
                if (_isArrayType_3.booleanValue()) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("std::list<");
                    String _compileCppType_5 = this._componentParamsGenHelpers.compileCppType(el_4);
                    _builder.append(_compileCppType_5, "\t\t");
                    _builder.append("> ");
                    String _name_23 = el_4.getName();
                    _builder.append(_name_23, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                _builder.append("\t");
                String _compileCppType_6 = this._componentParamsGenHelpers.compileCppType(el_4);
                _builder.append(_compileCppType_6, "\t\t");
                _builder.append(" ");
                String _name_24 = el_4.getName();
                _builder.append(_name_24, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// default constructor");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _name_25 = extendedParameter.getName();
            _builder.append(_name_25, "\t\t");
            _builder.append("Type() {");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_9 = it -> it.getName();
            List _sortBy_7 = IterableExtensions.sortBy((Iterable)extendedParameter.getAttributes(), (Functions.Function1)_function_9);
            for (AttributeDefinition el_5 : _sortBy_7) {
                AbstractValue _defaultvalue_3 = el_5.getDefaultvalue();
                if (_defaultvalue_3 instanceof ArrayValue) {
                    AbstractValue _defaultvalue_4 = el_5.getDefaultvalue();
                    EList _values_2 = ((ArrayValue)_defaultvalue_4).getValues();
                    for (SingleValue v_22 : _values_2) {
                        _builder.append("\t");
                        _builder.append("\t\t");
                        String _name_26 = el_5.getName();
                        _builder.append(_name_26, "\t\t\t");
                        _builder.append(".push_back(");
                        String _compileContent_2 = this._componentParamsGenHelpers.compileContent((AbstractValue)v_22);
                        _builder.append(_compileContent_2, "\t\t\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                    }
                    continue;
                }
                _builder.append("\t");
                _builder.append("\t\t");
                String _name_27 = el_5.getName();
                _builder.append(_name_27, "\t\t\t");
                _builder.append(" = ");
                String _compileContent_3 = this._componentParamsGenHelpers.compileContent(el_5.getDefaultvalue());
                _builder.append(_compileContent_3, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t ");
            _builder.append("* here are the public getters");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t ");
            _builder.append("*/");
            _builder.newLine();
            Functions.Function1 _function_10 = it -> it.getName();
            List _sortBy_8 = IterableExtensions.sortBy((Iterable)extendedParameter.getAttributes(), (Functions.Function1)_function_10);
            for (AttributeDefinition el_6 : _sortBy_8) {
                Boolean _isArrayType_4 = this._componentParameterModelUtility.isArrayType(el_6);
                if (_isArrayType_4.booleanValue()) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("inline std::list<");
                    String _compileCppType_7 = this._componentParamsGenHelpers.compileCppType(el_6);
                    _builder.append(_compileCppType_7, "\t\t");
                    _builder.append("> get");
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)el_6.getName());
                    _builder.append(_firstUpper_2, "\t\t");
                    _builder.append("() const { return ");
                    String _name_28 = el_6.getName();
                    _builder.append(_name_28, "\t\t");
                    _builder.append("; }");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("inline ");
                String _compileCppType_8 = this._componentParamsGenHelpers.compileCppType(el_6);
                _builder.append(_compileCppType_8, "\t\t");
                _builder.append(" get");
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)el_6.getName());
                _builder.append(_firstUpper_3, "\t\t");
                _builder.append("() const { return ");
                String _name_29 = el_6.getName();
                _builder.append(_name_29, "\t\t");
                _builder.append("; }");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("void to_ostream(std::ostream &os = std::cout) const");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("os << \"");
            String _name_30 = extendedParameter.getName();
            _builder.append(_name_30, "\t\t\t");
            _builder.append("(\";");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_11 = it -> it.getName();
            List _sortBy_9 = IterableExtensions.sortBy((Iterable)extendedParameter.getAttributes(), (Functions.Function1)_function_11);
            for (AttributeDefinition el_7 : _sortBy_9) {
                AbstractValue _defaultvalue_5 = el_7.getDefaultvalue();
                if (_defaultvalue_5 instanceof ArrayValue) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("std::list<");
                    String _compileCppType_9 = this._componentParamsGenHelpers.compileCppType(el_7);
                    _builder.append(_compileCppType_9, "\t\t\t");
                    _builder.append(">::const_iterator ");
                    String _name_31 = el_7.getName();
                    _builder.append(_name_31, "\t\t\t");
                    _builder.append("It;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("for(");
                    String _name_32 = el_7.getName();
                    _builder.append(_name_32, "\t\t\t");
                    _builder.append("It=");
                    String _name_33 = el_7.getName();
                    _builder.append(_name_33, "\t\t\t");
                    _builder.append(".begin(); ");
                    String _name_34 = el_7.getName();
                    _builder.append(_name_34, "\t\t\t");
                    _builder.append("It!=");
                    String _name_35 = el_7.getName();
                    _builder.append(_name_35, "\t\t\t");
                    _builder.append(".end(); ");
                    String _name_36 = el_7.getName();
                    _builder.append(_name_36, "\t\t\t");
                    _builder.append("It++)");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    AbstractValue _defaultvalue_6 = el_7.getDefaultvalue();
                    EList _values_3 = ((ArrayValue)_defaultvalue_6).getValues();
                    iterator = _values_3.iterator();
                    while (iterator.hasNext()) {
                        SingleValue cfr_ignored_1 = (SingleValue)iterator.next();
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("os << \"");
                        String _name_37 = el_7.getName();
                        _builder.append(_name_37, "\t\t\t");
                        _builder.append(" = \" << *");
                        String _name_38 = el_7.getName();
                        _builder.append(_name_38, "\t\t\t");
                        _builder.append("It << \", \";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    continue;
                }
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("os << \"");
                String _name_39 = el_7.getName();
                _builder.append(_name_39, "\t\t\t");
                _builder.append(" = \" << ");
                Iterator _name_40 = el_7.getName();
                _builder.append((String)((Object)_name_40), "\t\t\t");
                _builder.append(" << \", \";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("os << \")\\n\";");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}; // end class ");
            String _name_41 = extendedParameter.getName();
            _builder.append(_name_41, "\t");
            _builder.append("Type");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("///////////////////////////////////////////");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Instance params");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("///////////////////////////////////////////");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        Set<Map.Entry<String, List<ParameterSetInstance>>> _entrySet = this.getAllRepos(usage).entrySet();
        for (Map.Entry entry : _entrySet) {
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* Definition of instantiated ParameterRepository ");
            String _key = (String)entry.getKey();
            _builder.append(_key, "\t ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("class ");
            String _key_1 = (String)entry.getKey();
            _builder.append(_key_1, "\t");
            _builder.append("Type {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("friend class ParamUpdateHandler;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public:");
            _builder.newLine();
            List _value = (List)entry.getValue();
            for (ParameterSetInstance set_inst : _value) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("/**");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("* Definition of instantiated ParameterSet ");
                String _name_42 = set_inst.getParamSet().getName();
                _builder.append(_name_42, "\t\t ");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("class ");
                String _name_43 = set_inst.getParamSet().getName();
                _builder.append(_name_43, "\t\t");
                _builder.append("Type {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("friend class ParamUpdateHandler;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public:");
                _builder.newLine();
                Functions.Function1 _function_12 = it -> it.getName();
                List _sortBy_10 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)set_inst.getParamSet().getParameters(), ParameterDefinition.class), (Functions.Function1)_function_12);
                for (ParameterDefinition param : _sortBy_10) {
                    Object attr_222;
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append(" ");
                    _builder.append("* Definition of Parameter ");
                    String _name_44 = param.getName();
                    _builder.append(_name_44, "\t\t\t ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append(" ");
                    _builder.append("*/");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("class ");
                    String _name_45 = param.getName();
                    _builder.append(_name_45, "\t\t\t");
                    _builder.append("Type {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("friend class ParamUpdateHandler;");
                    _builder.newLine();
                    Functions.Function1 _function_13 = it -> {
                        AbstractAttributeType _type = it.getType();
                        return _type instanceof InlineEnumerationType;
                    };
                    Functions.Function1 _function_14 = it -> it.getName();
                    List _sortBy_11 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)param.getAttributes(), (Functions.Function1)_function_13), (Functions.Function1)_function_14);
                    for (Object attr_222 : _sortBy_11) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("public:");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        CharSequence _generateEnumClass_2 = this.generateEnumClass((AttributeDefinition)attr_222);
                        _builder.append((Object)_generateEnumClass_2, "\t\t\t\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.newLine();
                        Boolean _isArrayType_5 = this._componentParameterModelUtility.isArrayType((AttributeDefinition)attr_222);
                        if (_isArrayType_5.booleanValue()) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            CharSequence _generateEnumArrayConversionMethod_2 = this.generateEnumArrayConversionMethod((AttributeDefinition)attr_222);
                            _builder.append((Object)_generateEnumArrayConversionMethod_2, "\t\t\t\t");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.newLine();
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("protected:");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t ");
                    _builder.append("* here are the member definitions");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t ");
                    _builder.append("*/");
                    _builder.newLine();
                    Functions.Function1 _function_15 = it -> it.getName();
                    List _sortBy_12 = IterableExtensions.sortBy((Iterable)param.getAttributes(), (Functions.Function1)_function_15);
                    attr_222 = _sortBy_12.iterator();
                    while (attr_222.hasNext()) {
                        AttributeDefinition v_4 = (AttributeDefinition)attr_222.next();
                        Boolean _isArrayType_6 = this._componentParameterModelUtility.isArrayType(v_4);
                        if (_isArrayType_6.booleanValue()) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("std::list<");
                            String _compileCppType_10 = this._componentParamsGenHelpers.compileCppType(v_4);
                            _builder.append(_compileCppType_10, "\t\t\t\t");
                            _builder.append("> ");
                            String _name_46 = v_4.getName();
                            _builder.append(_name_46, "\t\t\t\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        String _compileCppType_11 = this._componentParamsGenHelpers.compileCppType(v_4);
                        _builder.append(_compileCppType_11, "\t\t\t\t");
                        _builder.append(" ");
                        String _name_47 = v_4.getName();
                        _builder.append(_name_47, "\t\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("public:");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("// default constructor");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    String _name_48 = param.getName();
                    _builder.append(_name_48, "\t\t\t\t");
                    _builder.append("Type() {");
                    _builder.newLineIfNotEmpty();
                    Functions.Function1 _function_16 = it -> it.getName();
                    List _sortBy_13 = IterableExtensions.sortBy((Iterable)param.getAttributes(), (Functions.Function1)_function_16);
                    for (AttributeDefinition v_5 : _sortBy_13) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        String _generateConstructorDefaultValues = this.generateConstructorDefaultValues(v_5, param, set_inst);
                        _builder.append(_generateConstructorDefaultValues, "\t\t\t\t\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t ");
                    _builder.append("* here are the getter methods");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t ");
                    _builder.append("*/");
                    _builder.newLine();
                    Functions.Function1 _function_17 = it -> it.getName();
                    List _sortBy_14 = IterableExtensions.sortBy((Iterable)param.getAttributes(), (Functions.Function1)_function_17);
                    for (AttributeDefinition v_6 : _sortBy_14) {
                        Boolean _isArrayType_7 = this._componentParameterModelUtility.isArrayType(v_6);
                        if (_isArrayType_7.booleanValue()) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("inline std::list<");
                            String _compileCppType_12 = this._componentParamsGenHelpers.compileCppType(v_6);
                            _builder.append(_compileCppType_12, "\t\t\t\t");
                            _builder.append("> get");
                            String _firstUpper_4 = StringExtensions.toFirstUpper((String)v_6.getName());
                            _builder.append(_firstUpper_4, "\t\t\t\t");
                            _builder.append("() const { return ");
                            String _name_49 = v_6.getName();
                            _builder.append(_name_49, "\t\t\t\t");
                            _builder.append("; }");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("inline ");
                        String _compileCppType_13 = this._componentParamsGenHelpers.compileCppType(v_6);
                        _builder.append(_compileCppType_13, "\t\t\t\t");
                        _builder.append(" get");
                        String _firstUpper_5 = StringExtensions.toFirstUpper((String)v_6.getName());
                        _builder.append(_firstUpper_5, "\t\t\t\t");
                        _builder.append("() const { return ");
                        String _name_50 = v_6.getName();
                        _builder.append(_name_50, "\t\t\t\t");
                        _builder.append("; }");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("void to_ostream(std::ostream &os = std::cout) const");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("os << \"\\t");
                    String _name_51 = param.getName();
                    _builder.append(_name_51, "\t\t\t\t\t");
                    _builder.append("(\";");
                    _builder.newLineIfNotEmpty();
                    Functions.Function1 _function_18 = it -> it.getName();
                    List _sortBy_15 = IterableExtensions.sortBy((Iterable)param.getAttributes(), (Functions.Function1)_function_18);
                    for (AttributeDefinition el_8 : _sortBy_15) {
                        if (el_8 instanceof ArrayValue) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t\t");
                            _builder.append("std::list<");
                            String _compileCppType_14 = this._componentParamsGenHelpers.compileCppType(el_8);
                            _builder.append(_compileCppType_14, "\t\t\t\t\t");
                            _builder.append(">::const_iterator ");
                            String _name_52 = el_8.getName();
                            _builder.append(_name_52, "\t\t\t\t\t");
                            _builder.append("It;");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t\t");
                            _builder.append("for(");
                            String _name_53 = el_8.getName();
                            _builder.append(_name_53, "\t\t\t\t\t");
                            _builder.append("It=");
                            String _name_54 = el_8.getName();
                            _builder.append(_name_54, "\t\t\t\t\t");
                            _builder.append(".begin(); ");
                            String _name_55 = el_8.getName();
                            _builder.append(_name_55, "\t\t\t\t\t");
                            _builder.append("It!=");
                            String _name_56 = el_8.getName();
                            _builder.append(_name_56, "\t\t\t\t\t");
                            _builder.append(".end(); ");
                            String _name_57 = el_8.getName();
                            _builder.append(_name_57, "\t\t\t\t\t");
                            _builder.append("It++)");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t\t");
                            _builder.append("{");
                            _builder.newLine();
                            EList _values_4 = ((ArrayValue)el_8).getValues();
                            Iterator iterator2 = _values_4.iterator();
                            while (iterator2.hasNext()) {
                                SingleValue cfr_ignored_2 = (SingleValue)iterator2.next();
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("\t\t");
                                _builder.append("os << \"");
                                String _name_58 = el_8.getName();
                                _builder.append(_name_58, "\t\t\t\t\t");
                                _builder.append(" = \" << *");
                                String _name_59 = el_8.getName();
                                _builder.append(_name_59, "\t\t\t\t\t");
                                _builder.append("It << \", \";");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t\t");
                            _builder.append("}");
                            _builder.newLine();
                            continue;
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("os << \"");
                        String _name_60 = el_8.getName();
                        _builder.append(_name_60, "\t\t\t\t\t");
                        _builder.append(" = \" << ");
                        String _name_61 = el_8.getName();
                        _builder.append(_name_61, "\t\t\t\t\t");
                        _builder.append(" << \", \";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("os << \")\\n\";");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}; // end of parameter class ");
                    String _name_62 = param.getName();
                    _builder.append(_name_62, "\t\t\t");
                    _builder.append("Type");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("protected:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("/**");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t ");
                _builder.append("* internal members");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t ");
                _builder.append("*/");
                _builder.newLine();
                Functions.Function1 _function_19 = it -> it.getName();
                List _sortBy_16 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)set_inst.getParamSet().getParameters(), ParameterDefinition.class), (Functions.Function1)_function_19);
                for (ParameterDefinition param_1 : _sortBy_16) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    String _name_63 = param_1.getName();
                    _builder.append(_name_63, "\t\t\t\t");
                    _builder.append("Type ");
                    String _name_64 = param_1.getName();
                    _builder.append(_name_64, "\t\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("/**");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t ");
                _builder.append("* public getter methods");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t ");
                _builder.append("*/");
                _builder.newLine();
                Functions.Function1 _function_20 = it -> it.getName();
                List _sortBy_17 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)set_inst.getParamSet().getParameters(), ParameterDefinition.class), (Functions.Function1)_function_20);
                for (ParameterDefinition param_2 : _sortBy_17) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("inline ");
                    String _name_65 = param_2.getName();
                    _builder.append(_name_65, "\t\t\t\t");
                    _builder.append("Type get");
                    String _firstUpper_6 = StringExtensions.toFirstUpper((String)param_2.getName());
                    _builder.append(_firstUpper_6, "\t\t\t\t");
                    _builder.append("() const { return ");
                    String _name_66 = param_2.getName();
                    _builder.append(_name_66, "\t\t\t\t");
                    _builder.append("; }");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("void to_ostream(std::ostream &os = std::cout) const");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("os << \"");
                String _name_67 = set_inst.getParamSet().getName();
                _builder.append(_name_67, "\t\t\t\t\t");
                _builder.append("(\\n\";");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_21 = it -> it.getName();
                List _sortBy_18 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)set_inst.getParamSet().getParameters(), ParameterDefinition.class), (Functions.Function1)_function_21);
                for (ParameterDefinition param_3 : _sortBy_18) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t\t");
                    String _name_68 = param_3.getName();
                    _builder.append(_name_68, "\t\t\t\t\t");
                    _builder.append(".to_ostream(os);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("os << \")\";");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}; // end of parameter-set class ");
                String _name_69 = set_inst.getParamSet().getName();
                _builder.append(_name_69, "\t\t");
                _builder.append("Type");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("protected:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t ");
            _builder.append("* internal members");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t ");
            _builder.append("*/");
            _builder.newLine();
            List _value_1 = (List)entry.getValue();
            for (ParameterSetInstance set_inst_1 : _value_1) {
                _builder.append("\t");
                _builder.append("\t\t");
                String _name_70 = set_inst_1.getParamSet().getName();
                _builder.append(_name_70, "\t\t\t");
                _builder.append("Type ");
                String _name_71 = set_inst_1.getParamSet().getName();
                _builder.append(_name_71, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t ");
            _builder.append("* public getter methods");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t ");
            _builder.append("*/");
            _builder.newLine();
            List _value_2 = (List)entry.getValue();
            for (ParameterSetInstance set_inst_2 : _value_2) {
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("inline ");
                String _name_72 = set_inst_2.getParamSet().getName();
                _builder.append(_name_72, "\t\t\t");
                _builder.append("Type get");
                String _firstUpper_7 = StringExtensions.toFirstUpper((String)set_inst_2.getParamSet().getName());
                _builder.append(_firstUpper_7, "\t\t\t");
                _builder.append("() const { return ");
                String _name_73 = set_inst_2.getParamSet().getName();
                _builder.append(_name_73, "\t\t\t");
                _builder.append("; }");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("void to_ostream(std::ostream &os = std::cout) const");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("os << \"");
            String _key_2 = (String)entry.getKey();
            _builder.append(_key_2, "\t\t\t\t");
            _builder.append("(\\n\";");
            _builder.newLineIfNotEmpty();
            List _value_3 = (List)entry.getValue();
            for (ParameterSetInstance set_inst_3 : _value_3) {
                _builder.append("\t");
                _builder.append("\t\t\t");
                String _name_74 = set_inst_3.getParamSet().getName();
                _builder.append(_name_74, "\t\t\t\t");
                _builder.append(".to_ostream(os);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("os << \")\";");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}; // end of parameter-repository wrapper class ");
            String _key_3 = (String)entry.getKey();
            _builder.append(_key_3, "\t");
            _builder.append("Type");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String generateConstructorDefaultValues(AttributeDefinition attr, ParameterDefinition par, ParameterSetInstance set_inst) {
        boolean _isEmpty;
        Iterable _filter = Iterables.filter((Iterable)set_inst.getParameterInstances(), ParameterInstance.class);
        ParameterInstance _findFirst = null;
        if (_filter != null) {
            Functions.Function1 _function = p -> p.getParameterDef().equals(par);
            _findFirst = (ParameterInstance)IterableExtensions.findFirst((Iterable)_filter, (Functions.Function1)_function);
        }
        ParameterInstance par_inst = _findFirst;
        String result = "";
        if (par_inst != null) {
            Functions.Function1 _function_1 = a -> a.getAttribute().equals(attr);
            AttributeRefinement attr_inst = (AttributeRefinement)IterableExtensions.findFirst((Iterable)par_inst.getAttributes(), (Functions.Function1)_function_1);
            if (attr_inst != null) {
                AbstractValue _value = attr_inst.getValue();
                if (_value instanceof ArrayValue) {
                    AbstractValue _value_1 = attr_inst.getValue();
                    EList _values = ((ArrayValue)_value_1).getValues();
                    for (SingleValue curr_attr : _values) {
                        String _plus;
                        StringConcatenation _builder = new StringConcatenation();
                        String _name = attr_inst.getAttribute().getName();
                        _builder.append(_name);
                        _builder.append(".push_back(");
                        String _compileContent = this._componentParamsGenHelpers.compileContent((AbstractValue)curr_attr);
                        _builder.append(_compileContent);
                        _builder.append(");");
                        result = _plus = String.valueOf(result) + _builder;
                    }
                } else {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _name_1 = attr_inst.getAttribute().getName();
                    _builder_1.append(_name_1);
                    _builder_1.append(" = ");
                    String _compileContent_1 = this._componentParamsGenHelpers.compileContent(attr_inst.getValue());
                    _builder_1.append(_compileContent_1);
                    _builder_1.append(";");
                    result = _builder_1.toString();
                }
            }
        }
        if (_isEmpty = result.isEmpty()) {
            StringConcatenation _builder_2 = new StringConcatenation();
            String _name_2 = attr.getName();
            _builder_2.append(_name_2);
            _builder_2.append(" = ");
            String _standardValue = this._componentParamsGenHelpers.getStandardValue(attr);
            _builder_2.append(_standardValue);
            _builder_2.append(";");
            result = _builder_2.toString();
        }
        return result;
    }

    private Map<String, List<ParameterSetInstance>> getAllRepos(ComponentParameter usage) {
        HashMap<String, List<ParameterSetInstance>> repos = new HashMap<String, List<ParameterSetInstance>>();
        Iterable _filter = Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class);
        for (ParameterSetInstance set_inst : _filter) {
            boolean _tripleEquals;
            EObject _eContainer = set_inst.getParamSet().eContainer();
            ParameterSetRepository curr_repo = (ParameterSetRepository)_eContainer;
            List _get = (List)repos.get(curr_repo.getName());
            boolean bl = _tripleEquals = _get == null;
            if (_tripleEquals) {
                String _name = curr_repo.getName();
                ArrayList _arrayList = new ArrayList();
                repos.put(_name, _arrayList);
            }
            ((List)repos.get(curr_repo.getName())).add(set_inst);
        }
        return repos;
    }

    private CharSequence generateEnumArrayConversionMethod(AttributeDefinition attr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void set");
        String _firstUpper = StringExtensions.toFirstUpper((String)attr.getName());
        _builder.append(_firstUpper);
        _builder.append("Type(const std::list<std::string> &");
        String _name = attr.getName();
        _builder.append(_name);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("std::list<std::string>::const_iterator it;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this->");
        String _name_1 = attr.getName();
        _builder.append(_name_1, "\t");
        _builder.append(".clear();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("for(it=");
        String _name_2 = attr.getName();
        _builder.append(_name_2, "\t");
        _builder.append(".begin(); it!=");
        String _name_3 = attr.getName();
        _builder.append(_name_3, "\t");
        _builder.append(".end(); it++) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("this->");
        String _name_4 = attr.getName();
        _builder.append(_name_4, "\t\t");
        _builder.append(".push_back(*it);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateMembersCopyFunction(ComponentParameter model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void setContent(const ParameterStateStructCore &commit) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// External params");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), ExtendedParameter.class), (Functions.Function1)_function);
        for (ExtendedParameter ex : _sortBy) {
            _builder.append("\t");
            _builder.append("this->");
            String _name = ex.getName();
            _builder.append(_name, "\t");
            _builder.append(" = commit.get");
            String _firstUpper = StringExtensions.toFirstUpper((String)ex.getName());
            _builder.append(_firstUpper, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Set<String> _keySet = this.getAllRepos(model).keySet();
        for (String repo : _keySet) {
            _builder.append("\t");
            _builder.append("this->");
            _builder.append(repo, "\t");
            _builder.append(" = commit.get");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)repo);
            _builder.append(_firstUpper_1, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateMemberVariables(ComponentParameter model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Internal params");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), InternalParameter.class), (Functions.Function1)_function);
        for (InternalParameter p : _sortBy) {
            String _name = p.getName();
            _builder.append(_name);
            _builder.append("Type ");
            String _name_1 = p.getName();
            _builder.append(_name_1);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("// External params");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), ExtendedParameter.class), (Functions.Function1)_function_1);
        for (ExtendedParameter ex : _sortBy_1) {
            String _name_2 = ex.getName();
            _builder.append(_name_2);
            _builder.append("Type ");
            String _name_3 = ex.getName();
            _builder.append(_name_3);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("// Instance params (encapsulated in a wrapper class for each instantiated parameter repository)");
        _builder.newLine();
        Set<String> _keySet = this.getAllRepos(model).keySet();
        for (String repo : _keySet) {
            _builder.append(repo);
            _builder.append("Type ");
            _builder.append(repo);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateOSmembers(ComponentParameter model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Internal params");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), InternalParameter.class), (Functions.Function1)_function);
        for (InternalParameter p : _sortBy) {
            String _name = p.getName();
            _builder.append(_name);
            _builder.append(".to_ostream(os);");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("// External params");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), ExtendedParameter.class), (Functions.Function1)_function_1);
        for (ExtendedParameter ex : _sortBy_1) {
            String _name_1 = ex.getName();
            _builder.append(_name_1);
            _builder.append(".to_ostream(os);");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("// Instance params (encapsulated in a wrapper class for each instantiated parameter repository)");
        _builder.newLine();
        Set<String> _keySet = this.getAllRepos(model).keySet();
        for (String repo : _keySet) {
            _builder.append(repo);
            _builder.append(".to_ostream(os);");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateUpcallsCore(ComponentParameter model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Extended param upcall methods");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), ExtendedParameter.class), (Functions.Function1)_function);
        for (ExtendedParameter ex : _sortBy) {
            _builder.append("SmartACE::ParamResponseType handle");
            String _upperCase = ex.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("Core(");
            String _nameTypes = this._componentParamsGenHelpers.getNameTypes((EList<AttributeDefinition>)ex.getAttributes(), true);
            _builder.append(_nameTypes);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_1 = it -> it.getName();
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)ex.getAttributes(), (Functions.Function1)_function_1);
            for (AttributeDefinition el : _sortBy_1) {
                _builder.append("\t");
                _builder.append("this->");
                String _name = ex.getName();
                _builder.append(_name, "\t");
                _builder.append(".");
                String _name_1 = el.getName();
                _builder.append(_name_1, "\t");
                _builder.append(" = ");
                String _name_2 = el.getName();
                _builder.append(_name_2, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("return handle");
            String _upperCase_1 = ex.getName().toUpperCase();
            _builder.append(_upperCase_1, "\t");
            _builder.append("(");
            String _name_3 = ex.getName();
            _builder.append(_name_3, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function_2);
        for (ParameterSetInstance paramSetInst : _sortBy_2) {
            _builder.append("// Instance param upcall methods");
            _builder.newLine();
            Iterable _filter = Iterables.filter((Iterable)paramSetInst.getParamSet().getParameters(), ParameterDefinition.class);
            for (ParameterDefinition p : _filter) {
                _builder.append("SmartACE::ParamResponseType handle");
                String _upperCase_2 = p.getName().toUpperCase();
                _builder.append(_upperCase_2);
                _builder.append("Core(");
                String _nameTypes_1 = this._componentParamsGenHelpers.getNameTypes((EList<AttributeDefinition>)p.getAttributes(), true);
                _builder.append(_nameTypes_1);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_3 = it -> it.getName();
                List _sortBy_3 = IterableExtensions.sortBy((Iterable)p.getAttributes(), (Functions.Function1)_function_3);
                for (AttributeDefinition v : _sortBy_3) {
                    _builder.append("\t");
                    _builder.append("this->");
                    String _name_4 = p.getName();
                    _builder.append(_name_4, "\t");
                    _builder.append(".");
                    String _name_5 = v.getName();
                    _builder.append(_name_5, "\t");
                    _builder.append(" = ");
                    String _name_6 = v.getName();
                    _builder.append(_name_6, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("return handle");
                String _upperCase_3 = p.getName().toUpperCase();
                _builder.append(_upperCase_3, "\t");
                _builder.append("(");
                String _ntNames = this._componentParamsGenHelpers.getNtNames((EList<AttributeDefinition>)p.getAttributes());
                _builder.append(_ntNames, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
        }
        return _builder;
    }

    public CharSequence generateUpcalls(ComponentParameter model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Extended param user upcall methods");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), ExtendedParameter.class), (Functions.Function1)_function);
        for (ExtendedParameter ex : _sortBy) {
            _builder.append("virtual SmartACE::ParamResponseType handle");
            String _upperCase = ex.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("(");
            String _nameTypes = this._componentParamsGenHelpers.getNameTypes((EList<AttributeDefinition>)ex.getAttributes(), true);
            _builder.append(_nameTypes);
            _builder.append(") = 0;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function_1);
        for (ParameterSetInstance paramSetInst : _sortBy_1) {
            _builder.append("// Instance param user upcall methods");
            _builder.newLine();
            Functions.Function1 _function_2 = it -> it.getName();
            List _sortBy_2 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)paramSetInst.getParamSet().getParameters(), ParameterDefinition.class), (Functions.Function1)_function_2);
            for (ParameterDefinition p : _sortBy_2) {
                _builder.append("virtual SmartACE::ParamResponseType handle");
                String _upperCase_1 = p.getName().toUpperCase();
                _builder.append(_upperCase_1);
                _builder.append("(");
                String _nameTypes_1 = this._componentParamsGenHelpers.getNameTypes((EList<AttributeDefinition>)p.getAttributes(), true);
                _builder.append(_nameTypes_1);
                _builder.append(") = 0;");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence generateGetterMethods(ComponentParameter model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// internal param getters");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), InternalParameter.class), (Functions.Function1)_function);
        for (InternalParameter in : _sortBy) {
            boolean _not;
            boolean _isEmpty = in.getAttributes().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            String _name = in.getName();
            _builder.append(_name);
            _builder.append("Type get");
            String _firstUpper = StringExtensions.toFirstUpper((String)in.getName());
            _builder.append(_firstUpper);
            _builder.append("() const {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return ");
            String _name_1 = in.getName();
            _builder.append(_name_1, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("// external param getters");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getParameters(), ExtendedParameter.class), (Functions.Function1)_function_1);
        for (ExtendedParameter ex : _sortBy_1) {
            boolean _not_1;
            boolean _isEmpty_1 = ex.getAttributes().isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (!_not_1) continue;
            String _name_2 = ex.getName();
            _builder.append(_name_2);
            _builder.append("Type get");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)ex.getName());
            _builder.append(_firstUpper_1);
            _builder.append("() const {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return ");
            String _name_3 = ex.getName();
            _builder.append(_name_3, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("// repo wrapper class getter(s)");
        _builder.newLine();
        Set<String> _keySet = this.getAllRepos(model).keySet();
        for (String repo : _keySet) {
            _builder.append(repo);
            _builder.append("Type get");
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)repo);
            _builder.append(_firstUpper_2);
            _builder.append("() const {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return ");
            _builder.append(repo, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence compileIniFile(ComponentParameter usage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#####################");
        _builder.newLine();
        _builder.append("# internal parameters");
        _builder.newLine();
        _builder.append("#####################");
        _builder.newLine();
        Functions.Function1 _function = g -> g.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), InternalParameter.class), (Functions.Function1)_function);
        for (InternalParameter internalGroup : _sortBy) {
            CharSequence _compileIniFileParameter = this.compileIniFileParameter((ComponentParameterBase)internalGroup);
            _builder.append((Object)_compileIniFileParameter);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("#####################");
        _builder.newLine();
        _builder.append("# extended parameters");
        _builder.newLine();
        _builder.append("#####################");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ExtendedParameter.class), (Functions.Function1)_function_1);
        for (ExtendedParameter extended : _sortBy_1) {
            CharSequence _compileIniFileParameter_1 = this.compileIniFileParameter((ComponentParameterBase)extended);
            _builder.append((Object)_compileIniFileParameter_1);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("#####################");
        _builder.newLine();
        _builder.append("# instance parameters");
        _builder.newLine();
        _builder.append("#####################");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)usage.getParameters(), ParameterSetInstance.class), (Functions.Function1)_function_2);
        for (ParameterSetInstance paramSetInstance : _sortBy_2) {
            _builder.append("##########################");
            _builder.newLine();
            _builder.append("# ParameterSet ");
            String _name = paramSetInstance.getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_3 = it -> it.getName();
            List _sortBy_3 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)paramSetInstance.getParamSet().getParameters(), ParameterDefinition.class), (Functions.Function1)_function_3);
            for (ParameterDefinition par : _sortBy_3) {
                Functions.Function1 _function_4 = p -> {
                    ParameterDefinition _parameterDef = p.getParameterDef();
                    return Objects.equal((Object)_parameterDef, (Object)par);
                };
                boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)paramSetInstance.getParameterInstances(), ParameterInstance.class), (Functions.Function1)_function_4);
                if (_exists) {
                    Functions.Function1 _function_5 = p -> {
                        ParameterDefinition _parameterDef = p.getParameterDef();
                        return Objects.equal((Object)_parameterDef, (Object)par);
                    };
                    CharSequence _compileIniFileParameter_2 = this.compileIniFileParameter((ComponentParameterBase)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)paramSetInstance.getParameterInstances(), ParameterInstance.class), (Functions.Function1)_function_5));
                    _builder.append((Object)_compileIniFileParameter_2);
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                Functions.Function1 _function_6 = it -> it.getName();
                List _sortBy_4 = IterableExtensions.sortBy((Iterable)par.getAttributes(), (Functions.Function1)_function_6);
                for (AttributeDefinition el : _sortBy_4) {
                    Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(el);
                    if (_isArrayType.booleanValue()) {
                        _builder.append("# element ");
                        String _name_1 = el.getName();
                        _builder.append(_name_1);
                        _builder.append(" is an array type without a default value");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    String _name_2 = el.getName();
                    _builder.append(_name_2);
                    _builder.append(" ");
                    CharSequence _defaultValue = this._componentParamsGenHelpers.getDefaultValue(el.getType());
                    _builder.append((Object)_defaultValue);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
            }
        }
        return _builder;
    }

    public CharSequence compileIniFileParameter(ComponentParameterBase parameter) {
        StringConcatenation _builder = new StringConcatenation();
        if (parameter instanceof InternalParameter) {
            _builder.append("##########################");
            _builder.newLine();
            _builder.append("# InternalParameter ");
            String _name = ((InternalParameter)parameter).getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            _builder.append("[");
            String _name_1 = ((InternalParameter)parameter).getName();
            _builder.append(_name_1);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function = v -> v.getName();
            List _sortBy = IterableExtensions.sortBy((Iterable)((InternalParameter)parameter).getAttributes(), (Functions.Function1)_function);
            for (AttributeDefinition el : _sortBy) {
                CharSequence _compileIniAttribute = this.compileIniAttribute((AbstractDocumentationElement)el);
                _builder.append((Object)_compileIniAttribute);
                _builder.newLineIfNotEmpty();
            }
        } else if (parameter instanceof ExtendedParameter) {
            _builder.append("##########################");
            _builder.newLine();
            _builder.append("# ExtendedParameter ");
            String _name_2 = ((ExtendedParameter)parameter).getName();
            _builder.append(_name_2);
            _builder.newLineIfNotEmpty();
            _builder.append("[");
            String _name_3 = ((ExtendedParameter)parameter).getName();
            _builder.append(_name_3);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_1 = it -> it.getName();
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)((ExtendedParameter)parameter).getAttributes(), (Functions.Function1)_function_1);
            for (AttributeDefinition nv : _sortBy_1) {
                CharSequence _compileIniAttribute_1 = this.compileIniAttribute((AbstractDocumentationElement)nv);
                _builder.append((Object)_compileIniAttribute_1);
                _builder.newLineIfNotEmpty();
            }
        } else if (parameter instanceof ParameterInstance) {
            _builder.append("##########################");
            _builder.newLine();
            _builder.append("# ParameterInstance ");
            String _name_4 = ((ParameterInstance)parameter).getName();
            _builder.append(_name_4);
            _builder.newLineIfNotEmpty();
            _builder.append("[");
            String _name_5 = ((ParameterInstance)parameter).getName();
            _builder.append(_name_5);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            EList _attributes = ((ParameterInstance)parameter).getAttributes();
            for (AttributeRefinement v2 : _attributes) {
                CharSequence _compileIniAttribute_2 = this.compileIniAttribute((AbstractDocumentationElement)v2);
                _builder.append((Object)_compileIniAttribute_2);
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _compileIniAttribute(AttributeDefinition attr) {
        StringConcatenation _builder = new StringConcatenation();
        AbstractValue _defaultvalue = attr.getDefaultvalue();
        if (_defaultvalue instanceof SingleValue) {
            String _name = attr.getName();
            _builder.append(_name);
            _builder.append(" ");
            AbstractValue _defaultvalue_1 = attr.getDefaultvalue();
            Object _value = this._componentParamsGenHelpers.getValue((SingleValue)_defaultvalue_1);
            _builder.append(_value);
            _builder.newLineIfNotEmpty();
        } else {
            AbstractValue _defaultvalue_2 = attr.getDefaultvalue();
            if (_defaultvalue_2 instanceof ArrayValue) {
                _builder.append("# ");
                String _name_1 = attr.getName();
                _builder.append(_name_1);
                _builder.append(" has an array value (defined by assigning each array element in a separate line)");
                _builder.newLineIfNotEmpty();
                AbstractValue _defaultvalue_3 = attr.getDefaultvalue();
                EList _values = ((ArrayValue)_defaultvalue_3).getValues();
                for (SingleValue arrVal : _values) {
                    String _name_2 = attr.getName();
                    _builder.append(_name_2);
                    _builder.append(" ");
                    Object _value_1 = this._componentParamsGenHelpers.getValue(arrVal);
                    _builder.append(_value_1);
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    protected CharSequence _compileIniAttribute(AttributeRefinement attr) {
        StringConcatenation _builder = new StringConcatenation();
        AbstractValue _value = attr.getValue();
        if (_value instanceof SingleValue) {
            String _name = attr.getAttribute().getName();
            _builder.append(_name);
            _builder.append(" ");
            AbstractValue _value_1 = attr.getValue();
            Object _value_2 = this._componentParamsGenHelpers.getValue((SingleValue)_value_1);
            _builder.append(_value_2);
            _builder.newLineIfNotEmpty();
        } else {
            AbstractValue _value_3 = attr.getValue();
            if (_value_3 instanceof ArrayValue) {
                _builder.append("# ");
                String _name_1 = attr.getAttribute().getName();
                _builder.append(_name_1);
                _builder.append(" has an array value (defined by assigning each array element in a separate line)");
                _builder.newLineIfNotEmpty();
                AbstractValue _value_4 = attr.getValue();
                EList _values = ((ArrayValue)_value_4).getValues();
                for (SingleValue arrVal : _values) {
                    String _name_2 = attr.getAttribute().getName();
                    _builder.append(_name_2);
                    _builder.append(" ");
                    Object _value_5 = this._componentParamsGenHelpers.getValue(arrVal);
                    _builder.append(_value_5);
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    private String getFullyQualifiedName(AbstractDocumentationElement par) {
        if (par instanceof ParameterDefinition) {
            return this._getFullyQualifiedName((ParameterDefinition)par);
        }
        if (par instanceof TriggerDefinition) {
            return this._getFullyQualifiedName((TriggerDefinition)par);
        }
        if (par instanceof ParameterSetDefinition) {
            return this._getFullyQualifiedName((ParameterSetDefinition)par);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(par).toString());
    }

    private String getFullyQualifiedVariableName(AbstractDocumentationElement par) {
        if (par instanceof ParameterDefinition) {
            return this._getFullyQualifiedVariableName((ParameterDefinition)par);
        }
        if (par instanceof TriggerDefinition) {
            return this._getFullyQualifiedVariableName((TriggerDefinition)par);
        }
        if (par instanceof ParameterSetDefinition) {
            return this._getFullyQualifiedVariableName((ParameterSetDefinition)par);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(par).toString());
    }

    private String generateTriggerAttributeDefinitions(AbstractDocumentationElement t) {
        if (t instanceof ExtendedTrigger) {
            return this._generateTriggerAttributeDefinitions((ExtendedTrigger)t);
        }
        if (t instanceof TriggerDefinition) {
            return this._generateTriggerAttributeDefinitions((TriggerDefinition)t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }

    private String generateTriggerAttributeNames(AbstractDocumentationElement t, String prefix) {
        if (t instanceof ExtendedTrigger) {
            return this._generateTriggerAttributeNames((ExtendedTrigger)t, prefix);
        }
        if (t instanceof TriggerDefinition) {
            return this._generateTriggerAttributeNames((TriggerDefinition)t, prefix);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t, prefix).toString());
    }

    public CharSequence compileIniAttribute(AbstractDocumentationElement attr) {
        if (attr instanceof AttributeDefinition) {
            return this._compileIniAttribute((AttributeDefinition)attr);
        }
        if (attr instanceof AttributeRefinement) {
            return this._compileIniAttribute((AttributeRefinement)attr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(attr).toString());
    }
}

