/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.system;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.ActivationConstraints;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultInputTrigger;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultPeriodicTimer;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultTrigger;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.AbstractInputNode;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.AbstractSourceNode;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivationSource;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitectureModel;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityNode;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.CPUCore;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.DataFlow;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.DataTriggered;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.PeriodicTimer;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.Scheduler;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.Sporadic;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.TriggerInputNode;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ActivityConfigurationMapping;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.Connection;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.RequiredService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ServiceInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ActivityConfig {
    public CharSequence compileActivityNode(ActivityConfigurationMapping mapping) {
        CPUCore _affinity;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile(mapping.getConfig().getActivationSource(), mapping);
        _builder.append((Object)_compile);
        _builder.newLineIfNotEmpty();
        Scheduler _scheduler = mapping.getConfig().getScheduler();
        boolean bl = _tripleNotEquals = _scheduler != null;
        if (_tripleNotEquals) {
            _builder.append("scheduler ");
            String _literal = mapping.getConfig().getScheduler().getType().getLiteral();
            _builder.append(_literal);
            _builder.newLineIfNotEmpty();
            _builder.append("priority ");
            int _priority = mapping.getConfig().getScheduler().getPriority();
            _builder.append((Object)_priority);
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _tripleNotEquals_1 = (_affinity = mapping.getConfig().getAffinity()) != null;
        if (_tripleNotEquals_1) {
            _builder.append("cpuAffinity ");
            int _coreNumber = mapping.getConfig().getAffinity().getCoreNumber();
            _builder.append((Object)_coreNumber);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _compile(DataTriggered data, ActivityConfigurationMapping mapping) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("triggerType DataTriggered");
        _builder.newLine();
        _builder.append("inPortRef ");
        ComponentPort _inputPort = this.getInputPort(mapping);
        String _name = null;
        if (_inputPort != null) {
            _name = _inputPort.getName();
        }
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("prescale ");
        int _prescale = data.getPrescale();
        _builder.append((Object)_prescale);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _compile(PeriodicTimer timer, ActivityConfigurationMapping mapping) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("triggerType PeriodicTimer");
        _builder.newLine();
        _builder.append("periodicActFreqHz ");
        double _periodicActFreq = timer.getPeriodicActFreq();
        _builder.append((Object)_periodicActFreq);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _compile(Sporadic timer, ActivityConfigurationMapping mapping) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("triggerType Sporadic");
        _builder.newLine();
        _builder.append("minActFreqHz ");
        double _minActFreq = timer.getMinActFreq();
        _builder.append((Object)_minActFreq);
        _builder.newLineIfNotEmpty();
        _builder.append("maxActFreqHz ");
        double _maxActFreq = timer.getMaxActFreq();
        _builder.append((Object)_maxActFreq);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public ComponentPort getInputPort(ActivityConfigurationMapping mapping) {
        EObject systemModel;
        EObject componentInstance;
        AbstractSourceNode sourceNode = this.getSourceNode(mapping);
        if (sourceNode instanceof ActivityNode && (componentInstance = mapping.eContainer()) instanceof ComponentInstance && (systemModel = ((ComponentInstance)componentInstance).eContainer()) instanceof SystemComponentArchitecture) {
            EList _ports = ((ComponentInstance)componentInstance).getPorts();
            for (ServiceInstance port : _ports) {
                Functions.Function1 _function = it -> {
                    InputPort _inputPort = it.getInputPort();
                    ComponentPort _port = port.getPort();
                    return Objects.equal((Object)_inputPort, (Object)_port);
                };
                boolean _exists = IterableExtensions.exists((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)mapping.getActivity()), (Functions.Function1)_function);
                if (!_exists) continue;
                Functions.Function1 _function_1 = it -> {
                    RequiredService _from = it.getFrom();
                    return Objects.equal((Object)_from, (Object)port);
                };
                Connection connection = (Connection)IterableExtensions.findFirst((Iterable)((SystemComponentArchitecture)systemModel).getConnections(), (Functions.Function1)_function_1);
                if (connection == null) continue;
                ComponentPort sourcePort = connection.getTo().getPort();
                EObject _eContainer = connection.getTo().eContainer();
                ComponentInstance sourceComponent = (ComponentInstance)_eContainer;
                if (!(sourcePort instanceof OutputPort)) continue;
                Activity sourceActivity = ((OutputPort)sourcePort).getActivity();
                Iterable _filter = Iterables.filter((Iterable)sourceComponent.getExtensions(), ActivityConfigurationMapping.class);
                for (ActivityConfigurationMapping sourceActMapping : _filter) {
                    if (!Objects.equal((Object)sourceActMapping.getActivity(), (Object)sourceActivity) || !Objects.equal((Object)sourceActMapping.getConfig(), (Object)sourceNode)) continue;
                    return port.getPort();
                }
            }
        }
        return null;
    }

    public AbstractSourceNode getSourceNode(ActivityConfigurationMapping mapping) {
        EObject actModel;
        ActivationSource activationSource = mapping.getConfig().getActivationSource();
        if (activationSource instanceof DataTriggered && (actModel = mapping.getConfig().eContainer()) instanceof ActivityArchitectureModel) {
            Functions.Function1 _function = it -> {
                AbstractInputNode _destination = it.getDestination();
                TriggerInputNode _triggerRef = ((DataTriggered)activationSource).getTriggerRef();
                return Objects.equal((Object)_destination, (Object)_triggerRef);
            };
            DataFlow df = (DataFlow)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)((ActivityArchitectureModel)actModel).getElements(), DataFlow.class), (Functions.Function1)_function);
            if (df != null) {
                return df.getSource();
            }
        }
        return null;
    }

    public CharSequence compileDefaultActivity(Activity activity) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            boolean _isConfigurable = it.isConfigurable();
            return !_isConfigurable;
        };
        boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)activity.getExtensions(), ActivationConstraints.class), (Functions.Function1)_function);
        boolean bl = _not = !_exists;
        if (_not) {
            _builder.append("minActFreqHz ");
            Double _minActFreq = this.getMinActFreq(activity);
            _builder.append((Object)_minActFreq);
            _builder.newLineIfNotEmpty();
            _builder.append("maxActFreqHz ");
            Double _maxActFreq = this.getMaxActFreq(activity);
            _builder.append((Object)_maxActFreq);
            _builder.newLineIfNotEmpty();
            Iterable _filter = Iterables.filter((Iterable)activity.getExtensions(), DefaultTrigger.class);
            for (DefaultTrigger trigger : _filter) {
                if (trigger instanceof DefaultPeriodicTimer) {
                    _builder.append("# setup default trigger as PeriodicTimer");
                    _builder.newLine();
                    _builder.append("triggerType PeriodicTimer");
                    _builder.newLine();
                    _builder.append("periodicActFreqHz ");
                    double _periodicActFreq = ((DefaultPeriodicTimer)trigger).getPeriodicActFreq();
                    _builder.append((Object)_periodicActFreq);
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                if (!(trigger instanceof DefaultInputTrigger)) continue;
                _builder.append("# setup default trigger as DataTriggered");
                _builder.newLine();
                _builder.append("triggerType DataTriggered");
                _builder.newLine();
                _builder.append("inPortRef ");
                String _name = ((DefaultInputTrigger)trigger).getInputLink().getInputPort().getName();
                _builder.append(_name);
                _builder.newLineIfNotEmpty();
                _builder.append("prescale 1");
                _builder.newLine();
            }
            _builder.append("# other trigger-types are:");
            _builder.newLine();
            _builder.append("#triggerType PeriodicTimer");
            _builder.newLine();
            _builder.append("#periodicActFreqHz ");
            Double _minActFreq_1 = this.getMinActFreq(activity);
            _builder.append((Object)_minActFreq_1);
            _builder.newLineIfNotEmpty();
            _builder.append("# or alternatively:");
            _builder.newLine();
            _builder.append("#triggerType DataTriggered");
            _builder.newLine();
            _builder.append("#inPortRef <InPortName>");
            _builder.newLine();
            _builder.append("#prescale 1");
            _builder.newLine();
        }
        _builder.append("# optional scheduling parameters");
        _builder.newLine();
        _builder.append("# scheduler FIFO");
        _builder.newLine();
        _builder.append("# priority 0");
        _builder.newLine();
        _builder.append("# cpuAffinity 0");
        _builder.newLine();
        return _builder;
    }

    public Double getMinActFreq(Activity activity) {
        boolean _equals;
        int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)activity.getExtensions(), ActivationConstraints.class));
        boolean bl = _equals = _size == 0;
        if (_equals) {
            return 0.0;
        }
        return ((ActivationConstraints[])Conversions.unwrapArray((Object)Iterables.filter((Iterable)activity.getExtensions(), ActivationConstraints.class), ActivationConstraints.class))[0].getMinActFreq();
    }

    public Double getMaxActFreq(Activity activity) {
        boolean _equals;
        int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)activity.getExtensions(), ActivationConstraints.class));
        boolean bl = _equals = _size == 0;
        if (_equals) {
            return 0.0;
        }
        return ((ActivationConstraints[])Conversions.unwrapArray((Object)Iterables.filter((Iterable)activity.getExtensions(), ActivationConstraints.class), ActivationConstraints.class))[0].getMaxActFreq();
    }

    public CharSequence compile(ActivationSource data, ActivityConfigurationMapping mapping) {
        if (data instanceof DataTriggered) {
            return this._compile((DataTriggered)data, mapping);
        }
        if (data instanceof PeriodicTimer) {
            return this._compile((PeriodicTimer)data, mapping);
        }
        if (data instanceof Sporadic) {
            return this._compile((Sporadic)data, mapping);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data, mapping).toString());
    }
}

