/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtext.behavior.taskDefinition.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smartmdsd.xtext.behavior.taskDefinition.TaskDefinitionRuntimeModule;
import org.eclipse.smartmdsd.xtext.behavior.taskDefinition.TaskDefinitionStandaloneSetup;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class TaskDefinitionIdeSetup extends TaskDefinitionStandaloneSetup {
  @Override
  public Injector createInjector() {
    TaskDefinitionRuntimeModule _taskDefinitionRuntimeModule = new TaskDefinitionRuntimeModule();
    TaskDefinitionIdeModule _taskDefinitionIdeModule = new TaskDefinitionIdeModule();
    return Guice.createInjector(Modules2.mixin(_taskDefinitionRuntimeModule, _taskDefinitionIdeModule));
  }
}
