/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentDefinition.scoping;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPortLink;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CommunicationServiceUsageRealization;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationExtensionPackage;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.PerformanceExtensionPackage;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SeronetExtensionPackage;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class ComponentDefinitionScopeProvider extends AbstractComponentDefinitionScopeProvider {
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    EReference _opcUaReadServer_OutPort = SeronetExtensionPackage.eINSTANCE.getOpcUaReadServer_OutPort();
    boolean _equals = Objects.equal(reference, _opcUaReadServer_OutPort);
    if (_equals) {
      final EObject parent = context.eContainer();
      if ((parent instanceof ComponentDefinition)) {
        return Scopes.scopeFor(Iterables.<OutputPort>filter(((ComponentDefinition)parent).getElements(), OutputPort.class));
      }
    } else {
      EReference _communicationServiceUsageRealization_ServiceUsage = CoordinationExtensionPackage.eINSTANCE.getCommunicationServiceUsageRealization_ServiceUsage();
      boolean _equals_1 = Objects.equal(reference, _communicationServiceUsageRealization_ServiceUsage);
      if (_equals_1) {
        final EObject parent_1 = context.eContainer();
        if ((parent_1 instanceof CoordinationSlavePort)) {
          return Scopes.scopeFor(((CoordinationSlavePort)parent_1).getService().getServices());
        }
      } else {
        EReference _communicationServiceUsageRealization_ComponentPort = CoordinationExtensionPackage.eINSTANCE.getCommunicationServiceUsageRealization_ComponentPort();
        boolean _equals_2 = Objects.equal(reference, _communicationServiceUsageRealization_ComponentPort);
        if (_equals_2) {
          final EObject parent_2 = context.eContainer().eContainer();
          if ((parent_2 instanceof ComponentDefinition)) {
            final CommunicationServiceUsageRealization serviceDefRef = ((CommunicationServiceUsageRealization) context);
            final Function1<ComponentPort, Boolean> _function = (ComponentPort it) -> {
              CommunicationServiceDefinition _service = ComponentDefinitionModelUtility.getService(it);
              CommunicationServiceDefinition _uses = serviceDefRef.getServiceUsage().getUses();
              return Boolean.valueOf(Objects.equal(_service, _uses));
            };
            return Scopes.scopeFor(IterableExtensions.<ComponentPort>filter(Iterables.<ComponentPort>filter(((ComponentDefinition)parent_2).getElements(), ComponentPort.class), _function));
          }
        } else {
          EReference _defaultInputTrigger_InputLink = PerformanceExtensionPackage.eINSTANCE.getDefaultInputTrigger_InputLink();
          boolean _equals_3 = Objects.equal(reference, _defaultInputTrigger_InputLink);
          if (_equals_3) {
            final EObject parent_3 = context.eContainer();
            if ((parent_3 instanceof Activity)) {
              return Scopes.scopeFor(Iterables.<InputPortLink>filter(((Activity)parent_3).getLinks(), InputPortLink.class));
            }
          } else {
            EReference _defaultObservedElementTrigger_Element = PerformanceExtensionPackage.eINSTANCE.getDefaultObservedElementTrigger_Element();
            boolean _equals_4 = Objects.equal(reference, _defaultObservedElementTrigger_Element);
            if (_equals_4) {
              final EObject parent_4 = context.eContainer();
              if ((parent_4 instanceof Activity)) {
                final Function1<ComponentSubNodeObserver, ComponentSubNode> _function_1 = (ComponentSubNodeObserver it) -> {
                  return it.getSubject();
                };
                return Scopes.scopeFor(IterableExtensions.<ComponentSubNodeObserver, ComponentSubNode>map(Iterables.<ComponentSubNodeObserver>filter(((Activity)parent_4).getLinks(), ComponentSubNodeObserver.class), _function_1));
              }
            } else {
              return super.getScope(context, reference);
            }
          }
        }
      }
    }
    return IScope.NULLSCOPE;
  }
}
