/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentParameter.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.component.componentParameter.AbstractComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.AbstractParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParamModel;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterSetInstance;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParamDefModel;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParamDefRepoImport;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetRepository;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.formatting2.ParameterDefinitionFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ComponentParameterFormatter extends ParameterDefinitionFormatter {
  protected void _format(final ComponentParamModel componentParamModel, @Extension final IFormattableDocument document) {
    EList<ParamDefRepoImport> _imports = componentParamModel.getImports();
    for (final ParamDefRepoImport paramDefRepoImport : _imports) {
      {
        final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.<ParamDefRepoImport>append(paramDefRepoImport, _function);
        document.<ParamDefRepoImport>format(paramDefRepoImport);
      }
    }
    document.<ComponentParameter>format(componentParamModel.getParametrization());
  }
  
  protected void _format(final ComponentParameter componentParameter, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(componentParameter).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(componentParameter).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    EList<AbstractComponentParameter> _parameters = componentParameter.getParameters();
    for (final AbstractComponentParameter abstractComponentParameter : _parameters) {
      {
        document.<AbstractComponentParameter>format(abstractComponentParameter);
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<AbstractComponentParameter>append(abstractComponentParameter, _function_3);
        final ISemanticRegion open = this.textRegionExtensions.regionFor(abstractComponentParameter).keyword("{");
        final ISemanticRegion close = this.textRegionExtensions.regionFor(abstractComponentParameter).keyword("}");
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.prepend(open, _function_4);
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.append(open, _function_5);
        final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
          it.indent();
        };
        document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_6);
      }
    }
  }
  
  protected void _format(final ParameterSetInstance paramSet, @Extension final IFormattableDocument document) {
    EList<AbstractParameterInstance> _parameterInstances = paramSet.getParameterInstances();
    for (final AbstractParameterInstance param : _parameterInstances) {
      {
        document.<AbstractParameterInstance>format(param);
        final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<AbstractParameterInstance>append(param, _function);
      }
    }
  }
  
  protected void _format(final ParameterInstance param, @Extension final IFormattableDocument document) {
    final ISemanticRegion open = this.textRegionExtensions.regionFor(param).keyword("{");
    final ISemanticRegion close = this.textRegionExtensions.regionFor(param).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(open, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_1);
    EList<AttributeRefinement> _attributes = param.getAttributes();
    for (final AttributeRefinement attr : _attributes) {
      {
        final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        document.surround(this.textRegionExtensions.regionFor(attr).keyword("="), _function_2);
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<AttributeRefinement>append(attr, _function_3);
        document.<AttributeRefinement>format(attr);
      }
    }
  }
  
  public void format(final Object param, final IFormattableDocument document) {
    if (param instanceof ParameterInstance) {
      _format((ParameterInstance)param, document);
      return;
    } else if (param instanceof ParameterSetInstance) {
      _format((ParameterSetInstance)param, document);
      return;
    } else if (param instanceof XtextResource) {
      _format((XtextResource)param, document);
      return;
    } else if (param instanceof AttributeDefinition) {
      _format((AttributeDefinition)param, document);
      return;
    } else if (param instanceof AttributeRefinement) {
      _format((AttributeRefinement)param, document);
      return;
    } else if (param instanceof InlineEnumerationType) {
      _format((InlineEnumerationType)param, document);
      return;
    } else if (param instanceof ParameterSetRepository) {
      _format((ParameterSetRepository)param, document);
      return;
    } else if (param instanceof ComponentParamModel) {
      _format((ComponentParamModel)param, document);
      return;
    } else if (param instanceof ComponentParameter) {
      _format((ComponentParameter)param, document);
      return;
    } else if (param instanceof ParamDefModel) {
      _format((ParamDefModel)param, document);
      return;
    } else if (param instanceof EObject) {
      _format((EObject)param, document);
      return;
    } else if (param == null) {
      _format((Void)null, document);
      return;
    } else if (param != null) {
      _format(param, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(param, document).toString());
    }
  }
}
