/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.activityArchitecture.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.AbstractActivityArchitectureElement;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitectureModel;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.InputHandlerNode;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.TriggerInputNode;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class ActivityArchitectureFormatter extends AbstractFormatter2 {
  protected void _format(final ActivityArchitectureModel activityArchitectureModel, @Extension final IFormattableDocument document) {
    EList<AbstractActivityArchitectureElement> _elements = activityArchitectureModel.getElements();
    for (final AbstractActivityArchitectureElement abstractActivityArchitectureElement : _elements) {
      document.<AbstractActivityArchitectureElement>format(abstractActivityArchitectureElement);
    }
  }
  
  protected void _format(final InputHandlerNode inputHandlerNode, @Extension final IFormattableDocument document) {
    document.<TriggerInputNode>format(inputHandlerNode.getInputNode());
  }
  
  public void format(final Object inputHandlerNode, final IFormattableDocument document) {
    if (inputHandlerNode instanceof InputHandlerNode) {
      _format((InputHandlerNode)inputHandlerNode, document);
      return;
    } else if (inputHandlerNode instanceof XtextResource) {
      _format((XtextResource)inputHandlerNode, document);
      return;
    } else if (inputHandlerNode instanceof ActivityArchitectureModel) {
      _format((ActivityArchitectureModel)inputHandlerNode, document);
      return;
    } else if (inputHandlerNode instanceof EObject) {
      _format((EObject)inputHandlerNode, document);
      return;
    } else if (inputHandlerNode == null) {
      _format((Void)null, document);
      return;
    } else if (inputHandlerNode != null) {
      _format(inputHandlerNode, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(inputHandlerNode, document).toString());
    }
  }
}
