/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.componentArchitecture.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitectureRuntimeModule;
import org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitectureStandaloneSetup;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class ComponentArchitectureIdeSetup extends ComponentArchitectureStandaloneSetup {
  @Override
  public Injector createInjector() {
    ComponentArchitectureRuntimeModule _componentArchitectureRuntimeModule = new ComponentArchitectureRuntimeModule();
    ComponentArchitectureIdeModule _componentArchitectureIdeModule = new ComponentArchitectureIdeModule();
    return Guice.createInjector(Modules2.mixin(_componentArchitectureRuntimeModule, _componentArchitectureIdeModule));
  }
}
