/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.utils;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.CustomStyle;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractNotSelectableShapeNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.figure.IWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AirStyleDefaultSizeNodeFigure;

public class CommPortEditPart
extends AbstractNotSelectableShapeNodeEditPart
implements IStyleEditPart {
    protected IFigure contentPane;
    protected WorkspaceImage leftImage;
    protected WorkspaceImage rightImage;
    protected WorkspaceImage topImage;
    protected WorkspaceImage bottomImage;
    protected IWorkspaceImageFigure primaryShape;

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    public CommPortEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    private NodeFigure createNodePlate() {
        AirStyleDefaultSizeNodeFigure result = new AirStyleDefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
        return result;
    }

    protected IFigure createNodeShape() {
        EObject element = this.resolveSemanticElement();
        WorkspaceImageFigure wif = null;
        if (element instanceof CustomStyle) {
            CustomStyle customStyle = (CustomStyle)element;
            String baseImagePath = "org.eclipse.smartmdsd.sirius.utils/icons/" + customStyle.getId();
            this.leftImage = DiagramFactory.eINSTANCE.createWorkspaceImage();
            this.rightImage = DiagramFactory.eINSTANCE.createWorkspaceImage();
            this.topImage = DiagramFactory.eINSTANCE.createWorkspaceImage();
            this.bottomImage = DiagramFactory.eINSTANCE.createWorkspaceImage();
            this.leftImage.setWorkspacePath(String.valueOf(baseImagePath) + "/left.png");
            this.rightImage.setWorkspacePath(String.valueOf(baseImagePath) + "/right.png");
            this.topImage.setWorkspacePath(String.valueOf(baseImagePath) + "/up.png");
            this.bottomImage.setWorkspacePath(String.valueOf(baseImagePath) + "/down.png");
            wif = WorkspaceImageFigure.createImageFigure((WorkspaceImage)this.leftImage);
        }
        this.primaryShape = wif;
        return this.primaryShape;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy result = super.getPrimaryDragEditPolicy();
        if (result instanceof ResizableEditPolicy) {
            ResizableEditPolicy ep = (ResizableEditPolicy)result;
            ep.setResizeDirections(0);
        }
        return result;
    }

    public IWorkspaceImageFigure getPrimaryShape() {
        return this.primaryShape;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void refreshVisuals() {
        Node model;
        Node portNode;
        super.refreshVisuals();
        if (this.getModel() instanceof Node && (portNode = (Node)(model = (Node)this.getModel()).eContainer()).getLayoutConstraint() instanceof Bounds) {
            Bounds portBounds = (Bounds)portNode.getLayoutConstraint();
            Node componentNode = (Node)portNode.eContainer();
            if (componentNode.getLayoutConstraint() instanceof Bounds) {
                Bounds compBounds = (Bounds)componentNode.getLayoutConstraint();
                if (portBounds.getX() < 0) {
                    this.primaryShape.refreshFigure(this.leftImage);
                } else if (portBounds.getY() < 0) {
                    this.primaryShape.refreshFigure(this.topImage);
                } else if (compBounds.getWidth() < portBounds.getX() + portBounds.getWidth()) {
                    this.primaryShape.refreshFigure(this.rightImage);
                } else {
                    this.primaryShape.refreshFigure(this.bottomImage);
                }
            }
        }
    }
}

