/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ACSettingEntry;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CDTProjectHelpers {
    public static List<IConfiguration> getSupportedConfigurations() {
        ArrayList<IConfiguration> cfgs = new ArrayList<IConfiguration>();
        IConfiguration[] iConfigurationArray = ManagedBuildManager.getExtensionConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildPropertyValue value;
            IConfiguration cfg = iConfigurationArray[n2];
            IToolChain tc = cfg.getToolChain();
            if (tc != null && ManagedBuildManager.isPlatformOk((IToolChain)tc) && tc.isSupported() && (value = cfg.getBuildArtefactType()) != null && "org.eclipse.cdt.build.core.buildArtefactType.exe".equals(value.getId())) {
                cfgs.add(cfg);
            }
            ++n2;
        }
        return cfgs;
    }

    public static boolean isSmartMDSDBuilderActiveFor(IProject project) {
        IConfiguration[] configs;
        boolean hasSmartMDSDBuilder = false;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configs = buildInfo.getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (config.getBuilder().getName().startsWith("SmartMDSD")) {
                hasSmartMDSDBuilder = true;
            }
            ++n2;
        }
        return hasSmartMDSDBuilder;
    }

    public static IBuilder getSmartMDSDBuilderOf(IProject project) {
        IConfiguration[] configs;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configs = buildInfo.getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (config.getBuilder().getName().startsWith("SmartMDSD")) {
                return config.getBuilder();
            }
            ++n2;
        }
        return null;
    }

    public static IBuilder getSmartMDSDBuilder() {
        IBuilder[] iBuilderArray = ManagedBuildManager.getRealBuilders();
        int n = iBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuilder builder = iBuilderArray[n2];
            if (builder.getId().equals("org.eclipse.smartmdsd.ui.smartmdsd.builder")) {
                return builder;
            }
            ++n2;
        }
        return null;
    }

    public static IBuilder getDefaultGNUBuilder() {
        IBuilder[] iBuilderArray = ManagedBuildManager.getRealBuilders();
        int n = iBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuilder builder = iBuilderArray[n2];
            if (builder.getId().startsWith("cdt.managedbuild.")) {
                return builder;
            }
            ++n2;
        }
        return null;
    }

    public static void addDefaultSettingsTo(IProject project, String activeBuildType, IProgressMonitor monitor) throws CoreException, BuildException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Set default CDT Settings", (int)100);
        CProjectNature.addCNature((IProject)project, (IProgressMonitor)subMonitor.split(20));
        CCProjectNature.addCCNature((IProject)project, (IProgressMonitor)subMonitor.split(20));
        ICProjectDescription cProjectDescription = CoreModel.getDefault().createProjectDescription(project, false);
        List<IConfiguration> supportedConfigurations = CDTProjectHelpers.getSupportedConfigurations();
        ManagedBuildManager.createBuildInfo((IResource)project);
        IManagedProject managedProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)supportedConfigurations.get(0).getProjectType());
        IBuilder smartmdsdBuilder = CDTProjectHelpers.getSmartMDSDBuilder();
        for (IConfiguration configuration : supportedConfigurations) {
            subMonitor.split(20);
            String builderSuffix = configuration.getName().toLowerCase();
            String builderID = ManagedBuildManager.calculateChildId((String)"org.eclipse.smartmdsd.ui.smartmdsd.builder", (String)builderSuffix);
            IConfiguration configurationClone = managedProject.createConfiguration(configuration, builderID);
            configurationClone.setArtifactName("${ProjName}");
            if (smartmdsdBuilder != null) {
                configurationClone.changeBuilder(smartmdsdBuilder, builderID, smartmdsdBuilder.getName());
            }
            configurationClone.getEditableBuilder().setParallelBuildOn(true);
            cProjectDescription.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", configurationClone.getConfigurationData());
        }
        ICConfigurationDescription[] configs = cProjectDescription.getConfigurations();
        if (configs != null && configs.length > 0) {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription config = iCConfigurationDescriptionArray[n2];
                if (config.getName().equals(activeBuildType)) {
                    config.setActive();
                    break;
                }
                ++n2;
            }
        }
        subMonitor.split(20);
        CoreModel.getDefault().setProjectDescription(project, cProjectDescription);
    }

    public static void setSmartMDSDCdtBuilderFor(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] configs = buildInfo.getManagedProject().getConfigurations();
        boolean hasChanges = false;
        IBuilder smartmdsdBuilder = CDTProjectHelpers.getSmartMDSDBuilder();
        if (smartmdsdBuilder != null) {
            IConfiguration[] iConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                String builderSuffix = config.getName().toLowerCase();
                String builderID = ManagedBuildManager.calculateChildId((String)smartmdsdBuilder.getId(), (String)builderSuffix);
                config.changeBuilder(smartmdsdBuilder, builderID, smartmdsdBuilder.getName());
                try {
                    config.getEditableBuilder().setParallelBuildOn(true);
                    hasChanges = true;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        if (hasChanges) {
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
    }

    public static void resetDefaultCdtBuilderFor(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] configs = buildInfo.getManagedProject().getConfigurations();
        boolean hasChanges = false;
        IBuilder gnuBuilder = CDTProjectHelpers.getDefaultGNUBuilder();
        if (gnuBuilder != null) {
            IConfiguration[] iConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                String builderID = ManagedBuildManager.calculateChildId((String)gnuBuilder.getId(), null);
                config.changeBuilder(gnuBuilder, builderID, gnuBuilder.getName());
                try {
                    config.getEditableBuilder().setParallelBuildOn(false);
                    hasChanges = true;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        if (hasChanges) {
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
    }

    public static void setDefaultCppIncludesFor(IProject project, boolean useKernelIncludes) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription projectDescription = mngr.getProjectDescription(project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDescription.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            ICFolderDescription projectRoot = configDescription.getRootFolderDescription();
            ICLanguageSetting[] iCLanguageSettingArray = projectRoot.getLanguageSettings();
            int n3 = iCLanguageSettingArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ICLanguageSetting setting = iCLanguageSettingArray[n4];
                String languageId = setting.getLanguageId();
                if (languageId != null && languageId.equals("org.eclipse.cdt.core.g++")) {
                    List includePathSettings = setting.getSettingEntriesList(1);
                    String aceInclude = "${ACE_ROOT}";
                    includePathSettings.add(new CIncludePathEntry(aceInclude, 4));
                    String smartInclude = "${SMART_ROOT_ACE}/include";
                    includePathSettings.add(new CIncludePathEntry(smartInclude, 4));
                    if (useKernelIncludes) {
                        String apiInclude = "/usr/include/SmartSoft_CD_API";
                        includePathSettings.add(new CIncludePathEntry(apiInclude, 4));
                        String kernelInclude = "/usr/include/AceSmartSoftKernel";
                        includePathSettings.add(new CIncludePathEntry(kernelInclude, 4));
                        String kernelMWInclude = "/usr/include/AceSmartSoftKernel/middlewareMapping";
                        includePathSettings.add(new CIncludePathEntry(kernelMWInclude, 4));
                    }
                    includePathSettings.add(new CIncludePathEntry("smartsoft/src", 8));
                    includePathSettings.add(new CIncludePathEntry("smartsoft/src-gen", 8));
                    setting.setSettingEntries(1, includePathSettings);
                }
                ++n4;
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(project, projectDescription);
    }

    public static boolean addFurtherCdtIncludesTo(IProject project, Map<String, Boolean> includes) throws CoreException {
        boolean settings_changed = false;
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription projectDescription = mngr.getProjectDescription(project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDescription.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            ICFolderDescription projectRoot = configDescription.getRootFolderDescription();
            ICLanguageSetting[] iCLanguageSettingArray = projectRoot.getLanguageSettings();
            int n3 = iCLanguageSettingArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ICLanguageSetting setting = iCLanguageSettingArray[n4];
                String languageId = setting.getLanguageId();
                if (languageId != null && languageId.equals("org.eclipse.cdt.core.g++")) {
                    List includePathSettings = setting.getSettingEntriesList(1);
                    for (Map.Entry<String, Boolean> includeEntry : includes.entrySet()) {
                        String includeString = includeEntry.getKey();
                        boolean already_included = false;
                        for (ICLanguageSettingEntry entry : includePathSettings) {
                            ACSettingEntry settingEntry;
                            if (!(entry instanceof ACSettingEntry) || !(settingEntry = (ACSettingEntry)entry).getName().contentEquals(includeString)) continue;
                            already_included = true;
                        }
                        if (already_included) continue;
                        settings_changed = true;
                        if (includeEntry.getValue().booleanValue()) {
                            includePathSettings.add(new CIncludePathEntry(includeString, 8));
                            continue;
                        }
                        includePathSettings.add(new CIncludePathEntry(includeString, 4));
                    }
                    setting.setSettingEntries(1, includePathSettings);
                }
                ++n4;
            }
            ++n2;
        }
        if (settings_changed) {
            CoreModel.getDefault().setProjectDescription(project, projectDescription);
        }
        return settings_changed;
    }

    public static void triggerCdtIndexRebuildFor(String projectName) {
        ICProject cproject = CoreModel.getDefault().getCModel().getCProject(projectName);
        CCorePlugin.getIndexManager().reindex(cproject);
    }

    public static void setActiveBuildTypeFor(IProject project, String activeBuildType) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription cProjectDescription = mngr.getProjectDescription(project);
        ICConfigurationDescription[] configs = cProjectDescription.getConfigurations();
        boolean settings_changed = false;
        if (configs != null && configs.length > 0) {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription config = iCConfigurationDescriptionArray[n2];
                if (config.getName().equals(activeBuildType)) {
                    if (config.isActive()) break;
                    config.setActive();
                    settings_changed = true;
                    System.out.println("change active build type to '" + config.getName() + "' for project " + project.getName());
                    break;
                }
                ++n2;
            }
        }
        if (settings_changed) {
            CoreModel.getDefault().setProjectDescription(project, cProjectDescription);
        }
    }

    public static String getCdtBuildMessages(IProject project) {
        return CUIPlugin.getDefault().getConsoleManager().getConsoleDocument(project).get();
    }
}

