/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.builder;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.smartmdsd.ui.Activator;
import org.eclipse.smartmdsd.ui.builder.CDTProjectHelpers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

public class CMakeConsoleRunnable
implements IWorkspaceRunnable {
    public static final String CONSOLE_ID = "org.eclipse.smartmdsd.ui.console.cmake";
    public static final String CONSOLE_NAME = "CMake Console";
    private IProject project;
    private IConsole console;
    private String buildConfigurationName;
    private MultiStatus cmakeStatus;

    public CMakeConsoleRunnable(IProject project, String buildConfigurationName) {
        this.project = project;
        this.buildConfigurationName = buildConfigurationName;
        this.console = CUIPlugin.getDefault().getConsoleManager(CONSOLE_NAME, CONSOLE_ID).getConsole(project);
        this.console.start(project);
        this.cmakeStatus = new MultiStatus(CONSOLE_ID, 1, "", null);
    }

    public void printInfoLine(String text) throws CoreException {
        ConsoleOutputStream info = this.console.getInfoStream();
        try {
            info.write(String.valueOf(text) + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getCMakeMessages(IProject project) {
        return CUIPlugin.getDefault().getConsoleManager(CONSOLE_NAME, CONSOLE_ID).getConsoleDocument(project).get();
    }

    public static String getCdtBuildMessages(IProject project) {
        return CUIPlugin.getDefault().getConsoleManager().getConsoleDocument(project).get();
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        ArrayList<String> cmakeArgimentsList = new ArrayList<String>();
        cmakeArgimentsList.add("-DBUILD_DEPENDENCIES=OFF");
        String defaultBuildType = Activator.getDefault().getPreferenceStore().getString("CMakeBuildType");
        if (!this.buildConfigurationName.contentEquals(defaultBuildType)) {
            CDTProjectHelpers.setActiveBuildTypeFor(this.project, defaultBuildType);
            this.buildConfigurationName = defaultBuildType;
        }
        cmakeArgimentsList.add("-DCMAKE_BUILD_TYPE=" + this.buildConfigurationName);
        String ros_distro_dir = Activator.getDefault().getPreferenceStore().getString("ROSDistributionDir");
        File ros_dir = new File(ros_distro_dir);
        if (ros_dir.exists()) {
            cmakeArgimentsList.add("-DCMAKE_PREFIX_PATH=" + ros_dir.getPath());
        }
        String[] environmentVariables = this.calculateEnvironmentVariables(this.project, ros_dir);
        cmakeArgimentsList.add("..");
        String[] cmakeArguments = new String[cmakeArgimentsList.size()];
        cmakeArguments = cmakeArgimentsList.toArray(cmakeArguments);
        IBuilder builder = CDTProjectHelpers.getSmartMDSDBuilderOf(this.project);
        ICommandLauncher launcher = builder.getCommandLauncher();
        this.setCMakeConsolePinned(true);
        this.printInfoLine("Start CMake for [" + this.project.getName() + "]");
        if (!builder.getBuildLocation().toFile().exists()) {
            builder.getBuildLocation().toFile().mkdirs();
            this.project.refreshLocal(2, monitor);
        }
        Process cmakeProcess = launcher.execute(builder.getBuildCommand(), cmakeArguments, environmentVariables, builder.getBuildLocation(), monitor);
        launcher.waitAndRead((OutputStream)this.console.getOutputStream(), (OutputStream)this.console.getErrorStream(), monitor);
        if (cmakeProcess.exitValue() != 0) {
            this.cmakeStatus = new MultiStatus(CONSOLE_ID, 4, "CMake of [" + this.project.getName() + "] canceled with Errors!", null);
        } else {
            this.cmakeStatus = new MultiStatus(CONSOLE_ID, 0, "CMake of [" + this.project.getName() + "] successfully finished!", null);
            this.printInfoLine("CMake of [" + this.project.getName() + "] successfully finished!\n");
            this.setCMakeConsolePinned(false);
        }
    }

    public MultiStatus getStatus() {
        return this.cmakeStatus;
    }

    private String[] calculateEnvironmentVariables(IProject project, File ros_dir) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        Map environment = manager.getNativeEnvironment();
        Integer index = 0;
        int env_size = environment.size();
        if (ros_dir.exists()) {
            env_size += 3;
        }
        String[] environmentVariables = new String[env_size];
        String workspacePath = project.getWorkspace().getRoot().getLocation().toOSString();
        for (Map.Entry entry : environment.entrySet()) {
            environmentVariables[index.intValue()] = ((String)entry.getKey()).contentEquals("SMART_PACKAGE_PATH") ? String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue() + ":" + workspacePath : (((String)entry.getKey()).equals("PATH") && ros_dir.exists() ? String.valueOf((String)entry.getKey()) + "=" + ros_dir.getPath() + "/bin:" + (String)entry.getValue() : String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
            index = index + 1;
        }
        if (ros_dir.exists()) {
            Integer n = index;
            index = n + 1;
            environmentVariables[n.intValue()] = "ROS_ROOT=" + ros_dir.getPath() + "/share/ros";
            Integer n2 = index;
            index = n2 + 1;
            environmentVariables[n2.intValue()] = "ROS_PACKAGE_PATH=" + ros_dir.getPath() + "/share";
            String python_version = "3";
            if (ros_dir.getName().contentEquals("melodic") || ros_dir.getName().contentEquals("kinetic")) {
                python_version = "2.7";
            }
            Integer n3 = index;
            index = n3 + 1;
            environmentVariables[n3.intValue()] = "PYTHONPATH=" + ros_dir.getPath() + "/lib/python" + python_version + "/dist-packages:/usr/lib/python" + python_version + "/dist-packages";
        }
        return environmentVariables;
    }

    private void setCMakeConsolePinned(final boolean pinned) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    IViewPart consoleViewPart = page.findView("org.eclipse.ui.console.ConsoleView");
                    if (consoleViewPart == null) {
                        try {
                            IWorkbenchPart activePart = page.getActivePart();
                            consoleViewPart = page.showView("org.eclipse.ui.console.ConsoleView");
                            page.activate(activePart);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                    page.bringToTop((IWorkbenchPart)consoleViewPart);
                    if (consoleViewPart instanceof IConsoleView) {
                        IConsoleView consoleView = (IConsoleView)consoleViewPart;
                        ConsolePlugin plugin = ConsolePlugin.getDefault();
                        IConsoleManager consoleManager = plugin.getConsoleManager();
                        org.eclipse.ui.console.IConsole[] ui_consoles = consoleManager.getConsoles();
                        int i = 0;
                        while (i < ui_consoles.length) {
                            org.eclipse.ui.console.IConsole ui_console = ui_consoles[i];
                            if (ui_console.getName().startsWith(CMakeConsoleRunnable.CONSOLE_NAME)) {
                                if (pinned) {
                                    consoleView.display(ui_console);
                                }
                                consoleView.setPinned(pinned);
                            }
                            if (!pinned && ui_console.getName().startsWith("CDT Build Console")) {
                                consoleView.display(ui_console);
                            }
                            ++i;
                        }
                    }
                }
            }
        });
    }
}

