/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.preferences;

import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class VariablesAndDirectoryFieldEditor
extends DirectoryFieldEditor {
    private Button variablesButton;

    public VariablesAndDirectoryFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public int getNumberOfControls() {
        return 4;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns - 1);
        this.variablesButton = this.getVariablesButton(parent);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels((Control)this.variablesButton, 61);
        gd.widthHint = Math.max(widthHint, this.variablesButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.variablesButton.setLayoutData((Object)gd);
    }

    protected Button getVariablesButton(final Composite parent) {
        if (this.variablesButton == null) {
            this.variablesButton = new Button(parent, 8);
            this.variablesButton.setText("Variables...");
            this.variablesButton.setFont(parent.getFont());
            this.variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String newValue = VariablesAndDirectoryFieldEditor.this.getVariableSelection(parent.getShell());
                    if (newValue != null) {
                        VariablesAndDirectoryFieldEditor.this.setStringValue(newValue);
                    }
                }
            });
            this.variablesButton.addDisposeListener(event -> {
                Button button = this.variablesButton = null;
            });
        } else {
            this.checkParent((Control)this.variablesButton, parent);
        }
        return this.variablesButton;
    }

    protected String getVariableSelection(Shell shell) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(shell);
        if (dialog.open() == 0) {
            return dialog.getVariableExpression();
        }
        return null;
    }

    protected boolean doCheckState() {
        String fileName = this.getTextControl().getText();
        if (fileName.length() > 0 && fileName.startsWith("${")) {
            return true;
        }
        return super.doCheckState();
    }
}

