/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class FilteredProjectReferencePage
extends WizardNewProjectReferencePage {
    private SmartMDSDNatureEnum currentNatureEnum;

    public FilteredProjectReferencePage(String pageName, SmartMDSDNatureEnum currentNatureEnum) {
        super(pageName);
        this.currentNatureEnum = currentNatureEnum;
    }

    protected IStructuredContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (!(element instanceof IWorkspace)) {
                    return new Object[0];
                }
                IProject[] projects = ((IWorkspace)element).getRoot().getProjects();
                if (projects != null) {
                    ArrayList<IProject> filteredProjects = new ArrayList<IProject>();
                    try {
                        List<String> relatedProjectNatureIds = FilteredProjectReferencePage.this.currentNatureEnum.createSmartMDSDNatureObject().getImportedProjectNatureIds();
                        IProject[] iProjectArray = projects;
                        int n = projects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            if (project.isOpen()) {
                                for (String natureId : relatedProjectNatureIds) {
                                    if (!project.hasNature(natureId)) continue;
                                    filteredProjects.add(project);
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    return filteredProjects.toArray();
                }
                return projects == null ? new Object[]{} : projects;
            }
        };
    }
}

