/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.docuterminals.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smartmdsd.xtext.base.docuterminals.DocuTerminalsRuntimeModule;
import org.eclipse.smartmdsd.xtext.base.docuterminals.DocuTerminalsStandaloneSetup;
import org.eclipse.smartmdsd.xtext.base.docuterminals.ide.DocuTerminalsIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class DocuTerminalsIdeSetup extends DocuTerminalsStandaloneSetup {
  @Override
  public Injector createInjector() {
    DocuTerminalsRuntimeModule _docuTerminalsRuntimeModule = new DocuTerminalsRuntimeModule();
    DocuTerminalsIdeModule _docuTerminalsIdeModule = new DocuTerminalsIdeModule();
    return Guice.createInjector(Modules2.mixin(_docuTerminalsRuntimeModule, _docuTerminalsIdeModule));
  }
}
