/********************************************************************************
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.base.docuterminals.parser.antlr;

import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtext.base.docuterminals.parser.antlr.internal.InternalDocuTerminalsParser;
import org.eclipse.smartmdsd.xtext.base.docuterminals.services.DocuTerminalsGrammarAccess;
import org.eclipse.xtext.parser.antlr.AbstractAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;

public class DocuTerminalsParser extends AbstractAntlrParser {

	@Inject
	private DocuTerminalsGrammarAccess grammarAccess;

	@Override
	protected void setInitialHiddenTokens(XtextTokenStream tokenStream) {
		tokenStream.setInitialHiddenTokens("RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT");
	}
	

	@Override
	protected InternalDocuTerminalsParser createParser(XtextTokenStream stream) {
		return new InternalDocuTerminalsParser(stream, getGrammarAccess());
	}

	@Override 
	protected String getDefaultRuleName() {
		return "AbstractDocumentationElement";
	}

	public DocuTerminalsGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(DocuTerminalsGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
}
