/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.componentMode;

import com.google.inject.Injector;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModePackage;
import org.eclipse.smartmdsd.xtext.service.componentMode.ComponentModeStandaloneSetupGenerated;

/**
 * Initialization support for running Xtext languages without Equinox extension registry.
 */
@SuppressWarnings("all")
public class ComponentModeStandaloneSetup extends ComponentModeStandaloneSetupGenerated {
  public static void doSetup() {
    new ComponentModeStandaloneSetup().createInjectorAndDoEMFRegistration();
  }
  
  @Override
  public void register(final Injector injector) {
    boolean _containsKey = EPackage.Registry.INSTANCE.containsKey(ComponentModePackage.eNS_URI);
    boolean _not = (!_containsKey);
    if (_not) {
      EPackage.Registry.INSTANCE.put(ComponentModePackage.eNS_URI, 
        ComponentModePackage.eINSTANCE);
    }
    super.register(injector);
  }
}
