/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OpcUaXmlParser {
    public SeRoNetNodeId getNodeIdFromString(String StartString) {
        SeRoNetNodeId nid = new SeRoNetNodeId();
        int _indexOf = StartString.indexOf("=");
        int _plus = _indexOf + 1;
        nid.ns = Integer.parseInt(StartString.substring(_plus, StartString.indexOf(";")));
        String StartString2 = StartString.substring(StartString.indexOf("i"), StartString.length());
        int _indexOf_1 = StartString2.indexOf("=");
        int _plus_1 = _indexOf_1 + 1;
        nid.i = Integer.parseInt(StartString2.substring(_plus_1, StartString2.length()));
        return nid;
    }

    public String getObjectName(File xmlFile) {
        try {
            boolean verbose = true;
            String objectName = "NotFound";
            boolean _exists = xmlFile.exists();
            if (_exists) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(xmlFile);
                doc.getDocumentElement().normalize();
                NodeList nl = doc.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Element el;
                    String nodeName;
                    boolean _equals;
                    Node uel = nl.item(i);
                    if (uel instanceof Element && (_equals = Objects.equal((Object)(nodeName = (el = (Element)uel).getNodeName()), (Object)"UAObjectType"))) {
                        NodeList cn = el.getChildNodes();
                        int j = 0;
                        while (j < cn.getLength()) {
                            Node uuel = cn.item(j);
                            if (uuel instanceof Element) {
                                Element cel = (Element)uuel;
                                String childNode = cel.getNodeName();
                                String childNodeName = cel.getTextContent();
                                boolean _equals_1 = Objects.equal((Object)childNode, (Object)"DisplayName");
                                if (_equals_1) {
                                    objectName = childNodeName;
                                    if (verbose) {
                                        InputOutput.println((Object)("object found " + objectName));
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            return objectName;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Iterable<SeRoNetENTITY> getEntityList(File xmlFile) {
        try {
            ArrayList<SeRoNetENTITY> entityList = new ArrayList<SeRoNetENTITY>();
            boolean verbose = true;
            boolean _exists = xmlFile.exists();
            if (_exists) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(xmlFile);
                doc.getDocumentElement().normalize();
                if (verbose) {
                    InputOutput.println((Object)"||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||");
                }
                if (verbose) {
                    InputOutput.println((Object)"=============================================================================");
                }
                NodeList nl = doc.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node uel = nl.item(i);
                    if (uel instanceof Element) {
                        Element el = (Element)uel;
                        String nodeName = el.getNodeName();
                        String dataType = el.getAttribute("DataType");
                        String userAccessLevel = el.getAttribute("UserAccessLevel");
                        String EntityNodeId = el.getAttribute("NodeId");
                        String EntityParentNodeId = el.getAttribute("ParentNodeId");
                        boolean _equals = Objects.equal((Object)nodeName, (Object)"UAVariable");
                        if (_equals) {
                            SeRoNetENTITY entity = new SeRoNetENTITY();
                            ArrayList<SeRoNetNodeId> New_Children_nodeid = new ArrayList<SeRoNetNodeId>();
                            boolean addNewEntity = false;
                            NodeList cn = el.getChildNodes();
                            int j = 0;
                            while (j < cn.getLength()) {
                                Node uuel = cn.item(j);
                                if (uuel instanceof Element) {
                                    boolean _equals_2;
                                    Element cel = (Element)uuel;
                                    String childNode = cel.getNodeName();
                                    String childNodeName = cel.getTextContent();
                                    boolean _equals_1 = Objects.equal((Object)childNode, (Object)"DisplayName");
                                    if (_equals_1 && !Objects.equal((Object)childNodeName, (Object)"InputArguments") && !Objects.equal((Object)childNodeName, (Object)"OutputArguments")) {
                                        entity.name = childNodeName;
                                        entity.type = dataType;
                                        entity.userAccessLevel = Integer.parseInt(userAccessLevel);
                                        entity.nodeid = this.getNodeIdFromString(EntityNodeId);
                                        entity.Parent_nodeid = this.getNodeIdFromString(EntityParentNodeId);
                                        addNewEntity = true;
                                    }
                                    if (_equals_2 = Objects.equal((Object)childNode, (Object)"References")) {
                                        NodeList Refs = cel.getChildNodes();
                                        int r = 0;
                                        while (r < Refs.getLength()) {
                                            Node Ref = Refs.item(r);
                                            if (Ref instanceof Element) {
                                                String RefChildNodeType = ((Element)Ref).getAttribute("ReferenceType");
                                                String IsForward = ((Element)Ref).getAttribute("IsForward");
                                                if (Objects.equal((Object)RefChildNodeType, (Object)"HasComponent") && !Objects.equal((Object)IsForward, (Object)"false")) {
                                                    String childnodeid = ((Element)Ref).getTextContent();
                                                    New_Children_nodeid.add(this.getNodeIdFromString(childnodeid));
                                                }
                                            }
                                            ++r;
                                        }
                                    }
                                }
                                ++j;
                            }
                            if (addNewEntity) {
                                entity.Children_nodeid = New_Children_nodeid;
                                if (verbose) {
                                    entity.Display();
                                }
                                entityList.add(entity);
                            }
                        }
                    }
                    ++i;
                }
                if (verbose) {
                    InputOutput.println((Object)"=============================================================================");
                }
            }
            return entityList;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Iterable<SeRoNetMETHOD> getMethodList(File xmlFile) {
        try {
            ArrayList<SeRoNetMETHOD> methodList = new ArrayList<SeRoNetMETHOD>();
            boolean verbose = true;
            boolean _exists = xmlFile.exists();
            if (_exists) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(xmlFile);
                doc.getDocumentElement().normalize();
                NodeList nl = doc.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node uel = nl.item(i);
                    if (uel instanceof Element) {
                        Element el = (Element)uel;
                        String nodeName = el.getNodeName();
                        String MethodNodeId = el.getAttribute("NodeId");
                        String MethodParentNodeId = el.getAttribute("ParentNodeId");
                        boolean _equals = Objects.equal((Object)nodeName, (Object)"UAMethod");
                        if (_equals) {
                            SeRoNetMETHOD method = new SeRoNetMETHOD();
                            ArrayList<SeRoNetNodeId> New_Children_nodeid = new ArrayList<SeRoNetNodeId>();
                            boolean addNewMethod = false;
                            NodeList cn = el.getChildNodes();
                            int j = 0;
                            while (j < cn.getLength()) {
                                Node uuel = cn.item(j);
                                if (uuel instanceof Element) {
                                    boolean _equals_2;
                                    Element cel = (Element)uuel;
                                    String childNode = cel.getNodeName();
                                    String childNodeName = cel.getTextContent();
                                    boolean _equals_1 = Objects.equal((Object)childNode, (Object)"References");
                                    if (_equals_1) {
                                        NodeList Refs = cel.getChildNodes();
                                        int r = 0;
                                        while (r < Refs.getLength()) {
                                            Node Ref = Refs.item(r);
                                            if (Ref instanceof Element) {
                                                String RefChildNodeType = ((Element)Ref).getAttribute("ReferenceType");
                                                String IsForward = ((Element)Ref).getAttribute("IsForward");
                                                if (Objects.equal((Object)RefChildNodeType, (Object)"HasProperty") && !Objects.equal((Object)IsForward, (Object)"false")) {
                                                    String childnodeid = ((Element)Ref).getTextContent();
                                                    New_Children_nodeid.add(this.getNodeIdFromString(childnodeid));
                                                }
                                            }
                                            ++r;
                                        }
                                    }
                                    if (_equals_2 = Objects.equal((Object)childNode, (Object)"DisplayName")) {
                                        method.name = childNodeName;
                                        boolean verboseSAVED = verbose;
                                        verbose = true;
                                        int ib = 0;
                                        while (ib < nl.getLength()) {
                                            Node B = nl.item(ib);
                                            if (B instanceof Element) {
                                                Element C = (Element)B;
                                                String C_Node = C.getNodeName();
                                                String C_ParentNodeId = C.getAttribute("ParentNodeId");
                                                String ArgumentNodeId = C.getAttribute("NodeId");
                                                if (Objects.equal((Object)C_Node, (Object)"UAVariable") && Objects.equal((Object)C_ParentNodeId, (Object)MethodNodeId)) {
                                                    boolean _notEquals;
                                                    NodeList D = C.getChildNodes();
                                                    String F_InOrOutl = "";
                                                    int id = 0;
                                                    while (id < D.getLength()) {
                                                        Node E = D.item(id);
                                                        if (E instanceof Element) {
                                                            Element F = (Element)E;
                                                            String F_Node = F.getNodeName();
                                                            String F_NodeName = F.getTextContent();
                                                            boolean _equals_3 = Objects.equal((Object)F_Node, (Object)"DisplayName");
                                                            if (_equals_3) {
                                                                F_InOrOutl = F_NodeName;
                                                            }
                                                        }
                                                        ++id;
                                                    }
                                                    boolean bl = _notEquals = !Objects.equal((Object)F_InOrOutl, (Object)"");
                                                    if (_notEquals) {
                                                        int id2 = 0;
                                                        while (id2 < D.getLength()) {
                                                            Node E = D.item(id2);
                                                            if (E instanceof Element && E.getNodeName().equals("Value")) {
                                                                NodeList F = E.getChildNodes();
                                                                int iff = 0;
                                                                while (iff < F.getLength()) {
                                                                    Node G = F.item(iff);
                                                                    if (G instanceof Element && G.getNodeName().equals("ListOfExtensionObject")) {
                                                                        NodeList H = G.getChildNodes();
                                                                        int ih = 0;
                                                                        while (ih < H.getLength()) {
                                                                            Node I = H.item(ih);
                                                                            if (I instanceof Element && I.getNodeName().equals("ExtensionObject")) {
                                                                                NodeList J = I.getChildNodes();
                                                                                int ij = 0;
                                                                                while (ij < J.getLength()) {
                                                                                    Node K = J.item(ij);
                                                                                    if (K instanceof Element && K.getNodeName().equals("Body")) {
                                                                                        NodeList L = K.getChildNodes();
                                                                                        int il = 0;
                                                                                        while (il < L.getLength()) {
                                                                                            Node M = L.item(il);
                                                                                            if (M instanceof Element && M.getNodeName().equals("Argument")) {
                                                                                                SeRoNetARGUMENT NewArg = new SeRoNetARGUMENT();
                                                                                                NodeList N = M.getChildNodes();
                                                                                                int in = 0;
                                                                                                while (in < N.getLength()) {
                                                                                                    Node O = N.item(in);
                                                                                                    if (O instanceof Element && O.getNodeName().equals("Name") && !O.getTextContent().equals("")) {
                                                                                                        NewArg.name = O.getTextContent();
                                                                                                    }
                                                                                                    if (O instanceof Element && O.getNodeName().equals("DataType") && !O.getTextContent().equals("")) {
                                                                                                        NodeList P = O.getChildNodes();
                                                                                                        int ip = 0;
                                                                                                        while (ip < P.getLength()) {
                                                                                                            Node Q = P.item(ip);
                                                                                                            if (Q instanceof Element && Q.getNodeName().equals("Identifier") && !Q.getTextContent().equals("")) {
                                                                                                                String tmp = Q.getTextContent();
                                                                                                                tmp = tmp.substring(2);
                                                                                                                NewArg.DataTypeIdentifier = Integer.parseInt(tmp);
                                                                                                            }
                                                                                                            ++ip;
                                                                                                        }
                                                                                                    }
                                                                                                    if (O instanceof Element && O.getNodeName().equals("ValueRank") && !O.getTextContent().equals("")) {
                                                                                                        NewArg.ValueRank = Integer.parseInt(O.getTextContent());
                                                                                                    }
                                                                                                    if (O instanceof Element && O.getNodeName().equals("ArrayDimensions") && !O.getTextContent().equals("")) {
                                                                                                        NewArg.ArrayDimensions = Integer.parseInt(O.getTextContent());
                                                                                                    }
                                                                                                    ++in;
                                                                                                }
                                                                                                NewArg.nodeid = this.getNodeIdFromString(ArgumentNodeId);
                                                                                                NewArg.Parent_nodeid = this.getNodeIdFromString(C_ParentNodeId);
                                                                                                boolean _equals_3 = Objects.equal((Object)F_InOrOutl, (Object)"InputArguments");
                                                                                                if (_equals_3) {
                                                                                                    method.inputArguments.add(NewArg);
                                                                                                } else {
                                                                                                    method.outputArguments.add(NewArg);
                                                                                                }
                                                                                            }
                                                                                            ++il;
                                                                                        }
                                                                                    }
                                                                                    ++ij;
                                                                                }
                                                                            }
                                                                            ++ih;
                                                                        }
                                                                    }
                                                                    ++iff;
                                                                }
                                                            }
                                                            ++id2;
                                                        }
                                                    }
                                                }
                                            }
                                            ++ib;
                                        }
                                        method.nodeid = this.getNodeIdFromString(MethodNodeId);
                                        method.Parent_nodeid = this.getNodeIdFromString(MethodParentNodeId);
                                        addNewMethod = true;
                                        verbose = verboseSAVED;
                                    }
                                }
                                ++j;
                            }
                            if (addNewMethod) {
                                method.Children_nodeid = New_Children_nodeid;
                                if (verbose) {
                                    method.Display();
                                }
                                methodList.add(method);
                            }
                        }
                    }
                    ++i;
                }
                if (verbose) {
                    InputOutput.println((Object)"=============================================================================");
                }
            }
            return methodList;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String getCppType(String opcUaType) {
        String _switchResult;
        block70: {
            _switchResult = null;
            if (opcUaType == null) break block70;
            switch (opcUaType) {
                case "Boolean": {
                    _switchResult = "bool";
                    break;
                }
                case "String": {
                    _switchResult = "std::string";
                    break;
                }
                case "Byte": {
                    _switchResult = "unsigned char";
                    break;
                }
                case "Int16": {
                    _switchResult = "short";
                    break;
                }
                case "UInt16": {
                    _switchResult = "unsigned short";
                    break;
                }
                case "Int32": {
                    _switchResult = "int";
                    break;
                }
                case "UInt32": {
                    _switchResult = "unsigned int";
                    break;
                }
                case "Int64": {
                    _switchResult = "long";
                    break;
                }
                case "UInt64": {
                    _switchResult = "unsigned long";
                    break;
                }
                case "Float": {
                    _switchResult = "float";
                    break;
                }
                case "Double": {
                    _switchResult = "double";
                    break;
                }
                case "std::vector<Boolean>": {
                    _switchResult = "std::vector<bool>";
                    break;
                }
                case "std::vector<String>": {
                    _switchResult = "std::vector<std::string>";
                    break;
                }
                case "std::vector<Byte>": {
                    _switchResult = "std::vector<unsigned char>";
                    break;
                }
                case "std::vector<Int16>": {
                    _switchResult = "std::vector<short>";
                    break;
                }
                case "std::vector<UInt16>": {
                    _switchResult = "std::vector<unsigned short>";
                    break;
                }
                case "std::vector<Int32>": {
                    _switchResult = "std::vector<int>";
                    break;
                }
                case "std::vector<UInt32>": {
                    _switchResult = "std::vector<unsigned int>";
                    break;
                }
                case "std::vector<Int64>": {
                    _switchResult = "std::vector<long>";
                    break;
                }
                case "std::vector<UInt64>": {
                    _switchResult = "std::vector<unsigned long>";
                    break;
                }
                case "std::vector<Float>": {
                    _switchResult = "std::vector<float>";
                    break;
                }
                case "std::vector<Double>": {
                    _switchResult = "std::vector<double>";
                }
            }
        }
        return _switchResult;
    }

    public String getCppDefaultValue(String opcUaType) {
        String _switchResult;
        block70: {
            _switchResult = null;
            if (opcUaType == null) break block70;
            switch (opcUaType) {
                case "Boolean": {
                    _switchResult = "false";
                    break;
                }
                case "String": {
                    _switchResult = "std::string(\"\")";
                    break;
                }
                case "Byte": {
                    _switchResult = "0";
                    break;
                }
                case "Int16": {
                    _switchResult = "0";
                    break;
                }
                case "UInt16": {
                    _switchResult = "0";
                    break;
                }
                case "Int32": {
                    _switchResult = "0";
                    break;
                }
                case "UInt32": {
                    _switchResult = "0";
                    break;
                }
                case "Int64": {
                    _switchResult = "0";
                    break;
                }
                case "UInt64": {
                    _switchResult = "0";
                    break;
                }
                case "Float": {
                    _switchResult = "0.0";
                    break;
                }
                case "Double": {
                    _switchResult = "0.0";
                    break;
                }
                case "std::vector<Boolean>": {
                    _switchResult = "std::vector<bool>()";
                    break;
                }
                case "std::vector<String>": {
                    _switchResult = "std::vector<std::string>()";
                    break;
                }
                case "std::vector<Byte>": {
                    _switchResult = "std::vector<unsigned char>()";
                    break;
                }
                case "std::vector<Int16>": {
                    _switchResult = "std::vector<short>()";
                    break;
                }
                case "std::vector<UInt16>": {
                    _switchResult = "std::vector<unsigned short>()";
                    break;
                }
                case "std::vector<Int32>": {
                    _switchResult = "std::vector<int>()";
                    break;
                }
                case "std::vector<UInt32>": {
                    _switchResult = "std::vector<unsigned int>()";
                    break;
                }
                case "std::vector<Int64>": {
                    _switchResult = "std::vector<long>()";
                    break;
                }
                case "std::vector<UInt64>": {
                    _switchResult = "std::vector<unsigned long>()";
                    break;
                }
                case "std::vector<Float>": {
                    _switchResult = "std::vector<float>()";
                    break;
                }
                case "std::vector<Double>": {
                    _switchResult = "std::vector<double>()";
                }
            }
        }
        return _switchResult;
    }

    public String getCppMethodArgumentsDef(SeRoNetMETHOD method) {
        String result = "";
        for (SeRoNetARGUMENT argIn : method.inputArguments) {
            boolean _notEquals;
            result = String.valueOf(result) + "const ";
            if (argIn.ValueRank == 1) {
                String _plus_1;
                String _DataTypeString = argIn.DataTypeString();
                String _plus = String.valueOf(result) + "std::vector<" + _DataTypeString;
                result = _plus_1 = String.valueOf(_plus) + ">";
            } else {
                String _plus_2;
                String _DataTypeString_1 = argIn.DataTypeString();
                result = _plus_2 = String.valueOf(result) + _DataTypeString_1;
            }
            result = String.valueOf(result) + " &" + argIn.name;
            SeRoNetARGUMENT _last = (SeRoNetARGUMENT)IterableExtensions.last(method.inputArguments);
            boolean bl = _notEquals = !Objects.equal((Object)argIn, (Object)_last);
            if (!_notEquals) continue;
            result = String.valueOf(result) + ", ";
        }
        for (SeRoNetARGUMENT argOut : method.outputArguments) {
            SeRoNetARGUMENT _head;
            boolean _equals = Objects.equal((Object)argOut, (Object)(_head = (SeRoNetARGUMENT)IterableExtensions.head(method.outputArguments)));
            if (_equals) {
                boolean _not;
                boolean _isEmpty = method.inputArguments.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    result = String.valueOf(result) + ", ";
                }
            } else {
                result = String.valueOf(result) + ", ";
            }
            if (argOut.ValueRank == 1) {
                String _plus_1;
                String _DataTypeString = argOut.DataTypeString();
                String _plus = String.valueOf(result) + "std::vector<" + _DataTypeString;
                result = _plus_1 = String.valueOf(_plus) + ">";
            } else {
                String _plus_2;
                String _DataTypeString_1 = argOut.DataTypeString();
                result = _plus_2 = String.valueOf(result) + _DataTypeString_1;
            }
            result = String.valueOf(result) + " &" + argOut.name;
        }
        return result;
    }

    public String getCppMethodArgumentsCall(SeRoNetMETHOD method) {
        String result = "";
        for (SeRoNetARGUMENT argIn : method.inputArguments) {
            boolean _notEquals;
            result = String.valueOf(result) + argIn.name;
            SeRoNetARGUMENT _last = (SeRoNetARGUMENT)IterableExtensions.last(method.inputArguments);
            boolean bl = _notEquals = !Objects.equal((Object)argIn, (Object)_last);
            if (!_notEquals) continue;
            result = String.valueOf(result) + ", ";
        }
        for (SeRoNetARGUMENT argOut : method.outputArguments) {
            SeRoNetARGUMENT _head;
            boolean _equals = Objects.equal((Object)argOut, (Object)(_head = (SeRoNetARGUMENT)IterableExtensions.head(method.outputArguments)));
            if (_equals) {
                boolean _not;
                boolean _isEmpty = method.inputArguments.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    result = String.valueOf(result) + ", ";
                }
            } else {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + argOut.name;
        }
        return result;
    }

    public static class SeRoNetARGUMENT {
        public String name;
        public int DataTypeIdentifier;
        public static int UA_TYPES_BOOLEAN = 1;
        public static int UA_TYPES_INT32 = 6;
        public static int UA_TYPES_DOUBLE = 11;
        public static int UA_TYPES_STRING = 12;
        public int ValueRank;
        public int ArrayDimensions;
        public SeRoNetNodeId nodeid;
        public SeRoNetNodeId Parent_nodeid;

        public String UADataTypeIdentifierString() {
            String _switchResult = null;
            int DataTypeIdentifier = this.DataTypeIdentifier;
            switch (DataTypeIdentifier) {
                case 1: {
                    _switchResult = "UA_Boolean";
                    break;
                }
                case 6: {
                    _switchResult = "UA_Int32";
                    break;
                }
                case 11: {
                    _switchResult = "UA_Double";
                    break;
                }
                case 12: {
                    _switchResult = "UA_String";
                }
            }
            return _switchResult;
        }

        public String UADataTypeDefaultValues() {
            String _switchResult = null;
            int DataTypeIdentifier = this.DataTypeIdentifier;
            switch (DataTypeIdentifier) {
                case 1: {
                    _switchResult = "false";
                    break;
                }
                case 6: {
                    _switchResult = "0";
                    break;
                }
                case 11: {
                    _switchResult = "0.0";
                    break;
                }
                case 12: {
                    _switchResult = "std::string()";
                }
            }
            return _switchResult;
        }

        public String DataTypeIdentifierString() {
            String _switchResult = null;
            int DataTypeIdentifier = this.DataTypeIdentifier;
            switch (DataTypeIdentifier) {
                case 1: {
                    _switchResult = "UA_TYPES_BOOLEAN";
                    break;
                }
                case 6: {
                    _switchResult = "UA_TYPES_INT32";
                    break;
                }
                case 11: {
                    _switchResult = "UA_TYPES_DOUBLE";
                    break;
                }
                case 12: {
                    _switchResult = "UA_TYPES_STRING";
                }
            }
            return _switchResult;
        }

        public String DataTypeString() {
            String _switchResult = null;
            int DataTypeIdentifier = this.DataTypeIdentifier;
            switch (DataTypeIdentifier) {
                case 1: {
                    _switchResult = "bool";
                    break;
                }
                case 6: {
                    _switchResult = "int";
                    break;
                }
                case 11: {
                    _switchResult = "double";
                    break;
                }
                case 12: {
                    _switchResult = "std::string";
                }
            }
            return _switchResult;
        }

        public String Display() {
            String _DataTypeString = this.DataTypeString();
            String _plus = "(" + Integer.valueOf(this.Parent_nodeid.ns) + ", " + Integer.valueOf(this.Parent_nodeid.i) + ")-->(" + Integer.valueOf(this.nodeid.ns) + ", " + Integer.valueOf(this.nodeid.i) + ") ARGUMENT: " + _DataTypeString;
            String _plus_1 = String.valueOf(_plus) + " ";
            String _plus_2 = String.valueOf(_plus_1) + this.name;
            String _plus_3 = String.valueOf(_plus_2) + " DataTypeIdentifier:";
            String _plus_4 = String.valueOf(_plus_3) + Integer.valueOf(this.DataTypeIdentifier);
            String _plus_5 = String.valueOf(_plus_4) + " ValueRank:";
            String _plus_6 = String.valueOf(_plus_5) + Integer.valueOf(this.ValueRank);
            String _plus_7 = String.valueOf(_plus_6) + " ArrayDimensions:";
            String _plus_8 = String.valueOf(_plus_7) + Integer.valueOf(this.ArrayDimensions);
            return (String)InputOutput.println((Object)_plus_8);
        }
    }

    public static class SeRoNetENTITY {
        public String name;
        public String commObjectCall;
        public String type;
        public int userAccessLevel;
        public SeRoNetNodeId nodeid;
        public SeRoNetNodeId Parent_nodeid;
        public Collection<SeRoNetNodeId> Children_nodeid = new ArrayList<SeRoNetNodeId>();
        public static int UA_ACCESSLEVELMASK_READ = 1;
        public static int UA_ACCESSLEVELMASK_WRITE = 2;
        public static int UA_ACCESSLEVELMASK_HISTORYREAD = 4;
        public static int UA_ACCESSLEVELMASK_HISTORYWRITE = 8;
        public static int UA_ACCESSLEVELMASK_SEMANTICCHANGE = 16;
        public static int UA_ACCESSLEVELMASK_STATUSWRITE = 32;
        public static int UA_ACCESSLEVELMASK_TIMESTAMPWRITE = 64;

        public String UAuserAccessLevel() {
            String _switchResult = null;
            int userAccessLevel = this.userAccessLevel;
            switch (userAccessLevel) {
                case 1: {
                    _switchResult = "UA_ACCESSLEVELMASK_READ";
                    break;
                }
                case 2: {
                    _switchResult = "UA_ACCESSLEVELMASK_WRITE";
                    break;
                }
                case 3: {
                    _switchResult = "UA_ACCESSLEVELMASK_READ | UA_ACCESSLEVELMASK_WRITE";
                }
            }
            return _switchResult;
        }

        public String UADataTypeIdentifierString() {
            String _switchResult;
            block16: {
                _switchResult = null;
                String type = this.type;
                if (type == null) break block16;
                switch (type) {
                    case "Boolean": {
                        _switchResult = "UA_Boolean";
                        break;
                    }
                    case "Int32": {
                        _switchResult = "UA_Int32";
                        break;
                    }
                    case "Double": {
                        _switchResult = "UA_Double";
                        break;
                    }
                    case "String": {
                        _switchResult = "UA_String";
                    }
                }
            }
            return _switchResult;
        }

        public String UADataTypeDefaultValues() {
            String _switchResult;
            block16: {
                _switchResult = null;
                String type = this.type;
                if (type == null) break block16;
                switch (type) {
                    case "Boolean": {
                        _switchResult = "false";
                        break;
                    }
                    case "Int32": {
                        _switchResult = "0";
                        break;
                    }
                    case "Double": {
                        _switchResult = "0.0";
                        break;
                    }
                    case "String": {
                        _switchResult = "UA_LOCALIZEDTEXT_ALLOC(\"NA\")";
                    }
                }
            }
            return _switchResult;
        }

        public String DataTypeIdentifierString() {
            String _switchResult;
            block16: {
                _switchResult = null;
                String type = this.type;
                if (type == null) break block16;
                switch (type) {
                    case "Boolean": {
                        _switchResult = "UA_TYPES_BOOLEAN";
                        break;
                    }
                    case "Int32": {
                        _switchResult = "UA_TYPES_INT32";
                        break;
                    }
                    case "Double": {
                        _switchResult = "UA_TYPES_DOUBLE";
                        break;
                    }
                    case "String": {
                        _switchResult = "UA_TYPES_STRING";
                    }
                }
            }
            return _switchResult;
        }

        public String DataTypeString() {
            String _switchResult;
            block16: {
                _switchResult = null;
                String type = this.type;
                if (type == null) break block16;
                switch (type) {
                    case "Boolean": {
                        _switchResult = "bool";
                        break;
                    }
                    case "Int32": {
                        _switchResult = "int";
                        break;
                    }
                    case "Double": {
                        _switchResult = "double";
                        break;
                    }
                    case "String": {
                        _switchResult = "std::string";
                    }
                }
            }
            return _switchResult;
        }

        public String Display() {
            String _xblockexpression = null;
            String _DataTypeString = this.DataTypeString();
            String _plus = "(" + Integer.valueOf(this.Parent_nodeid.ns) + ", " + Integer.valueOf(this.Parent_nodeid.i) + ")-->(" + Integer.valueOf(this.nodeid.ns) + ", " + Integer.valueOf(this.nodeid.i) + ") ENTITY:   Name:" + this.name + "  DataType:" + _DataTypeString;
            String _plus_1 = String.valueOf(_plus) + "  UserAccessLevel:";
            String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(this.userAccessLevel);
            String _plus_3 = String.valueOf(_plus_2) + "  Children_nodeids:||";
            InputOutput.print((Object)_plus_3);
            for (SeRoNetNodeId ch : this.Children_nodeid) {
                String _plus_4 = Integer.valueOf(ch.ns) + ", ";
                String _plus_5 = String.valueOf(_plus_4) + Integer.valueOf(ch.i);
                String _plus_6 = String.valueOf(_plus_5) + "||";
                InputOutput.print((Object)_plus_6);
            }
            _xblockexpression = (String)InputOutput.println((Object)"");
            return _xblockexpression;
        }
    }

    public static class SeRoNetMETHOD {
        public String name;
        public SeRoNetNodeId nodeid;
        public SeRoNetNodeId Parent_nodeid;
        public Collection<SeRoNetNodeId> Children_nodeid = new ArrayList<SeRoNetNodeId>();
        public Collection<SeRoNetARGUMENT> inputArguments = new ArrayList<SeRoNetARGUMENT>();
        public Collection<SeRoNetARGUMENT> outputArguments = new ArrayList<SeRoNetARGUMENT>();

        public String DisplaySmall() {
            String _xblockexpression = null;
            InputOutput.print((Object)("(" + Integer.valueOf(this.Parent_nodeid.ns) + ", " + Integer.valueOf(this.Parent_nodeid.i) + ")-->(" + Integer.valueOf(this.nodeid.ns) + ", " + Integer.valueOf(this.nodeid.i) + ") METHOD: ["));
            for (SeRoNetARGUMENT elem : this.inputArguments) {
                String _DataTypeString = elem.DataTypeString();
                String _plus = "   " + _DataTypeString;
                String _plus_1 = String.valueOf(_plus) + " ";
                String _plus_2 = String.valueOf(_plus_1) + elem.name;
                InputOutput.print((Object)_plus_2);
            }
            InputOutput.print((Object)("    ] = " + this.name + " ("));
            for (SeRoNetARGUMENT elem_1 : this.outputArguments) {
                String _DataTypeString_1 = elem_1.DataTypeString();
                String _plus_3 = "   " + _DataTypeString_1;
                String _plus_4 = String.valueOf(_plus_3) + " ";
                String _plus_5 = String.valueOf(_plus_4) + elem_1.name;
                InputOutput.print((Object)_plus_5);
            }
            InputOutput.print((Object)"    )");
            _xblockexpression = (String)InputOutput.println((Object)(" NodeId:" + Integer.valueOf(this.nodeid.ns) + ", " + Integer.valueOf(this.nodeid.i) + "  Parent_NodeId:" + Integer.valueOf(this.Parent_nodeid.ns) + ", " + Integer.valueOf(this.Parent_nodeid.i)));
            return _xblockexpression;
        }

        public void Display() {
            InputOutput.print((Object)("(" + Integer.valueOf(this.Parent_nodeid.ns) + ", " + Integer.valueOf(this.Parent_nodeid.i) + ")-->(" + Integer.valueOf(this.nodeid.ns) + ", " + Integer.valueOf(this.nodeid.i) + ") METHOD: ["));
            for (SeRoNetARGUMENT elem : this.outputArguments) {
                String _DataTypeString = elem.DataTypeString();
                String _plus = "   " + _DataTypeString;
                String _plus_1 = String.valueOf(_plus) + " ";
                String _plus_2 = String.valueOf(_plus_1) + elem.name;
                InputOutput.print((Object)_plus_2);
            }
            InputOutput.print((Object)("    ] = " + this.name + " ("));
            for (SeRoNetARGUMENT elem_1 : this.inputArguments) {
                String _DataTypeString_1 = elem_1.DataTypeString();
                String _plus_3 = "   " + _DataTypeString_1;
                String _plus_4 = String.valueOf(_plus_3) + " ";
                String _plus_5 = String.valueOf(_plus_4) + elem_1.name;
                InputOutput.print((Object)_plus_5);
            }
            InputOutput.print((Object)"    )  -->  Children_nodeids:||");
            for (SeRoNetNodeId ch : this.Children_nodeid) {
                String _plus_6 = Integer.valueOf(ch.ns) + ", ";
                String _plus_7 = String.valueOf(_plus_6) + Integer.valueOf(ch.i);
                String _plus_8 = String.valueOf(_plus_7) + "||";
                InputOutput.print((Object)_plus_8);
            }
            InputOutput.println((Object)"");
            for (SeRoNetARGUMENT elem_2 : this.inputArguments) {
                InputOutput.print((Object)"        IN--");
                elem_2.Display();
            }
            for (SeRoNetARGUMENT elem_3 : this.outputArguments) {
                InputOutput.print((Object)"       OUT--");
                elem_3.Display();
            }
        }
    }

    public static class SeRoNetNodeId {
        public int ns = 1001;
        public int i = 1;
    }
}

