/**
 * Copyright (c) 2013 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.ExtendedOutputConfigurationProvider;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class SmartEventHandler {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private ComponentGenHelpers _componentGenHelpers;
  
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  public String EventTestHandlerCoreHeaderFileName(final ComponentPort service) {
    String _nameClass = this._componentGenHelpers.nameClass(service);
    return (_nameClass + "EventTestHandlerCore.hh");
  }
  
  public String EventTestHandlerUserHeaderFileName(final ComponentPort service) {
    String _nameClass = this._componentGenHelpers.nameClass(service);
    return (_nameClass + "EventTestHandler.hh");
  }
  
  public String EventTestHandlerUserSourceFileName(final ComponentPort service) {
    String _nameClass = this._componentGenHelpers.nameClass(service);
    return (_nameClass + "EventTestHandler.cc");
  }
  
  public void CreateEventTestHandlers(final ComponentDefinition comp, final IFileSystemAccess fsa) {
    final Function1<OutputPort, Boolean> _function = (OutputPort it) -> {
      return Boolean.valueOf(this._componentGenHelpers.isEventServer(it));
    };
    Iterable<OutputPort> _filter = IterableExtensions.<OutputPort>filter(Iterables.<OutputPort>filter(comp.getElements(), OutputPort.class), _function);
    for (final OutputPort eventServer : _filter) {
      {
        fsa.generateFile(this.EventTestHandlerCoreHeaderFileName(eventServer), this.HandlerHeaderFileContent(eventServer));
        fsa.generateFile(this.EventTestHandlerUserHeaderFileName(eventServer), ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.HandlerUserHeaderFileContent(eventServer));
        fsa.generateFile(this.EventTestHandlerUserSourceFileName(eventServer), ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.HandlerUserSourceFileContent(eventServer));
      }
    }
  }
  
  public CharSequence HandlerHeaderFileContent(final OutputPort service) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = service.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_EVENT_TEST_HANDLER_CORE_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = service.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_EVENT_TEST_HANDLER_CORE_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.newLine();
    {
      final Function1<CommunicationObject, String> _function = (CommunicationObject it) -> {
        return it.getName();
      };
      List<CommunicationObject> _sortBy = IterableExtensions.<CommunicationObject, String>sortBy(ComponentDefinitionModelUtility.getAllCommObjects(service), _function);
      for(final CommunicationObject obj : _sortBy) {
        _builder.append("#include <");
        CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(obj);
        _builder.append(_userClassHeaderFileNameFQN);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("class ");
    String _nameClass = this._componentGenHelpers.nameClass(service);
    _builder.append(_nameClass);
    _builder.append("EventTestHandlerCore : public SmartACE::EventTestHandler<");
    CharSequence _commObjectCppList = this._componentGenHelpers.getCommObjectCppList(service, Boolean.valueOf(true));
    _builder.append(_commObjectCppList);
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence HandlerUserHeaderFileContent(final OutputPort service) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = service.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_EVENT_TEST_HANDLER_USER_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = service.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_EVENT_TEST_HANDLER_USER_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("#include \"");
    String _EventTestHandlerCoreHeaderFileName = this.EventTestHandlerCoreHeaderFileName(service);
    _builder.append(_EventTestHandlerCoreHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("class ");
    String _nameClass = this._componentGenHelpers.nameClass(service);
    _builder.append(_nameClass);
    _builder.append("EventTestHandler : public ");
    String _nameClass_1 = this._componentGenHelpers.nameClass(service);
    _builder.append(_nameClass_1);
    _builder.append("EventTestHandlerCore");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual bool testEvent(");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects(service).get("Activation"));
    _builder.append(_fullyQualifiedNameCpp, "\t\t");
    _builder.append(" &p,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects(service).get("Event"));
    _builder.append(_fullyQualifiedNameCpp_1, "\t\t");
    _builder.append(" &r,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("const ");
    CharSequence _fullyQualifiedNameCpp_2 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects(service).get("EventState"));
    _builder.append(_fullyQualifiedNameCpp_2, "\t\t");
    _builder.append(" &s");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(") throw();");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence HandlerUserSourceFileContent(final OutputPort service) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _EventTestHandlerUserHeaderFileName = this.EventTestHandlerUserHeaderFileName(service);
    _builder.append(_EventTestHandlerUserHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("bool ");
    String _nameClass = this._componentGenHelpers.nameClass(service);
    _builder.append(_nameClass);
    _builder.append("EventTestHandler::testEvent(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects(service).get("Activation"));
    _builder.append(_fullyQualifiedNameCpp, "\t");
    _builder.append(" &p,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects(service).get("Event"));
    _builder.append(_fullyQualifiedNameCpp_1, "\t");
    _builder.append(" &r,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("const ");
    CharSequence _fullyQualifiedNameCpp_2 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects(service).get("EventState"));
    _builder.append(_fullyQualifiedNameCpp_2, "\t");
    _builder.append(" &s");
    _builder.newLineIfNotEmpty();
    _builder.append(") throw() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// fire all events (without filtering) in the default implementation");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// implement your own (specific) event-filtering code using the event-parameter as input");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// true means that the current event will be fired to the according client");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// false means that the current event is ignored (it will not be communicated to the according client)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
