/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtext.behavior.taskRealization.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.behavior.taskRealization.AbstractCoordinationModuleInstance;
import org.eclipse.smartmdsd.ecore.behavior.taskRealization.TaskRealization;
import org.eclipse.smartmdsd.ecore.behavior.taskRealization.TaskRealizationModel;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class TaskRealizationFormatter extends AbstractFormatter2 {
  protected void _format(final TaskRealizationModel taskRealizationModel, @Extension final IFormattableDocument document) {
    EList<AbstractCoordinationModuleInstance> _abstCoordInst = taskRealizationModel.getAbstCoordInst();
    for (final AbstractCoordinationModuleInstance abstractCoordinationModuleInstance : _abstCoordInst) {
      document.<AbstractCoordinationModuleInstance>format(abstractCoordinationModuleInstance);
    }
    EList<TaskRealization> _tasks = taskRealizationModel.getTasks();
    for (final TaskRealization taskRealization : _tasks) {
      document.<TaskRealization>format(taskRealization);
    }
  }
  
  public void format(final Object taskRealizationModel, final IFormattableDocument document) {
    if (taskRealizationModel instanceof XtextResource) {
      _format((XtextResource)taskRealizationModel, document);
      return;
    } else if (taskRealizationModel instanceof TaskRealizationModel) {
      _format((TaskRealizationModel)taskRealizationModel, document);
      return;
    } else if (taskRealizationModel instanceof EObject) {
      _format((EObject)taskRealizationModel, document);
      return;
    } else if (taskRealizationModel == null) {
      _format((Void)null, document);
      return;
    } else if (taskRealizationModel != null) {
      _format(taskRealizationModel, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(taskRealizationModel, document).toString());
    }
  }
}
