/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.deployment.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.deployment.AbstractDeploymentElement;
import org.eclipse.smartmdsd.ecore.system.deployment.ComponentArtefact;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentModel;
import org.eclipse.smartmdsd.ecore.system.deployment.LoginAccountSelection;
import org.eclipse.smartmdsd.ecore.system.deployment.NamingService;
import org.eclipse.smartmdsd.ecore.system.deployment.NetworkInterfaceSelection;
import org.eclipse.smartmdsd.ecore.system.deployment.TargetPlatformReference;
import org.eclipse.smartmdsd.ecore.system.deployment.UploadDirectory;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class DeploymentFormatter extends AbstractFormatter2 {
  protected void _format(final DeploymentModel deploymentModel, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(deploymentModel).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(deploymentModel).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    EList<AbstractDeploymentElement> _elements = deploymentModel.getElements();
    for (final AbstractDeploymentElement abstractDeploymentElement : _elements) {
      document.<AbstractDeploymentElement>format(abstractDeploymentElement);
    }
  }
  
  protected void _format(final ComponentArtefact componentArtefact, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, 2);
    };
    document.<ComponentArtefact>append(componentArtefact, _function);
  }
  
  protected void _format(final NamingService ns, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(ns).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(ns).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, 2);
    };
    document.<NamingService>append(ns, _function_3);
  }
  
  protected void _format(final TargetPlatformReference cpr, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(cpr).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(cpr).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, 2);
    };
    document.<TargetPlatformReference>append(cpr, _function_3);
    LoginAccountSelection _login = cpr.getLogin();
    if (_login!=null) {
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(1, 1, 2);
      };
      document.<LoginAccountSelection>append(_login, _function_4);
    }
    NetworkInterfaceSelection _host = cpr.getHost();
    if (_host!=null) {
      final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(1, 1, 2);
      };
      document.<NetworkInterfaceSelection>append(_host, _function_5);
    }
    UploadDirectory _directory = cpr.getDirectory();
    if (_directory!=null) {
      final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(1, 1, 2);
      };
      document.<UploadDirectory>append(_directory, _function_6);
    }
  }
  
  public void format(final Object componentArtefact, final IFormattableDocument document) {
    if (componentArtefact instanceof XtextResource) {
      _format((XtextResource)componentArtefact, document);
      return;
    } else if (componentArtefact instanceof ComponentArtefact) {
      _format((ComponentArtefact)componentArtefact, document);
      return;
    } else if (componentArtefact instanceof NamingService) {
      _format((NamingService)componentArtefact, document);
      return;
    } else if (componentArtefact instanceof TargetPlatformReference) {
      _format((TargetPlatformReference)componentArtefact, document);
      return;
    } else if (componentArtefact instanceof DeploymentModel) {
      _format((DeploymentModel)componentArtefact, document);
      return;
    } else if (componentArtefact instanceof EObject) {
      _format((EObject)componentArtefact, document);
      return;
    } else if (componentArtefact == null) {
      _format((Void)null, document);
      return;
    } else if (componentArtefact != null) {
      _format(componentArtefact, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(componentArtefact, document).toString());
    }
  }
}
