/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.base.basicAttributes;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class BasicAttributesStyledLabelProvider {
  public String getValueString(final AbstractValue av) {
    String _switchResult = null;
    boolean _matched = false;
    if (av instanceof IntValue) {
      _matched=true;
      _switchResult = Integer.valueOf(((IntValue)av).getValue()).toString();
    }
    if (!_matched) {
      if (av instanceof FloatingPointValue) {
        _matched=true;
        _switchResult = Double.valueOf(((FloatingPointValue)av).getValue()).toString();
      }
    }
    if (!_matched) {
      if (av instanceof StringValue) {
        _matched=true;
        _switchResult = ((StringValue)av).getValue();
      }
    }
    if (!_matched) {
      if (av instanceof BoolValue) {
        _matched=true;
        _switchResult = Boolean.valueOf(((BoolValue)av).isValue()).toString();
      }
    }
    if (!_matched) {
      if (av instanceof EnumerationValue) {
        _matched=true;
        _switchResult = ((EnumerationValue)av).getValue().getName();
      }
    }
    if (!_matched) {
      if (av instanceof ArrayValue) {
        _matched=true;
        EList<SingleValue> _values = ((ArrayValue)av).getValues();
        List<String> _map = null;
        if (_values!=null) {
          final Function1<SingleValue, String> _function = (SingleValue it) -> {
            return this.getValueString(it);
          };
          _map=ListExtensions.<SingleValue, String>map(_values, _function);
        }
        String _join = IterableExtensions.join(_map, ", ");
        String _plus = ("[" + _join);
        _switchResult = (_plus + "]");
      }
    }
    return _switchResult;
  }
  
  public String getTypeName(final AbstractAttributeType attrType) {
    String _switchResult = null;
    boolean _matched = false;
    if (attrType instanceof PrimitiveType) {
      _matched=true;
      _switchResult = ((PrimitiveType)attrType).getTypeName().getLiteral();
    }
    if (!_matched) {
      if (attrType instanceof InlineEnumerationType) {
        _matched=true;
        _switchResult = "InlineEnumeration";
      }
    }
    return _switchResult;
  }
  
  public StyledString getEnumerationElementStyledString(final EnumerationElement en) {
    String _name = en.getName();
    final StyledString text = new StyledString(_name, StyledString.QUALIFIER_STYLER);
    int _value = en.getValue();
    boolean _notEquals = (_value != 0);
    if (_notEquals) {
      String _string = Integer.valueOf(en.getValue()).toString();
      String _plus = (" = " + _string);
      StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
      text.append(_styledString);
    }
    return text;
  }
  
  public StyledString getAttributeStyledString(final AttributeDefinition attr) {
    String _name = attr.getName();
    StyledString text = new StyledString(_name, StyledString.QUALIFIER_STYLER);
    AbstractAttributeType _type = attr.getType();
    boolean _tripleNotEquals = (_type != null);
    if (_tripleNotEquals) {
      String _typeName = this.getTypeName(attr.getType());
      String _plus = (": " + _typeName);
      final StyledString typeString = new StyledString(_plus, 
        StyledString.DECORATIONS_STYLER);
      text.append(typeString);
      ArrayType _array = attr.getType().getArray();
      boolean _tripleNotEquals_1 = (_array != null);
      if (_tripleNotEquals_1) {
        String arrayString = " [";
        String _length = attr.getType().getArray().getLength();
        boolean _tripleNotEquals_2 = (_length != null);
        if (_tripleNotEquals_2) {
          String _length_1 = attr.getType().getArray().getLength();
          String _plus_1 = (arrayString + _length_1);
          arrayString = _plus_1;
        }
        arrayString = (arrayString + "]");
        StyledString _styledString = new StyledString(arrayString, StyledString.DECORATIONS_STYLER);
        text.append(_styledString);
      }
    }
    AbstractValue _defaultvalue = attr.getDefaultvalue();
    boolean _tripleNotEquals_3 = (_defaultvalue != null);
    if (_tripleNotEquals_3) {
      String _valueString = this.getValueString(attr.getDefaultvalue());
      String _plus_2 = (" = " + _valueString);
      final StyledString attrValueString = new StyledString(_plus_2, 
        StyledString.QUALIFIER_STYLER);
      text.append(attrValueString);
    }
    return text;
  }
}
