/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.service.communicationObject;

import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesStyledLabelProvider;

@SuppressWarnings("all")
public class CommunicationObjectStyledLabelProvider extends BasicAttributesStyledLabelProvider {
  @Override
  public String getValueString(final AbstractValue av) {
    String _xifexpression = null;
    if ((av instanceof CommElementValue)) {
      return ((CommElementValue)av).getValue().getName();
    } else {
      _xifexpression = super.getValueString(av);
    }
    return _xifexpression;
  }
  
  @Override
  public String getTypeName(final AbstractAttributeType attrType) {
    String _xifexpression = null;
    if ((attrType instanceof CommElementReference)) {
      return ((CommElementReference)attrType).getTypeName().getName();
    } else {
      _xifexpression = super.getTypeName(attrType);
    }
    return _xifexpression;
  }
}
