/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.codegen;

import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.smartmdsd.ui.factories.JavaProjectFactory;
import org.eclipse.smartmdsd.ui.models.SmartMDSDModelingLanguage;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureHelpers;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.osgi.framework.Bundle;

public class ManualCodeGeneratorWorspaceOperation
extends WorkspaceModifyOperation {
    private IResource resource;
    private MessageConsole messageConsole;
    public static final String CONSOLE_NAME = "SmarMDSD Code-Generator";

    public ManualCodeGeneratorWorspaceOperation(IResource resource) {
        this.resource = resource;
        this.messageConsole = this.findCodeGeneratorConsole();
    }

    private MessageConsole findCodeGeneratorConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        IConsole[] existing = consoleManager.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (existing[i].getName().equals(CONSOLE_NAME)) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.smartmdsd.ui");
        ImageDescriptor codeGeneratorIcon = ImageDescriptor.createFromURL((URL)bundle.getEntry("icons/manual-gear.png"));
        MessageConsole codeGeneratorConsole = new MessageConsole(CONSOLE_NAME, codeGeneratorIcon);
        consoleManager.addConsoles(new IConsole[]{codeGeneratorConsole});
        return codeGeneratorConsole;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        AbstractSmartMDSDNature smartMDSDnature = SmartMDSDNatureHelpers.getFirstSmartMDSDNatureFrom(this.resource.getProject());
        if (smartMDSDnature == null) {
            return;
        }
        this.messageConsole.clearConsole();
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.messageConsole);
        MessageConsoleStream out = this.messageConsole.newMessageStream();
        out.println("Run SmartMDSD code generator for: " + this.resource.getName());
        List<IResource> modelFiles = JavaProjectFactory.getContainingJavaSources(this.resource);
        int numberModels = modelFiles.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(numberModels * 10));
        for (IResource modelResource : modelFiles) {
            if (monitor.isCanceled()) {
                out.print("code genearion cancelled!");
                return;
            }
            subMonitor.split(10);
            SmartMDSDModelingLanguage language = smartMDSDnature.getLanguageFrom(modelResource);
            if (language == null) continue;
            Injector injector = language.getInjector();
            XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
            String modelUriString = "platform:/resource/" + this.resource.getProject().getName() + "/" + modelResource.getProjectRelativePath();
            out.println("Load model: " + modelResource.getName());
            Resource resource = resourceSet.getResource(URI.createURI((String)modelUriString), true);
            if (!resource.isLoaded()) continue;
            IResourceValidator validator = (IResourceValidator)injector.getInstance(IResourceValidator.class);
            boolean hasErrors = false;
            List issues = validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
            for (Issue issue : issues) {
                if (issue.getSeverity() == Severity.ERROR) {
                    hasErrors = true;
                    out.println("ERROR: " + issue.getMessage());
                    continue;
                }
                if (issue.getSeverity() != Severity.WARNING) continue;
                out.println("WARNING: " + issue.getMessage());
            }
            if (monitor.isCanceled()) {
                out.print("code genearion cancelled!");
                return;
            }
            if (hasErrors) {
                out.println("code generation skipped due to errors.");
                continue;
            }
            GeneratorDelegate generator = (GeneratorDelegate)injector.getInstance(GeneratorDelegate.class);
            JavaIoFileSystemAccess fsa = (JavaIoFileSystemAccess)injector.getInstance(JavaIoFileSystemAccess.class);
            out.println("Run code generator...");
            generator.doGenerate(resource, (IFileSystemAccess)fsa);
            out.println("done!");
        }
    }
}

