/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.serviceDefinition.scoping;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.CoordinationPatternPackage;
import org.eclipse.smartmdsd.xtext.base.stateMachine.StateMachineDefaultLifecycleLib;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ParameterDefinitionDefaultLib;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class ServiceDefinitionScopeProvider extends AbstractServiceDefinitionScopeProvider {
  @Inject
  private ServiceDefinitionGlobalScopeProvider gsp;
  
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    EReference _parameterPattern_ParameterSet = CoordinationPatternPackage.eINSTANCE.getParameterPattern_ParameterSet();
    boolean _equals = Objects.equal(reference, _parameterPattern_ParameterSet);
    if (_equals) {
      final IScope result = this.gsp.getScope(context.eResource(), reference);
      final Iterable<IEObjectDescription> elements = result.getElements(ParameterDefinitionDefaultLib.DEFAULT_PARAMETR_SET_QNAME);
      final IScope globalScope = super.getScope(context, reference);
      final Function1<IEObjectDescription, EObject> _function = (IEObjectDescription it) -> {
        return it.getEObjectOrProxy();
      };
      return Scopes.scopeFor(IterableExtensions.<IEObjectDescription, EObject>map(elements, _function), globalScope);
    } else {
      EReference _statePattern_Lifecycle = CoordinationPatternPackage.eINSTANCE.getStatePattern_Lifecycle();
      boolean _equals_1 = Objects.equal(reference, _statePattern_Lifecycle);
      if (_equals_1) {
        final IScope result_1 = this.gsp.getScope(context.eResource(), reference);
        final Iterable<IEObjectDescription> elements_1 = result_1.getElements(StateMachineDefaultLifecycleLib.COMPONENT_LIFECYCLE_QNAME);
        final IScope globalScope_1 = super.getScope(context, reference);
        final Function1<IEObjectDescription, EObject> _function_1 = (IEObjectDescription it) -> {
          return it.getEObjectOrProxy();
        };
        return Scopes.scopeFor(IterableExtensions.<IEObjectDescription, EObject>map(elements_1, _function_1), globalScope_1);
      }
    }
    return super.getScope(context, reference);
  }
}
