/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.system.deployment.design;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitecturePackage;
import org.eclipse.smartmdsd.ecore.system.deployment.TargetPlatformReference;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.LoginAccount;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.NetworkInterface;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformPackage;
import org.eclipse.smartmdsd.sirius.utils.DiagramHelperServices;
import org.eclipse.smartmdsd.xtext.system.componentArchitecture.ui.internal.ComponentArchitectureActivator;
import org.eclipse.smartmdsd.xtext.system.targetPlatform.ui.internal.TargetPlatformActivator;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public class Services {
    public String getProjectName(EObject obj) {
        return DiagramHelperServices.getProjectName((EObject)obj);
    }

    public Collection<EObject> getLoginAccounts(EObject context) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        EObject parent = context.eContainer();
        if (parent instanceof TargetPlatformReference) {
            TargetPlatformReference target = (TargetPlatformReference)parent;
            for (EObject obj : target.getPlatform().getElements()) {
                if (!(obj instanceof LoginAccount)) continue;
                objects.add(obj);
            }
        }
        return objects;
    }

    public Collection<EObject> getNetworkInterfaces(EObject context) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        EObject parent = context.eContainer();
        if (parent instanceof TargetPlatformReference) {
            TargetPlatformReference target = (TargetPlatformReference)parent;
            for (EObject obj : target.getPlatform().getElements()) {
                if (!(obj instanceof NetworkInterface)) continue;
                objects.add(obj);
            }
        }
        return objects;
    }

    public Iterable<EObject> getAllComponentInstances(EObject context) {
        Injector injector = this.getComponentArchitectureInjector();
        return this.geXtextIndexEObjetcsByType(injector, context, ComponentArchitecturePackage.eINSTANCE.getComponentInstance());
    }

    public Iterable<EObject> getAllComputationPlatforms(EObject context) {
        Injector injector = this.getTargetPlatformInjector();
        return this.geXtextIndexEObjetcsByType(injector, context, TargetPlatformPackage.eINSTANCE.getTargetPlatformDefinition());
    }

    private Injector getTargetPlatformInjector() {
        return TargetPlatformActivator.getInstance().getInjector("org.eclipse.smartmdsd.xtext.system.targetPlatform.TargetPlatform");
    }

    private Injector getComponentArchitectureInjector() {
        return ComponentArchitectureActivator.getInstance().getInjector("org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture");
    }

    private Collection<EObject> geXtextIndexEObjetcsByType(Injector injector, EObject context, EClass type) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        ResourceDescriptionsProvider rdp = (ResourceDescriptionsProvider)injector.getInstance(ResourceDescriptionsProvider.class);
        IResourceDescriptions descriptions = rdp.getResourceDescriptions(context.eResource());
        IResourceDescription description = descriptions.getResourceDescription(context.eResource().getURI());
        IContainer.Manager manager = (IContainer.Manager)injector.getInstance(IContainer.Manager.class);
        List containters = manager.getVisibleContainers(description, descriptions);
        for (IContainer container : containters) {
            Iterable objectDescriptions = container.getExportedObjectsByType(type);
            for (IEObjectDescription objectDescription : objectDescriptions) {
                EObject serviceRepoProxy = objectDescription.getEObjectOrProxy();
                if (serviceRepoProxy.eIsProxy()) {
                    EObject serviceRepo = context.eResource().getResourceSet().getEObject(objectDescription.getEObjectURI(), true);
                    objects.add(serviceRepo);
                    continue;
                }
                objects.add(serviceRepoProxy);
            }
        }
        return objects;
    }
}

