/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class OpcUaHtmlViewImpl implements OpcUaHtmlView {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Override
  public String getOpcUaDeviceServerVisualFileName() {
    return "../html-view/Visual.html";
  }
  
  @Override
  public String getOpcUaDevice_HtmlView_HeaderFileName(final String objectName) {
    return (objectName + "HtmlView.hh");
  }
  
  @Override
  public String getOpcUaDevice_HtmlView_SourceFileName(final String objectName) {
    return (objectName + "HtmlView.cc");
  }
  
  @Override
  public CharSequence compileOpcUaDevice_HtmlView_HeaderFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = objectName.toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_HTML_VIEW_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = objectName.toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_HTML_VIEW_HH\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"Pixtend2Observer.h\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("namespace Smart {");
    _builder.newLine();
    _builder.append("class ");
    _builder.append(objectName);
    _builder.append("HtmlView : public Pixtend2Observer");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("private:");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity : entityList) {
        _builder.append("\t");
        _builder.append("unsigned short PIN_");
        _builder.append(entity.name, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// constructor requires a Pixtend2DriverModel");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(objectName, "\t");
    _builder.append("HtmlView(Pixtend2DriverModel *model);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~");
    _builder.append(objectName, "\t");
    _builder.append("HtmlView();");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// PIN number setters");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity_1 : entityList) {
        _builder.append("\t");
        _builder.append("void setPIN_");
        _builder.append(entity_1.name, "\t");
        _builder.append(" (unsigned short p) { PIN_");
        _builder.append(entity_1.name, "\t");
        _builder.append(" = p; }");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("/// PIN NUMBER getters");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity_2 : entityList) {
        _builder.append("\t");
        _builder.append("unsigned short getPIN_");
        _builder.append(entity_2.name, "\t");
        _builder.append(" () {return PIN_");
        _builder.append(entity_2.name, "\t");
        _builder.append("; }");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// implements Pixtend2Observer");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void update();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// returns a pinter to the internally used model");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("inline Pixtend2DriverModel* getModel() const {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return model;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} /* namespace Smart */");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif /* _");
    String _upperCase_2 = objectName.toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("_HTML_VIEW_HH */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Override
  public CharSequence compileOpcUaDevice_HtmlView_SourceFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _opcUaDevice_HtmlView_HeaderFileName = this.getOpcUaDevice_HtmlView_HeaderFileName(objectName);
    _builder.append(_opcUaDevice_HtmlView_HeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.append("#include <fstream>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("namespace Smart {");
    _builder.newLine();
    _builder.append("// Default PIN Setting");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity : entityList) {
        _builder.append("unsigned short DEFAULT_PIN_");
        _builder.append(entity.name);
        _builder.append(" = 0; //Fill Actual");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(objectName);
    _builder.append("HtmlView::");
    _builder.append(objectName);
    _builder.append("HtmlView(Pixtend2DriverModel *model)");
    _builder.newLineIfNotEmpty();
    _builder.append(":\tPixtend2Observer(model)");
    _builder.newLine();
    _builder.append("{  ");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity_1 : entityList) {
        _builder.append("\t");
        _builder.append("PIN_");
        _builder.append(entity_1.name, "\t");
        _builder.append(" = DEFAULT_PIN_");
        _builder.append(entity_1.name, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append(objectName);
    _builder.append("HtmlView::~");
    _builder.append(objectName);
    _builder.append("HtmlView()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    _builder.append(objectName);
    _builder.append("HtmlView::update()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout<<\"");
    _builder.append(objectName, "\t");
    _builder.append("HtmlView Update \" << std::endl;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::cout<<\"DO \" << (int)model->getDigitalOutput()<<\"  RO \" << (int)model->getRelayOutput() <<\"  DI \" << (int)model->getDigitalInput()<< std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::ofstream html_file(\"../Visual/Visual.html\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(html_file.is_open())");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"<!DOCTYPE html>\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"<html>\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"<head>\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"<meta http-equiv=refresh content=1 />\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"</head>\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"<body>\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"<div align=center>\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"<B>");
    String _upperCase = objectName.toUpperCase();
    _builder.append(_upperCase, "\t\t");
    _builder.append("_SERVER</B><BR>\"<< std::endl;");
    _builder.newLineIfNotEmpty();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity_2 : entityList) {
        _builder.append("\t\t");
        _builder.append("html_file << \"");
        _builder.append(entity_2.name, "\t\t");
        _builder.append(" : \" << model->getDigitalInput(getPIN_");
        _builder.append(entity_2.name, "\t\t");
        _builder.append("()) << \"<BR>\" << std::endl;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("html_file <<\"<BR>  DO \" << (int)model->getDigitalOutput()<< std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file <<\"<BR>  RO \" << (int)model->getRelayOutput()<< std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file <<\"<BR>  DI \" << (int)model->getDigitalInput()<<\"<BR>\" << std::endl;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"</div>\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"</body>\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file << \"</html>\" << std::endl;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("html_file.close();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} /* namespace Smart */");
    _builder.newLine();
    return _builder;
  }
}
