/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaDeviceClient;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaReadServer;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaComponentExtension;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaDeviceClient;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaStatusServer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class PlainOpcUaGenerator2Impl
extends AbstractGenerator {
    @Inject
    @Extension
    private PlainOpcUaDeviceClient _plainOpcUaDeviceClient;
    @Inject
    @Extension
    private PlainOpcUaStatusServer _plainOpcUaStatusServer;
    @Inject
    @Extension
    private PlainOpcUaComponentExtension _plainOpcUaComponentExtension;

    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)input.getAllContents()), ComponentDefinition.class);
        for (ComponentDefinition comp : _filter) {
            fsa.generateFile(this._plainOpcUaComponentExtension.getPlainOpcUaExtensionHeaderFilename(comp), this._plainOpcUaComponentExtension.compilePlainOpcUaExtensionHeader(comp));
            fsa.generateFile(this._plainOpcUaComponentExtension.getPlainOpcUaExtensionSourceFilename(comp), this._plainOpcUaComponentExtension.compilePlainOpcUaExtensionSource(comp));
            String _name = comp.getName();
            String _plus = String.valueOf(_name) + "PlainOpcUa.cmake";
            fsa.generateFile(_plus, this.compileCMakeFile(comp));
            Iterable _filter_1 = Iterables.filter((Iterable)comp.getElements(), OpcUaDeviceClient.class);
            for (OpcUaDeviceClient opcUaDevClient : _filter_1) {
                this._plainOpcUaDeviceClient.compilePlainOpcUaDeviceClient(opcUaDevClient, fsa);
            }
            Iterable _filter_2 = Iterables.filter((Iterable)comp.getElements(), OpcUaReadServer.class);
            for (OpcUaReadServer opcUaStatusServer : _filter_2) {
                this._plainOpcUaStatusServer.compilePlainOpcUaReadServer(opcUaStatusServer, fsa);
            }
        }
    }

    public CharSequence compileCMakeFile(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.5)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("FIND_PACKAGE(Open62541CppWrapper 1.0 QUIET)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("IF(Open62541CppWrapper_FOUND)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SET(CMAKE_CXX_STANDARD 14)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("INCLUDE_DIRECTORIES(${CMAKE_CURRENT_LIST_DIR})");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("FILE(GLOB PLAIN_OPCUA_SRCS ${CMAKE_CURRENT_LIST_DIR}/*.cc)");
        _builder.newLine();
        _builder.append("ENDIF(Open62541CppWrapper_FOUND)");
        _builder.newLine();
        return _builder;
    }
}

