/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component.docu;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentDatasheet;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentPortDatasheet;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.ExtendedOutputConfigurationProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@SuppressWarnings("all")
public class ComponentDocuGenerator2Impl extends AbstractGenerator {
  @Inject
  @Extension
  private ComponentParametersDocu _componentParametersDocu;
  
  @Inject
  @Extension
  private HtmlTableHelpers _htmlTableHelpers;
  
  @Override
  public void doGenerate(final Resource input, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    Iterable<ComponentDatasheet> _filter = Iterables.<ComponentDatasheet>filter(IteratorExtensions.<EObject>toIterable(input.getAllContents()), ComponentDatasheet.class);
    for (final ComponentDatasheet datasheet : _filter) {
      fsa.generateFile("README.md", ExtendedOutputConfigurationProvider.SRC_GEN_DOCU, this.compileDocu(datasheet));
    }
  }
  
  public CharSequence getDatasheetPropertyTableHeader() {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _tableHeaderBegin = this._htmlTableHelpers.getTableHeaderBegin();
    _builder.append(_tableHeaderBegin);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableHeaderCell = this._htmlTableHelpers.getAsTableHeaderCell("Property Name");
    _builder.append(_asTableHeaderCell);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableHeaderCell_1 = this._htmlTableHelpers.getAsTableHeaderCell("Property Value");
    _builder.append(_asTableHeaderCell_1);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableHeaderCell_2 = this._htmlTableHelpers.getAsTableHeaderCell("Property Description");
    _builder.append(_asTableHeaderCell_2);
    _builder.newLineIfNotEmpty();
    CharSequence _tableHeaderEnd = this._htmlTableHelpers.getTableHeaderEnd();
    _builder.append(_tableHeaderEnd);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence getTableRow(final DatasheetProperty property) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<tr>");
    _builder.newLine();
    CharSequence _asTableCell = this._htmlTableHelpers.getAsTableCell(property.getName());
    _builder.append(_asTableCell);
    _builder.newLineIfNotEmpty();
    {
      String _unit = property.getUnit();
      boolean _tripleNotEquals = (_unit != null);
      if (_tripleNotEquals) {
        String _value = property.getValue();
        String _plus = (_value + " ");
        String _unit_1 = property.getUnit();
        String _plus_1 = (_plus + _unit_1);
        CharSequence _asTableCell_1 = this._htmlTableHelpers.getAsTableCell(_plus_1);
        _builder.append(_asTableCell_1);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _asTableCell_2 = this._htmlTableHelpers.getAsTableCell(property.getValue());
        _builder.append(_asTableCell_2);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      String _semanticID = property.getSemanticID();
      boolean _tripleNotEquals_1 = (_semanticID != null);
      if (_tripleNotEquals_1) {
        CharSequence _asTableCell_3 = this._htmlTableHelpers.getAsTableCell(property.getSemanticID());
        _builder.append(_asTableCell_3);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _asTableCell_4 = this._htmlTableHelpers.getAsTableCell(property.getShortDescription());
        _builder.append(_asTableCell_4);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("</tr>");
    _builder.newLine();
    return _builder;
  }
  
  public String getShortDescription(final ComponentDatasheet datasheet) {
    final Function1<MandatoryDatasheetElement, Boolean> _function = (MandatoryDatasheetElement it) -> {
      return Boolean.valueOf(it.getName().equals(MandatoryDatasheetElementNames.SHORT_DESCRIPTION));
    };
    final MandatoryDatasheetElement decription = IterableExtensions.<MandatoryDatasheetElement>findFirst(Iterables.<MandatoryDatasheetElement>filter(datasheet.getElements(), MandatoryDatasheetElement.class), _function);
    if ((decription != null)) {
      return decription.getValue();
    }
    return "";
  }
  
  public CharSequence compileDocu(final ComponentDatasheet datasheet) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<!--- This file is generated from the ");
    String _name = datasheet.getComponent().getName();
    _builder.append(_name);
    _builder.append(".componentDocumentation model --->");
    _builder.newLineIfNotEmpty();
    _builder.append("<!--- do not modify this file manually as it will by automatically overwritten by the code generator, modify the model instead and re-generate this file --->");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# ");
    String _name_1 = datasheet.getComponent().getName();
    _builder.append(_name_1);
    _builder.append(" Component");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("<img src=\"model/");
    String _name_2 = datasheet.getComponent().getName();
    _builder.append(_name_2);
    _builder.append("ComponentDefinition.jpg\" alt=\"");
    String _name_3 = datasheet.getComponent().getName();
    _builder.append(_name_3);
    _builder.append("-ComponentImage\" width=\"1000\">");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("*Component Short Description:* ");
    String _shortDescription = this.getShortDescription(datasheet);
    _builder.append(_shortDescription);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      if (((datasheet.getComponent() != null) && (datasheet.getComponent().getDocumentation() != null))) {
        _builder.append("## Component Documentation");
        _builder.newLine();
        String _multilineHtmlDocumentation = datasheet.getComponent().getMultilineHtmlDocumentation();
        _builder.append(_multilineHtmlDocumentation);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("## Component-Datasheet Properties");
    _builder.newLine();
    _builder.newLine();
    CharSequence _tableBegin = this._htmlTableHelpers.getTableBegin();
    _builder.append(_tableBegin);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableCaption = this._htmlTableHelpers.getAsTableCaption("Component-Datasheet Properties");
    _builder.append(_asTableCaption);
    _builder.newLineIfNotEmpty();
    CharSequence _datasheetPropertyTableHeader = this.getDatasheetPropertyTableHeader();
    _builder.append(_datasheetPropertyTableHeader);
    _builder.newLineIfNotEmpty();
    {
      Iterable<DatasheetProperty> _filter = Iterables.<DatasheetProperty>filter(datasheet.getElements(), DatasheetProperty.class);
      for(final DatasheetProperty property : _filter) {
        CharSequence _tableRow = this.getTableRow(property);
        _builder.append(_tableRow);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _tableEnd = this._htmlTableHelpers.getTableEnd();
    _builder.append(_tableEnd);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("## Component Ports");
    _builder.newLine();
    _builder.newLine();
    {
      Iterable<ComponentPort> _filter_1 = Iterables.<ComponentPort>filter(datasheet.getComponent().getElements(), ComponentPort.class);
      for(final ComponentPort port : _filter_1) {
        _builder.append("### ");
        String _name_4 = port.getName();
        _builder.append(_name_4);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("*Documentation:*");
        _builder.newLine();
        String _multilineHtmlDocumentation_1 = port.getMultilineHtmlDocumentation();
        _builder.append(_multilineHtmlDocumentation_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        {
          final Function1<ComponentPortDatasheet, Boolean> _function = (ComponentPortDatasheet it) -> {
            ComponentPort _port = it.getPort();
            return Boolean.valueOf(Objects.equal(_port, port));
          };
          Iterable<ComponentPortDatasheet> _filter_2 = IterableExtensions.<ComponentPortDatasheet>filter(Iterables.<ComponentPortDatasheet>filter(datasheet.getElements(), ComponentPortDatasheet.class), _function);
          for(final ComponentPortDatasheet port_ds : _filter_2) {
            {
              int _size = port_ds.getProperties().size();
              boolean _greaterThan = (_size > 0);
              if (_greaterThan) {
                CharSequence _tableBegin_1 = this._htmlTableHelpers.getTableBegin();
                _builder.append(_tableBegin_1);
                _builder.newLineIfNotEmpty();
                String _name_5 = port.getName();
                String _plus = ("Datasheet Properties of Component-Port <b>" + _name_5);
                CharSequence _asTableCaption_1 = this._htmlTableHelpers.getAsTableCaption((_plus + "</b>"));
                _builder.append(_asTableCaption_1);
                _builder.newLineIfNotEmpty();
                CharSequence _datasheetPropertyTableHeader_1 = this.getDatasheetPropertyTableHeader();
                _builder.append(_datasheetPropertyTableHeader_1);
                _builder.newLineIfNotEmpty();
                {
                  EList<DatasheetProperty> _properties = port_ds.getProperties();
                  for(final DatasheetProperty property_1 : _properties) {
                    CharSequence _tableRow_1 = this.getTableRow(property_1);
                    _builder.append(_tableRow_1);
                    _builder.newLineIfNotEmpty();
                  }
                }
                CharSequence _tableEnd_1 = this._htmlTableHelpers.getTableEnd();
                _builder.append(_tableEnd_1);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
              }
            }
          }
        }
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.newLine();
    {
      Iterable<ComponentParametersRef> _filter_3 = Iterables.<ComponentParametersRef>filter(datasheet.getComponent().getElements(), ComponentParametersRef.class);
      for(final ComponentParametersRef paramRef : _filter_3) {
        CharSequence _compileComponentParameters = this._componentParametersDocu.compileComponentParameters(paramRef.getParameter());
        _builder.append(_compileComponentParameters);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
