/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.system;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.CoordinationModuleRealization;
import org.eclipse.smartmdsd.ecore.behavior.taskRealization.AbstractCoordinationModuleInstance;
import org.eclipse.smartmdsd.ecore.behavior.taskRealization.TaskRealizationModel;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CommunicationServiceUsageRealization;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModeCollection;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModeDefinition;
import org.eclipse.smartmdsd.ecore.system.compArchBehaviorExtension.CoordinationInterfaceComponentInstanceMapping;
import org.eclipse.smartmdsd.ecore.system.compArchBehaviorExtension.CoordinationModuleMapping;
import org.eclipse.smartmdsd.ecore.system.compArchBehaviorExtension.TaskRealizationModelRef;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.ecore.system.deployment.ComponentArtefact;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentModel;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class BehaviorSystem {
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;

    public CharSequence compileModuleConnections(SystemComponentArchitecture model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"modules-insts\" : [");
        _builder.newLine();
        _builder.append("\t");
        Iterable mappings = Iterables.filter((Iterable)model.getExtensions(), CoordinationModuleMapping.class);
        _builder.newLineIfNotEmpty();
        for (CoordinationModuleMapping mapping : mappings) {
            boolean _notEquals_1;
            _builder.append("\t");
            CoordinationModuleRealization coordModRealization = mapping.getCoordModReal();
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            AbstractCoordinationModuleInstance coordModInstance = mapping.getCoordModuleInst();
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\"coordination-module-inst\" : {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\"type\" : \"");
            String _name = coordModRealization.getCoordinationModuleDef().getName();
            _builder.append(_name, "\t\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\"inst-name\" : \"");
            String _name_1 = coordModInstance.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\"coordination-interfaces-instances\" : [");
            _builder.newLine();
            EList _coordInterCompInstMapping = mapping.getCoordInterCompInstMapping();
            for (CoordinationInterfaceComponentInstanceMapping coordInterCompInstMapping : _coordInterCompInstMapping) {
                boolean _notEquals;
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("{ \"type\" : \"");
                String _name_2 = coordInterCompInstMapping.getCoordInterInst().getCoordinationInterfaceDef().getName();
                _builder.append(_name_2, "\t\t");
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\"inst-name\" : \"");
                String _name_3 = coordInterCompInstMapping.getCoordInterInst().getName();
                _builder.append(_name_3, "\t\t");
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\"component-inst\" : \"");
                String _name_4 = coordInterCompInstMapping.getCompInst().getName();
                _builder.append(_name_4, "\t\t");
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\"services\" : [");
                ArrayList<String> _generatePortNames = this.generatePortNames(coordInterCompInstMapping.getCompInst());
                for (String service : _generatePortNames) {
                    _builder.append(service, "\t\t");
                }
                _builder.append("]");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("} ");
                CoordinationInterfaceComponentInstanceMapping _last = (CoordinationInterfaceComponentInstanceMapping)IterableExtensions.last((Iterable)mapping.getCoordInterCompInstMapping());
                boolean bl = _notEquals = !Objects.equal((Object)coordInterCompInstMapping, (Object)_last);
                if (_notEquals) {
                    _builder.append(",");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("]");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            CoordinationModuleMapping _last_1 = (CoordinationModuleMapping)IterableExtensions.last((Iterable)mappings);
            boolean bl = _notEquals_1 = !Objects.equal((Object)mapping, (Object)_last_1);
            if (_notEquals_1) {
                _builder.append(",");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private String getLocation(TaskRealizationModel model) {
        URI uri = model.eResource().getURI();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.segment(1));
        return project.getLocation().toString();
    }

    public CharSequence compileBehaviorProjectFiles(SystemComponentArchitecture model) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable behaviorTaskRefs = Iterables.filter((Iterable)model.getExtensions(), TaskRealizationModelRef.class);
        _builder.newLineIfNotEmpty();
        _builder.append("#!/bin/bash");
        _builder.newLine();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# this script will be sourced from the components deployment");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("declare -a BEHAVIOR_PROJECTS_PATH=(");
        _builder.newLine();
        _builder.append("    \t");
        for (TaskRealizationModelRef ref : behaviorTaskRefs) {
            _builder.append("\"");
            String _location = this.getLocation(ref.getTaskModelRef());
            _builder.append(_location, "    \t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append(")");
        _builder.newLine();
        return _builder;
    }

    public ArrayList<String> generateMainState(ComponentInstance compInst) {
        ArrayList<String> res = new ArrayList<String>();
        Iterable coordSlavePorts = Iterables.filter((Iterable)compInst.getComponent().getElements(), CoordinationSlavePort.class);
        if (coordSlavePorts != null) {
            for (CoordinationSlavePort coodrinationSlavePort : coordSlavePorts) {
                ComponentModeCollection modeCollection = coodrinationSlavePort.getService().getStatePattern().getModes();
                if (modeCollection == null) continue;
                EList _modes = modeCollection.getModes();
                for (ComponentModeDefinition mode : _modes) {
                    res.add(mode.getName());
                }
            }
        }
        return res;
    }

    public ArrayList<String> generatePortNames(ComponentInstance compInst) {
        ArrayList<String> result = new ArrayList<String>();
        Iterable coordSlavePorts = Iterables.filter((Iterable)compInst.getComponent().getElements(), CoordinationSlavePort.class);
        for (CoordinationSlavePort coodrinationSlavePort : coordSlavePorts) {
            Iterable comServiceUsagesReals = Iterables.filter((Iterable)coodrinationSlavePort.getElements(), CommunicationServiceUsageRealization.class);
            for (CommunicationServiceUsageRealization comServiceUsage : comServiceUsagesReals) {
                boolean _notEquals;
                String _name = comServiceUsage.getServiceUsage().getName();
                String _plus = "{ \"coordservice\" : \"" + _name;
                String _plus_1 = String.valueOf(_plus) + "\", \"compservice\" : \"";
                String _name_1 = comServiceUsage.getComponentPort().getName();
                String _plus_2 = String.valueOf(_plus_1) + _name_1;
                String tmp = String.valueOf(_plus_2) + "\"}";
                CommunicationServiceUsageRealization _last = (CommunicationServiceUsageRealization)IterableExtensions.last((Iterable)comServiceUsagesReals);
                boolean bl = _notEquals = !Objects.equal((Object)comServiceUsage, (Object)_last);
                if (_notEquals) {
                    String _tmp = tmp;
                    tmp = String.valueOf(_tmp) + ",";
                }
                result.add(tmp);
            }
        }
        return result;
    }

    public LinkedHashSet<String> getAllComponentCoordinationInterfaces(DeploymentModel model) {
        LinkedHashSet<String> cis = new LinkedHashSet<String>();
        Iterable _filter = Iterables.filter((Iterable)model.getElements(), ComponentArtefact.class);
        for (ComponentArtefact artefact : _filter) {
            Iterable coordSlavePorts = Iterables.filter((Iterable)artefact.getComponent().getComponent().getElements(), CoordinationSlavePort.class);
            for (CoordinationSlavePort coodrinationSlavePort : coordSlavePorts) {
                cis.add(coodrinationSlavePort.getService().getName());
            }
        }
        return cis;
    }

    public CharSequence compileBehaviorDeploymentFiles(DeploymentModel model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/bin/bash");
        _builder.newLine();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# this script will be sourced from the components deployment");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("COMP_INTERFACE_FILES=\"");
        _builder.newLine();
        LinkedHashSet<String> _allComponentCoordinationInterfaces = this.getAllComponentCoordinationInterfaces(model);
        for (String ci : _allComponentCoordinationInterfaces) {
            _builder.append("$SMART_ROOT_ACE/lib/lib");
            _builder.append(ci);
            _builder.append(".so");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\"");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append("BEHAVIOR_UTILITY_FILES=\"");
        _builder.newLine();
        _builder.append("src-gen/system/CoordinationModuleConnections.json");
        _builder.newLine();
        _builder.append("\"");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append("COMP_INTERFACE_FILES_MISSING=false");
        _builder.newLine();
        _builder.append("for FILE in $COMP_INTERFACE_FILES; do");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if [ ! -e $FILE ]; then");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("echo \"Deployment: No such file or directory: $FILE\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("COMP_INTERFACE_FILES_MISSING=true");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.newLine();
        _builder.append("if [ \"$COMP_INTERFACE_FILES_MISSING\" = \"true\" ]; then");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"ERROR: FILES ARE MISSING FROM THE DEPLOYMENT (see above). Did you compile all components interfaces/components?\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("exit 1");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append("echo \"Sourcing behaviorProjectFiles\"");
        _builder.newLine();
        _builder.append("source src-gen/system/behaviorProjectFiles.sh 2>&1");
        _builder.newLine();
        _builder.newLine();
        _builder.append("BEHAVIOR_PROJECT_MODEL_FILES=\"\"");
        _builder.newLine();
        _builder.append("shopt -u | grep -q nullglob && changed=true && shopt -s nullglob");
        _builder.newLine();
        _builder.append("for DIR in \"${BEHAVIOR_PROJECTS_PATH[@]}\"; do");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Behavior files for $DIR\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for entry in \"$DIR\"/model/*.smartTcl");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("do");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("echo \"Behavior file: $entry\"");
        _builder.newLine();
        _builder.append("  \t\t");
        _builder.append("BEHAVIOR_PROJECT_MODEL_FILES=\"$BEHAVIOR_PROJECT_MODEL_FILES $entry\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("done");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.append("[ $changed ] && shopt -u nullglob; unset changed");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("cp -rv $BEHAVIOR_PROJECT_MODEL_FILES $TMPDIR/behaviorFiles 2>&1");
        _builder.newLine();
        _builder.append("cp -rv $COMP_INTERFACE_FILES $TMPDIR/behaviorFiles 2>&1");
        _builder.newLine();
        _builder.append("cp -rv $BEHAVIOR_UTILITY_FILES $TMPDIR/behaviorFiles 2>&1");
        _builder.newLine();
        return _builder;
    }
}

