/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.utils.xtext;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IBatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class XtextVirtualResourceProvider
implements IEditedResourceProvider {
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private FileExtensionProvider fileExt;
    private Resource originalResource = null;
    private URI currentDiagramUri = null;
    private XtextResource virtualXtextResource = null;
    private int offset = 0;
    private int endOffset = 0;

    public String getModelFileExtension() {
        return this.fileExt.getPrimaryFileExtension();
    }

    public XtextResource createResource() {
        ResourceSet resourceSet = this.resourceSetProvider.get(null);
        URI uri = URI.createURI((String)("platform:/resource/VirtualProject/virtualModel." + this.getModelFileExtension()));
        this.virtualXtextResource = (XtextResource)resourceSet.createResource(uri);
        resourceSet.getResources().add((Object)this.virtualXtextResource);
        return this.virtualXtextResource;
    }

    public void setCurrentResourceObject(DRepresentationElement diagramElementObject) {
        EObject semanticObject = diagramElementObject.getTarget();
        this.originalResource = semanticObject.eResource();
        ICompositeNode actualNode = NodeModelUtils.findActualNodeFor((EObject)semanticObject);
        if (actualNode != null) {
            this.setEditableTextRegion(actualNode.getOffset(), actualNode.getEndOffset());
        } else {
            this.setEditableTextRegion(0, 0);
        }
        this.virtualXtextResource.setURI(this.originalResource.getURI());
        this.currentDiagramUri = diagramElementObject.eResource().getURI();
    }

    public void setExternalResource(DRepresentationElement diagramElementObject, URI xtextResourceUri) {
        this.currentDiagramUri = diagramElementObject.eResource().getURI();
        this.reloadExternalResource(xtextResourceUri);
    }

    public void reloadExternalResource(URI xtextResourceUri) {
        String projectName = xtextResourceUri.segment(1);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            ResourceSet resourceSet = this.resourceSetProvider.get(project);
            this.originalResource = resourceSet.getResource(xtextResourceUri, true);
            this.setEditableTextRegion(0, 0);
            this.virtualXtextResource.setURI(this.originalResource.getURI());
        }
    }

    public URI getAccordingXtextResourceUri(DRepresentationElement diagramElementObject) {
        return diagramElementObject.getTarget().eResource().getURI().trimFileExtension().appendFileExtension(this.getModelFileExtension());
    }

    public void removeExternalResource(URI resourceUri) {
        if (this.originalResource != null && this.originalResource.getURI().equals(resourceUri)) {
            try {
                this.setEditableTextRegion(0, 0);
                this.originalResource.delete(null);
                this.originalResource = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isCurrentSession(Session session) {
        URI sessionUri;
        return this.currentDiagramUri != null && (sessionUri = URI.createURI((String)session.getID())).equals(this.currentDiagramUri);
    }

    public ICompositeNode getCurrentRootNode() {
        if (this.originalResource != null && this.originalResource instanceof XtextResource) {
            XtextResource xResource = (XtextResource)this.originalResource;
            return xResource.getParseResult().getRootNode();
        }
        return null;
    }

    public void setEditableTextRegion(int offset, int endOffset) {
        this.offset = offset;
        this.endOffset = endOffset;
    }

    public List<String> getModelText() {
        ArrayList<String> modelText = new ArrayList<String>();
        if (this.originalResource instanceof XtextResource) {
            XtextResource xtextResource = (XtextResource)this.originalResource;
            ICompositeNode rootNode = xtextResource.getParseResult().getRootNode();
            String fullModelText = rootNode.getText();
            int fullModelLength = fullModelText.length();
            if (this.offset > 0) {
                String prefix = "";
                String editablePart = "";
                String suffix = "";
                if (this.offset < fullModelLength) {
                    prefix = fullModelText.substring(0, this.offset - 1);
                }
                if (this.offset < this.endOffset && this.endOffset <= fullModelLength) {
                    editablePart = fullModelText.substring(this.offset, this.endOffset);
                    if (this.endOffset < fullModelLength) {
                        suffix = fullModelText.substring(this.endOffset);
                    }
                }
                modelText.add(prefix);
                modelText.add(editablePart);
                modelText.add(suffix);
            } else {
                modelText.add("");
                modelText.add(fullModelText);
                modelText.add("");
            }
        }
        return modelText;
    }

    public void saveOriginalResource(IProgressMonitor monitor) {
        if (this.virtualXtextResource != null) {
            EcoreUtil.resolveAll((Resource)this.virtualXtextResource);
            IParseResult parseResult = this.virtualXtextResource.getParseResult();
            if (!parseResult.hasSyntaxErrors() && EcoreUtil.UnresolvedProxyCrossReferencer.find((Resource)this.virtualXtextResource).size() <= 0) {
                this.mergeVirtualResourceWithOriginal(monitor);
                Session session = SessionManager.INSTANCE.getSession(this.currentDiagramUri, monitor);
                if (session != null) {
                    session.save(monitor);
                }
            } else {
                System.out.println("Edited model has errors -> skip saving!");
            }
        }
    }

    private void mergeVirtualResourceWithOriginal(IProgressMonitor monitor) {
        if (this.originalResource != null && this.virtualXtextResource != null) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)this.originalResource);
            if (editingDomain != null) {
                DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.originalResource, (Notifier)this.virtualXtextResource, null);
                Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
                IMerger.Registry mergeRegistry = IMerger.RegistryImpl.createStandaloneInstance();
                BatchMerger merger = new BatchMerger(mergeRegistry);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, "update resource after direct text edit", (IBatchMerger)merger, comparison){
                    private final /* synthetic */ IBatchMerger val$merger;
                    private final /* synthetic */ Comparison val$comparison;
                    {
                        this.val$merger = iBatchMerger;
                        this.val$comparison = comparison;
                        super($anonymous0, $anonymous1);
                    }

                    protected void doExecute() {
                        this.val$merger.copyAllRightToLeft((Iterable)this.val$comparison.getDifferences(), (Monitor)new BasicMonitor());
                    }
                });
            } else if (this.originalResource instanceof XtextResource) {
                try {
                    XtextResource origXtextResource = (XtextResource)this.originalResource;
                    ICompositeNode rootNode = this.virtualXtextResource.getParseResult().getRootNode();
                    origXtextResource.reparse(rootNode.getText().substring(rootNode.getOffset()));
                    IParseResult parseResult = origXtextResource.getParseResult();
                    if (!parseResult.hasSyntaxErrors()) {
                        origXtextResource.save(SaveOptions.defaultOptions().toOptionsMap());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

