/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.natures;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.smartmdsd.ui.builder.CDTProjectHelpers;
import org.eclipse.smartmdsd.ui.models.SmartMDSDModelingLanguage;
import org.eclipse.smartmdsd.ui.models.SmartMDSDModelingLanguageRegistry;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractSmartMDSDNature
implements IProjectNature {
    protected IProject project;
    protected static Map<String, SmartMDSDModelingLanguageRegistry> languages_registry = new HashMap<String, SmartMDSDModelingLanguageRegistry>();

    public abstract String getNatureID();

    public abstract List<String> getImportedProjectNatureIds();

    public void configure() throws CoreException {
        if (this.project != null) {
            CDTProjectHelpers.setSmartMDSDCdtBuilderFor(this.project);
        }
    }

    public void deconfigure() throws CoreException {
        if (this.project != null) {
            CDTProjectHelpers.resetDefaultCdtBuilderFor(this.project);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void initializeRegistry() {
        SmartMDSDNatureEnum[] smartMDSDNatureEnumArray = SmartMDSDNatureEnum.values();
        int n = smartMDSDNatureEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SmartMDSDNatureEnum nature = smartMDSDNatureEnumArray[n2];
            languages_registry.put(nature.getId(), new SmartMDSDModelingLanguageRegistry(nature));
            ++n2;
        }
    }

    public SmartMDSDModelingLanguage getLanguage(String languageName) {
        return languages_registry.get(this.getNatureID()).getLanguage(languageName);
    }

    public SmartMDSDModelingLanguage getLanguageFrom(IResource modelResource) {
        try {
            IEditorRegistry editorRegistry;
            IEditorDescriptor editor;
            IProject project = modelResource.getProject();
            if (project.hasNature(this.getNatureID()) && (editor = (editorRegistry = PlatformUI.getWorkbench().getEditorRegistry()).getDefaultEditor(modelResource.getName())) != null) {
                return languages_registry.get(this.getNatureID()).getLanguageFrom(editor.getId());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Collection<SmartMDSDModelingLanguage> getAllSupportedLanguages() {
        return languages_registry.get(this.getNatureID()).getAllLanguages();
    }
}

