/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.basicAttributes.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.xtext.base.docuterminals.formatting2.DocuTerminalsFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class BasicAttributesFormatter extends DocuTerminalsFormatter {
  protected void _format(final AttributeDefinition attributeDefinition, @Extension final IFormattableDocument document) {
    document.<AbstractAttributeType>format(attributeDefinition.getType());
    document.<AbstractValue>format(attributeDefinition.getDefaultvalue());
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, 2);
    };
    document.<AttributeDefinition>append(attributeDefinition, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(attributeDefinition).keyword("="), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(attributeDefinition).keyword(":"), _function_2);
  }
  
  protected void _format(final AttributeRefinement attributeRefinement, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, 2);
    };
    document.<AttributeRefinement>append(attributeRefinement, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(attributeRefinement).keyword("="), _function_1);
  }
  
  protected void _format(final InlineEnumerationType inlineEnumerationType, @Extension final IFormattableDocument document) {
    document.<ArrayType>format(inlineEnumerationType.getArray());
    EList<EnumerationElement> _enums = inlineEnumerationType.getEnums();
    for (final EnumerationElement enumerationElement : _enums) {
      document.<EnumerationElement>format(enumerationElement);
    }
  }
  
  public void format(final Object attributeDefinition, final IFormattableDocument document) {
    if (attributeDefinition instanceof XtextResource) {
      _format((XtextResource)attributeDefinition, document);
      return;
    } else if (attributeDefinition instanceof AttributeDefinition) {
      _format((AttributeDefinition)attributeDefinition, document);
      return;
    } else if (attributeDefinition instanceof AttributeRefinement) {
      _format((AttributeRefinement)attributeDefinition, document);
      return;
    } else if (attributeDefinition instanceof InlineEnumerationType) {
      _format((InlineEnumerationType)attributeDefinition, document);
      return;
    } else if (attributeDefinition instanceof EObject) {
      _format((EObject)attributeDefinition, document);
      return;
    } else if (attributeDefinition == null) {
      _format((Void)null, document);
      return;
    } else if (attributeDefinition != null) {
      _format(attributeDefinition, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(attributeDefinition, document).toString());
    }
  }
}
