/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.skillDefinition.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.service.skillDefinition.CoordinationModuleDefinition;
import org.eclipse.smartmdsd.ecore.service.skillDefinition.SkillDefinitionModel;
import org.eclipse.smartmdsd.ecore.service.skillDefinition.SkillDefinitionRepository;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.formatting2.BasicAttributesFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class SkillDefinitionFormatter extends BasicAttributesFormatter {
  protected void _format(final SkillDefinitionModel skillDefinitionModel, @Extension final IFormattableDocument document) {
    document.<SkillDefinitionRepository>format(skillDefinitionModel.getRepository());
  }
  
  protected void _format(final SkillDefinitionRepository skillDefinitionRepository, @Extension final IFormattableDocument document) {
    EList<CoordinationModuleDefinition> _modules = skillDefinitionRepository.getModules();
    for (final CoordinationModuleDefinition coordinationModuleDefinition : _modules) {
      document.<CoordinationModuleDefinition>format(coordinationModuleDefinition);
    }
  }
  
  public void format(final Object skillDefinitionModel, final IFormattableDocument document) {
    if (skillDefinitionModel instanceof XtextResource) {
      _format((XtextResource)skillDefinitionModel, document);
      return;
    } else if (skillDefinitionModel instanceof AttributeDefinition) {
      _format((AttributeDefinition)skillDefinitionModel, document);
      return;
    } else if (skillDefinitionModel instanceof AttributeRefinement) {
      _format((AttributeRefinement)skillDefinitionModel, document);
      return;
    } else if (skillDefinitionModel instanceof InlineEnumerationType) {
      _format((InlineEnumerationType)skillDefinitionModel, document);
      return;
    } else if (skillDefinitionModel instanceof SkillDefinitionModel) {
      _format((SkillDefinitionModel)skillDefinitionModel, document);
      return;
    } else if (skillDefinitionModel instanceof SkillDefinitionRepository) {
      _format((SkillDefinitionRepository)skillDefinitionModel, document);
      return;
    } else if (skillDefinitionModel instanceof EObject) {
      _format((EObject)skillDefinitionModel, document);
      return;
    } else if (skillDefinitionModel == null) {
      _format((Void)null, document);
      return;
    } else if (skillDefinitionModel != null) {
      _format(skillDefinitionModel, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(skillDefinitionModel, document).toString());
    }
  }
}
