/**
 * Copyright (c) 2021 Toolify Robotics GmbH
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package eu.toolify.xtend.generators.domainmodels.json;

import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.DomainModelsGeneratorExtension;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class JsonDomainModelsExtension implements DomainModelsGeneratorExtension {
  @Override
  public String getExtensionName(final CommObjectsRepository repo) {
    String _name = repo.getName();
    return (_name + "JsonTransformation");
  }
  
  @Override
  public CharSequence getCMakeExtension(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("GET_FILENAME_COMPONENT(TOOLIFY_DIR \"${PROJECT_SOURCE_DIR}/../toolify\" REALPATH)");
    _builder.newLine();
    _builder.append("IF(EXISTS ${TOOLIFY_DIR})");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ADD_SUBDIRECTORY(${TOOLIFY_DIR}/src-gen ${CMAKE_CURRENT_BINARY_DIR}/toolify)");
    _builder.newLine();
    _builder.append("ENDIF(EXISTS ${TOOLIFY_DIR})");
    _builder.newLine();
    return _builder;
  }
}
