/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj;

import com.google.inject.Inject;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class DebianPackageGenerator {
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private CommObjectCMakeGenerator _commObjectCMakeGenerator;
  
  public CharSequence generateCMakeDebianControlFile(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
    _builder.append(_copyrightWriteOnceHash);
    _builder.newLineIfNotEmpty();
    _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 2.8)");
    _builder.newLine();
    _builder.append("#TODO remove ace in verion 6.0.1");
    _builder.newLine();
    _builder.append("SET(SMARTSOFT_DEBS \"");
    {
      final Function1<CommunicationObject, String> _function = (CommunicationObject x) -> {
        return x.getName();
      };
      List<CommunicationObject> _sortBy = IterableExtensions.<CommunicationObject, String>sortBy(this._commObjectCMakeGenerator.getReferencedCommObjects(repo), _function);
      for(final CommunicationObject obj : _sortBy) {
        _builder.append("lib");
        String _lowerCase = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(" (>=");
        int _major = this._commObjectGenHelpers.getRepoVersion(repo).getMajor();
        _builder.append(_major);
        _builder.append(".");
        int _minor = this._commObjectGenHelpers.getRepoVersion(repo).getMinor();
        _builder.append(_minor);
        _builder.append(".");
        int _patch = this._commObjectGenHelpers.getRepoVersion(repo).getPatch();
        _builder.append(_patch);
        _builder.append("), ");
      }
    }
    _builder.append(" ");
    String _dependency = repo.getDependency();
    _builder.append(_dependency);
    _builder.append("libsmartxml (>=1.0.0), libace-6.0.1 (>=6.0.1)| libace-6.0.3,\")");
    _builder.newLineIfNotEmpty();
    _builder.append("SET(SMARTSOFT_DEV_DEBS \"");
    {
      final Function1<CommunicationObject, String> _function_1 = (CommunicationObject x) -> {
        return x.getName();
      };
      List<CommunicationObject> _sortBy_1 = IterableExtensions.<CommunicationObject, String>sortBy(this._commObjectCMakeGenerator.getReferencedCommObjects(repo), _function_1);
      for(final CommunicationObject obj_1 : _sortBy_1) {
        _builder.append("lib");
        String _lowerCase_1 = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
        _builder.append(_lowerCase_1);
        _builder.append("-dev (>=");
        int _major_1 = this._commObjectGenHelpers.getRepoVersion(repo).getMajor();
        _builder.append(_major_1);
        _builder.append(".");
        int _minor_1 = this._commObjectGenHelpers.getRepoVersion(repo).getMinor();
        _builder.append(_minor_1);
        _builder.append(".");
        int _patch_1 = this._commObjectGenHelpers.getRepoVersion(repo).getPatch();
        _builder.append(_patch_1);
        _builder.append("), ");
      }
    }
    _builder.append(" ");
    String _dependency_1 = repo.getDependency();
    _builder.append(_dependency_1);
    _builder.append("libsmartxml-dev (>=1.0.0), libace-dev (>=6.0.1),\")");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("MESSAGE(\"SMARTSOFT_DEBS is: ${SMARTSOFT_DEBS}\")");
    _builder.newLine();
    _builder.append("MESSAGE(\"SMARTSOFT_DEV_DEBS is: ${SMARTSOFT_DEV_DEBS}\")");
    _builder.newLine();
    _builder.append("GET_FILENAME_COMPONENT(CURRENTPATH ${CMAKE_CURRENT_LIST_FILE} PATH)");
    _builder.newLine();
    _builder.append("CONFIGURE_FILE(${CURRENTPATH}/../debian/control.user ${CURRENTPATH}/../debian/control @ONLY)");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianCommObjectControl(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
    _builder.append(_copyrightWriteOnceHash);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("Source: lib");
    String _lowerCase = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
    _builder.append(_lowerCase);
    _builder.newLineIfNotEmpty();
    _builder.append("Section: devel");
    _builder.newLine();
    _builder.append("Priority: extra");
    _builder.newLine();
    _builder.append("Maintainer: Service Robotics Research Center University of Applied Sciences Ulm <schlegel@hs-ulm.de>");
    _builder.newLine();
    _builder.append("Build-Depends: debhelper, cmake");
    _builder.newLine();
    _builder.append("Standards-Version: 3.9.3");
    _builder.newLine();
    _builder.append("Homepage: http://www.servicerobotik-ulm.de/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("Package: lib");
    String _lowerCase_1 = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
    _builder.append(_lowerCase_1);
    _builder.newLineIfNotEmpty();
    _builder.append("Architecture: any");
    _builder.newLine();
    _builder.append("Section: libs");
    _builder.newLine();
    _builder.append("Depends: @SMARTSOFT_DEBS@ libc6 (>=2.13), libgcc1 (>= 1:4.1.1), libstdc++6 (>=4.6)");
    _builder.newLine();
    _builder.append("Recommends: libsmartsoftkernelace (>=2.0.0)");
    _builder.newLine();
    _builder.append("Description: CommunicationObjectLibarry");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("Package: lib");
    String _lowerCase_2 = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
    _builder.append(_lowerCase_2);
    _builder.append("-dbg");
    _builder.newLineIfNotEmpty();
    _builder.append("Architecture: any");
    _builder.newLine();
    _builder.append("Section: debug");
    _builder.newLine();
    _builder.append("Priority: extra");
    _builder.newLine();
    _builder.append("Depends: lib");
    String _lowerCase_3 = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
    _builder.append(_lowerCase_3);
    _builder.append(" (= ${binary:Version}), ${misc:Depends}");
    _builder.newLineIfNotEmpty();
    _builder.append("Recommends: libsmartsoftkernelace (>=2.0.0)");
    _builder.newLine();
    _builder.append("Description: CommunicationObjectLibrary - debugging symbols");
    _builder.newLine();
    _builder.newLine();
    _builder.append("Package: lib");
    String _lowerCase_4 = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
    _builder.append(_lowerCase_4);
    _builder.append("-dev");
    _builder.newLineIfNotEmpty();
    _builder.append("Architecture: any");
    _builder.newLine();
    _builder.append("Section: libdevel");
    _builder.newLine();
    _builder.append("Depends: @SMARTSOFT_DEV_DEBS@ lib");
    String _lowerCase_5 = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
    _builder.append(_lowerCase_5);
    _builder.append(" (= ${binary:Version}), smartsoftbuild-environment");
    _builder.newLineIfNotEmpty();
    _builder.append("Recommends: libsmartsoftkernelace-dev (>=2.0.0)");
    _builder.newLine();
    _builder.append("Description: CommunicationObjectLibrary - devel files");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    _builder.newLine();
    _builder.append("Package: lib");
    String _lowerCase_6 = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
    _builder.append(_lowerCase_6);
    _builder.append("-doc");
    _builder.newLineIfNotEmpty();
    _builder.append("Architecture: all");
    _builder.newLine();
    _builder.append("Description: CommunicationObjectLibrary - doc files");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianCommObjectRules(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#!/usr/bin/make -f");
    _builder.newLine();
    _builder.newLine();
    String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
    _builder.append(_copyrightWriteOnceHash);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# Uncomment this to turn on verbose mode.");
    _builder.newLine();
    _builder.append("#export DH_VERBOSE=1");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# This has to be exported to make some magic below work.");
    _builder.newLine();
    _builder.append("export DH_OPTIONS");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("%:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("dh $@ ");
    _builder.newLine();
    _builder.newLine();
    _builder.append("override_dh_auto_configure:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("dh_auto_configure -- -DAUTOINSTALL=\"OFF\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append(".PHONY: override_dh_strip");
    _builder.newLine();
    _builder.append("override_dh_strip:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("dh_strip --dbg-package=lib");
    String _lowerCase = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
    _builder.append(_lowerCase, "\t");
    _builder.append("-dbg");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("override_dh_shlibdeps:");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianCommObjectInstallBIN(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("usr/lib/lib");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(repo);
    _builder.append(_repoNamespace);
    _builder.append("* usr/lib/");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence generateDebianCommObjectInstallDOC(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#TODO");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianCommObjectInstallDEV(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("usr/modules/* opt/smartSoftAce/modules");
    _builder.newLine();
    _builder.append("usr/include/*");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianCommObjectCopyright(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Format: http://dep.debian.net/deps/dep5");
    _builder.newLine();
    _builder.append("Upstream-Name: ");
    String _string = this._commObjectGenHelpers.getRepoNamespace(repo).toString();
    _builder.append(_string);
    _builder.newLineIfNotEmpty();
    _builder.append("Source: http://sourceforge.net/projects/smartsoft-ace/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("Files: debian/*");
    _builder.newLine();
    _builder.append("Copyright: <years> <put author\'s name and email here>");
    _builder.newLine();
    _builder.append("           ");
    _builder.append("<years> <likewise for another author>");
    _builder.newLine();
    _builder.append("License: <your license SPDX string>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Please also look if there are files or directories which have a");
    _builder.newLine();
    _builder.append("# different copyright/license attached and list them here.");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianCommObjectChangelog(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("lib");
    String _lowerCase = this._commObjectGenHelpers.getRepoNamespace(repo).toString().toLowerCase();
    _builder.append(_lowerCase);
    _builder.append(" (1.0.0) unstable; urgency=low");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("  ");
    _builder.append("* Initial release");
    _builder.newLine();
    _builder.newLine();
    _builder.append(" ");
    _builder.append("-- SmartMDSDToolchain <mail@unknown>  ");
    String _currentSystemDate = this.getCurrentSystemDate();
    _builder.append(_currentSystemDate, " ");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence generateDebianCommObjectCompat(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("8");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianCommObjectFormat(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("3.0 (native)");
    _builder.newLine();
    return _builder;
  }
  
  private String getCurrentSystemDate() {
    DateFormat dateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
    Calendar cal = Calendar.getInstance();
    return dateFormat.format(cal.getTime());
  }
}
