/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ComponentCMakeGenerator {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private ComponentGenHelpers _componentGenHelpers;
  
  public String getCMakeMixedPortIncludesFilename() {
    return "MixedPortIncludes.cmake";
  }
  
  public String getCMakeMixedPortTargetConfigFilename() {
    return "MixedPortTargetConfigs.cmake";
  }
  
  public CharSequence generateCmakeProjectFile(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
    _builder.append(_copyrightHash);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("PROJECT(");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence generateCmakeDependenciesFile(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
    _builder.append(_copyrightHash);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# other CommunicationObject-dependencies are added here (if there are any)");
    _builder.newLine();
    {
      final Function1<CommObjectsRepository, String> _function = (CommObjectsRepository x) -> {
        return x.getName();
      };
      List<CommObjectsRepository> _sortBy = IterableExtensions.<CommObjectsRepository, String>sortBy(this._componentGenHelpers.getReferencedCommObjRepos(ComponentDefinitionModelUtility.getAllCommObjects(component)), _function);
      for(final CommObjectsRepository co : _sortBy) {
        _builder.append("LIST(APPEND ");
        String _name = component.getName();
        _builder.append(_name);
        _builder.append("_DEPENDENCIES ");
        String _name_1 = co.getName();
        _builder.append(_name_1);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      boolean _isEmpty = ComponentDefinitionModelUtility.getAllCommObjects(component).isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append("LIST(REMOVE_DUPLICATES ");
        String _name_2 = component.getName();
        _builder.append(_name_2);
        _builder.append("_DEPENDENCIES)");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence CMakeListsUserFileContent(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
    _builder.append(_copyrightWriteOnceHash);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.0)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# find the SmartSoft CMake Macros (version 2 that uses CMake v3)");
    _builder.newLine();
    _builder.append("FIND_FILE(SMART_MACROS SmartMacros2.cmake PATHS $ENV{SMART_ROOT_ACE}/CMakeMacros /opt/smartSoftAce/CMakeMacros/)");
    _builder.newLine();
    _builder.append("INCLUDE(${SMART_MACROS})");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Create and configure a CMake project for a CommunicationObject");
    _builder.newLine();
    _builder.append("SMART_COMPONENT_PROJECT()");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# find SmartSoft package");
    _builder.newLine();
    _builder.append("FIND_PACKAGE(AceSmartSoft PATHS $ENV{SMART_ROOT_ACE} $ENV{SMART_ROOT_ACE}/modules)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# generte doxygen documentation");
    _builder.newLine();
    _builder.append("SMART_COMPONENT_GENERATE_DOC()");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# automatically build CommunicationObject dependencies");
    _builder.newLine();
    _builder.append("SMART_COMPONENT_AUTOBUILD_DEPENDENCIES()");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#################################################################################");
    _builder.newLine();
    _builder.append("## here you can put all your project-specific compiler configurations          ##");
    _builder.newLine();
    _builder.append("## using regular CMake commands (like FIND_PACKAGE, INCLUDE_DIRECTORIES, etc.) ##");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# you can add additional external libraries using regular CMake commands, e.g.:");
    _builder.newLine();
    _builder.append("#FIND_PACKAGE(<SomePackageName>)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("INCLUDE(${CMAKE_CURRENT_LIST_DIR}/src-gen/");
    String _cMakeMixedPortIncludesFilename = this.getCMakeMixedPortIncludesFilename();
    _builder.append(_cMakeMixedPortIncludesFilename);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# these are the regular includes (add your own includes, if needed)");
    _builder.newLine();
    _builder.append("INCLUDE_DIRECTORIES(");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("${CMAKE_CURRENT_LIST_DIR}/src");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("${CMAKE_CURRENT_LIST_DIR}/src-gen");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("${CMAKE_CURRENT_LIST_DIR}/src-gen/params");
    _builder.newLine();
    _builder.append(")");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# collect the toolchain-generated source-files");
    _builder.newLine();
    _builder.append("FILE(GLOB_RECURSE SRC ${CMAKE_CURRENT_LIST_DIR}/src/*.cc)");
    _builder.newLine();
    _builder.append("FILE(GLOB_RECURSE SRC_GEN ${CMAKE_CURRENT_LIST_DIR}/src-gen/*.cc)");
    _builder.newLine();
    _builder.append("FILE(GLOB_RECURSE SRC_GEN_PARAMS ${CMAKE_CURRENT_LIST_DIR}/src-gen/params/*.cc)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# collect your own (local) source-files here (if needed)");
    _builder.newLine();
    _builder.append("#FILE(GLOB_RECURSE USER_SRC ${CMAKE_CURRENT_LIST_DIR}/src/<your-sources>)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# create the executable using collected source-files");
    _builder.newLine();
    _builder.append("ADD_EXECUTABLE(${PROJECT_NAME} ${SRC} ${SRC_GEN} ${SRC_GEN_PARAMS} ${FURTHER_SRCS}) # add ${USER_SRC} (if needed)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# link your external libraries here (if there are any)");
    _builder.newLine();
    _builder.append("#TARGET_LINK_LIBRARIES(${PROJECT_NAME} <your-libs>)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("INCLUDE(${CMAKE_CURRENT_LIST_DIR}/src-gen/");
    String _cMakeMixedPortTargetConfigFilename = this.getCMakeMixedPortTargetConfigFilename();
    _builder.append(_cMakeMixedPortTargetConfigFilename);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#INSTALL(FILES ${PROJECT_SOURCE_DIR}/src-gen/${PROJECT_NAME}.ini.template DESTINATION etc)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("## end user-code                                                               ##");
    _builder.newLine();
    _builder.append("#################################################################################");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# SmartSoftKernel is one of the default dependencies for each component");
    _builder.newLine();
    _builder.append("TARGET_LINK_LIBRARIES(${PROJECT_NAME} AceSmartSoftKernel)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# automatically link to all dependent CommunicationObjects");
    _builder.newLine();
    _builder.append("SMART_COMPONENT_AUTOLINK_DEPENDENCIES()");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# automatically install the component target");
    _builder.newLine();
    _builder.append("SMART_COMPONENT_AUTOINSTALL()");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateCMakeDebianControlFile(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
    _builder.append(_copyrightHash);
    _builder.newLineIfNotEmpty();
    _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 2.8.7)");
    _builder.newLine();
    _builder.append("#TODO remove ace in verion 6.0.1");
    _builder.newLine();
    _builder.newLine();
    _builder.append("MESSAGE(\"SMARTSOFT_DEBS is: ${SMARTSOFT_DEBS}\")");
    _builder.newLine();
    _builder.append("CONFIGURE_FILE(${CMAKE_CURRENT_SOURCE_DIR}/../debian/control.user ${CMAKE_CURRENT_SOURCE_DIR}/../debian/control @ONLY)");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianCommObjectControl(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
    _builder.append(_copyrightWriteOnceHash);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("Source: ");
    String _lowerCase = component.getName().toLowerCase();
    _builder.append(_lowerCase);
    _builder.newLineIfNotEmpty();
    _builder.append("Section: devel");
    _builder.newLine();
    _builder.append("Priority: extra");
    _builder.newLine();
    _builder.append("Maintainer: Service Robotics Research Center University of Applied Sciences Ulm <schlegel@hs-ulm.de>");
    _builder.newLine();
    _builder.append("Build-Depends: debhelper, cmake");
    _builder.newLine();
    _builder.append("Standards-Version: 3.9.3");
    _builder.newLine();
    _builder.append("Homepage: http://www.servicerobotik-ulm.de/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("Package: ");
    String _lowerCase_1 = component.getName().toLowerCase();
    _builder.append(_lowerCase_1);
    _builder.newLineIfNotEmpty();
    _builder.append("Architecture: any");
    _builder.newLine();
    _builder.append("Section: devel");
    _builder.newLine();
    _builder.append("Depends: @SMARTSOFT_DEBS@ libc6 (>=2.13), libgcc1 (>= 1:4.1.1), libstdc++6 (>=4.6)");
    _builder.newLine();
    _builder.append("Recommends: ");
    _builder.newLine();
    _builder.append("Description: SmartSoft Ace ComponentDefinition");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("Package: ");
    String _lowerCase_2 = component.getName().toLowerCase();
    _builder.append(_lowerCase_2);
    _builder.append("-dbg");
    _builder.newLineIfNotEmpty();
    _builder.append("Architecture: any");
    _builder.newLine();
    _builder.append("Section: debug");
    _builder.newLine();
    _builder.append("Priority: extra");
    _builder.newLine();
    _builder.append("Depends: ");
    String _lowerCase_3 = component.getName().toLowerCase();
    _builder.append(_lowerCase_3);
    _builder.append(" (= ${binary:Version}), ${misc:Depends}");
    _builder.newLineIfNotEmpty();
    _builder.append("Recommends: libsmartsoftkernelace (>=2.0.0)");
    _builder.newLine();
    _builder.append("Description: SmartSoft Ace ComponentDefinition - debug symbols");
    _builder.newLine();
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("Package: ");
    String _lowerCase_4 = component.getName().toLowerCase();
    _builder.append(_lowerCase_4);
    _builder.append("-doc");
    _builder.newLineIfNotEmpty();
    _builder.append("Architecture: all");
    _builder.newLine();
    _builder.append("Description: SmartSoft Ace ComponentDefinition - doc files");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianComponentDefinitionRules(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#!/usr/bin/make -f");
    _builder.newLine();
    _builder.newLine();
    String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
    _builder.append(_copyrightWriteOnceHash);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# Uncomment this to turn on verbose mode.");
    _builder.newLine();
    _builder.append("#export DH_VERBOSE=1");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# This has to be exported to make some magic below work.");
    _builder.newLine();
    _builder.append("export DH_OPTIONS");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("%:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("dh $@ ");
    _builder.newLine();
    _builder.newLine();
    _builder.append("override_dh_auto_configure:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("dh_auto_configure -- -DAUTOINSTALL=\"OFF\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append(".PHONY: override_dh_strip");
    _builder.newLine();
    _builder.append("override_dh_strip:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("dh_strip --dbg-package=");
    String _lowerCase = component.getName().toLowerCase();
    _builder.append(_lowerCase, "\t");
    _builder.append("-dbg");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("override_dh_shlibdeps:");
    _builder.newLine();
    _builder.newLine();
    _builder.append("override_dh_install:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("dh_install");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("mkdir $(CURDIR)/debian/");
    String _lowerCase_1 = component.getName().toLowerCase();
    _builder.append(_lowerCase_1, "\t");
    _builder.append("/opt/smartSoftAce/etc");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("cp $(CURDIR)/src-gen/");
    String _name = component.getName();
    _builder.append(_name, "\t");
    _builder.append(".ini.template $(CURDIR)/debian/");
    String _lowerCase_2 = component.getName().toLowerCase();
    _builder.append(_lowerCase_2, "\t");
    _builder.append("/opt/smartSoftAce/etc/");
    String _name_1 = component.getName();
    _builder.append(_name_1, "\t");
    _builder.append(".ini");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianComponentDefinitionInstallBIN(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("usr/bin/");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append(" opt/smartSoftAce/bin");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence generateDebianComponentDefinitionInstallDOC(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#TODO");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianComponentDefinitionCopyright(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Format: http://dep.debian.net/deps/dep5");
    _builder.newLine();
    _builder.append("Upstream-Name: ");
    String _name = component.getName();
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    _builder.append("Source: http://sourceforge.net/projects/smartsoft-ace/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("Files: debian/*");
    _builder.newLine();
    _builder.append("Copyright: <years> <put author\'s name and email here>");
    _builder.newLine();
    _builder.append("           ");
    _builder.append("<years> <likewise for another author>");
    _builder.newLine();
    _builder.append("License: <your SPDX license string>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# Please also look if there are files or directories which have a");
    _builder.newLine();
    _builder.append("# different copyright/license attached and list them here.");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianComponentDefinitionChangelog(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _lowerCase = component.getName().toLowerCase();
    _builder.append(_lowerCase);
    _builder.append(" (1.0.0) unstable; urgency=low");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("  ");
    _builder.append("* Initial release");
    _builder.newLine();
    _builder.newLine();
    _builder.append(" ");
    _builder.append("-- SmartMDSDToolchain <mail@unknown>  ");
    String _currentSystemDate = this.getCurrentSystemDate();
    _builder.append(_currentSystemDate, " ");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence generateDebianComponentDefinitionCompat(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("8");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateDebianComponentDefinitionFormat(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("3.0 (native)");
    _builder.newLine();
    return _builder;
  }
  
  private String getCurrentSystemDate() {
    SimpleDateFormat dateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
    Calendar cal = Calendar.getInstance();
    return dateFormat.format(cal.getTime());
  }
  
  public CharSequence generateCMakeMixedPortIncludes(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<ComponentGeneratorExtension, String> _function = (ComponentGeneratorExtension it) -> {
        return it.getExtensionName(component);
      };
      List<ComponentGeneratorExtension> _sortBy = IterableExtensions.<ComponentGeneratorExtension, String>sortBy(this._componentGenHelpers.getComponentGeneratorExtensions(), _function);
      for(final ComponentGeneratorExtension ext : _sortBy) {
        _builder.append("# includes for ");
        String _extensionName = ext.getExtensionName(component);
        _builder.append(_extensionName);
        _builder.newLineIfNotEmpty();
        CharSequence _cMakeIncludes = ext.getCMakeIncludes(component);
        _builder.append(_cMakeIncludes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence generateCMakeMixedPortTargetConfigs(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<ComponentGeneratorExtension, String> _function = (ComponentGeneratorExtension it) -> {
        return it.getExtensionName(component);
      };
      List<ComponentGeneratorExtension> _sortBy = IterableExtensions.<ComponentGeneratorExtension, String>sortBy(this._componentGenHelpers.getComponentGeneratorExtensions(), _function);
      for(final ComponentGeneratorExtension ext : _sortBy) {
        _builder.append("# target configurations for ");
        String _extensionName = ext.getExtensionName(component);
        _builder.append(_extensionName);
        _builder.newLineIfNotEmpty();
        CharSequence _cMakeTargetConfiguration = ext.getCMakeTargetConfiguration(component);
        _builder.append(_cMakeTargetConfiguration);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
      }
    }
    return _builder;
  }
}
