/**
 * Copyright (c) 2013 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ActivityExtension;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AnswerPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPortLink;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestPort;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationMasterPort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.PrivateOperationMode;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.PublicOperationMode;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.ActivationConstraints;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultInputTrigger;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultPeriodicTimer;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultTrigger;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.MixedPortROS;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.MixedPortYARP;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.ACE_SmartSoft;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class SmartComponent {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private SmartIniParameter _smartIniParameter;
  
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  @Inject
  @Extension
  private ComponentGenHelpers _componentGenHelpers;
  
  @Inject
  @Extension
  private SmartTask _smartTask;
  
  @Inject
  @Extension
  private SmartInputHandler _smartInputHandler;
  
  @Inject
  @Extension
  private SmartQueryHandler _smartQueryHandler;
  
  @Inject
  @Extension
  private SmartComponentPortFactory _smartComponentPortFactory;
  
  @Inject
  @Extension
  private SmartComponentExtension _smartComponentExtension;
  
  public String getCompImplHeaderFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Impl.hh");
    return _builder.toString();
  }
  
  public String getCompImplSourceFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Impl.cc");
    return _builder.toString();
  }
  
  public String getCompHeaderFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append(".hh");
    return _builder.toString();
  }
  
  public String getCompSourceFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append(".cc");
    return _builder.toString();
  }
  
  public String getCoreUserHeaderFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Core.hh");
    return _builder.toString();
  }
  
  public String getCoreUserSourceFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Core.cc");
    return _builder.toString();
  }
  
  public String getComponentDefinitionSingletonShortcut() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("COMP");
    return _builder.toString();
  }
  
  public String getCoreName(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Core");
    return _builder.toString();
  }
  
  public String getSingletonName(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("_");
    String _firstLower = StringExtensions.toFirstLower(component.getName());
    _builder.append(_firstLower);
    return _builder.toString();
  }
  
  public String getParameterIniFileName(final ComponentDefinition comp) {
    String _name = comp.getName();
    return (_name + ".ini.head");
  }
  
  public CharSequence MainFileContent(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.append("#include \"");
    String _compHeaderFilename = this.getCompHeaderFilename(component);
    _builder.append(_compHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("int main(int argc, char *argv[])");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout << \"main...\\n\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// initialize component infrastructure (loading ini-file, creating ports, tasks, etc.)");
    _builder.newLine();
    _builder.append("\t");
    String _name = component.getName();
    _builder.append(_name, "\t");
    _builder.append("::instance()->init(argc, argv);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// run component infrastructure until the component is commanded to shutdown");
    _builder.newLine();
    _builder.append("\t");
    String _name_1 = component.getName();
    _builder.append(_name_1, "\t");
    _builder.append("::instance()->run();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// clean-up component\'s internal resources (deleting ports, tasks, etc.)");
    _builder.newLine();
    _builder.append("\t");
    String _name_2 = component.getName();
    _builder.append(_name_2, "\t");
    _builder.append("::instance()->fini();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// destroy the component\'s singleton");
    _builder.newLine();
    _builder.append("\t");
    String _name_3 = component.getName();
    _builder.append(_name_3, "\t");
    _builder.append("::deleteInstance();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::cout << \"... main() end. return 0.\" << std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence CompImplHeaderFileContent(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = component.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("IMPL_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = component.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("IMPL_HH");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <chrono>");
    _builder.newLine();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("class ");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Impl : public SmartACE::SmartComponent {");
    _builder.newLineIfNotEmpty();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _name_1 = component.getName();
    _builder.append(_name_1, "\t");
    _builder.append("Impl(const std::string &componentName, int & argc, char ** argv);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _name_2 = component.getName();
    _builder.append(_name_2, "\t");
    _builder.append("Impl(const std::string &componentName, int & argc, char ** argv, const ACE_Sched_Params &sched_params);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _name_3 = component.getName();
    _builder.append(_name_3, "\t");
    _builder.append("Impl();");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int startComponentInfrastructure();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void stopComponentInfrastructure(const std::chrono::steady_clock::duration &timeoutTime=std::chrono::seconds(2));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void cleanUpComponentResources();");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence CompImplSourceFileContent(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _compImplHeaderFilename = this.getCompImplHeaderFilename(component);
    _builder.append(_compImplHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Impl::");
    String _name_1 = component.getName();
    _builder.append(_name_1);
    _builder.append("Impl(const std::string &componentName, int & argc, char ** argv)");
    _builder.newLineIfNotEmpty();
    _builder.append(":\tSmartACE::SmartComponent(componentName, argc, argv)");
    _builder.newLine();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    String _name_2 = component.getName();
    _builder.append(_name_2);
    _builder.append("Impl::");
    String _name_3 = component.getName();
    _builder.append(_name_3);
    _builder.append("Impl(const std::string &componentName, int & argc, char ** argv, const ACE_Sched_Params &sched_params)");
    _builder.newLineIfNotEmpty();
    _builder.append(":\tSmartACE::SmartComponent(componentName, argc, argv, NULL, sched_params)");
    _builder.newLine();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    String _name_4 = component.getName();
    _builder.append(_name_4);
    _builder.append("Impl::~");
    String _name_5 = component.getName();
    _builder.append(_name_5);
    _builder.append("Impl() ");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int ");
    String _name_6 = component.getName();
    _builder.append(_name_6);
    _builder.append("Impl::startComponentInfrastructure(void)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// open thread for managing all server-initiated-disconnects in this component");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("srvInitDiscHandler.start();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// if meanwile strg+c was called -> return immediatelly, without waiting on substate or reactor");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(!first_call_of_handle_signal) return -1;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("componentIsRunning = true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _name_7 = component.getName();
    _builder.append(_name_7);
    _builder.append("Impl::stopComponentInfrastructure(const std::chrono::steady_clock::duration &timeoutTime)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this->signalSmartTasksToStop(timeoutTime);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("void ");
    String _name_8 = component.getName();
    _builder.append(_name_8);
    _builder.append("Impl::cleanUpComponentResources()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this->cleanUpInternalResources();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence CompHeaderFileContent(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = component.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = component.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <map>");
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.append("#include \"smartQueryServerTaskTrigger_T.h\"");
    _builder.newLine();
    _builder.append("#include \"");
    String _coreUserHeaderFilename = this.getCoreUserHeaderFilename(component);
    _builder.append(_coreUserHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _portFactoryInterfaceFilename = this._smartComponentPortFactory.getPortFactoryInterfaceFilename(component);
    _builder.append(_portFactoryInterfaceFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _componentExtensionHeaderFilename = this._smartComponentExtension.getComponentExtensionHeaderFilename(component);
    _builder.append(_componentExtensionHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// forward declarations");
    _builder.newLine();
    _builder.append("class ");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("PortFactoryInterface;");
    _builder.newLineIfNotEmpty();
    _builder.append("class ");
    String _name_1 = component.getName();
    _builder.append(_name_1);
    _builder.append("Extension;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      final Function1<ComponentGeneratorExtension, String> _function = (ComponentGeneratorExtension it) -> {
        return it.getExtensionName(component);
      };
      List<ComponentGeneratorExtension> _sortBy = IterableExtensions.<ComponentGeneratorExtension, String>sortBy(this._componentGenHelpers.getComponentGeneratorExtensions(), _function);
      for(final ComponentGeneratorExtension ext : _sortBy) {
        _builder.append("// includes for ");
        String _extensionName = ext.getExtensionName(component);
        _builder.append(_extensionName);
        _builder.newLineIfNotEmpty();
        CharSequence _headerIncludes = ext.getHeaderIncludes(component);
        _builder.append(_headerIncludes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("// include communication objects");
    _builder.newLine();
    {
      final Function1<CommunicationObject, String> _function_1 = (CommunicationObject it) -> {
        return it.getName();
      };
      List<CommunicationObject> _sortBy_1 = IterableExtensions.<CommunicationObject, String>sortBy(ComponentDefinitionModelUtility.getAllCommObjects(component), _function_1);
      for(final CommunicationObject obj : _sortBy_1) {
        _builder.append("#include <");
        CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(obj);
        _builder.append(_userClassHeaderFileNameFQN);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("#include <");
        CharSequence _serailizationHeaderFileNameFQN = this._commObjectGenHelpers.getSerailizationHeaderFileNameFQN(obj);
        _builder.append(_serailizationHeaderFileNameFQN);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("// include tasks");
    _builder.newLine();
    {
      final Function1<Activity, String> _function_2 = (Activity e) -> {
        return e.getName();
      };
      List<Activity> _sortBy_2 = IterableExtensions.<Activity, String>sortBy(ComponentDefinitionModelUtility.getActivities(component), _function_2);
      for(final Activity task : _sortBy_2) {
        _builder.append("#include \"");
        String _TaskUserHeaderFileName = this._smartTask.TaskUserHeaderFileName(task);
        _builder.append(_TaskUserHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("// include UpcallManagers");
    _builder.newLine();
    {
      final Function1<InputPort, String> _function_3 = (InputPort it) -> {
        return it.getName();
      };
      List<InputPort> _sortBy_3 = IterableExtensions.<InputPort, String>sortBy(ComponentDefinitionModelUtility.getInputPorts(component), _function_3);
      for(final InputPort input : _sortBy_3) {
        _builder.append("#include \"");
        String _UpcallManagerHeaderFileName = this._smartInputHandler.UpcallManagerHeaderFileName(input);
        _builder.append(_UpcallManagerHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("// include input-handler(s)");
    _builder.newLine();
    {
      final Function1<InputHandler, String> _function_4 = (InputHandler e) -> {
        return e.getName();
      };
      List<InputHandler> _sortBy_4 = IterableExtensions.<InputHandler, String>sortBy(ComponentDefinitionModelUtility.getInputHandlers(component), _function_4);
      for(final InputHandler handler : _sortBy_4) {
        _builder.append("#include \"");
        String _InputHandlerUserHeaderFileName = this._smartInputHandler.InputHandlerUserHeaderFileName(handler);
        _builder.append(_InputHandlerUserHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("// include request-handler(s)");
    _builder.newLine();
    {
      final Function1<RequestHandler, String> _function_5 = (RequestHandler e) -> {
        return e.getName();
      };
      List<RequestHandler> _sortBy_5 = IterableExtensions.<RequestHandler, String>sortBy(ComponentDefinitionModelUtility.getRequestHandlers(component), _function_5);
      for(final RequestHandler handler_1 : _sortBy_5) {
        _builder.append("#include \"");
        String _QueryServerHandlerUserHeaderFileName = this._smartQueryHandler.QueryServerHandlerUserHeaderFileName(handler_1);
        _builder.append(_QueryServerHandlerUserHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("// include handler");
    _builder.newLine();
    _builder.append("#include \"CompHandler.hh\"");
    _builder.newLine();
    _builder.newLine();
    {
      Boolean _hasParameters = this._componentGenHelpers.hasParameters(component);
      if ((_hasParameters).booleanValue()) {
        _builder.append("#include \"ParameterStateStruct.hh\"");
        _builder.newLine();
        _builder.append("#include \"ParameterUpdateHandler.hh\"");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("#include \"SmartStateChangeHandler.hh\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#define ");
    String _componentDefinitionSingletonShortcut = this.getComponentDefinitionSingletonShortcut();
    _builder.append(_componentDefinitionSingletonShortcut);
    _builder.append(" ");
    String _name_2 = component.getName();
    _builder.append(_name_2);
    _builder.append("::instance()");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("class ");
    String _name_3 = component.getName();
    _builder.append(_name_3);
    _builder.append(" : public ");
    String _coreName = this.getCoreName(component);
    _builder.append(_coreName);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("private:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static ");
    String _name_4 = component.getName();
    _builder.append(_name_4, "\t");
    _builder.append(" *");
    String _singletonName = this.getSingletonName(component);
    _builder.append(_singletonName, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// constructor");
    _builder.newLine();
    _builder.append("\t");
    String _name_5 = component.getName();
    _builder.append(_name_5, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// copy-constructor");
    _builder.newLine();
    _builder.append("\t");
    String _name_6 = component.getName();
    _builder.append(_name_6, "\t");
    _builder.append("(const ");
    String _name_7 = component.getName();
    _builder.append(_name_7, "\t");
    _builder.append("& cc);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destructor");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("~");
    String _name_8 = component.getName();
    _builder.append(_name_8, "\t");
    _builder.append("() { };");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// load parameter from ini file");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void loadParameter(int argc, char* argv[]);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// instantiate comp-handler");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("CompHandler compHandler;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// helper method that maps a string-name to an according TaskTriggerSubject");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Smart::TaskTriggerSubject* getInputTaskTriggerFromString(const std::string &client);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// internal map storing the different port-creation factories (that internally map to specific middleware implementations)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::map<std::string, ");
    String _name_9 = component.getName();
    _builder.append(_name_9, "\t");
    _builder.append("PortFactoryInterface*> portFactoryRegistry;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// internal map storing various extensions of this component class");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::map<std::string, ");
    String _name_10 = component.getName();
    _builder.append(_name_10, "\t");
    _builder.append("Extension*> componentExtensionRegistry;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    {
      Boolean _hasParameters_1 = this._componentGenHelpers.hasParameters(component);
      if ((_hasParameters_1).booleanValue()) {
        _builder.append("\t");
        _builder.append("ParameterStateStruct getGlobalState() const");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return paramHandler.getGlobalState();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ParameterStateStruct getParameters() const");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return paramHandler.getGlobalState();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// define tasks");
    _builder.newLine();
    {
      final Function1<Activity, String> _function_6 = (Activity e) -> {
        return e.getName();
      };
      List<Activity> _sortBy_6 = IterableExtensions.<Activity, String>sortBy(ComponentDefinitionModelUtility.getActivities(component), _function_6);
      for(final Activity task_1 : _sortBy_6) {
        _builder.append("\t");
        _builder.append("Smart::TaskTriggerSubject* ");
        String _nameInstance = this._componentGenHelpers.nameInstance(task_1);
        _builder.append(_nameInstance, "\t");
        _builder.append("Trigger;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _nameClass = this._componentGenHelpers.nameClass(task_1);
        _builder.append(_nameClass, "\t");
        _builder.append(" *");
        String _nameInstance_1 = this._componentGenHelpers.nameInstance(task_1);
        _builder.append(_nameInstance_1, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// define input-ports");
    _builder.newLine();
    {
      final Function1<InputPort, String> _function_7 = (InputPort it) -> {
        return it.getName();
      };
      List<InputPort> _sortBy_7 = IterableExtensions.<InputPort, String>sortBy(ComponentDefinitionModelUtility.getInputPorts(component), _function_7);
      for(final InputPort input_1 : _sortBy_7) {
        _builder.append("\t");
        _builder.append("// InputPort ");
        String _name_11 = input_1.getName();
        _builder.append(_name_11, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _portDefinition = this._componentGenHelpers.getPortDefinition(input_1);
        _builder.append(_portDefinition, "\t");
        _builder.append(" *");
        String _nameInstance_2 = this._componentGenHelpers.nameInstance(input_1);
        _builder.append(_nameInstance_2, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Smart::InputTaskTrigger<");
        CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject(input_1);
        _builder.append(_inputHandlerCommObject, "\t");
        _builder.append("> *");
        String _nameInstance_3 = this._componentGenHelpers.nameInstance(input_1);
        _builder.append(_nameInstance_3, "\t");
        _builder.append("InputTaskTrigger;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _nameClass_1 = this._componentGenHelpers.nameClass(input_1);
        _builder.append(_nameClass_1, "\t");
        _builder.append("UpcallManager *");
        String _nameInstance_4 = this._componentGenHelpers.nameInstance(input_1);
        _builder.append(_nameInstance_4, "\t");
        _builder.append("UpcallManager;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// define request-ports");
    _builder.newLine();
    {
      final Function1<RequestPort, String> _function_8 = (RequestPort it) -> {
        return it.getName();
      };
      List<RequestPort> _sortBy_8 = IterableExtensions.<RequestPort, String>sortBy(ComponentDefinitionModelUtility.getRequestPorts(component), _function_8);
      for(final RequestPort request : _sortBy_8) {
        _builder.append("\t");
        String _portDefinition_1 = this._componentGenHelpers.getPortDefinition(request);
        _builder.append(_portDefinition_1, "\t");
        _builder.append(" *");
        String _nameInstance_5 = this._componentGenHelpers.nameInstance(request);
        _builder.append(_nameInstance_5, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// define input-handler");
    _builder.newLine();
    {
      final Function1<InputHandler, String> _function_9 = (InputHandler it) -> {
        return it.getName();
      };
      List<InputHandler> _sortBy_9 = IterableExtensions.<InputHandler, String>sortBy(ComponentDefinitionModelUtility.getInputHandlers(component), _function_9);
      for(final InputHandler handler_2 : _sortBy_9) {
        _builder.append("\t");
        String _nameClass_2 = this._componentGenHelpers.nameClass(handler_2);
        _builder.append(_nameClass_2, "\t");
        _builder.append(" *");
        String _nameInstance_6 = this._componentGenHelpers.nameInstance(handler_2);
        _builder.append(_nameInstance_6, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// define output-ports");
    _builder.newLine();
    {
      final Function1<OutputPort, String> _function_10 = (OutputPort it) -> {
        return it.getName();
      };
      List<OutputPort> _sortBy_10 = IterableExtensions.<OutputPort, String>sortBy(ComponentDefinitionModelUtility.getOutputPorts(component), _function_10);
      for(final OutputPort output : _sortBy_10) {
        _builder.append("\t");
        String _portDefinition_2 = this._componentGenHelpers.getPortDefinition(output);
        _builder.append(_portDefinition_2, "\t");
        _builder.append(" *");
        String _nameInstance_7 = this._componentGenHelpers.nameInstance(output);
        _builder.append(_nameInstance_7, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        {
          boolean _isEventServer = this._componentGenHelpers.isEventServer(output);
          if (_isEventServer) {
            _builder.append("\t");
            _builder.append("std::shared_ptr<Smart::IEventTestHandler<");
            CharSequence _commObjectCppList = this._componentGenHelpers.getCommObjectCppList(output, Boolean.valueOf(true));
            _builder.append(_commObjectCppList, "\t");
            _builder.append(">> ");
            String _nameInstance_8 = this._componentGenHelpers.nameInstance(output);
            _builder.append(_nameInstance_8, "\t");
            _builder.append("EventTestHandler;");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// define answer-ports");
    _builder.newLine();
    {
      final Function1<AnswerPort, String> _function_11 = (AnswerPort it) -> {
        return it.getName();
      };
      List<AnswerPort> _sortBy_11 = IterableExtensions.<AnswerPort, String>sortBy(ComponentDefinitionModelUtility.getAnswerPorts(component), _function_11);
      for(final AnswerPort answer : _sortBy_11) {
        _builder.append("\t");
        String _portDefinition_3 = this._componentGenHelpers.getPortDefinition(answer);
        _builder.append(_portDefinition_3, "\t");
        _builder.append(" *");
        String _nameInstance_9 = this._componentGenHelpers.nameInstance(answer);
        _builder.append(_nameInstance_9, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Smart::QueryServerTaskTrigger<");
        CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject(answer);
        _builder.append(_inputHandlerCommObject_1, "\t");
        _builder.append("> *");
        String _nameInstance_10 = this._componentGenHelpers.nameInstance(answer);
        _builder.append(_nameInstance_10, "\t");
        _builder.append("InputTaskTrigger;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// define request-handlers");
    _builder.newLine();
    {
      final Function1<RequestHandler, String> _function_12 = (RequestHandler it) -> {
        return it.getName();
      };
      List<RequestHandler> _sortBy_12 = IterableExtensions.<RequestHandler, String>sortBy(ComponentDefinitionModelUtility.getRequestHandlers(component), _function_12);
      for(final RequestHandler handler_3 : _sortBy_12) {
        _builder.append("\t");
        String _nameClass_3 = this._componentGenHelpers.nameClass(handler_3);
        _builder.append(_nameClass_3, "\t");
        _builder.append(" *");
        String _nameInstance_11 = this._componentGenHelpers.nameInstance(handler_3);
        _builder.append(_nameInstance_11, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      final Function1<ComponentGeneratorExtension, String> _function_13 = (ComponentGeneratorExtension it) -> {
        return it.getExtensionName(component);
      };
      List<ComponentGeneratorExtension> _sortBy_13 = IterableExtensions.<ComponentGeneratorExtension, String>sortBy(this._componentGenHelpers.getComponentGeneratorExtensions(), _function_13);
      for(final ComponentGeneratorExtension ext_1 : _sortBy_13) {
        _builder.append("\t");
        _builder.append("// definitions of ");
        String _extensionName_1 = ext_1.getExtensionName(component);
        _builder.append(_extensionName_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _classMemberDefinition = ext_1.getClassMemberDefinition(component);
        _builder.append(_classMemberDefinition, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// define default slave ports");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("SmartACE::StateSlave *stateSlave;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("SmartStateChangeHandler *stateChangeHandler;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("SmartACE::WiringSlave *wiringSlave;");
    _builder.newLine();
    {
      Boolean _hasParameters_2 = this._componentGenHelpers.hasParameters(component);
      if ((_hasParameters_2).booleanValue()) {
        _builder.append("\t");
        _builder.append("ParamUpdateHandler paramHandler;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SmartACE::ParameterSlave *param;");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      final Function1<AbstractComponentElement, Boolean> _function_14 = (AbstractComponentElement it) -> {
        return Boolean.valueOf((it instanceof CoordinationMasterPort));
      };
      boolean _exists = IterableExtensions.<AbstractComponentElement>exists(component.getElements(), _function_14);
      if (_exists) {
        _builder.append("\t");
        _builder.append("// define master ports");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SmartACE::StateMaster *stateMaster;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SmartACE::ParameterMaster *paramMaster;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SmartACE::WiringMaster *wiringMaster;");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// this method is used to register different PortFactory classes (one for each supported middleware framework)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void addPortFactory(const std::string &name, ");
    String _name_12 = component.getName();
    _builder.append(_name_12, "\t");
    _builder.append("PortFactoryInterface *portFactory);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("SmartACE::SmartComponent* getComponentImpl();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// this method is used to register different component-extension classes");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void addExtension(");
    String _name_13 = component.getName();
    _builder.append(_name_13, "\t");
    _builder.append("Extension *extension);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// this method allows to access the registered component-extensions (automatically converting to the actuall implementation type)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("template <typename T>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("T* getExtension(const std::string &name) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("auto it = componentExtensionRegistry.find(name);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if(it != componentExtensionRegistry.end()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return dynamic_cast<T*>(it->second);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// initialize component\'s internal members");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void init(int argc, char *argv[]);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// execute the component\'s infrastructure");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void run();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// clean-up component\'s resources");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void fini();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// call this method to set the overall component into the Alive state (i.e. component is then ready to operate)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void setStartupFinished();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// connect all component\'s client ports");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Smart::StatusCode connectAndStartAllServices();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// start all assocuated Activities");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void startAllTasks();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// start all associated timers");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void startAllTimers();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_15 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_14 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllClientPorts(component), _function_15);
      for(final ComponentPort client : _sortBy_14) {
        _builder.append("\t");
        _builder.append("Smart::StatusCode connect");
        String _nameClass_4 = this._componentGenHelpers.nameClass(client);
        _builder.append(_nameClass_4, "\t");
        _builder.append("(const std::string &serverName, const std::string &serviceName);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// return singleton instance");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static ");
    String _nameClass_5 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_5, "\t");
    _builder.append("* instance()");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if(");
    String _singletonName_1 = this.getSingletonName(component);
    _builder.append(_singletonName_1, "\t\t");
    _builder.append(" == 0) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    String _singletonName_2 = this.getSingletonName(component);
    _builder.append(_singletonName_2, "\t\t\t");
    _builder.append(" = new ");
    String _nameClass_6 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_6, "\t\t\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    String _singletonName_3 = this.getSingletonName(component);
    _builder.append(_singletonName_3, "\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static void deleteInstance() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if(");
    String _singletonName_4 = this.getSingletonName(component);
    _builder.append(_singletonName_4, "\t\t");
    _builder.append(" != 0) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("delete ");
    String _singletonName_5 = this.getSingletonName(component);
    _builder.append(_singletonName_5, "\t\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _CreateIniStruct = this._smartIniParameter.CreateIniStruct(component);
    _builder.append(_CreateIniStruct, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  private boolean isVirtualElement(final AbstractComponentElement element) {
    if ((((((element instanceof CoordinationSlavePort) || (element instanceof CoordinationMasterPort)) || (element instanceof ComponentParametersRef)) || (element instanceof MixedPortROS)) || (element instanceof MixedPortYARP))) {
      return true;
    }
    return false;
  }
  
  public CharSequence CompSourceFileContent(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _compHeaderFilename = this.getCompHeaderFilename(component);
    _builder.append(_compHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"smartTimedTaskTrigger.h\"");
    _builder.newLine();
    _builder.append("//FIXME: implement logging");
    _builder.newLine();
    _builder.append("//#include \"smartGlobalLogger.hh\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// the ace port-factory is used as a default port-mapping");
    _builder.newLine();
    _builder.append("#include \"");
    String _acePortFactoryHeaderFilename = this._smartComponentPortFactory.getAcePortFactoryHeaderFilename(component);
    _builder.append(_acePortFactoryHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      final Function1<ComponentPort, Boolean> _function = (ComponentPort it) -> {
        return Boolean.valueOf(this._componentGenHelpers.isEventServer(it));
      };
      final Function1<ComponentPort, String> _function_1 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy = IterableExtensions.<ComponentPort, String>sortBy(IterableExtensions.<ComponentPort>filter(ComponentDefinitionModelUtility.getPorts(component), _function), _function_1);
      for(final ComponentPort initiator : _sortBy) {
        _builder.append("#include \"");
        String _nameClass = this._componentGenHelpers.nameClass(initiator);
        _builder.append(_nameClass);
        _builder.append("EventTestHandler.hh\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("// initialize static singleton pointer to zero");
    _builder.newLine();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("* ");
    String _name_1 = component.getName();
    _builder.append(_name_1);
    _builder.append("::");
    String _singletonName = this.getSingletonName(component);
    _builder.append(_singletonName);
    _builder.append(" = 0;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// constructor");
    _builder.newLine();
    String _name_2 = component.getName();
    _builder.append(_name_2);
    _builder.append("::");
    String _name_3 = component.getName();
    _builder.append(_name_3);
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout << \"constructor of ");
    String _name_4 = component.getName();
    _builder.append(_name_4, "\t");
    _builder.append("\\n\";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// set all pointer members to NULL");
    _builder.newLine();
    {
      final Function1<AbstractComponentElement, String> _function_2 = (AbstractComponentElement e) -> {
        return this._componentGenHelpers.nameOriginal(e);
      };
      List<AbstractComponentElement> _sortBy_1 = IterableExtensions.<AbstractComponentElement, String>sortBy(component.getElements(), _function_2);
      for(final AbstractComponentElement element : _sortBy_1) {
        _builder.append("\t");
        {
          boolean _isVirtualElement = this.isVirtualElement(element);
          boolean _equals = (_isVirtualElement == true);
          if (_equals) {
            _builder.append("//");
          }
        }
        String _nameInstance = this._componentGenHelpers.nameInstance(element);
        _builder.append(_nameInstance, "\t");
        _builder.append(" = NULL;");
        _builder.newLineIfNotEmpty();
        {
          if ((element instanceof InputPort)) {
            _builder.append("\t");
            String _nameInstance_1 = this._componentGenHelpers.nameInstance(element);
            _builder.append(_nameInstance_1, "\t");
            _builder.append("InputTaskTrigger = NULL;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _nameInstance_2 = this._componentGenHelpers.nameInstance(element);
            _builder.append(_nameInstance_2, "\t");
            _builder.append("UpcallManager = NULL;");
            _builder.newLineIfNotEmpty();
          } else {
            if ((element instanceof Activity)) {
              _builder.append("\t");
              String _nameInstance_3 = this._componentGenHelpers.nameInstance(element);
              _builder.append(_nameInstance_3, "\t");
              _builder.append("Trigger = NULL;");
              _builder.newLineIfNotEmpty();
            } else {
              if ((element instanceof AnswerPort)) {
                _builder.append("\t");
                String _nameInstance_4 = this._componentGenHelpers.nameInstance(element);
                _builder.append(_nameInstance_4, "\t");
                _builder.append("InputTaskTrigger = NULL;");
                _builder.newLineIfNotEmpty();
              } else {
                boolean _isEventServer = this._componentGenHelpers.isEventServer(element);
                if (_isEventServer) {
                  _builder.append("\t");
                  String _nameInstance_5 = this._componentGenHelpers.nameInstance(element);
                  _builder.append(_nameInstance_5, "\t");
                  _builder.append("EventTestHandler = nullptr; ");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("stateChangeHandler = NULL;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("stateSlave = NULL;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("wiringSlave = NULL;");
    _builder.newLine();
    _builder.append("\t");
    {
      Boolean _hasParameters = this._componentGenHelpers.hasParameters(component);
      if ((_hasParameters).booleanValue()) {
        _builder.append("param = NULL;");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      final Function1<AbstractComponentElement, Boolean> _function_3 = (AbstractComponentElement it) -> {
        return Boolean.valueOf((it instanceof CoordinationMasterPort));
      };
      boolean _exists = IterableExtensions.<AbstractComponentElement>exists(component.getElements(), _function_3);
      if (_exists) {
        _builder.append("\t");
        _builder.append("stateMaster = NULL;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("paramMaster = NULL;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wiringMaster = NULL;");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _iniParametersConstructor = this._smartIniParameter.iniParametersConstructor(component);
    _builder.append(_iniParametersConstructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _name_5 = component.getName();
    _builder.append(_name_5);
    _builder.append("::addPortFactory(const std::string &name, ");
    String _name_6 = component.getName();
    _builder.append(_name_6);
    _builder.append("PortFactoryInterface *portFactory)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("portFactoryRegistry[name] = portFactory;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _name_7 = component.getName();
    _builder.append(_name_7);
    _builder.append("::addExtension(");
    String _name_8 = component.getName();
    _builder.append(_name_8);
    _builder.append("Extension *extension)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("componentExtensionRegistry[extension->getName()] = extension;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("SmartACE::SmartComponent* ");
    String _name_9 = component.getName();
    _builder.append(_name_9);
    _builder.append("::getComponentImpl()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return dynamic_cast<");
    String _name_10 = component.getName();
    _builder.append(_name_10, "\t");
    _builder.append("AcePortFactory*>(portFactoryRegistry[\"ACE_SmartSoft\"])->getComponentImpl();");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Notify the component that setup/initialization is finished.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* You may call this function from anywhere in the component.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Set component\'s internal lifecycle state automaton (if any) into ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Alive mode (from here on the component is ready to provide its services)");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("void ");
    String _name_11 = component.getName();
    _builder.append(_name_11);
    _builder.append("::setStartupFinished() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("stateSlave->setWaitState(\"Alive\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout << \"ComponentDefinition initialization/startup finished.\" << std::endl;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_4 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_2 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllClientPorts(component), _function_4);
      for(final ComponentPort client : _sortBy_2) {
        _builder.append("Smart::StatusCode ");
        String _name_12 = component.getName();
        _builder.append(_name_12);
        _builder.append("::connect");
        String _nameClass_1 = this._componentGenHelpers.nameClass(client);
        _builder.append(_nameClass_1);
        _builder.append("(const std::string &serverName, const std::string &serviceName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Smart::StatusCode status;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        {
          boolean _isOptional = this._smartIniParameter.isOptional(client);
          if (_isOptional) {
            _builder.append("\t");
            _builder.append("if(connections.");
            String _nameInstance_6 = this._componentGenHelpers.nameInstance(client);
            _builder.append(_nameInstance_6, "\t");
            _builder.append(".initialConnect == false) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return Smart::SMART_OK;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("std::cout << \"connecting to: \" << serverName << \"; \" << serviceName << std::endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("status = ");
        String _nameInstance_7 = this._componentGenHelpers.nameInstance(client);
        _builder.append(_nameInstance_7, "\t");
        _builder.append("->connect(serverName, serviceName);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("while(status != Smart::SMART_OK)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ACE_OS::sleep(ACE_Time_Value(0,500000));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("status = COMP->");
        String _nameInstance_8 = this._componentGenHelpers.nameInstance(client);
        _builder.append(_nameInstance_8, "\t\t");
        _builder.append("->connect(serverName, serviceName);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::cout << \"connected.\\n\";");
        _builder.newLine();
        {
          boolean _isSubscriber = this._componentGenHelpers.isSubscriber(client);
          if (_isSubscriber) {
            _builder.append("\t");
            String _nameInstance_9 = this._componentGenHelpers.nameInstance(client);
            _builder.append(_nameInstance_9, "\t");
            _builder.append("->subscribe(connections.");
            String _nameInstance_10 = this._componentGenHelpers.nameInstance(client);
            _builder.append(_nameInstance_10, "\t");
            _builder.append(".interval);");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("return status;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* First connect ALL client ports contained in this component, then start all services:");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* activate state, push, etc...");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("Smart::StatusCode ");
    String _name_13 = component.getName();
    _builder.append(_name_13);
    _builder.append("::connectAndStartAllServices() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Smart::StatusCode status = Smart::SMART_OK;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_5 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_3 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllClientPorts(component), _function_5);
      for(final ComponentPort client_1 : _sortBy_3) {
        _builder.append("\t");
        _builder.append("status = connect");
        String _nameClass_2 = this._componentGenHelpers.nameClass(client_1);
        _builder.append(_nameClass_2, "\t");
        _builder.append("(connections.");
        String _nameInstance_11 = this._componentGenHelpers.nameInstance(client_1);
        _builder.append(_nameInstance_11, "\t");
        _builder.append(".serverName, connections.");
        String _nameInstance_12 = this._componentGenHelpers.nameInstance(client_1);
        _builder.append(_nameInstance_12, "\t");
        _builder.append(".serviceName);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(status != Smart::SMART_OK) return status;");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return status;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Start all tasks contained in this component.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("void ");
    String _name_14 = component.getName();
    _builder.append(_name_14);
    _builder.append("::startAllTasks() {");
    _builder.newLineIfNotEmpty();
    {
      final Function1<Activity, String> _function_6 = (Activity e) -> {
        return e.getName();
      };
      List<Activity> _sortBy_4 = IterableExtensions.<Activity, String>sortBy(ComponentDefinitionModelUtility.getActivities(component), _function_6);
      for(final Activity task : _sortBy_4) {
        _builder.append("\t");
        _builder.append("// start task ");
        String _nameOriginal = this._componentGenHelpers.nameOriginal(task);
        _builder.append(_nameOriginal, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(connections.");
        String _nameInstance_13 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_13, "\t");
        _builder.append(".scheduler != \"DEFAULT\") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("ACE_Sched_Params ");
        String _nameInstance_14 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_14, "\t\t");
        _builder.append("_SchedParams(ACE_SCHED_OTHER, ACE_THR_PRI_OTHER_DEF);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if(connections.");
        String _nameInstance_15 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_15, "\t\t");
        _builder.append(".scheduler == \"FIFO\") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        String _nameInstance_16 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_16, "\t\t\t");
        _builder.append("_SchedParams.policy(ACE_SCHED_FIFO);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        String _nameInstance_17 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_17, "\t\t\t");
        _builder.append("_SchedParams.priority(ACE_THR_PRI_FIFO_MIN);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("} else if(connections.");
        String _nameInstance_18 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_18, "\t\t");
        _builder.append(".scheduler == \"RR\") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        String _nameInstance_19 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_19, "\t\t\t");
        _builder.append("_SchedParams.policy(ACE_SCHED_RR);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        String _nameInstance_20 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_20, "\t\t\t");
        _builder.append("_SchedParams.priority(ACE_THR_PRI_RR_MIN);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        String _nameInstance_21 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_21, "\t\t");
        _builder.append("->start(");
        String _nameInstance_22 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_22, "\t\t");
        _builder.append("_SchedParams, connections.");
        String _nameInstance_23 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_23, "\t\t");
        _builder.append(".cpuAffinity);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        String _nameInstance_24 = this._componentGenHelpers.nameInstance(task);
        _builder.append(_nameInstance_24, "\t\t");
        _builder.append("->start();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Start all timers contained in this component");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("void ");
    String _name_15 = component.getName();
    _builder.append(_name_15);
    _builder.append("::startAllTimers() {");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("Smart::TaskTriggerSubject* ");
    String _name_16 = component.getName();
    _builder.append(_name_16);
    _builder.append("::getInputTaskTriggerFromString(const std::string &client)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      final Function1<InputPort, String> _function_7 = (InputPort it) -> {
        return it.getName();
      };
      List<InputPort> _sortBy_5 = IterableExtensions.<InputPort, String>sortBy(ComponentDefinitionModelUtility.getInputPorts(component), _function_7);
      for(final InputPort input : _sortBy_5) {
        _builder.append("\t");
        _builder.append("if(client == \"");
        String _nameOriginal_1 = this._componentGenHelpers.nameOriginal(input);
        _builder.append(_nameOriginal_1, "\t");
        _builder.append("\") return ");
        String _nameInstance_25 = this._componentGenHelpers.nameInstance(input);
        _builder.append(_nameInstance_25, "\t");
        _builder.append("InputTaskTrigger;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return NULL;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _name_17 = component.getName();
    _builder.append(_name_17);
    _builder.append("::init(int argc, char *argv[])");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Smart::StatusCode status;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// load initial parameters from ini-file (if found)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("loadParameter(argc, argv);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    {
      Boolean _hasParameters_1 = this._componentGenHelpers.hasParameters(component);
      if ((_hasParameters_1).booleanValue()) {
        _builder.append("\t\t");
        _builder.append("// print out the actual parameters which are used to initialize the component");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::cout << \" \\nComponentDefinition Initial-Parameters:\\n\" << COMP->getParameters() << std::endl;");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    {
      final Function1<ComponentGeneratorExtension, String> _function_8 = (ComponentGeneratorExtension it) -> {
        return it.getExtensionName(component);
      };
      List<ComponentGeneratorExtension> _sortBy_6 = IterableExtensions.<ComponentGeneratorExtension, String>sortBy(this._componentGenHelpers.getComponentGeneratorExtensions(), _function_8);
      for(final ComponentGeneratorExtension ext : _sortBy_6) {
        _builder.append("\t\t");
        _builder.append("// initializations of ");
        String _extensionName = ext.getExtensionName(component);
        _builder.append(_extensionName, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _classMemberInitialization = ext.getClassMemberInitialization(component);
        _builder.append(_classMemberInitialization, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// initialize all registered port-factories");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for(auto portFactory = portFactoryRegistry.begin(); portFactory != portFactoryRegistry.end(); portFactory++) ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("portFactory->second->initialize(this, argc, argv);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// initialize all registered component-extensions");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for(auto extension = componentExtensionRegistry.begin(); extension != componentExtensionRegistry.end(); extension++) ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("extension->second->initialize(this, argc, argv);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    String _name_18 = component.getName();
    _builder.append(_name_18, "\t\t");
    _builder.append("PortFactoryInterface *acePortFactory = portFactoryRegistry[\"");
    String _simpleName = ACE_SmartSoft.class.getSimpleName();
    _builder.append(_simpleName, "\t\t");
    _builder.append("\"];");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if(acePortFactory == 0) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("std::cerr << \"ERROR: acePortFactory NOT instantiated -> exit(-1)\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("exit(-1);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// this pointer is used for backwards compatibility (deprecated: should be removed as soon as all patterns, including coordination, are moved to port-factory)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("SmartACE::SmartComponent *component = dynamic_cast<");
    String _name_19 = component.getName();
    _builder.append(_name_19, "\t\t");
    _builder.append("AcePortFactory*>(acePortFactory)->getComponentImpl();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cout << \"ComponentDefinition ");
    String _name_20 = component.getName();
    _builder.append(_name_20, "\t\t");
    _builder.append(" is named \" << connections.component.name << std::endl;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if(connections.component.useLogger == true) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("//FIXME: use logging");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("//Smart::LOGGER->openLogFileInFolder(\"data/\"+connections.component.name);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("//Smart::LOGGER->startLogging();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// create event-test handlers (if needed)");
    _builder.newLine();
    {
      final Function1<OutputPort, String> _function_9 = (OutputPort it) -> {
        return it.getName();
      };
      List<OutputPort> _sortBy_7 = IterableExtensions.<OutputPort, String>sortBy(ComponentDefinitionModelUtility.getOutputPorts(component), _function_9);
      for(final OutputPort output : _sortBy_7) {
        {
          boolean _isEventServer_1 = this._componentGenHelpers.isEventServer(output);
          if (_isEventServer_1) {
            _builder.append("\t\t");
            String _nameInstance_26 = this._componentGenHelpers.nameInstance(output);
            _builder.append(_nameInstance_26, "\t\t");
            _builder.append("EventTestHandler = std::make_shared<");
            String _nameClass_3 = this._componentGenHelpers.nameClass(output);
            _builder.append(_nameClass_3, "\t\t");
            _builder.append("EventTestHandler>();");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// create server ports");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// TODO: set minCycleTime from Ini-file");
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_10 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_8 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllServerPorts(component), _function_10);
      for(final ComponentPort server : _sortBy_8) {
        {
          boolean _isEventServer_2 = this._componentGenHelpers.isEventServer(server);
          if (_isEventServer_2) {
            _builder.append("\t\t");
            String _nameInstance_27 = this._componentGenHelpers.nameInstance(server);
            _builder.append(_nameInstance_27, "\t\t");
            _builder.append("EventTestHandler = std::make_shared<");
            String _nameClass_4 = this._componentGenHelpers.nameClass(server);
            _builder.append(_nameClass_4, "\t\t");
            _builder.append("EventTestHandler>();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _nameInstance_28 = this._componentGenHelpers.nameInstance(server);
            _builder.append(_nameInstance_28, "\t\t");
            _builder.append(" = portFactoryRegistry[connections.");
            String _nameInstance_29 = this._componentGenHelpers.nameInstance(server);
            _builder.append(_nameInstance_29, "\t\t");
            _builder.append(".roboticMiddleware]->create");
            String _nameClass_5 = this._componentGenHelpers.nameClass(server);
            _builder.append(_nameClass_5, "\t\t");
            _builder.append("(connections.");
            String _nameInstance_30 = this._componentGenHelpers.nameInstance(server);
            _builder.append(_nameInstance_30, "\t\t");
            _builder.append(".serviceName, ");
            String _nameInstance_31 = this._componentGenHelpers.nameInstance(server);
            _builder.append(_nameInstance_31, "\t\t");
            _builder.append("EventTestHandler);");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t\t");
            String _nameInstance_32 = this._componentGenHelpers.nameInstance(server);
            _builder.append(_nameInstance_32, "\t\t");
            _builder.append(" = portFactoryRegistry[connections.");
            String _nameInstance_33 = this._componentGenHelpers.nameInstance(server);
            _builder.append(_nameInstance_33, "\t\t");
            _builder.append(".roboticMiddleware]->create");
            String _nameClass_6 = this._componentGenHelpers.nameClass(server);
            _builder.append(_nameClass_6, "\t\t");
            _builder.append("(connections.");
            String _nameInstance_34 = this._componentGenHelpers.nameInstance(server);
            _builder.append(_nameInstance_34, "\t\t");
            _builder.append(".serviceName);");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          if ((server instanceof AnswerPort)) {
            _builder.append("\t\t");
            String _nameInstance_35 = this._componentGenHelpers.nameInstance(server);
            _builder.append(_nameInstance_35, "\t\t");
            _builder.append("InputTaskTrigger = new Smart::QueryServerTaskTrigger<");
            CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject(server);
            _builder.append(_inputHandlerCommObject, "\t\t");
            _builder.append(">(");
            String _nameInstance_36 = this._componentGenHelpers.nameInstance(server);
            _builder.append(_nameInstance_36, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// create client ports");
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_11 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_9 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllClientPorts(component), _function_11);
      for(final ComponentPort client_2 : _sortBy_9) {
        _builder.append("\t\t");
        String _nameInstance_37 = this._componentGenHelpers.nameInstance(client_2);
        _builder.append(_nameInstance_37, "\t\t");
        _builder.append(" = portFactoryRegistry[connections.");
        String _nameInstance_38 = this._componentGenHelpers.nameInstance(client_2);
        _builder.append(_nameInstance_38, "\t\t");
        _builder.append(".roboticMiddleware]->create");
        String _nameClass_7 = this._componentGenHelpers.nameClass(client_2);
        _builder.append(_nameClass_7, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// create InputTaskTriggers and UpcallManagers");
    _builder.newLine();
    {
      final Function1<InputPort, String> _function_12 = (InputPort it) -> {
        return it.getName();
      };
      List<InputPort> _sortBy_10 = IterableExtensions.<InputPort, String>sortBy(ComponentDefinitionModelUtility.getInputPorts(component), _function_12);
      for(final InputPort input_1 : _sortBy_10) {
        _builder.append("\t\t");
        String _nameInstance_39 = this._componentGenHelpers.nameInstance(input_1);
        _builder.append(_nameInstance_39, "\t\t");
        _builder.append("InputTaskTrigger = new Smart::InputTaskTrigger<");
        CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject(input_1);
        _builder.append(_inputHandlerCommObject_1, "\t\t");
        _builder.append(">(");
        String _nameInstance_40 = this._componentGenHelpers.nameInstance(input_1);
        _builder.append(_nameInstance_40, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _nameInstance_41 = this._componentGenHelpers.nameInstance(input_1);
        _builder.append(_nameInstance_41, "\t\t");
        _builder.append("UpcallManager = new ");
        String _nameClass_8 = this._componentGenHelpers.nameClass(input_1);
        _builder.append(_nameClass_8, "\t\t");
        _builder.append("UpcallManager(");
        String _nameInstance_42 = this._componentGenHelpers.nameInstance(input_1);
        _builder.append(_nameInstance_42, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// create input-handler");
    _builder.newLine();
    {
      final Function1<InputHandler, String> _function_13 = (InputHandler it) -> {
        return it.getName();
      };
      List<InputHandler> _sortBy_11 = IterableExtensions.<InputHandler, String>sortBy(ComponentDefinitionModelUtility.getInputHandlers(component), _function_13);
      for(final InputHandler handler : _sortBy_11) {
        _builder.append("\t\t");
        String _nameInstance_43 = this._componentGenHelpers.nameInstance(handler);
        _builder.append(_nameInstance_43, "\t\t");
        _builder.append(" = new ");
        String _nameClass_9 = this._componentGenHelpers.nameClass(handler);
        _builder.append(_nameClass_9, "\t\t");
        _builder.append("(");
        String _nameInstance_44 = this._componentGenHelpers.nameInstance(handler.getInputPort());
        _builder.append(_nameInstance_44, "\t\t");
        _builder.append(", connections.");
        String _nameInstance_45 = this._componentGenHelpers.nameInstance(handler);
        _builder.append(_nameInstance_45, "\t\t");
        _builder.append(".prescale);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// create request-handlers");
    _builder.newLine();
    {
      final Function1<RequestHandler, String> _function_14 = (RequestHandler it) -> {
        return it.getName();
      };
      List<RequestHandler> _sortBy_12 = IterableExtensions.<RequestHandler, String>sortBy(ComponentDefinitionModelUtility.getRequestHandlers(component), _function_14);
      for(final RequestHandler handler_1 : _sortBy_12) {
        _builder.append("\t\t");
        String _nameInstance_46 = this._componentGenHelpers.nameInstance(handler_1);
        _builder.append(_nameInstance_46, "\t\t");
        _builder.append(" = new ");
        String _nameClass_10 = this._componentGenHelpers.nameClass(handler_1);
        _builder.append(_nameClass_10, "\t\t");
        _builder.append("(");
        String _nameInstance_47 = this._componentGenHelpers.nameInstance(handler_1.getAnswerPort());
        _builder.append(_nameInstance_47, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// create state pattern");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("stateChangeHandler = new SmartStateChangeHandler();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("stateSlave = new SmartACE::StateSlave(component, stateChangeHandler);");
    _builder.newLine();
    {
      Iterable<CoordinationSlavePort> _filter = Iterables.<CoordinationSlavePort>filter(component.getElements(), CoordinationSlavePort.class);
      for(final CoordinationSlavePort slave : _filter) {
        {
          Iterable<PublicOperationMode> _filter_1 = Iterables.<PublicOperationMode>filter(slave.getElements(), PublicOperationMode.class);
          for(final PublicOperationMode mode : _filter_1) {
            {
              EList<PrivateOperationMode> _activates = mode.getActivates();
              for(final PrivateOperationMode sub : _activates) {
                _builder.append("\t\t");
                _builder.append("if (stateSlave->defineStates(\"");
                String _name_21 = mode.getName();
                _builder.append(_name_21, "\t\t");
                _builder.append("\" ,\"");
                String _name_22 = sub.getName();
                _builder.append(_name_22, "\t\t");
                _builder.append("\") != Smart::SMART_OK) std::cerr << \"ERROR: defining state combinaion ");
                String _name_23 = mode.getName();
                _builder.append(_name_23, "\t\t");
                _builder.append(".");
                String _name_24 = sub.getName();
                _builder.append(_name_24, "\t\t");
                _builder.append("\" << std::endl;");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    _builder.append("\t\t");
    _builder.append("status = stateSlave->setUpInitialState(connections.component.initialComponentMode);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (status != Smart::SMART_OK) std::cerr << status << \"; failed setting initial ComponentMode: \" << connections.component.initialComponentMode << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// activate state slave");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("status = stateSlave->activate();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if(status != Smart::SMART_OK) std::cerr << \"ERROR: activate state\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("wiringSlave = new SmartACE::WiringSlave(component);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// add client port to wiring slave");
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_15 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_13 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllClientPorts(component), _function_15);
      for(final ComponentPort client_3 : _sortBy_13) {
        _builder.append("\t\t");
        _builder.append("if(connections.");
        String _nameInstance_48 = this._componentGenHelpers.nameInstance(client_3);
        _builder.append(_nameInstance_48, "\t\t");
        _builder.append(".roboticMiddleware == \"");
        String _simpleName_1 = ACE_SmartSoft.class.getSimpleName();
        _builder.append(_simpleName_1, "\t\t");
        _builder.append("\") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("//FIXME: this must also work with other implementations");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("dynamic_cast<");
        String _portImplementation = this._componentGenHelpers.getPortImplementation(client_3);
        _builder.append(_portImplementation, "\t\t\t");
        _builder.append("*>(");
        String _nameInstance_49 = this._componentGenHelpers.nameInstance(client_3);
        _builder.append(_nameInstance_49, "\t\t\t");
        _builder.append(")->add(wiringSlave, connections.");
        String _nameInstance_50 = this._componentGenHelpers.nameInstance(client_3);
        _builder.append(_nameInstance_50, "\t\t\t");
        _builder.append(".wiringName);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    {
      Boolean _hasParameters_2 = this._componentGenHelpers.hasParameters(component);
      if ((_hasParameters_2).booleanValue()) {
        _builder.append("\t\t");
        _builder.append("// create parameter slave");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("param = new SmartACE::ParameterSlave(component, &paramHandler);");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    {
      final Function1<AbstractComponentElement, Boolean> _function_16 = (AbstractComponentElement it) -> {
        return Boolean.valueOf((it instanceof CoordinationMasterPort));
      };
      boolean _exists_1 = IterableExtensions.<AbstractComponentElement>exists(component.getElements(), _function_16);
      if (_exists_1) {
        _builder.append("\t\t");
        _builder.append("// create master ports");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateMaster = new SmartACE::StateMaster(component);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("paramMaster = new SmartACE::ParameterMaster(component);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("wiringMaster = new SmartACE::WiringMaster(component);");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    {
      final Function1<Activity, String> _function_17 = (Activity e) -> {
        return e.getName();
      };
      List<Activity> _sortBy_14 = IterableExtensions.<Activity, String>sortBy(ComponentDefinitionModelUtility.getActivities(component), _function_17);
      for(final Activity task_1 : _sortBy_14) {
        _builder.append("\t\t");
        _builder.append("// create Task ");
        String _name_25 = task_1.getName();
        _builder.append(_name_25, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _nameInstance_51 = this._componentGenHelpers.nameInstance(task_1);
        _builder.append(_nameInstance_51, "\t\t");
        _builder.append(" = new ");
        String _nameClass_11 = this._componentGenHelpers.nameClass(task_1);
        _builder.append(_nameClass_11, "\t\t");
        _builder.append("(component);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("// configure input-links");
        _builder.newLine();
        {
          final Function1<InputPortLink, String> _function_18 = (InputPortLink it) -> {
            return it.getName();
          };
          List<InputPortLink> _sortBy_15 = IterableExtensions.<InputPortLink, String>sortBy(ComponentDefinitionModelUtility.getInputLinks(task_1), _function_18);
          for(final InputPortLink inLink : _sortBy_15) {
            _builder.append("\t\t");
            String _nameInstance_52 = this._componentGenHelpers.nameInstance(inLink.getInputPort());
            _builder.append(_nameInstance_52, "\t\t");
            _builder.append("UpcallManager->attach(");
            String _nameInstance_53 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_53, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t");
        _builder.append("// configure task-trigger (if task is configurable)");
        _builder.newLine();
        {
          final Function1<ActivationConstraints, Boolean> _function_19 = (ActivationConstraints it) -> {
            boolean _isConfigurable = it.isConfigurable();
            return Boolean.valueOf((_isConfigurable == false));
          };
          boolean _exists_2 = IterableExtensions.<ActivationConstraints>exists(Iterables.<ActivationConstraints>filter(task_1.getExtensions(), ActivationConstraints.class), _function_19);
          boolean _not = (!_exists_2);
          if (_not) {
            _builder.append("\t\t");
            _builder.append("if(connections.");
            String _nameInstance_54 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_54, "\t\t");
            _builder.append(".trigger == \"PeriodicTimer\") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("// create PeriodicTimerTrigger");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("int microseconds = 1000*1000 / connections.");
            String _nameInstance_55 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_55, "\t\t\t");
            _builder.append(".periodicActFreq;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("if(microseconds > 0) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("Smart::TimedTaskTrigger *triggerPtr = new Smart::TimedTaskTrigger();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("triggerPtr->attach(");
            String _nameInstance_56 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_56, "\t\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("component->getTimerManager()->scheduleTimer(triggerPtr, (void *) 0, std::chrono::microseconds(microseconds), std::chrono::microseconds(microseconds));");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("// store trigger in class member");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            String _nameInstance_57 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_57, "\t\t\t\t");
            _builder.append("Trigger = triggerPtr;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("std::cerr << \"ERROR: could not set-up Timer with cycle-time \" << microseconds << \" as activation source for Task ");
            String _nameClass_12 = this._componentGenHelpers.nameClass(task_1);
            _builder.append(_nameClass_12, "\t\t\t\t");
            _builder.append("\" << std::endl;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("} else if(connections.");
            String _nameInstance_58 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_58, "\t\t");
            _builder.append(".trigger == \"DataTriggered\") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _nameInstance_59 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_59, "\t\t\t");
            _builder.append("Trigger = getInputTaskTriggerFromString(connections.");
            String _nameInstance_60 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_60, "\t\t\t");
            _builder.append(".inPortRef);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("if(");
            String _nameInstance_61 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_61, "\t\t\t");
            _builder.append("Trigger != NULL) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            String _nameInstance_62 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_62, "\t\t\t\t");
            _builder.append("Trigger->attach(");
            String _nameInstance_63 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_63, "\t\t\t\t");
            _builder.append(", connections.");
            String _nameInstance_64 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_64, "\t\t\t\t");
            _builder.append(".prescale);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("std::cerr << \"ERROR: could not set-up InPort \" << connections.");
            String _nameInstance_65 = this._componentGenHelpers.nameInstance(task_1);
            _builder.append(_nameInstance_65, "\t\t\t\t");
            _builder.append(".inPortRef << \" as activation source for Task ");
            String _nameClass_13 = this._componentGenHelpers.nameClass(task_1);
            _builder.append(_nameClass_13, "\t\t\t\t");
            _builder.append("\" << std::endl;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("} ");
            {
              final Function1<ActivityExtension, Boolean> _function_20 = (ActivityExtension it) -> {
                return Boolean.valueOf((it instanceof DefaultTrigger));
              };
              boolean _exists_3 = IterableExtensions.<ActivityExtension>exists(task_1.getExtensions(), _function_20);
              if (_exists_3) {
                _builder.append("else");
              }
            }
            _builder.newLineIfNotEmpty();
          }
        }
        {
          Iterable<DefaultTrigger> _filter_2 = Iterables.<DefaultTrigger>filter(task_1.getExtensions(), DefaultTrigger.class);
          for(final DefaultTrigger trigger : _filter_2) {
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            {
              if ((trigger instanceof DefaultPeriodicTimer)) {
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("// setup default task-trigger as PeriodicTimer");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("Smart::TimedTaskTrigger *triggerPtr = new Smart::TimedTaskTrigger();");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("int microseconds = 1000*1000 / ");
                double _periodicActFreq = ((DefaultPeriodicTimer)trigger).getPeriodicActFreq();
                _builder.append(_periodicActFreq, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("if(microseconds > 0) {");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("component->getTimerManager()->scheduleTimer(triggerPtr, (void *) 0, std::chrono::microseconds(microseconds), std::chrono::microseconds(microseconds));");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("triggerPtr->attach(");
                String _nameInstance_66 = this._componentGenHelpers.nameInstance(task_1);
                _builder.append(_nameInstance_66, "\t\t\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("// store trigger in class member");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("\t");
                String _nameInstance_67 = this._componentGenHelpers.nameInstance(task_1);
                _builder.append(_nameInstance_67, "\t\t\t\t");
                _builder.append("Trigger = triggerPtr;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("} else {");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("std::cerr << \"ERROR: could not set-up Timer with cycle-time \" << microseconds << \" as activation source for Task ");
                String _nameClass_14 = this._componentGenHelpers.nameClass(task_1);
                _builder.append(_nameClass_14, "\t\t\t\t");
                _builder.append("\" << std::endl;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              } else {
                if ((trigger instanceof DefaultInputTrigger)) {
                  _builder.append("\t\t");
                  _builder.append("\t");
                  _builder.append("// setup default task-trigger as InputTrigger");
                  _builder.newLine();
                  _builder.append("\t\t");
                  _builder.append("\t");
                  String _nameInstance_68 = this._componentGenHelpers.nameInstance(task_1);
                  _builder.append(_nameInstance_68, "\t\t\t");
                  _builder.append("Trigger = getInputTaskTriggerFromString(\"");
                  String _name_26 = ((DefaultInputTrigger)trigger).getInputLink().getName();
                  _builder.append(_name_26, "\t\t\t");
                  _builder.append("\");");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append("\t");
                  _builder.append("if(");
                  String _nameInstance_69 = this._componentGenHelpers.nameInstance(task_1);
                  _builder.append(_nameInstance_69, "\t\t\t");
                  _builder.append("Trigger != NULL) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append("\t");
                  _builder.append("\t");
                  String _nameInstance_70 = this._componentGenHelpers.nameInstance(task_1);
                  _builder.append(_nameInstance_70, "\t\t\t\t");
                  _builder.append("Trigger->attach(");
                  String _nameInstance_71 = this._componentGenHelpers.nameInstance(task_1);
                  _builder.append(_nameInstance_71, "\t\t\t\t");
                  _builder.append(", connections.");
                  String _nameInstance_72 = this._componentGenHelpers.nameInstance(task_1);
                  _builder.append(_nameInstance_72, "\t\t\t\t");
                  _builder.append(".prescale);");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append("\t");
                  _builder.append("} else {");
                  _builder.newLine();
                  _builder.append("\t\t");
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("std::cerr << \"ERROR: could not set-up InPort ");
                  String _name_27 = ((DefaultInputTrigger)trigger).getInputLink().getName();
                  _builder.append(_name_27, "\t\t\t\t");
                  _builder.append(" as activation source for Task ");
                  String _nameClass_15 = this._componentGenHelpers.nameClass(task_1);
                  _builder.append(_nameClass_15, "\t\t\t\t");
                  _builder.append("\" << std::endl;");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                }
              }
            }
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("\t\t");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// link observers with subjects");
    _builder.newLine();
    {
      final Function1<ComponentSubNode, String> _function_21 = (ComponentSubNode e) -> {
        return e.getName();
      };
      List<ComponentSubNode> _sortBy_16 = IterableExtensions.<ComponentSubNode, String>sortBy(ComponentDefinitionModelUtility.getSubNodes(component), _function_21);
      for(final ComponentSubNode node : _sortBy_16) {
        {
          Iterable<ComponentSubNodeObserver> _observers = ComponentDefinitionModelUtility.getObservers(node);
          for(final ComponentSubNodeObserver observer : _observers) {
            _builder.append("\t\t");
            String _nameInstance_73 = this._componentGenHelpers.nameInstance(observer.getSubject());
            _builder.append(_nameInstance_73, "\t\t");
            _builder.append("->attach_interaction_observer(");
            String _nameInstance_74 = this._componentGenHelpers.nameInstance(node);
            _builder.append(_nameInstance_74, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("} catch (const std::exception &ex) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cerr << \"Uncaught std exception\" << ex.what() << std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (...) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cerr << \"Uncaught exception\" << std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// run the component");
    _builder.newLine();
    _builder.append("void ");
    String _name_28 = component.getName();
    _builder.append(_name_28);
    _builder.append("::run()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("stateSlave->acquire(\"init\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// startup all registered port-factories");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for(auto portFactory = portFactoryRegistry.begin(); portFactory != portFactoryRegistry.end(); portFactory++) ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("portFactory->second->onStartup();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// startup all registered component-extensions");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for(auto extension = componentExtensionRegistry.begin(); extension != componentExtensionRegistry.end(); extension++) ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("extension->second->onStartup();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("stateSlave->release(\"init\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// do not call this handler within the init state (see above) as this handler internally calls setStartupFinished() (this should be fixed in future)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("compHandler.onStartup();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// this call blocks until the component is commanded to shutdown");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("stateSlave->acquire(\"shutdown\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// shutdown all registered component-extensions");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for(auto extension = componentExtensionRegistry.begin(); extension != componentExtensionRegistry.end(); extension++) ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("extension->second->onShutdown();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// shutdown all registered port-factories");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for(auto portFactory = portFactoryRegistry.begin(); portFactory != portFactoryRegistry.end(); portFactory++) ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("portFactory->second->onShutdown();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(connections.component.useLogger == true) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//FIXME: use logging");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//Smart::LOGGER->stopLogging();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("compHandler.onShutdown();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("stateSlave->release(\"shutdown\");");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// clean-up component\'s resources");
    _builder.newLine();
    _builder.append("void ");
    String _name_29 = component.getName();
    _builder.append(_name_29);
    _builder.append("::fini()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// unlink all observers");
    _builder.newLine();
    {
      final Function1<ComponentSubNode, String> _function_22 = (ComponentSubNode e) -> {
        return e.getName();
      };
      List<ComponentSubNode> _sortBy_17 = IterableExtensions.<ComponentSubNode, String>sortBy(ComponentDefinitionModelUtility.getSubNodes(component), _function_22);
      for(final ComponentSubNode node_1 : _sortBy_17) {
        {
          Iterable<ComponentSubNodeObserver> _observers_1 = ComponentDefinitionModelUtility.getObservers(node_1);
          for(final ComponentSubNodeObserver observer_1 : _observers_1) {
            _builder.append("\t");
            String _nameInstance_75 = this._componentGenHelpers.nameInstance(observer_1.getSubject());
            _builder.append(_nameInstance_75, "\t");
            _builder.append("->detach_interaction_observer(");
            String _nameInstance_76 = this._componentGenHelpers.nameInstance(node_1);
            _builder.append(_nameInstance_76, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destroy all task instances");
    _builder.newLine();
    {
      final Function1<Activity, String> _function_23 = (Activity e) -> {
        return e.getName();
      };
      List<Activity> _sortBy_18 = IterableExtensions.<Activity, String>sortBy(ComponentDefinitionModelUtility.getActivities(component), _function_23);
      for(final Activity task_2 : _sortBy_18) {
        _builder.append("\t");
        _builder.append("// unlink all UpcallManagers");
        _builder.newLine();
        {
          final Function1<InputPortLink, String> _function_24 = (InputPortLink it) -> {
            return it.getName();
          };
          List<InputPortLink> _sortBy_19 = IterableExtensions.<InputPortLink, String>sortBy(ComponentDefinitionModelUtility.getInputLinks(task_2), _function_24);
          for(final InputPortLink inLink_1 : _sortBy_19) {
            _builder.append("\t");
            String _nameInstance_77 = this._componentGenHelpers.nameInstance(inLink_1.getInputPort());
            _builder.append(_nameInstance_77, "\t");
            _builder.append("UpcallManager->detach(");
            String _nameInstance_78 = this._componentGenHelpers.nameInstance(task_2);
            _builder.append(_nameInstance_78, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("// unlink the TaskTrigger");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(");
        String _nameInstance_79 = this._componentGenHelpers.nameInstance(task_2);
        _builder.append(_nameInstance_79, "\t");
        _builder.append("Trigger != NULL){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        String _nameInstance_80 = this._componentGenHelpers.nameInstance(task_2);
        _builder.append(_nameInstance_80, "\t\t");
        _builder.append("Trigger->detach(");
        String _nameInstance_81 = this._componentGenHelpers.nameInstance(task_2);
        _builder.append(_nameInstance_81, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("delete ");
        String _nameInstance_82 = this._componentGenHelpers.nameInstance(task_2);
        _builder.append(_nameInstance_82, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destroy all input-handler");
    _builder.newLine();
    {
      final Function1<InputHandler, String> _function_25 = (InputHandler it) -> {
        return it.getName();
      };
      List<InputHandler> _sortBy_20 = IterableExtensions.<InputHandler, String>sortBy(ComponentDefinitionModelUtility.getInputHandlers(component), _function_25);
      for(final InputHandler handler_2 : _sortBy_20) {
        _builder.append("\t");
        _builder.append("delete ");
        String _nameInstance_83 = this._componentGenHelpers.nameInstance(handler_2);
        _builder.append(_nameInstance_83, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destroy InputTaskTriggers and UpcallManagers");
    _builder.newLine();
    {
      final Function1<InputPort, String> _function_26 = (InputPort it) -> {
        return it.getName();
      };
      List<InputPort> _sortBy_21 = IterableExtensions.<InputPort, String>sortBy(ComponentDefinitionModelUtility.getInputPorts(component), _function_26);
      for(final InputPort input_2 : _sortBy_21) {
        _builder.append("\t");
        _builder.append("delete ");
        String _nameInstance_84 = this._componentGenHelpers.nameInstance(input_2);
        _builder.append(_nameInstance_84, "\t");
        _builder.append("InputTaskTrigger;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("delete ");
        String _nameInstance_85 = this._componentGenHelpers.nameInstance(input_2);
        _builder.append(_nameInstance_85, "\t");
        _builder.append("UpcallManager;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destroy client ports");
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_27 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_22 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllClientPorts(component), _function_27);
      for(final ComponentPort client_4 : _sortBy_22) {
        _builder.append("\t");
        _builder.append("delete ");
        String _nameInstance_86 = this._componentGenHelpers.nameInstance(client_4);
        _builder.append(_nameInstance_86, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destroy server ports");
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_28 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_23 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllServerPorts(component), _function_28);
      for(final ComponentPort server_1 : _sortBy_23) {
        _builder.append("\t");
        _builder.append("delete ");
        String _nameInstance_87 = this._componentGenHelpers.nameInstance(server_1);
        _builder.append(_nameInstance_87, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        {
          if ((server_1 instanceof AnswerPort)) {
            _builder.append("\t");
            _builder.append("delete ");
            String _nameInstance_88 = this._componentGenHelpers.nameInstance(server_1);
            _builder.append(_nameInstance_88, "\t");
            _builder.append("InputTaskTrigger;");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("// destroy event-test handlers (if needed)");
    _builder.newLine();
    {
      final Function1<OutputPort, String> _function_29 = (OutputPort it) -> {
        return it.getName();
      };
      List<OutputPort> _sortBy_24 = IterableExtensions.<OutputPort, String>sortBy(ComponentDefinitionModelUtility.getOutputPorts(component), _function_29);
      for(final OutputPort output_1 : _sortBy_24) {
        {
          boolean _isEventServer_3 = this._componentGenHelpers.isEventServer(output_1);
          if (_isEventServer_3) {
            _builder.append("\t");
            String _nameInstance_89 = this._componentGenHelpers.nameInstance(output_1);
            _builder.append(_nameInstance_89, "\t");
            _builder.append("EventTestHandler;");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destroy request-handlers");
    _builder.newLine();
    {
      final Function1<RequestHandler, String> _function_30 = (RequestHandler it) -> {
        return it.getName();
      };
      List<RequestHandler> _sortBy_25 = IterableExtensions.<RequestHandler, String>sortBy(ComponentDefinitionModelUtility.getRequestHandlers(component), _function_30);
      for(final RequestHandler handler_3 : _sortBy_25) {
        _builder.append("\t");
        _builder.append("delete ");
        String _nameInstance_90 = this._componentGenHelpers.nameInstance(handler_3);
        _builder.append(_nameInstance_90, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("delete stateSlave;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destroy state-change-handler");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("delete stateChangeHandler;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destroy all master/slave ports");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("delete wiringSlave;");
    _builder.newLine();
    _builder.append("\t");
    {
      Boolean _hasParameters_3 = this._componentGenHelpers.hasParameters(component);
      if ((_hasParameters_3).booleanValue()) {
        _builder.append("delete param;");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      final Function1<AbstractComponentElement, Boolean> _function_31 = (AbstractComponentElement it) -> {
        return Boolean.valueOf((it instanceof CoordinationMasterPort));
      };
      boolean _exists_4 = IterableExtensions.<AbstractComponentElement>exists(component.getElements(), _function_31);
      if (_exists_4) {
        _builder.append("\t");
        _builder.append("// destroy master ports");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("delete stateMaster;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("delete paramMaster;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("delete wiringMaster;");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destroy all registered component-extensions");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for(auto extension = componentExtensionRegistry.begin(); extension != componentExtensionRegistry.end(); extension++) ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("extension->second->destroy();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// destroy all registered port-factories");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for(auto portFactory = portFactoryRegistry.begin(); portFactory != portFactoryRegistry.end(); portFactory++) ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("portFactory->second->destroy();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    {
      final Function1<ComponentGeneratorExtension, String> _function_32 = (ComponentGeneratorExtension it) -> {
        return it.getExtensionName(component);
      };
      List<ComponentGeneratorExtension> _sortBy_26 = IterableExtensions.<ComponentGeneratorExtension, String>sortBy(this._componentGenHelpers.getComponentGeneratorExtensions(), _function_32);
      for(final ComponentGeneratorExtension ext_1 : _sortBy_26) {
        _builder.append("\t");
        _builder.append("// destruction of ");
        String _extensionName_1 = ext_1.getExtensionName(component);
        _builder.append(_extensionName_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _classMemberDestruction = ext_1.getClassMemberDestruction(component);
        _builder.append(_classMemberDestruction, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _loadParameterImplementation = this._smartIniParameter.loadParameterImplementation(component);
    _builder.append(_loadParameterImplementation);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence CoreUserHeaderFileContent(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = this.getCoreName(component).toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = this.getCoreName(component).toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("class ");
    String _coreName = this.getCoreName(component);
    _builder.append(_coreName);
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("private:");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _coreName_1 = this.getCoreName(component);
    _builder.append(_coreName_1, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence CoreUserSourceFileContent(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _coreUserHeaderFilename = this.getCoreUserHeaderFilename(component);
    _builder.append(_coreUserHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// constructor");
    _builder.newLine();
    String _coreName = this.getCoreName(component);
    _builder.append(_coreName);
    _builder.append("::");
    String _coreName_1 = this.getCoreName(component);
    _builder.append(_coreName_1);
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout << \"constructor ");
    String _coreName_2 = this.getCoreName(component);
    _builder.append(_coreName_2, "\t");
    _builder.append("\\n\";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence CompHandlerHeaderFileContent(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _COMPHANDLER_HH");
    _builder.newLine();
    _builder.append("#define _COMPHANDLER_HH");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("class CompHandler");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void onStartup();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void onShutdown();");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence CompHandlerSourceFileContent(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"CompHandler.hh\"");
    _builder.newLine();
    _builder.append("#include \"");
    String _compHeaderFilename = this.getCompHeaderFilename(component);
    _builder.append(_compHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// include communication objects");
    _builder.newLine();
    {
      final Function1<CommunicationObject, String> _function = (CommunicationObject it) -> {
        return it.getName();
      };
      List<CommunicationObject> _sortBy = IterableExtensions.<CommunicationObject, String>sortBy(ComponentDefinitionModelUtility.getAllCommObjects(component), _function);
      for(final CommunicationObject obj : _sortBy) {
        _builder.append("#include <");
        CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(obj);
        _builder.append(_userClassHeaderFileNameFQN);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.newLine();
    _builder.append("void CompHandler::onStartup() ");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout << \"startup - put your startupCode in CompHandler::onStartup()!!!\\n\";");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Smart::StatusCode status;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Start all services. If you need manual control, use the content of this function to");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// connect and start each service individually, e.g:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// COMP->connectMyPortName(\"SmartExampleComponent\", \"examplePort\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("status = COMP->connectAndStartAllServices();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Start all tasks. If you need manual control, use the content of this function to");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// start each task individually.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("COMP->startAllTasks();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Start all timers. If you need manual control, use the content of this function to");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// start each timer individually.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("COMP->startAllTimers();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Notify the component that setup/initialization is finished.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// You may move this function to any other place.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("COMP->setStartupFinished(); ");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void CompHandler::onShutdown() ");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout << \"shutdown - put your cleanup code in CompHandler::onShutdown()!!!\\n\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
