/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.targetPlatform.validation;

import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformModel;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformPackage;
import org.eclipse.xtext.validation.Check;

/**
 * This class contains custom validation rules.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
@SuppressWarnings("all")
public class TargetPlatformValidator extends AbstractTargetPlatformValidator {
  public static final String NO_TARGET_PLATFORMS = "no_target_platforms";
  
  @Check
  public void hasATargetPlatformDefinition(final TargetPlatformModel model) {
    boolean _isEmpty = model.getElements().isEmpty();
    if (_isEmpty) {
      this.warning("At least one TargetPlatform should be defined", TargetPlatformPackage.Literals.TARGET_PLATFORM_MODEL__NAME, TargetPlatformValidator.NO_TARGET_PLATFORMS);
    }
  }
}
