/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.datasheet.indexer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class DatasheetProjectSettings {
    public static String SETTINGS_NODE_NAME = "toolchain.project.metadata";
    public static String VALUE_NODE_KEY = "value";
    public static String UNIT_NODE_KEY = "unit";
    public static String SEMANTIC_URI_NODE_KEY = "semanticURI";
    public static String SHORT_DESCRIPTION_KEY = "shortDescription";
    private IProject project;
    private ProjectScope settings;
    private IEclipsePreferences rootNode;
    private Preferences projectNode;

    public DatasheetProjectSettings(IProject project) {
        this.project = project;
        this.settings = new ProjectScope(project);
        this.rootNode = this.settings.getNode(SETTINGS_NODE_NAME);
        this.projectNode = this.rootNode.node(project.getName());
    }

    public boolean isValid() {
        return this.project.isAccessible();
    }

    public String getShortDescription(String defaultValue) {
        return this.projectNode.get(SHORT_DESCRIPTION_KEY, defaultValue);
    }

    public void setShortDescription(String shortDescription) {
        this.projectNode.put(SHORT_DESCRIPTION_KEY, shortDescription);
    }

    public Preferences getMainPropertyNode(String name) {
        return this.projectNode.node(name);
    }

    public boolean hasMainPropertyNode(String name) {
        try {
            if (this.isValid()) {
                return this.projectNode.nodeExists(name);
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public void clearAllMainProperties() {
        try {
            this.projectNode.clear();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public Preferences getCustomSubNode(String path) {
        return this.rootNode.node(path);
    }

    public Collection<String> getPropertyValues(Preferences property) {
        HashSet<String> result = new HashSet<String>();
        Preferences values = property.node(VALUE_NODE_KEY);
        try {
            String[] stringArray = values.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = values.get(key, "");
                if (value != "") {
                    result.add(value);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Collection<String> getPropertyUnits(Preferences property) {
        HashSet<String> result = new HashSet<String>();
        Preferences units = property.node(UNIT_NODE_KEY);
        try {
            String[] stringArray = units.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String unit = units.get(key, "");
                if (unit != "") {
                    result.add(unit);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Collection<String> getPropertySemanticURIs(Preferences property) {
        HashSet<String> result = new HashSet<String>();
        Preferences uris = property.node(SEMANTIC_URI_NODE_KEY);
        try {
            String[] stringArray = uris.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String uri = uris.get(key, "");
                if (uri != "") {
                    result.add(uri);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Collection<String> getAllPropertyNames() {
        HashSet<String> result = new HashSet<String>();
        try {
            String[] stringArray = this.rootNode.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeName = stringArray[n2];
                Preferences node = this.rootNode.node(nodeName);
                result.addAll(Arrays.asList(node.childrenNames()));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Collection<String> getAllPropertyValues(String propertyName) {
        HashSet<String> result = new HashSet<String>();
        try {
            String[] stringArray = this.rootNode.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeName = stringArray[n2];
                Preferences curr_node = this.rootNode.node(nodeName);
                if (curr_node.nodeExists(propertyName)) {
                    result.addAll(this.getPropertyValues(curr_node.node(propertyName)));
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Collection<String> getAllPropertyUnits(String propertyName) {
        HashSet<String> result = new HashSet<String>();
        try {
            String[] stringArray = this.rootNode.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeName = stringArray[n2];
                Preferences curr_node = this.rootNode.node(nodeName);
                if (curr_node.nodeExists(propertyName)) {
                    result.addAll(this.getPropertyUnits(curr_node.node(propertyName)));
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Collection<String> getAllPropertySemanticURIs(String propertyName) {
        HashSet<String> result = new HashSet<String>();
        try {
            String[] stringArray = this.rootNode.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeName = stringArray[n2];
                Preferences curr_node = this.rootNode.node(nodeName);
                if (curr_node.nodeExists(propertyName)) {
                    result.addAll(this.getPropertySemanticURIs(curr_node.node(propertyName)));
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void updatePropertyValue(Preferences property, int index, String value) {
        this.updatePropertyValue(property, index, value, null);
    }

    public void updatePropertyValue(Preferences property, int index, String value, String unit) {
        String str_index = Integer.toString(index);
        Preferences value_node = property.node(VALUE_NODE_KEY);
        value_node.put(str_index, value);
        if (unit != null) {
            Preferences unit_node = property.node(UNIT_NODE_KEY);
            unit_node.put(str_index, unit);
        }
    }

    public void updatePropertySeminticURI(Preferences property, int index, String semanticURI) {
        String str_index = Integer.toString(index);
        Preferences uri_node = property.node(SEMANTIC_URI_NODE_KEY);
        uri_node.put(str_index, semanticURI);
    }

    public void saveProperties() {
        try {
            this.rootNode.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

