/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.builder;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.AbstractBuildRunner;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.smartmdsd.ui.Activator;

public class SmartMDSDBuildRunner
extends AbstractBuildRunner {
    public boolean invokeBuild(int kind, IProject project, IConfiguration configuration, IBuilder builder, IConsole console, IMarkerGenerator markerGenerator, IncrementalProjectBuilder projectBuilder, IProgressMonitor monitor) throws CoreException {
        boolean rebuild_required = false;
        String defaultBuildType = Activator.getDefault().getPreferenceStore().getString("CMakeBuildType");
        switch (kind) {
            case 15: {
                this.printInfoMessage(console, "Clean project " + project.getName());
                if (this.cleanProject(project, configuration, builder, console, monitor)) {
                    project.refreshLocal(2, monitor);
                    this.printInfoMessage(console, "Project " + project.getName() + " has cleaned successfully!\n");
                    break;
                }
                this.printInfoMessage(console, "An error occurred while cleaning the project " + project.getName());
                rebuild_required = true;
                break;
            }
            case 6: 
            case 10: {
                this.printInfoMessage(console, "Configure CMake (" + defaultBuildType + ") for project " + project.getName());
                if (this.configureCMake(project, builder, defaultBuildType, console, monitor)) {
                    this.printInfoMessage(console, "CMake finished successfully!\n");
                    this.printInfoMessage(console, "Build project " + project.getName() + " (" + defaultBuildType + ")");
                    if (this.buildProject(project, builder, builder.getIncrementalBuildTarget(), defaultBuildType, console, monitor)) {
                        project.refreshLocal(2, monitor);
                        this.printInfoMessage(console, "Project " + project.getName() + " has built successfully!");
                        break;
                    }
                    this.printInfoMessage(console, "Errors occurred while building the project " + project.getName());
                    rebuild_required = true;
                    break;
                }
                this.printInfoMessage(console, "Errors occurred while configuring CMake for the project " + project.getName());
                rebuild_required = true;
                break;
            }
        }
        return rebuild_required;
    }

    private void printInfoMessage(IConsole console, String message) throws CoreException {
        try {
            console.getInfoStream().write(String.valueOf(message) + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean configureCMake(IProject project, IBuilder builder, String build_type, IConsole console, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> cmakeArgumentsList = new ArrayList<String>();
        cmakeArgumentsList.add("-DBUILD_DEPENDENCIES=OFF");
        File ros_dir = null;
        if (!Platform.getOS().equals("win32")) {
            cmakeArgumentsList.add("-DCMAKE_BUILD_TYPE=" + build_type);
            String ros_distro_dir = Activator.getDefault().getPreferenceStore().getString("ROSDistributionDir");
            ros_dir = new File(ros_distro_dir);
            if (ros_dir.exists()) {
                cmakeArgumentsList.add("-DCMAKE_PREFIX_PATH=" + ros_dir.getPath());
            }
        }
        String[] environmentVariables = this.calculateEnvironmentVariables(project, ros_dir);
        cmakeArgumentsList.add("..");
        String[] cmakeArguments = new String[cmakeArgumentsList.size()];
        cmakeArguments = cmakeArgumentsList.toArray(cmakeArguments);
        builder.getBuildLocation().toFile().mkdirs();
        ICommandLauncher launcher = builder.getCommandLauncher();
        Process cmakeProcess = launcher.execute(builder.getBuildCommand(), cmakeArguments, environmentVariables, builder.getBuildLocation(), monitor);
        launcher.waitAndRead((OutputStream)console.getOutputStream(), (OutputStream)console.getErrorStream(), monitor);
        return cmakeProcess.exitValue() == 0;
    }

    private boolean buildProject(IProject project, IBuilder builder, String build_target, String build_type, IConsole console, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> buildArgumentsList = new ArrayList<String>();
        buildArgumentsList.add("--build");
        buildArgumentsList.add(".");
        buildArgumentsList.add("--target");
        buildArgumentsList.add(build_target);
        if (Platform.getOS().equals("win32")) {
            buildArgumentsList.add("--config");
            buildArgumentsList.add(build_type);
        } else if (Platform.getOS().equals("linux")) {
            buildArgumentsList.add("--");
        }
        buildArgumentsList.add(builder.getArguments());
        String[] buildArguments = new String[buildArgumentsList.size()];
        buildArguments = buildArgumentsList.toArray(buildArguments);
        String ros_distro_dir = Activator.getDefault().getPreferenceStore().getString("ROSDistributionDir");
        File ros_dir = new File(ros_distro_dir);
        String[] environmentVariables = this.calculateEnvironmentVariables(project, ros_dir);
        ICommandLauncher launcher = builder.getCommandLauncher();
        Process cmakeProcess = launcher.execute(builder.getBuildCommand(), buildArguments, environmentVariables, builder.getBuildLocation(), monitor);
        launcher.waitAndRead((OutputStream)console.getOutputStream(), (OutputStream)console.getErrorStream(), monitor);
        return cmakeProcess.exitValue() == 0;
    }

    private boolean cleanProject(IProject project, IConfiguration configuration, IBuilder builder, IConsole console, IProgressMonitor monitor) throws CoreException {
        Path cleanCommandPath = null;
        String[] cleanArguments = null;
        if (Platform.getOS().equals("linux")) {
            cleanCommandPath = new Path("bash");
            cleanArguments = new String[]{"-c", String.valueOf(configuration.getCleanCommand()) + " * -v"};
        } else if (Platform.getOS().equals("win32")) {
            cleanCommandPath = builder.getBuildCommand();
            ArrayList<String> buildArgumentsList = new ArrayList<String>();
            buildArgumentsList.add("--build");
            buildArgumentsList.add(".");
            buildArgumentsList.add("--target");
            buildArgumentsList.add(builder.getCleanBuildTarget());
            cleanArguments = new String[buildArgumentsList.size()];
            cleanArguments = buildArgumentsList.toArray(cleanArguments);
        }
        String ros_distro_dir = Activator.getDefault().getPreferenceStore().getString("ROSDistributionDir");
        File ros_dir = new File(ros_distro_dir);
        String[] environmentVariables = this.calculateEnvironmentVariables(project, ros_dir);
        if (cleanCommandPath != null) {
            ICommandLauncher launcher = builder.getCommandLauncher();
            Process cmakeProcess = launcher.execute((IPath)cleanCommandPath, cleanArguments, environmentVariables, builder.getBuildLocation(), monitor);
            launcher.waitAndRead((OutputStream)console.getOutputStream(), (OutputStream)console.getErrorStream(), monitor);
            return cmakeProcess.exitValue() == 0;
        }
        return false;
    }

    private String[] calculateEnvironmentVariables(IProject project, File ros_dir) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        Map environment = manager.getNativeEnvironment();
        Integer index = 0;
        int env_size = environment.size();
        if (ros_dir != null && ros_dir.exists()) {
            env_size += 3;
        }
        String[] environmentVariables = new String[env_size];
        String workspacePath = project.getWorkspace().getRoot().getLocation().toOSString();
        for (Map.Entry entry : environment.entrySet()) {
            environmentVariables[index.intValue()] = ((String)entry.getKey()).contentEquals("SMART_PACKAGE_PATH") ? String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue() + ":" + workspacePath : (((String)entry.getKey()).equals("PATH") && ros_dir != null && ros_dir.exists() ? String.valueOf((String)entry.getKey()) + "=" + ros_dir.getPath() + "/bin:" + (String)entry.getValue() : String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
            index = index + 1;
        }
        if (ros_dir != null && ros_dir.exists()) {
            Integer n = index;
            index = n + 1;
            environmentVariables[n.intValue()] = "ROS_ROOT=" + ros_dir.getPath() + "/share/ros";
            Integer n2 = index;
            index = n2 + 1;
            environmentVariables[n2.intValue()] = "ROS_PACKAGE_PATH=" + ros_dir.getPath() + "/share";
            String python_version = "3";
            if (ros_dir.getName().contentEquals("melodic") || ros_dir.getName().contentEquals("kinetic")) {
                python_version = "2.7";
            }
            Integer n3 = index;
            index = n3 + 1;
            environmentVariables[n3.intValue()] = "PYTHONPATH=" + ros_dir.getPath() + "/lib/python" + python_version + "/dist-packages:/usr/lib/python" + python_version + "/dist-packages";
        }
        return environmentVariables;
    }
}

