/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.gerrit;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.ResourcePropertyTester;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitSelectRepositoryPage;
import org.eclipse.jgit.lib.Repository;

public class GerritSelectRepositoryPage
extends GitSelectRepositoryPage {
    private RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
    private RepositoryCache cache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();

    public GerritSelectRepositoryPage() {
        super(false, false);
        this.setTitle(UIText.GerritSelectRepositoryPage_PageTitle);
        this.setDescription(null);
        this.setImageDescriptor(UIIcons.WIZBAN_FETCH_GERRIT);
    }

    @Override
    protected List<String> getInitialRepositories() {
        List configuredRepos = this.util.getConfiguredRepositories();
        return configuredRepos.stream().map(name -> {
            File gitDir = new File((String)name);
            if (gitDir.exists()) {
                try {
                    Repository repo = this.cache.lookupRepository(gitDir);
                    if (repo != null && ResourcePropertyTester.hasGerritConfiguration(repo)) {
                        return name;
                    }
                }
                catch (IOException e) {
                    Activator.logWarning(e.getLocalizedMessage(), e);
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

