/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor;

import com.cthing.cmakeed.ui.CMakeEditorPlugin;
import com.cthing.cmakeed.ui.Messages;
import com.cthing.cmakeed.ui.editor.CMakeDocumentSetupParticipant;
import com.cthing.cmakeed.ui.editor.CMakeEditorConfiguration;
import com.cthing.cmakeed.ui.editor.ColorMgr;
import com.cthing.cmakeed.ui.prefs.Preferences;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class CMakeEditor
extends TextEditor
implements IPropertyChangeListener {
    private static final char[] matchChars = new char[]{'(', ')', '[', ']', '<', '>'};
    private StyledText text;
    private ColorMgr colorMgr;

    public CMakeEditor() {
        ForwardingDocumentProvider provider = new ForwardingDocumentProvider("__cmake_partitioning", (IDocumentSetupParticipant)new CMakeDocumentSetupParticipant(), (IDocumentProvider)new TextFileDocumentProvider());
        this.setDocumentProvider((IDocumentProvider)provider);
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] inheritedPages = super.collectContextMenuPreferencePages();
        int length = 2;
        String[] result = new String[inheritedPages.length + length];
        result[0] = "com.cthing.cmakeed.ui.prefs.PrefPage";
        result[1] = "com.cthing.cmakeed.ui.prefs.TemplatesPreferencePage";
        System.arraycopy(inheritedPages, 0, result, length, inheritedPages.length);
        return result;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.text = this.getSourceViewer().getTextWidget();
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(Messages.getResourceBundle(), "ContentProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"com.cthing.cmakeed.ui.cmakeEditorScope"});
    }

    public Object getAdapter(Class key) {
        if (key.equals(ISourceViewer.class)) {
            return this.getSourceViewer();
        }
        if (key.equals(StyledText.class)) {
            return this.text;
        }
        return super.getAdapter(key);
    }

    protected void initializeEditor() {
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{EditorsUI.getPreferenceStore(), CMakeEditorPlugin.getDefault().getPreferenceStore()});
        this.setPreferenceStore((IPreferenceStore)store);
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.colorMgr == null) {
            this.colorMgr = new ColorMgr();
        }
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new CMakeEditorConfiguration(this.colorMgr, (IPreferenceStore)store));
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        CMakeEditorPlugin.getDefault().getCMakePartitionScanner().removeUserVariableRule();
    }

    public void doSave(IProgressMonitor prog) {
        super.doSave(prog);
        CMakeEditorPlugin.getDefault().getCMakePartitionScanner().setDefaultScannerRules();
        CMakeEditorPlugin.getDefault().getCMakePartitionScanner().removeUserVariableRule();
    }

    public void dispose() {
        IPreferenceStore store = this.getPreferenceStore();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
        this.colorMgr.dispose();
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event == null || Preferences.isTextPreference(event.getProperty())) {
            SourceViewer sourceViewer = (SourceViewer)this.getSourceViewer();
            int line = sourceViewer.getTopIndex();
            sourceViewer.unconfigure();
            CMakeEditorConfiguration config = new CMakeEditorConfiguration(this.colorMgr, this.getPreferenceStore());
            sourceViewer.configure((SourceViewerConfiguration)config);
            sourceViewer.refresh();
            sourceViewer.setTopIndex(line);
        }
    }

    public SourceViewer getCMakeEditorSourceViewer() {
        return (SourceViewer)this.getSourceViewer();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        DefaultCharacterPairMatcher matcher = new DefaultCharacterPairMatcher(matchChars, "__dftl_partitioning");
        support.setCharacterPairMatcher((ICharacterPairMatcher)matcher);
        support.setMatchingCharacterPainterPreferenceKeys("matchBrackets", "matchingBracketsColor");
        support.install(CMakeEditorPlugin.getDefault().getPreferenceStore());
    }
}

