/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.prefs;

import com.cthing.cmakeed.ui.CMakeEditorPlugin;
import com.cthing.cmakeed.ui.Messages;
import com.cthing.cmakeed.ui.prefs.Preferences;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Map<String, RGB> colorMap = new HashMap<String, RGB>();
    private Map<String, Integer> styleMap = new HashMap<String, Integer>();
    private Button upperCaseCommandsB;
    private Button bracketB;
    private ColorSelector bracketColorB;
    private ListViewer textAttrViewer;
    private ColorSelector colorB;
    private Button boldB;
    private Button italicB;
    private Button underlineB;
    private Button strikeB;

    public PrefPage() {
        this.setPreferenceStore(CMakeEditorPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite topComp = new Composite(parent, 0);
        topComp.setLayout((Layout)new GridLayout(1, false));
        Control control = this.createHeader(topComp);
        control.setLayoutData((Object)new GridData());
        Composite upperCaseCommandsComp = new Composite(topComp, 0);
        upperCaseCommandsComp.setLayoutData((Object)new GridData());
        upperCaseCommandsComp.setLayout((Layout)new GridLayout(2, false));
        this.upperCaseCommandsB = new Button(upperCaseCommandsComp, 32);
        this.upperCaseCommandsB.setLayoutData((Object)new GridData());
        Label upperCaseCommandsL = new Label(upperCaseCommandsComp, 0);
        upperCaseCommandsL.setLayoutData((Object)new GridData());
        upperCaseCommandsL.setText(Messages.getString("PreferencePage.UpperCaseCommands"));
        Composite bracketComp = new Composite(topComp, 0);
        bracketComp.setLayoutData((Object)new GridData());
        bracketComp.setLayout((Layout)new GridLayout(2, false));
        this.bracketB = new Button(bracketComp, 32);
        this.bracketB.setLayoutData((Object)new GridData());
        Label bracketL = new Label(bracketComp, 0);
        bracketL.setLayoutData((Object)new GridData());
        bracketL.setText(Messages.getString("PreferencePage.BracketHighlighting"));
        new Label(bracketComp, 16384);
        Composite colorComp = new Composite(bracketComp, 0);
        colorComp.setLayoutData((Object)new GridData());
        colorComp.setLayout((Layout)new GridLayout(2, false));
        Label colorL = new Label(colorComp, 0);
        colorL.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        colorL.setText(Messages.getString("PreferencePage.Color"));
        this.bracketColorB = new ColorSelector(colorComp);
        this.bracketColorB.getButton().setLayoutData((Object)new GridData());
        this.bracketB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = PrefPage.this.bracketB.getSelection();
                PrefPage.this.bracketColorB.setEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite textComp = new Composite(topComp, 0);
        textComp.setLayoutData((Object)new GridData());
        textComp.setLayout((Layout)new GridLayout(2, false));
        Label attrL = new Label(textComp, 0);
        GridData attrData = new GridData();
        attrData.horizontalSpan = 2;
        attrL.setLayoutData((Object)attrData);
        attrL.setText(Messages.getString("PreferencePage.Attributes"));
        this.textAttrViewer = new ListViewer(textComp, 2564);
        this.textAttrViewer.getList().setLayoutData((Object)new GridData(1, 1, false, false));
        this.textAttrViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return Preferences.getMessage(element);
            }
        });
        this.textAttrViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.textAttrViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object obj1, Object obj2) {
                String label1 = Preferences.getMessage(obj1);
                String label2 = Preferences.getMessage(obj2);
                return label1.toString().compareToIgnoreCase(label2.toString());
            }
        });
        this.textAttrViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PrefPage.this.writeTextUI();
            }
        });
        Composite styleComp = new Composite(textComp, 0);
        styleComp.setLayoutData((Object)new GridData(0, 1, false, false));
        styleComp.setLayout((Layout)new GridLayout(2, false));
        Label colorL2 = new Label(styleComp, 0);
        colorL2.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        colorL2.setText(Messages.getString("PreferencePage.Color"));
        this.colorB = new ColorSelector(styleComp);
        this.colorB.getButton().setLayoutData((Object)new GridData());
        this.colorB.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PrefPage.this.readTextUI();
            }
        });
        this.boldB = new Button(styleComp, 32);
        this.boldB.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.boldB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPage.this.readTextUI();
            }
        });
        Label boldL = new Label(styleComp, 0);
        boldL.setLayoutData((Object)new GridData());
        boldL.setText(Messages.getString("PreferencePage.Bold"));
        this.italicB = new Button(styleComp, 32);
        this.italicB.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.italicB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPage.this.readTextUI();
            }
        });
        Label italicL = new Label(styleComp, 0);
        italicL.setLayoutData((Object)new GridData());
        italicL.setText(Messages.getString("PreferencePage.Italic"));
        this.underlineB = new Button(styleComp, 32);
        this.underlineB.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.underlineB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPage.this.readTextUI();
            }
        });
        Label underlineL = new Label(styleComp, 0);
        underlineL.setLayoutData((Object)new GridData());
        underlineL.setText(Messages.getString("PreferencePage.Underline"));
        this.strikeB = new Button(styleComp, 32);
        this.strikeB.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.strikeB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPage.this.readTextUI();
            }
        });
        Label strikeL = new Label(styleComp, 0);
        strikeL.setLayoutData((Object)new GridData());
        strikeL.setText(Messages.getString("PreferencePage.Strike"));
        this.init(CMakeEditorPlugin.getDefault().getWorkbench());
        return topComp;
    }

    private Control createHeader(Composite parent) {
        final Link link = new Link(parent, 0);
        link.setText(Messages.getString("PreferencePage.AdditionalPrefs"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        String linktooltip = Messages.getString("PreferencePage.AdditionalTip");
        link.setToolTipText(linktooltip);
        return link;
    }

    public void init(IWorkbench workbench) {
        if (this.textAttrViewer != null) {
            this.textAttrViewer.setInput((Object)Preferences.TEXT_KEYS);
            this.textAttrViewer.getList().select(0);
            this.textAttrViewer.getList().showSelection();
            IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
            this.upperCaseCommandsB.setSelection(store.getBoolean("upperCaseCommands"));
            this.bracketB.setSelection(store.getBoolean("matchBrackets"));
            this.bracketColorB.setColorValue(PreferenceConverter.getColor((IPreferenceStore)store, (String)"matchingBracketsColor"));
            this.readTextPrefs();
            this.writeTextUI();
        }
    }

    private String getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.textAttrViewer.getSelection();
        return (String)selection.getFirstElement();
    }

    private void readTextPrefs() {
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        String[] stringArray = Preferences.TEXT_KEYS;
        int n = Preferences.TEXT_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String baseKey = stringArray[n2];
            this.colorMap.put(baseKey, PreferenceConverter.getColor((IPreferenceStore)store, (String)Preferences.getColorKey(baseKey)));
            this.styleMap.put(baseKey, store.getInt(Preferences.getStyleKey(baseKey)));
            ++n2;
        }
    }

    private void writeTextPrefs() {
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        String[] stringArray = Preferences.TEXT_KEYS;
        int n = Preferences.TEXT_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String baseKey = stringArray[n2];
            PreferenceConverter.setValue((IPreferenceStore)store, (String)Preferences.getColorKey(baseKey), (RGB)this.colorMap.get(baseKey));
            store.setValue(Preferences.getStyleKey(baseKey), this.styleMap.get(baseKey).intValue());
            this.colorMap.put(baseKey, PreferenceConverter.getColor((IPreferenceStore)store, (String)Preferences.getColorKey(baseKey)));
            this.styleMap.put(baseKey, store.getInt(Preferences.getStyleKey(baseKey)));
            ++n2;
        }
    }

    private void writeTextUI() {
        String baseKey = this.getSelection();
        this.colorB.setColorValue(this.colorMap.get(baseKey));
        int style = this.styleMap.get(baseKey);
        this.boldB.setSelection((style & 1) != 0);
        this.italicB.setSelection((style & 2) != 0);
        this.underlineB.setSelection((style & 0x40000000) != 0);
        this.strikeB.setSelection((style & 0x20000000) != 0);
    }

    private void readTextUI() {
        String baseKey = this.getSelection();
        RGB color = this.colorB.getColorValue();
        this.colorMap.put(baseKey, color);
        int bold = this.boldB.getSelection() ? 1 : 0;
        int italic = this.italicB.getSelection() ? 2 : 0;
        int underline = this.underlineB.getSelection() ? 0x40000000 : 0;
        int strike = this.strikeB.getSelection() ? 0x20000000 : 0;
        int style = bold | italic | underline | strike;
        this.styleMap.put(baseKey, style);
    }

    protected void performDefaults() {
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        this.upperCaseCommandsB.setSelection(store.getDefaultBoolean("upperCaseCommands"));
        this.bracketB.setSelection(store.getDefaultBoolean("matchBrackets"));
        this.bracketColorB.setColorValue(PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"matchingBracketsColor"));
        String[] stringArray = Preferences.TEXT_KEYS;
        int n = Preferences.TEXT_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String baseKey = stringArray[n2];
            this.colorMap.put(baseKey, PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)Preferences.getColorKey(baseKey)));
            this.styleMap.put(baseKey, store.getDefaultInt(Preferences.getStyleKey(baseKey)));
            ++n2;
        }
        this.writeTextUI();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        store.setValue("upperCaseCommands", this.upperCaseCommandsB.getSelection());
        store.setValue("matchBrackets", this.bracketB.getSelection());
        PreferenceConverter.setValue((IPreferenceStore)store, (String)"matchingBracketsColor", (RGB)this.bracketColorB.getColorValue());
        this.writeTextPrefs();
        return super.performOk();
    }
}

