/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.layout;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.AbstractSequenceLayout;

public abstract class AbstractSequenceOrderingLayout<S, T, U>
extends AbstractSequenceLayout<S, T> {
    protected final List<U> semanticOrdering = new ArrayList<U>();
    protected final List<U> graphicalOrdering = new ArrayList<U>();
    protected final List<U> flaggedEnds = new ArrayList<U>();
    protected final Map<S, Rectangle> oldFlaggedLayoutData = new HashMap<S, Rectangle>();

    public AbstractSequenceOrderingLayout(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram);
    }

    @Override
    protected void dispose() {
        this.semanticOrdering.clear();
        this.graphicalOrdering.clear();
        this.flaggedEnds.clear();
        this.oldFlaggedLayoutData.clear();
        super.dispose();
    }

    protected int getDeltaStablePosition(int currentPos, U element, Map<? extends U, Integer> alreadyComputedLocations) {
        int deltaStablePos = currentPos;
        int semanticIndex = this.semanticOrdering.indexOf(element);
        int graphicalIndex = this.graphicalOrdering.indexOf(element);
        int flaggedIndex = this.flaggedEnds.indexOf(element);
        if (flaggedIndex != -1 && semanticIndex != 0 && graphicalIndex != -1) {
            ArrayList<U> semanticPredecessors = new ArrayList<U>(this.semanticOrdering.subList(0, semanticIndex));
            ArrayList<U> graphicalPredecessors = new ArrayList<U>(this.graphicalOrdering.subList(0, graphicalIndex));
            ArrayList<U> flaggedPredecessors = new ArrayList<U>(this.flaggedEnds.subList(0, flaggedIndex));
            semanticPredecessors.retainAll(this.flaggedEnds);
            graphicalPredecessors.retainAll(this.flaggedEnds);
            flaggedPredecessors.retainAll(semanticPredecessors);
            Function<U, Integer> oldPosition = this.getOldPosition();
            Object flaggedPred = null;
            if (Iterables.elementsEqual(semanticPredecessors, graphicalPredecessors) && !graphicalPredecessors.isEmpty()) {
                flaggedPred = graphicalPredecessors.get(graphicalPredecessors.size() - 1);
            } else {
                oldPosition = this.getOldFlaggedPosition();
                Object potentialSafePred = null;
                int i = 0;
                while (i < flaggedPredecessors.size()) {
                    Object semPot = semanticPredecessors.get(i);
                    Object flaggedPot = flaggedPredecessors.get(i);
                    if (semPot != null && semPot.equals(flaggedPot)) {
                        potentialSafePred = semPot;
                    }
                    ++i;
                }
                if (potentialSafePred != null) {
                    flaggedPred = potentialSafePred;
                }
            }
            if (flaggedPred != null) {
                Integer predY = (Integer)oldPosition.apply(flaggedPred);
                Integer flaggedY = (Integer)oldPosition.apply(element);
                int delta = flaggedY - predY;
                if (delta >= 0) {
                    deltaStablePos = alreadyComputedLocations.get(flaggedPred) + delta;
                }
            }
        }
        return deltaStablePos;
    }

    protected abstract Function<U, Integer> getOldPosition();

    protected abstract Function<U, Integer> getOldFlaggedPosition();
}

