/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.factories;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.smartmdsd.ui.factories.SelectViewpointCommand;
import org.eclipse.smartmdsd.ui.models.SmartMDSDModelingLanguage;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureHelpers;

public class ModelingProjectFactory {
    public static void convertToModelingProject(IProject project, IProgressMonitor monitor) throws CoreException {
        ModelingProjectManager.INSTANCE.convertToModelingProject(project, monitor);
    }

    public static Session getProjectSession(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectNature nature = project.getNature("org.eclipse.sirius.nature.modelingproject");
        if (nature instanceof ModelingProject) {
            ModelingProject mProject = (ModelingProject)nature;
            Session session = mProject.getSession();
            if (session == null) {
                String airdFileString = "platform:/resource/" + project.getName() + "/representations.aird";
                session = SessionManager.INSTANCE.openSession(URI.createURI((String)airdFileString), monitor, (UICallBack)new NoUICallback());
            }
            return session;
        }
        return null;
    }

    public static void createModelingProject(IProject project, List<String> selectedModelTypes, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create Modeling Project", (int)200);
        ModelingProjectFactory.convertToModelingProject(project, (IProgressMonitor)subMonitor.split(100));
        if (subMonitor.isCanceled()) {
            return;
        }
        Session session = ModelingProjectFactory.getProjectSession(project, monitor);
        if (session != null) {
            ModelingProjectFactory.selectViewpoints(project, session, selectedModelTypes, (IProgressMonitor)subMonitor.split(30));
            if (subMonitor.isCanceled()) {
                return;
            }
            ModelingProjectFactory.openSelectedDiagramEditorsForSession(project, session, selectedModelTypes, (IProgressMonitor)subMonitor.split(50));
            project.refreshLocal(2, (IProgressMonitor)subMonitor.split(10));
        }
    }

    public static void selectViewpoints(IProject project, Session session, List<String> selectedModelTypes, IProgressMonitor monitor) {
        boolean hasChanges = false;
        for (String modelTypeName : selectedModelTypes) {
            String viewpointName;
            SmartMDSDModelingLanguage dsl;
            AbstractSmartMDSDNature nature = SmartMDSDNatureHelpers.getFirstSmartMDSDNatureFrom(project);
            if (nature == null || (dsl = nature.getLanguage(modelTypeName)) == null || (viewpointName = dsl.getSiriusViewpointName()) == null) continue;
            SelectViewpointCommand vpSelectCmd = new SelectViewpointCommand(session, dsl.getModelFileExtension(), viewpointName, monitor);
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)vpSelectCmd);
            hasChanges = true;
        }
        if (hasChanges) {
            session.save(monitor);
        }
    }

    public static void openSelectedDiagramEditorsForSession(IProject project, Session session, List<String> selectedModelTypes, IProgressMonitor monitor) throws CoreException {
        for (String modelTypeName : selectedModelTypes) {
            String viewpointName;
            SmartMDSDModelingLanguage dsl;
            AbstractSmartMDSDNature nature = SmartMDSDNatureHelpers.getFirstSmartMDSDNatureFrom(project);
            if (nature == null || (dsl = nature.getLanguage(modelTypeName)) == null || (viewpointName = dsl.getSiriusViewpointName()) == null) continue;
            for (DView view : session.getOwnedViews()) {
                if (!view.getViewpoint().getName().equals(viewpointName)) continue;
                for (DRepresentationDescriptor representation : view.getOwnedRepresentationDescriptors()) {
                    DialectUIManager.INSTANCE.openEditor(session, representation.getRepresentation(), monitor);
                }
            }
        }
    }

    public static EList<DRepresentationDescriptor> getRepresentationsFor(IResource modelFile, Session session) throws CoreException {
        String viewpointName;
        SmartMDSDModelingLanguage dsl;
        IProject project = modelFile.getProject();
        AbstractSmartMDSDNature nature = SmartMDSDNatureHelpers.getFirstSmartMDSDNatureFrom(project);
        if (nature != null && (dsl = nature.getLanguageFrom(modelFile)) != null && (viewpointName = dsl.getSiriusViewpointName()) != null) {
            for (DView view : session.getOwnedViews()) {
                if (!view.getViewpoint().getName().equals(viewpointName)) continue;
                return view.getOwnedRepresentationDescriptors();
            }
        }
        return null;
    }
}

