/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ui.factories.ISmartMDSDModelFactory;
import org.eclipse.smartmdsd.ui.factories.XtextResourceFactory;
import org.eclipse.smartmdsd.ui.models.SmartMDSDModelingLanguage;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureHelpers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SmartMDSDModelFactory
extends XtextResourceFactory {
    private AbstractSmartMDSDNature project_nature;
    private static Map<String, ISmartMDSDModelFactory> registry = null;

    public SmartMDSDModelFactory(IProject project, IFolder modelFolder) {
        super(project, modelFolder);
        this.project_nature = SmartMDSDNatureHelpers.getFirstSmartMDSDNatureFrom(project);
        if (registry == null) {
            SmartMDSDModelFactory.initializeFactoryRegistry();
        }
    }

    public static synchronized void initializeFactoryRegistry() {
        registry = new HashMap<String, ISmartMDSDModelFactory>();
        IConfigurationElement[] configurations = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.smartmdsd.ui.SmartMDSDModelFactoryEP");
        try {
            IConfigurationElement[] iConfigurationElementArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                Object object = config.createExecutableExtension("class");
                if (object instanceof ISmartMDSDModelFactory) {
                    ISmartMDSDModelFactory factory = (ISmartMDSDModelFactory)object;
                    String packageURI = factory.getEPackage().getNsURI();
                    System.out.println("Register SmartMDSD model factory for package " + packageURI);
                    registry.put(packageURI, factory);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean createModel(EPackage epackage, IProgressMonitor monitor) {
        Resource resource = this.loadOrCreateResource(epackage.getName(), null);
        return resource != null && resource.isLoaded();
    }

    public boolean createSelectedModels(List<String> selectedModelTypes, IProgressMonitor monitor) {
        boolean allResourcesCreated = true;
        for (String languageName : selectedModelTypes) {
            Resource resource = this.loadOrCreateResource(languageName, null);
            if (resource != null && resource.isLoaded()) continue;
            allResourcesCreated = false;
        }
        return allResourcesCreated;
    }

    public void openSelectedModelsInEditor(final List<String> selectedModelTypes) {
        final IProject project = this.getProject();
        WorkspaceJob job = new WorkspaceJob("Open Selected Model Editors"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                project.refreshLocal(2, monitor);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        for (String languageName : selectedModelTypes) {
                            SmartMDSDModelingLanguage dsl = (this).SmartMDSDModelFactory.this.project_nature.getLanguage(languageName);
                            if (!dsl.getSiriusViewpointName().isEmpty()) continue;
                            String fileName = String.valueOf(project.getName()) + "." + dsl.getModelFileExtension();
                            IFile modelFile = SmartMDSDModelFactory.this.getModelFolder().getFile(fileName);
                            try {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)modelFile);
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)project);
        job.schedule();
    }

    private Resource loadOrCreateResource(String languageName, List<String> processedLangauges) {
        if (processedLangauges == null) {
            processedLangauges = new ArrayList<String>();
        }
        processedLangauges.add(languageName);
        SmartMDSDModelingLanguage language = this.project_nature.getLanguage(languageName);
        ISmartMDSDModelFactory factory = registry.get(language.getEPackage().getNsURI());
        Resource resource = this.loadEMFResource(language.getInjector());
        if (resource == null || !resource.isLoaded()) {
            ArrayList<Resource> parentResources = new ArrayList<Resource>();
            Collection<EPackage> parentPackages = factory.getParentEPackages();
            if (parentPackages != null) {
                for (EPackage parentPackage : parentPackages) {
                    if (processedLangauges.contains(parentPackage.getName())) {
                        System.err.println("A dependency cycle detected, skip dependnecy loading to prefent a stack overflow.");
                        continue;
                    }
                    parentResources.add(this.loadOrCreateResource(parentPackage.getName(), processedLangauges));
                }
            }
            resource = this.createNewXtextResource(language.getInjector(), parentResources);
            ArrayList<EObject> parentModels = new ArrayList<EObject>();
            for (Resource parent : parentResources) {
                parentModels.add((EObject)parent.getContents().get(0));
            }
            EObject model = factory.createDefaultModel(this.getProject().getName(), parentModels);
            this.saveEMFModelInResource(model, resource);
        }
        return resource;
    }
}

