/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.utils;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.action.AbstractExternalJavaAction;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DView;

public class OpenRepresentationAction
extends AbstractExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> arg0) {
        return true;
    }

    public void execute(Collection<? extends EObject> arg0, Map<String, Object> arg1) {
        String representationName = (String)this.getParameter(arg1, "representationName", String.class);
        if (arg0.size() > 0 && representationName != null) {
            for (EObject eObject : arg0) {
                if (eObject instanceof DRepresentationElement) {
                    this.openRepresentation((DRepresentationElement)eObject, representationName);
                    continue;
                }
                DRepresentationElement containerView = (DRepresentationElement)this.getParameter(arg1, "containerView", DRepresentationElement.class);
                if (containerView == null) continue;
                this.openRepresentation(containerView, representationName);
            }
        }
    }

    private void openRepresentation(DRepresentationElement element, String representationName) {
        Session session = SessionManager.INSTANCE.getExistingSession(element.eResource().getURI());
        if (session.isOpen()) {
            for (DView view : session.getOwnedViews()) {
                for (DRepresentationDescriptor representation : view.getOwnedRepresentationDescriptors()) {
                    if (!representation.getName().equals(representationName)) continue;
                    System.out.println("Opening represenatation: " + representationName);
                    DialectUIManager.INSTANCE.openEditor(session, representation.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
    }
}

