/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.logging;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.junit.Assert;

@Deprecated
public class LoggingTester {
    private static final Comparator<LogEntry> TEMPORAL_ORDER = ($0, $1) -> Longs.compare((long)((LogEntry)$0).timeStamp, (long)((LogEntry)$1).timeStamp);

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LogCapture captureLogging(Level level, Class<?> source, Runnable action) {
        logger = Logger.getLogger(source);
        appender = new QueueAppender();
        oldLevel = logger.getLevel();
        allAppenders = LoggingTester.appenderHierarchy(logger);
        filter = new SourceFilter(logger);
        try {
            for (Appender it : allAppenders) {
                it.addFilter((Filter)filter);
            }
            logger.addAppender((Appender)appender);
            logger.setLevel(level);
            action.run();
            events = IterableExtensions.sortWith((Iterable)IterableExtensions.toList((Iterable)QueueAppender.access$1(appender)), LoggingTester.TEMPORAL_ORDER);
            var11_10 = new LogCapture(events);
            return var11_10;
        }
        finally {
            logger.removeAppender((Appender)appender);
            ** for (it : allAppenders)
        }
lbl-1000:
        // 1 sources

        {
            LoggingTester.removeFilter(it, filter);
            continue;
        }
lbl21:
        // 1 sources

        logger.setLevel(oldLevel);
        return var11_10;
    }

    private static List<Appender> appenderHierarchy(Logger logger) {
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        Logger current = logger;
        while (current != null) {
            appenders.addAll(Collections.list(current.getAllAppenders()));
            current = current.getParent();
        }
        return appenders;
    }

    private static void removeFilter(Appender appender, Filter filter) {
        if (Objects.equal((Object)appender.getFilter(), (Object)filter)) {
            appender.clearFilters();
            appender.addFilter(filter.getNext());
        } else {
            Filter current = appender.getFilter();
            while (current != null) {
                if (Objects.equal((Object)current.getNext(), (Object)filter)) {
                    current.setNext(filter.getNext());
                    return;
                }
                current = current.getNext();
            }
        }
    }

    public static class LogCapture {
        private final List<LogEntry> logEntries;

        public void assertNoLogEntries() {
            this.assertNumberOfLogEntries(0);
        }

        public void assertLogEntry(String ... messageParts) {
            this.assertNumberOfLogEntries(1, messageParts);
        }

        public void assertLogEntry(Level level, String ... messageParts) {
            this.assertNumberOfLogEntries(1, level, messageParts);
        }

        public void assertNumberOfLogEntries(int number) {
            this.assertNumberOfLogEntries(number, new String[0]);
        }

        public void assertNumberOfLogEntries(int number, String ... messageParts) {
            this.assertNumberOfLogEntries(number, (Level)null, messageParts);
        }

        public void assertNumberOfLogEntries(int number, Level level, String ... messageParts) {
            Iterable passed = Iterables.filter(this.logEntries, log -> (level == null || Objects.equal((Object)((LogEntry)log).level, (Object)level)) && IterableExtensions.forall(messageParts == null ? null : Arrays.asList(messageParts), it -> ((LogEntry)log).message.contains((CharSequence)it)));
            if (Iterables.size((Iterable)passed) != number) {
                StringConcatenation builder = new StringConcatenation();
                if (number == 0) {
                    builder.append("Expected no log entries");
                    builder.newLine();
                } else if (number == 1) {
                    builder.append("Expected a log entry");
                    builder.newLine();
                } else {
                    builder.append("Expected ");
                    builder.append((Object)number);
                    builder.append(" log entries");
                    builder.newLineIfNotEmpty();
                }
                if (level != null) {
                    builder.append("with ");
                    builder.append((Object)level);
                    builder.append(" level");
                    builder.newLineIfNotEmpty();
                }
                builder.append("containing the phrases ");
                builder.append(IterableExtensions.join(messageParts == null ? null : Arrays.asList(messageParts), (CharSequence)", ", it -> "\"" + it + "\""));
                builder.newLineIfNotEmpty();
                builder.append("but got");
                builder.newLine();
                builder.append(this.logEntries);
                builder.newLineIfNotEmpty();
                Assert.fail((String)builder.toString());
            }
        }

        public LogCapture(List<LogEntry> logEntries) {
            this.logEntries = logEntries;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.logEntries == null ? 0 : this.logEntries.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogCapture other = (LogCapture)obj;
            return !(this.logEntries == null ? other.logEntries != null : !this.logEntries.equals(other.logEntries));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("logEntries", this.logEntries);
            return b.toString();
        }

        public List<LogEntry> getLogEntries() {
            return this.logEntries;
        }
    }

    public static class LogEntry {
        private final String message;
        private final String source;
        private final long timeStamp;
        private final Level level;

        public LogEntry(String message, String source, long timeStamp, Level level) {
            this.message = message;
            this.source = source;
            this.timeStamp = timeStamp;
            this.level = level;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogEntry other = (LogEntry)obj;
            if (this.level == null ? other.level != null : !this.level.equals((Object)other.level)) {
                return false;
            }
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            return this.timeStamp == other.timeStamp;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("message", (Object)this.message);
            b.add("source", (Object)this.source);
            b.add("timeStamp", (Object)this.timeStamp);
            b.add("level", (Object)this.level);
            return b.toString();
        }

        public String getMessage() {
            return this.message;
        }

        public String getSource() {
            return this.source;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public Level getLevel() {
            return this.level;
        }
    }

    private static class QueueAppender
    extends AppenderSkeleton {
        private final Queue<LogEntry> events = new ConcurrentLinkedQueue<LogEntry>();

        private QueueAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        protected void append(LoggingEvent event) {
            LogEntry entry = new LogEntry(event.getRenderedMessage(), event.getLoggerName(), event.getTimeStamp(), event.getLevel());
            this.events.add(entry);
        }

        public Queue<LogEntry> getEvents() {
            return this.events;
        }

        static /* synthetic */ Queue access$1(QueueAppender queueAppender) {
            return queueAppender.events;
        }
    }

    private static class SourceFilter
    extends Filter {
        private final Logger source;

        public int decide(LoggingEvent event) {
            if (Objects.equal((Object)event.getLoggerName(), (Object)this.source.getName())) {
                return -1;
            }
            return 0;
        }

        public SourceFilter(Logger source) {
            this.source = source;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SourceFilter other = (SourceFilter)((Object)obj);
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }

        public String toString() {
            return new ToStringBuilder((Object)this).addAllFields().toString();
        }

        public Logger getSource() {
            return this.source;
        }
    }
}

