/**
 * Copyright (c) 2021 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.component.componentDatasheet;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetUtils;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefModel;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionPackage;
import org.eclipse.smartmdsd.ui.factories.ISmartMDSDModelFactory;

@SuppressWarnings("all")
public class SmartMDSDComponentDatasheetFactory implements ISmartMDSDModelFactory {
  @Override
  public EPackage getEPackage() {
    return ComponentDatasheetPackage.eINSTANCE;
  }
  
  @Override
  public Collection<EPackage> getParentEPackages() {
    return Collections.<EPackage>singletonList(ComponentDefinitionPackage.eINSTANCE);
  }
  
  @Override
  public EObject createDefaultModel(final String projectName, final Collection<EObject> parentModels) {
    ComponentDefinition component = null;
    for (final EObject parent : parentModels) {
      if ((parent instanceof ComponentDefModel)) {
        component = ((ComponentDefModel)parent).getComponent();
      }
    }
    final ComponentDatasheet datasheet = ComponentDatasheetFactory.eINSTANCE.createComponentDatasheet();
    if ((component != null)) {
      datasheet.setComponent(component);
    }
    GenericDatasheetUtils.addDefaultDatasheetElements(datasheet, projectName);
    return datasheet;
  }
}
