/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.system.deployment;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.AbstractTPSubNode;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.NetworkInterface;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformDefinition;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class DeploymentUtility {
  public static TargetPlatformReference addDefaultTargetReference(final DeploymentModel deploymentModel, final TargetPlatformDefinition targetDef) {
    final TargetPlatformReference targetRef = DeploymentFactory.eINSTANCE.createTargetPlatformReference();
    targetRef.setName(targetDef.getName());
    targetRef.setPlatform(targetDef);
    final Function1<AbstractTPSubNode, Boolean> _function = (AbstractTPSubNode it) -> {
      return Boolean.valueOf((it instanceof NetworkInterface));
    };
    final AbstractTPSubNode ni = IterableExtensions.<AbstractTPSubNode>findFirst(targetDef.getElements(), _function);
    if ((ni instanceof NetworkInterface)) {
      final NetworkInterfaceSelection nis = DeploymentFactory.eINSTANCE.createNetworkInterfaceSelection();
      nis.setNetwork(((NetworkInterface)ni));
      targetRef.setHost(nis);
    }
    final UploadDirectory ud = DeploymentFactory.eINSTANCE.createUploadDirectory();
    ud.setPath("/tmp");
    targetRef.setDirectory(ud);
    deploymentModel.getElements().add(targetRef);
    final NamingService ns = DeploymentFactory.eINSTANCE.createNamingService();
    final Deployment ns_depl = DeploymentFactory.eINSTANCE.createDeployment();
    ns_depl.setTo(targetRef);
    ns.setDeploy(ns_depl);
    deploymentModel.getElements().add(ns);
    return targetRef;
  }
  
  public static boolean addComponentArtefact(final DeploymentModel deploymentModel, final ComponentInstance component, final TargetPlatformReference targetRef) {
    boolean _xblockexpression = false;
    {
      final ComponentArtefact artefact = DeploymentFactory.eINSTANCE.createComponentArtefact();
      artefact.setComponent(component);
      artefact.setDeploy(DeploymentFactory.eINSTANCE.createDeployment());
      Deployment _deploy = artefact.getDeploy();
      _deploy.setTo(targetRef);
      _xblockexpression = deploymentModel.getElements().add(artefact);
    }
    return _xblockexpression;
  }
  
  public static void addAllMissingComponentArtefacts(final DeploymentModel deploymentModel, final TargetPlatformReference targetRef) {
    EList<ComponentInstance> _components = deploymentModel.getComponentArch().getComponents();
    for (final ComponentInstance component : _components) {
      final Function1<ComponentArtefact, Boolean> _function = (ComponentArtefact it) -> {
        ComponentInstance _component = it.getComponent();
        return Boolean.valueOf(Objects.equal(_component, component));
      };
      boolean _exists = IterableExtensions.<ComponentArtefact>exists(Iterables.<ComponentArtefact>filter(deploymentModel.getElements(), ComponentArtefact.class), _function);
      boolean _not = (!_exists);
      if (_not) {
        DeploymentUtility.addComponentArtefact(deploymentModel, component, targetRef);
      }
    }
  }
  
  public static boolean areAllComponentsDeployed(final DeploymentModel deploymentModel) {
    EList<ComponentInstance> _components = deploymentModel.getComponentArch().getComponents();
    for (final ComponentInstance component : _components) {
      final Function1<ComponentArtefact, Boolean> _function = (ComponentArtefact it) -> {
        ComponentInstance _component = it.getComponent();
        return Boolean.valueOf(Objects.equal(_component, component));
      };
      boolean _exists = IterableExtensions.<ComponentArtefact>exists(Iterables.<ComponentArtefact>filter(deploymentModel.getElements(), ComponentArtefact.class), _function);
      boolean _not = (!_exists);
      if (_not) {
        return false;
      }
    }
    return true;
  }
}
